/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.taskprocessor;

import java.util.Collections;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.ce.task.CeTask;
import org.sonar.ce.task.CeTaskResult;
import org.sonar.ce.task.container.TaskContainer;
import org.sonar.ce.task.projectanalysis.container.ContainerFactory;
import org.sonar.ce.task.projectanalysis.container.ReportAnalysisComponentProvider;
import org.sonar.ce.task.step.ComputationStepExecutor;
import org.sonar.ce.task.taskprocessor.CeTaskProcessor;
import org.sonar.ce.task.taskprocessor.TaskResultHolder;
import org.sonar.core.platform.ComponentContainer;

public class ReportTaskProcessor
implements CeTaskProcessor {
    private static final Set<String> HANDLED_TYPES = Collections.singleton("REPORT");
    private final ContainerFactory containerFactory;
    private final ComponentContainer serverContainer;
    @CheckForNull
    private final ReportAnalysisComponentProvider[] componentProviders;

    public ReportTaskProcessor(ContainerFactory containerFactory, ComponentContainer serverContainer, ReportAnalysisComponentProvider[] componentProviders) {
        this.containerFactory = containerFactory;
        this.serverContainer = serverContainer;
        this.componentProviders = componentProviders;
    }

    public ReportTaskProcessor(ContainerFactory containerFactory, ComponentContainer serverContainer) {
        this.containerFactory = containerFactory;
        this.serverContainer = serverContainer;
        this.componentProviders = null;
    }

    public ReportTaskProcessor() {
        this(null, null, null);
    }

    public Set<String> getHandledCeTaskTypes() {
        return HANDLED_TYPES;
    }

    public CeTaskResult process(CeTask task) {
        try (TaskContainer ceContainer = this.containerFactory.create(this.serverContainer, task, this.componentProviders);){
            ceContainer.bootup();
            ((ComputationStepExecutor)ceContainer.getComponentByType(ComputationStepExecutor.class)).execute();
            CeTaskResult ceTaskResult = ((TaskResultHolder)ceContainer.getComponentByType(TaskResultHolder.class)).getResult();
            return ceTaskResult;
        }
    }
}

