/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.util.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.ce.task.projectanalysis.util.cache.CacheLoader;

public class MemoryCache<K, V> {
    private final CacheLoader<K, V> loader;
    private final Map<K, V> map = new HashMap();

    public MemoryCache(CacheLoader<K, V> loader) {
        this.loader = loader;
    }

    @CheckForNull
    public V getNullable(K key) {
        V value = this.map.get(key);
        if (value == null && !this.map.containsKey(key)) {
            value = this.loader.load(key);
            this.map.put(key, value);
        }
        return value;
    }

    public V get(K key) {
        V value = this.getNullable(key);
        if (value == null) {
            throw new IllegalStateException("No cache entry found for key: " + key);
        }
        return value;
    }

    public Map<K, V> getAll(Iterable<K> keys) {
        ArrayList<K> missingKeys = new ArrayList<K>();
        HashMap<Object, V> result = new HashMap<Object, V>();
        for (K key : keys) {
            V value = this.map.get(key);
            if (value == null && !this.map.containsKey(key)) {
                missingKeys.add(key);
                continue;
            }
            result.put(key, value);
        }
        if (!missingKeys.isEmpty()) {
            Map<K, V> missingValues = this.loader.loadAll(missingKeys);
            this.map.putAll(missingValues);
            result.putAll(missingValues);
            for (Object missingKey : missingKeys) {
                if (this.map.containsKey(missingKey)) continue;
                this.map.put(missingKey, null);
                result.put(missingKey, null);
            }
        }
        return result;
    }

    public void clear() {
        this.map.clear();
    }
}

