/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.webhook;

import java.util.Map;
import java.util.Optional;
import org.sonar.api.ce.posttask.Analysis;
import org.sonar.api.ce.posttask.PostProjectAnalysisTask;
import org.sonar.ce.task.projectanalysis.api.posttask.QGToEvaluatedQG;
import org.sonar.server.qualitygate.EvaluatedQualityGate;
import org.sonar.server.webhook.Branch;
import org.sonar.server.webhook.CeTask;
import org.sonar.server.webhook.Project;
import org.sonar.server.webhook.ProjectAnalysis;
import org.sonar.server.webhook.WebHooks;
import org.sonar.server.webhook.WebhookPayloadFactory;

public class WebhookPostTask
implements PostProjectAnalysisTask {
    private final WebhookPayloadFactory payloadFactory;
    private final WebHooks webHooks;

    public WebhookPostTask(WebhookPayloadFactory payloadFactory, WebHooks webHooks) {
        this.payloadFactory = payloadFactory;
        this.webHooks = webHooks;
    }

    public void finished(PostProjectAnalysisTask.ProjectAnalysis analysis) {
        this.webHooks.sendProjectAnalysisUpdate(new WebHooks.Analysis(analysis.getProject().getUuid(), (String)analysis.getAnalysis().map(Analysis::getAnalysisUuid).orElse(null), analysis.getCeTask().getId()), () -> this.payloadFactory.create(WebhookPostTask.convert(analysis)));
    }

    private static ProjectAnalysis convert(PostProjectAnalysisTask.ProjectAnalysis projectAnalysis) {
        CeTask ceTask = new CeTask(projectAnalysis.getCeTask().getId(), CeTask.Status.valueOf((String)projectAnalysis.getCeTask().getStatus().name()));
        org.sonar.server.webhook.Analysis analysis = projectAnalysis.getAnalysis().map(a -> new org.sonar.server.webhook.Analysis(a.getAnalysisUuid(), a.getDate().getTime())).orElse(null);
        Branch branch = projectAnalysis.getBranch().map(b -> new Branch(b.isMain(), (String)b.getName().orElse(null), Branch.Type.valueOf((String)b.getType().name()))).orElse(null);
        EvaluatedQualityGate qualityGate = Optional.ofNullable(projectAnalysis.getQualityGate()).map(QGToEvaluatedQG.INSTANCE).orElse(null);
        Long date = projectAnalysis.getAnalysis().map(a -> a.getDate().getTime()).orElse(null);
        Map properties = projectAnalysis.getScannerContext().getProperties();
        Project project = new Project(projectAnalysis.getProject().getUuid(), projectAnalysis.getProject().getKey(), projectAnalysis.getProject().getName());
        return new ProjectAnalysis(project, ceTask, analysis, branch, qualityGate, date, properties);
    }
}

