/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.util.Collections;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.AbstractFilePredicate;
import org.sonar.api.utils.PathUtils;

public class RelativePathPredicate
extends AbstractFilePredicate {
    @Nullable
    private final String path;

    RelativePathPredicate(String path) {
        this.path = PathUtils.sanitize(path);
    }

    public String path() {
        return this.path;
    }

    @Override
    public boolean apply(InputFile f) {
        if (this.path == null) {
            return false;
        }
        return this.path.equals(f.relativePath());
    }

    @Override
    public Iterable<InputFile> get(FileSystem.Index index) {
        InputFile f;
        if (this.path != null && (f = index.inputFile(this.path)) != null) {
            return Collections.singletonList(f);
        }
        return Collections.emptyList();
    }

    @Override
    public int priority() {
        return 20;
    }
}

