/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.code.internal;

import com.google.common.base.Preconditions;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.code.NewSignificantCode;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;

public class DefaultSignificantCode
extends DefaultStorable
implements NewSignificantCode {
    private SortedMap<Integer, TextRange> significantCodePerLine = new TreeMap<Integer, TextRange>();
    private InputFile inputFile;

    public DefaultSignificantCode() {
    }

    public DefaultSignificantCode(@Nullable SensorStorage storage) {
        super(storage);
    }

    @Override
    public DefaultSignificantCode onFile(InputFile inputFile) {
        this.inputFile = inputFile;
        return this;
    }

    @Override
    public DefaultSignificantCode addRange(TextRange range) {
        Preconditions.checkState((this.inputFile != null ? 1 : 0) != 0, (Object)"addRange() should be called after on()");
        int line = range.start().line();
        Preconditions.checkArgument((line == range.end().line() ? 1 : 0) != 0, (Object)"Ranges of significant code must be located in a single line");
        Preconditions.checkState((!this.significantCodePerLine.containsKey(line) ? 1 : 0) != 0, (String)"Significant code was already reported for line '%s'. Can only report once per line.", (Object[])new Object[]{line});
        this.significantCodePerLine.put(line, range);
        return this;
    }

    @Override
    protected void doSave() {
        Preconditions.checkState((this.inputFile != null ? 1 : 0) != 0, (Object)"Call onFile() first");
        this.storage.store(this);
    }

    public InputFile inputFile() {
        return this.inputFile;
    }

    public SortedMap<Integer, TextRange> significantCodePerLine() {
        return this.significantCodePerLine;
    }
}

