/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sonar.api.batch.sensor.code.internal.DefaultSignificantCode;
import org.sonar.api.batch.sensor.coverage.internal.DefaultCoverage;
import org.sonar.api.batch.sensor.cpd.internal.DefaultCpdTokens;
import org.sonar.api.batch.sensor.error.AnalysisError;
import org.sonar.api.batch.sensor.highlighting.internal.DefaultHighlighting;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.ExternalIssue;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.internal.DefaultExternalIssue;
import org.sonar.api.batch.sensor.measure.Measure;
import org.sonar.api.batch.sensor.rule.AdHocRule;
import org.sonar.api.batch.sensor.rule.internal.DefaultAdHocRule;
import org.sonar.api.batch.sensor.symbol.internal.DefaultSymbolTable;

class InMemorySensorStorage
implements SensorStorage {
    Table<String, String, Measure> measuresByComponentAndMetric = HashBasedTable.create();
    Collection<Issue> allIssues = new ArrayList<Issue>();
    Collection<ExternalIssue> allExternalIssues = new ArrayList<ExternalIssue>();
    Collection<AdHocRule> allAdHocRules = new ArrayList<AdHocRule>();
    Collection<AnalysisError> allAnalysisErrors = new ArrayList<AnalysisError>();
    Map<String, DefaultHighlighting> highlightingByComponent = new HashMap<String, DefaultHighlighting>();
    Map<String, DefaultCpdTokens> cpdTokensByComponent = new HashMap<String, DefaultCpdTokens>();
    Multimap<String, DefaultCoverage> coverageByComponent = ArrayListMultimap.create();
    Map<String, DefaultSymbolTable> symbolsPerComponent = new HashMap<String, DefaultSymbolTable>();
    Map<String, String> contextProperties = new HashMap<String, String>();
    Map<String, DefaultSignificantCode> significantCodePerComponent = new HashMap<String, DefaultSignificantCode>();

    InMemorySensorStorage() {
    }

    @Override
    public void store(Measure measure) {
        String metricKey;
        String componentKey = measure.inputComponent().key();
        if (this.measuresByComponentAndMetric.contains((Object)componentKey, (Object)(metricKey = measure.metric().key()))) {
            throw new IllegalStateException("Can not add the same measure twice");
        }
        this.measuresByComponentAndMetric.row((Object)componentKey).put(metricKey, measure);
    }

    @Override
    public void store(Issue issue) {
        this.allIssues.add(issue);
    }

    @Override
    public void store(DefaultAdHocRule adHocRule) {
        this.allAdHocRules.add(adHocRule);
    }

    @Override
    public void store(DefaultHighlighting highlighting) {
        String fileKey = highlighting.inputFile().key();
        if (this.highlightingByComponent.containsKey(fileKey)) {
            throw new UnsupportedOperationException("Trying to save highlighting twice for the same file is not supported: " + highlighting.inputFile());
        }
        this.highlightingByComponent.put(fileKey, highlighting);
    }

    @Override
    public void store(DefaultCoverage defaultCoverage) {
        String fileKey = defaultCoverage.inputFile().key();
        this.coverageByComponent.put((Object)fileKey, (Object)defaultCoverage);
    }

    @Override
    public void store(DefaultCpdTokens defaultCpdTokens) {
        String fileKey = defaultCpdTokens.inputFile().key();
        if (this.cpdTokensByComponent.containsKey(fileKey)) {
            throw new UnsupportedOperationException("Trying to save CPD tokens twice for the same file is not supported: " + defaultCpdTokens.inputFile());
        }
        this.cpdTokensByComponent.put(fileKey, defaultCpdTokens);
    }

    @Override
    public void store(DefaultSymbolTable symbolTable) {
        String fileKey = symbolTable.inputFile().key();
        if (this.symbolsPerComponent.containsKey(fileKey)) {
            throw new UnsupportedOperationException("Trying to save symbol table twice for the same file is not supported: " + symbolTable.inputFile());
        }
        this.symbolsPerComponent.put(fileKey, symbolTable);
    }

    @Override
    public void store(AnalysisError analysisError) {
        this.allAnalysisErrors.add(analysisError);
    }

    @Override
    public void storeProperty(String key, String value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key of context property must not be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Value of context property must not be null");
        this.contextProperties.put(key, value);
    }

    @Override
    public void store(DefaultExternalIssue issue) {
        this.allExternalIssues.add(issue);
    }

    @Override
    public void store(DefaultSignificantCode significantCode) {
        String fileKey = significantCode.inputFile().key();
        if (this.significantCodePerComponent.containsKey(fileKey)) {
            throw new UnsupportedOperationException("Trying to save significant code information twice for the same file is not supported: " + significantCode.inputFile());
        }
        this.significantCodePerComponent.put(fileKey, significantCode);
    }
}

