/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.ExternalIssue;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.internal.AbstractDefaultIssue;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.RuleType;

public class DefaultExternalIssue
extends AbstractDefaultIssue<DefaultExternalIssue>
implements ExternalIssue,
NewExternalIssue {
    private Long effort;
    private Severity severity;
    private RuleType type;
    private String engineId;
    private String ruleId;

    public DefaultExternalIssue(DefaultInputProject project) {
        this(project, null);
    }

    public DefaultExternalIssue(DefaultInputProject project, @Nullable SensorStorage storage) {
        super(project, storage);
    }

    @Override
    public DefaultExternalIssue remediationEffortMinutes(@Nullable Long effort) {
        Preconditions.checkArgument((effort == null || effort >= 0L ? 1 : 0) != 0, (Object)String.format("effort must be greater than or equal 0 (got %s)", effort));
        this.effort = effort;
        return this;
    }

    @Override
    public DefaultExternalIssue severity(Severity severity) {
        this.severity = severity;
        return this;
    }

    @Override
    public String engineId() {
        return this.engineId;
    }

    @Override
    public String ruleId() {
        return this.ruleId;
    }

    @Override
    public Severity severity() {
        return this.severity;
    }

    @Override
    public Long remediationEffort() {
        return this.effort;
    }

    @Override
    public void doSave() {
        Objects.requireNonNull(this.engineId, "Engine id is mandatory on external issue");
        Objects.requireNonNull(this.ruleId, "Rule id is mandatory on external issue");
        Preconditions.checkState((this.primaryLocation != null ? 1 : 0) != 0, (Object)"Primary location is mandatory on every external issue");
        Preconditions.checkState((boolean)this.primaryLocation.inputComponent().isFile(), (Object)"External issues must be located in files");
        Preconditions.checkState((this.primaryLocation.message() != null ? 1 : 0) != 0, (Object)"External issues must have a message");
        Preconditions.checkState((this.severity != null ? 1 : 0) != 0, (Object)"Severity is mandatory on every external issue");
        Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"Type is mandatory on every external issue");
        this.storage.store(this);
    }

    @Override
    public RuleType type() {
        return this.type;
    }

    @Override
    public NewExternalIssue engineId(String engineId) {
        this.engineId = engineId;
        return this;
    }

    @Override
    public NewExternalIssue ruleId(String ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    @Override
    public DefaultExternalIssue forRule(RuleKey ruleKey) {
        this.engineId = ruleKey.repository();
        this.ruleId = ruleKey.rule();
        return this;
    }

    @Override
    public RuleKey ruleKey() {
        if (this.engineId != null && this.ruleId != null) {
            return RuleKey.of("external_" + this.engineId, this.ruleId);
        }
        return null;
    }

    @Override
    public DefaultExternalIssue type(RuleType type) {
        this.type = type;
        return this;
    }
}

