/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rules;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.PropertyType;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleParam;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.FieldUtils2;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.check.RuleProperty;

@Deprecated
@ServerSide
@ComputeEngineSide
public final class AnnotationRuleParser {
    private static final Logger LOG = Loggers.get(AnnotationRuleParser.class);
    private static final Function<Class<?>, PropertyType> TYPE_FOR_CLASS = Functions.forMap((Map)ImmutableMap.builder().put(Integer.class, (Object)PropertyType.INTEGER).put(Integer.TYPE, (Object)PropertyType.INTEGER).put(Float.class, (Object)PropertyType.FLOAT).put(Float.TYPE, (Object)PropertyType.FLOAT).put(Boolean.class, (Object)PropertyType.BOOLEAN).put(Boolean.TYPE, (Object)PropertyType.BOOLEAN).build(), (Object)((Object)PropertyType.STRING));

    public List<Rule> parse(String repositoryKey, Collection<Class> annotatedClasses) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Class annotatedClass : annotatedClasses) {
            rules.add(AnnotationRuleParser.create(repositoryKey, annotatedClass));
        }
        return rules;
    }

    private static Rule create(String repositoryKey, Class annotatedClass) {
        org.sonar.check.Rule ruleAnnotation = AnnotationUtils.getAnnotation(annotatedClass, org.sonar.check.Rule.class);
        if (ruleAnnotation != null) {
            return AnnotationRuleParser.toRule(repositoryKey, annotatedClass, ruleAnnotation);
        }
        LOG.warn("The class " + annotatedClass.getCanonicalName() + " should be annotated with " + Rule.class);
        return null;
    }

    private static Rule toRule(String repositoryKey, Class clazz, org.sonar.check.Rule ruleAnnotation) {
        String ruleKey = StringUtils.defaultIfEmpty((String)ruleAnnotation.key(), (String)clazz.getCanonicalName());
        String ruleName = StringUtils.defaultIfEmpty((String)ruleAnnotation.name(), null);
        String description = StringUtils.defaultIfEmpty((String)ruleAnnotation.description(), null);
        Rule rule = Rule.create(repositoryKey, ruleKey, ruleName);
        rule.setDescription(description);
        rule.setSeverity(RulePriority.fromCheckPriority(ruleAnnotation.priority()));
        rule.setCardinality(ruleAnnotation.cardinality());
        rule.setStatus(ruleAnnotation.status());
        rule.setTags(ruleAnnotation.tags());
        List<Field> fields = FieldUtils2.getFields(clazz, true);
        for (Field field : fields) {
            AnnotationRuleParser.addRuleProperty(rule, field);
        }
        return rule;
    }

    private static void addRuleProperty(Rule rule, Field field) {
        RuleProperty propertyAnnotation = field.getAnnotation(RuleProperty.class);
        if (propertyAnnotation != null) {
            String fieldKey = StringUtils.defaultIfEmpty((String)propertyAnnotation.key(), (String)field.getName());
            RuleParam param = rule.createParameter(fieldKey);
            param.setDescription(propertyAnnotation.description());
            param.setDefaultValue(propertyAnnotation.defaultValue());
            if (!StringUtils.isBlank((String)propertyAnnotation.type())) {
                try {
                    param.setType(PropertyType.valueOf(propertyAnnotation.type().trim()).name());
                }
                catch (IllegalArgumentException e) {
                    throw new SonarException("Invalid property type [" + propertyAnnotation.type() + "]", e);
                }
            } else {
                param.setType(AnnotationRuleParser.guessType(field.getType()).name());
            }
        }
    }

    static PropertyType guessType(Class<?> type) {
        return (PropertyType)((Object)TYPE_FOR_CLASS.apply(type));
    }
}

