/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarqube.ws.client.Headers;
import org.sonarqube.ws.client.Parameters;
import org.sonarqube.ws.client.WsRequest;

abstract class BaseRequest<SELF extends BaseRequest>
implements WsRequest {
    private final String path;
    private String mediaType = "application/json";
    private final DefaultParameters parameters = new DefaultParameters();
    private final DefaultHeaders headers = new DefaultHeaders();
    private OptionalInt timeOutInMs = OptionalInt.empty();

    BaseRequest(String path) {
        this.path = path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public OptionalInt getTimeOutInMs() {
        return this.timeOutInMs;
    }

    public SELF setTimeOutInMs(int timeOutInMs) {
        this.timeOutInMs = OptionalInt.of(timeOutInMs);
        return (SELF)this;
    }

    public SELF setMediaType(String s) {
        Objects.requireNonNull(s, "media type of response cannot be null");
        this.mediaType = s;
        return (SELF)this;
    }

    public SELF setParam(String key, @Nullable String value) {
        return this.setSingleValueParam(key, value);
    }

    public SELF setParam(String key, @Nullable Integer value) {
        return this.setSingleValueParam(key, value);
    }

    public SELF setParam(String key, @Nullable Long value) {
        return this.setSingleValueParam(key, value);
    }

    public SELF setParam(String key, @Nullable Float value) {
        return this.setSingleValueParam(key, value);
    }

    public SELF setParam(String key, @Nullable Boolean value) {
        return this.setSingleValueParam(key, value);
    }

    private SELF setSingleValueParam(String key, @Nullable Object value) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"a WS parameter key cannot be null");
        if (value == null) {
            return (SELF)this;
        }
        this.parameters.setValue(key, value.toString());
        return (SELF)this;
    }

    public SELF setParam(String key, @Nullable Collection<? extends Object> values) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"a WS parameter key cannot be null");
        if (values == null || values.isEmpty()) {
            return (SELF)this;
        }
        this.parameters.setValues(key, values.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList()));
        return (SELF)this;
    }

    @Override
    public Map<String, String> getParams() {
        return this.parameters.keyValues.keySet().stream().collect(Collectors.toMap(Function.identity(), key -> (String)this.parameters.keyValues.get(key).get(0), (v1, v2) -> {
            throw new IllegalStateException(String.format("Duplicate key '%s' in request", v1));
        }, LinkedHashMap::new));
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    public SELF setHeader(String name, @Nullable String value) {
        Objects.requireNonNull(name, "Header name can't be null");
        this.headers.setValue(name, value);
        return (SELF)this;
    }

    private static class DefaultHeaders
    implements Headers {
        private final Map<String, String> keyValues = new HashMap<String, String>();

        private DefaultHeaders() {
        }

        @Override
        public Optional<String> getValue(String name) {
            return Optional.ofNullable(this.keyValues.get(name));
        }

        private DefaultHeaders setValue(String name, @Nullable String value) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
            if (value == null) {
                this.keyValues.remove(name);
            } else {
                this.keyValues.put(name, value);
            }
            return this;
        }

        @Override
        public Set<String> getNames() {
            return Collections.unmodifiableSet(this.keyValues.keySet());
        }
    }

    private static class DefaultParameters
    implements Parameters {
        private final ListMultimap<String, String> keyValues = LinkedListMultimap.create();

        private DefaultParameters() {
        }

        @Override
        @CheckForNull
        public String getValue(String key) {
            return this.keyValues.containsKey((Object)key) ? (String)this.keyValues.get((Object)key).get(0) : null;
        }

        @Override
        public List<String> getValues(String key) {
            return this.keyValues.get((Object)key);
        }

        @Override
        public Set<String> getKeys() {
            return this.keyValues.keySet();
        }

        private DefaultParameters setValue(String key, String value) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0);
            Preconditions.checkArgument((value != null ? 1 : 0) != 0);
            this.keyValues.putAll((Object)key, Collections.singletonList(value));
            return this;
        }

        private DefaultParameters setValues(String key, Collection<String> values) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0);
            Preconditions.checkArgument((values != null && !values.isEmpty() ? 1 : 0) != 0);
            this.keyValues.putAll((Object)key, (Iterable)values.stream().map(Object::toString).filter(Objects::nonNull).collect(Collectors.toList()));
            return this;
        }
    }
}

