/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sonar.api.server.ws.LocalConnector;
import org.sonarqube.ws.client.BaseResponse;
import org.sonarqube.ws.client.WsConnector;
import org.sonarqube.ws.client.WsRequest;
import org.sonarqube.ws.client.WsResponse;

class LocalWsConnector
implements WsConnector {
    private final LocalConnector localConnector;

    LocalWsConnector(LocalConnector localConnector) {
        this.localConnector = localConnector;
    }

    @VisibleForTesting
    LocalConnector localConnector() {
        return this.localConnector;
    }

    @Override
    public String baseUrl() {
        return "/";
    }

    @Override
    public WsResponse call(WsRequest wsRequest) {
        DefaultLocalRequest localRequest = new DefaultLocalRequest(wsRequest);
        LocalConnector.LocalResponse localResponse = this.localConnector.call((LocalConnector.LocalRequest)localRequest);
        return new ByteArrayResponse(wsRequest.getPath(), localResponse);
    }

    private static class ByteArrayResponse
    extends BaseResponse {
        private final String path;
        private final byte[] bytes;
        private final String contentType;
        private final int code;

        ByteArrayResponse(String path, LocalConnector.LocalResponse localResponse) {
            this.path = path;
            this.bytes = localResponse.getBytes();
            this.contentType = localResponse.getMediaType();
            this.code = localResponse.getStatus();
        }

        @Override
        public String requestUrl() {
            return this.path;
        }

        @Override
        public int code() {
            return this.code;
        }

        @Override
        public String contentType() {
            return this.contentType;
        }

        @Override
        public InputStream contentStream() {
            return new ByteArrayInputStream(this.bytes);
        }

        @Override
        public Reader contentReader() {
            return new InputStreamReader((InputStream)new ByteArrayInputStream(this.bytes), StandardCharsets.UTF_8);
        }

        @Override
        public String content() {
            return new String(this.bytes, StandardCharsets.UTF_8);
        }

        @Override
        public Optional<String> header(String name) {
            return Optional.empty();
        }
    }

    private static class DefaultLocalRequest
    implements LocalConnector.LocalRequest {
        private final WsRequest wsRequest;

        public DefaultLocalRequest(WsRequest wsRequest) {
            this.wsRequest = wsRequest;
        }

        public String getPath() {
            return this.wsRequest.getPath();
        }

        public String getMediaType() {
            return this.wsRequest.getMediaType();
        }

        public String getMethod() {
            return this.wsRequest.getMethod().name();
        }

        public boolean hasParam(String key) {
            return !this.wsRequest.getParameters().getValues(key).isEmpty();
        }

        public String getParam(String key) {
            return this.wsRequest.getParameters().getValue(key);
        }

        public List<String> getMultiParam(String key) {
            return this.wsRequest.getParameters().getValues(key);
        }

        public Optional<String> getHeader(String name) {
            return this.wsRequest.getHeaders().getValue(name);
        }

        public Map<String, String[]> getParameterMap() {
            return this.wsRequest.getParameters().getKeys().stream().collect(Collectors.toMap(Function.identity(), k -> this.wsRequest.getParameters().getValues((String)k).toArray(new String[0])));
        }
    }
}

