/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client;

import com.google.common.base.Throwables;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.sonarqube.ws.client.BaseResponse;

public class MockWsResponse
extends BaseResponse {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private int code = 200;
    private String requestUrl;
    private byte[] content;
    private final Map<String, String> headers = new HashMap<String, String>();

    @Override
    public int code() {
        return this.code;
    }

    public MockWsResponse setCode(int code) {
        this.code = code;
        return this;
    }

    @Override
    public String contentType() {
        return Objects.requireNonNull(this.headers.get(CONTENT_TYPE_HEADER));
    }

    @Override
    public Optional<String> header(String name) {
        return Optional.ofNullable(this.headers.get(name));
    }

    public MockWsResponse setContentType(String contentType) {
        this.headers.put(CONTENT_TYPE_HEADER, contentType);
        return this;
    }

    public MockWsResponse setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
        return this;
    }

    public MockWsResponse setContent(InputStream is) {
        try {
            return this.setContent(IOUtils.toByteArray((InputStream)is));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public MockWsResponse setContent(byte[] b) {
        this.content = b;
        return this;
    }

    public MockWsResponse setContent(String s) {
        this.content = s.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    @Override
    public boolean hasContent() {
        return this.content != null;
    }

    @Override
    public String requestUrl() {
        Objects.requireNonNull(this.requestUrl);
        return this.requestUrl;
    }

    @Override
    public InputStream contentStream() {
        Objects.requireNonNull(this.content);
        return new ByteArrayInputStream(this.content);
    }

    @Override
    public Reader contentReader() {
        Objects.requireNonNull(this.content);
        return new StringReader(new String(this.content, StandardCharsets.UTF_8));
    }

    @Override
    public String content() {
        Objects.requireNonNull(this.content);
        return new String(this.content, StandardCharsets.UTF_8);
    }

    public static MockWsResponse createJson(String json) {
        return new MockWsResponse().setContentType("application/json").setContentType(json);
    }
}

