/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.config.Configuration;
import org.sonar.api.internal.google.common.annotations.VisibleForTesting;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.dotnet.tests.Coverage;
import org.sonar.plugins.dotnet.tests.CoverageCache;
import org.sonar.plugins.dotnet.tests.CoverageConfiguration;
import org.sonar.plugins.dotnet.tests.CoverageParser;
import org.sonar.plugins.dotnet.tests.DotCoverReportParser;
import org.sonar.plugins.dotnet.tests.DotCoverReportsAggregator;
import org.sonar.plugins.dotnet.tests.NCover3ReportParser;
import org.sonar.plugins.dotnet.tests.OpenCoverReportParser;
import org.sonar.plugins.dotnet.tests.VisualStudioCoverageXmlReportParser;
import org.sonar.plugins.dotnet.tests.WildcardPatternFileProvider;

@ScannerSide
public class CoverageAggregator {
    private static final Logger LOG = Loggers.get(CoverageAggregator.class);
    private final CoverageConfiguration coverageConf;
    private final Configuration configuration;
    private final CoverageCache coverageCache;
    private final NCover3ReportParser ncover3ReportParser;
    private final OpenCoverReportParser openCoverReportParser;
    private final DotCoverReportsAggregator dotCoverReportsAggregator;
    private final VisualStudioCoverageXmlReportParser visualStudioCoverageXmlReportParser;

    public CoverageAggregator(CoverageConfiguration coverageConf, Configuration configuration, FileSystem fs) {
        Predicate<String> isSupportedLanguage = absolutePath -> fs.hasFiles(fs.predicates().and(fs.predicates().hasAbsolutePath(absolutePath), fs.predicates().hasLanguage(coverageConf.languageKey())));
        this.coverageConf = coverageConf;
        this.configuration = configuration;
        this.coverageCache = new CoverageCache();
        this.ncover3ReportParser = new NCover3ReportParser(isSupportedLanguage);
        this.openCoverReportParser = new OpenCoverReportParser(isSupportedLanguage);
        this.dotCoverReportsAggregator = new DotCoverReportsAggregator(new DotCoverReportParser(isSupportedLanguage));
        this.visualStudioCoverageXmlReportParser = new VisualStudioCoverageXmlReportParser(isSupportedLanguage);
    }

    @VisibleForTesting
    CoverageAggregator(CoverageConfiguration coverageConf, Configuration configuration, CoverageCache coverageCache, NCover3ReportParser ncover3ReportParser, OpenCoverReportParser openCoverReportParser, DotCoverReportsAggregator dotCoverReportsAggregator, VisualStudioCoverageXmlReportParser visualStudioCoverageXmlReportParser) {
        this.coverageConf = coverageConf;
        this.configuration = configuration;
        this.coverageCache = coverageCache;
        this.ncover3ReportParser = ncover3ReportParser;
        this.openCoverReportParser = openCoverReportParser;
        this.dotCoverReportsAggregator = dotCoverReportsAggregator;
        this.visualStudioCoverageXmlReportParser = visualStudioCoverageXmlReportParser;
    }

    boolean hasCoverageProperty() {
        return this.hasCoverageProperty(arg_0 -> ((Configuration)this.configuration).hasKey(arg_0));
    }

    boolean hasCoverageProperty(Predicate<String> hasKeyPredicate) {
        return this.hasNCover3ReportPaths(hasKeyPredicate) || this.hasOpenCoverReportPaths(hasKeyPredicate) || this.hasDotCoverReportPaths(hasKeyPredicate) || this.hasVisualStudioCoverageXmlReportPaths(hasKeyPredicate);
    }

    private boolean hasNCover3ReportPaths(Predicate<String> hasKeyPredicate) {
        return hasKeyPredicate.test(this.coverageConf.ncover3PropertyKey());
    }

    private boolean hasOpenCoverReportPaths(Predicate<String> hasKeyPredicate) {
        return hasKeyPredicate.test(this.coverageConf.openCoverPropertyKey());
    }

    private boolean hasDotCoverReportPaths(Predicate<String> hasKeyPredicate) {
        return hasKeyPredicate.test(this.coverageConf.dotCoverPropertyKey());
    }

    private boolean hasVisualStudioCoverageXmlReportPaths(Predicate<String> hasKeyPredicate) {
        return hasKeyPredicate.test(this.coverageConf.visualStudioCoverageXmlPropertyKey());
    }

    Coverage aggregate(WildcardPatternFileProvider wildcardPatternFileProvider, Coverage coverage) {
        if (this.hasNCover3ReportPaths(arg_0 -> ((Configuration)this.configuration).hasKey(arg_0))) {
            this.aggregate(wildcardPatternFileProvider, this.configuration.getStringArray(this.coverageConf.ncover3PropertyKey()), this.ncover3ReportParser, coverage);
        }
        if (this.hasOpenCoverReportPaths(arg_0 -> ((Configuration)this.configuration).hasKey(arg_0))) {
            this.aggregate(wildcardPatternFileProvider, this.configuration.getStringArray(this.coverageConf.openCoverPropertyKey()), this.openCoverReportParser, coverage);
        }
        if (this.hasDotCoverReportPaths(arg_0 -> ((Configuration)this.configuration).hasKey(arg_0))) {
            this.aggregate(wildcardPatternFileProvider, this.configuration.getStringArray(this.coverageConf.dotCoverPropertyKey()), this.dotCoverReportsAggregator, coverage);
        }
        if (this.hasVisualStudioCoverageXmlReportPaths(arg_0 -> ((Configuration)this.configuration).hasKey(arg_0))) {
            this.aggregate(wildcardPatternFileProvider, this.configuration.getStringArray(this.coverageConf.visualStudioCoverageXmlPropertyKey()), this.visualStudioCoverageXmlReportParser, coverage);
        }
        return coverage;
    }

    private void aggregate(WildcardPatternFileProvider wildcardPatternFileProvider, String[] reportPaths, CoverageParser parser, Coverage aggregatedCoverage) {
        for (String reportPathPattern : reportPaths) {
            if (reportPathPattern.isEmpty()) continue;
            Set<File> filesMatchingPattern = wildcardPatternFileProvider.listFiles(reportPathPattern);
            if (filesMatchingPattern.isEmpty()) {
                LOG.warn("Could not find any coverage report file matching the pattern '{}'.", (Object)reportPathPattern);
                continue;
            }
            for (File reportFile : filesMatchingPattern) {
                aggregatedCoverage.mergeWith(this.coverageCache.readCoverageFromCacheOrParse(parser, reportFile));
            }
        }
    }
}

