/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.RulesDefinitionXmlLoader;
import org.sonar.api.utils.Version;

@ScannerSide
public abstract class AbstractRulesDefinition
implements RulesDefinition {
    private static final Version SQ_7_3 = Version.create((int)7, (int)3);
    private static final Gson GSON = new Gson();
    private final String repositoryKey;
    private final String repositoryName;
    private final String languageKey;
    private final String rulesXmlFilePath;
    private final boolean supportsSecurityHotspots;

    protected AbstractRulesDefinition(String repositoryKey, String repositoryName, String languageKey, String rulesXmlFilePath) {
        this(repositoryKey, repositoryName, languageKey, rulesXmlFilePath, null);
    }

    protected AbstractRulesDefinition(String repositoryKey, String repositoryName, String languageKey, String rulesXmlFilePath, @Nullable SonarRuntime sonarRuntime) {
        this.repositoryKey = repositoryKey;
        this.repositoryName = repositoryName;
        this.languageKey = languageKey;
        this.rulesXmlFilePath = rulesXmlFilePath;
        this.supportsSecurityHotspots = sonarRuntime != null && sonarRuntime.getApiVersion().isGreaterThanOrEqual(SQ_7_3);
    }

    public void define(RulesDefinition.Context context) {
        RulesDefinition.NewRepository repository = context.createRepository(this.repositoryKey, this.languageKey).setName(this.repositoryName);
        RulesDefinitionXmlLoader loader = new RulesDefinitionXmlLoader();
        loader.load(repository, (Reader)new InputStreamReader(this.getClass().getResourceAsStream(this.rulesXmlFilePath), StandardCharsets.UTF_8));
        this.setupHotspotRules(repository.rules());
        repository.done();
    }

    private void setupHotspotRules(Collection<RulesDefinition.NewRule> rules) {
        Map<RulesDefinition.NewRule, RuleMetadata> allRuleMetadata = rules.stream().collect(Collectors.toMap(rule -> rule, rule -> this.readRuleMetadata(rule.key())));
        Set<RulesDefinition.NewRule> hotspotRules = AbstractRulesDefinition.getHotspotRules(allRuleMetadata);
        if (this.supportsSecurityHotspots) {
            allRuleMetadata.forEach(AbstractRulesDefinition::updateSecurityStandards);
            hotspotRules.forEach(rule -> rule.setType(RuleType.SECURITY_HOTSPOT));
        } else {
            rules.removeAll(hotspotRules);
        }
    }

    private static Set<RulesDefinition.NewRule> getHotspotRules(Map<RulesDefinition.NewRule, RuleMetadata> allRuleMetadata) {
        return allRuleMetadata.entrySet().stream().filter(entry -> ((RuleMetadata)entry.getValue()).isSecurityHotspot()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private static void updateSecurityStandards(RulesDefinition.NewRule rule, RuleMetadata ruleMetadata) {
        for (String s : ruleMetadata.securityStandards.OWASP) {
            rule.addOwaspTop10(new RulesDefinition.OwaspTop10[]{RulesDefinition.OwaspTop10.valueOf((String)s)});
        }
        rule.addCwe(ruleMetadata.securityStandards.CWE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RuleMetadata readRuleMetadata(String ruleKey) {
        String resourcePath = this.getRuleJson(ruleKey);
        try (InputStream stream = AbstractRulesDefinition.class.getResourceAsStream(resourcePath);){
            RuleMetadata ruleMetadata = stream != null ? GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), RuleMetadata.class) : new RuleMetadata();
            return ruleMetadata;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read: " + resourcePath, e);
        }
    }

    protected abstract String getRuleJson(String var1);

    private static class SecurityStandards {
        int[] CWE = new int[0];
        String[] OWASP = new String[0];

        private SecurityStandards() {
        }
    }

    private static class RuleMetadata {
        private static final String SECURITY_HOTSPOT = "SECURITY_HOTSPOT";
        String sqKey;
        String type;
        SecurityStandards securityStandards = new SecurityStandards();

        private RuleMetadata() {
        }

        String getKey() {
            return this.sqKey;
        }

        boolean isSecurityHotspot() {
            return SECURITY_HOTSPOT.equals(this.type);
        }
    }
}

