/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.protobuf;

import com.google.protobuf.Parser;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;
import org.sonarsource.dotnet.shared.plugins.protobuf.RawProtobufImporter;

public class FileMetadataImporter
extends RawProtobufImporter<SonarAnalyzer.FileMetadataInfo> {
    private final Set<Path> generatedFilePaths = new HashSet<Path>();

    FileMetadataImporter(Parser<SonarAnalyzer.FileMetadataInfo> parser) {
        super(parser);
    }

    public FileMetadataImporter() {
        this(SonarAnalyzer.FileMetadataInfo.parser());
    }

    @Override
    void consume(SonarAnalyzer.FileMetadataInfo message) {
        if (message.getIsGenerated()) {
            this.generatedFilePaths.add(Paths.get(message.getFilePath(), new String[0]));
        }
    }

    public Set<Path> getGeneratedFilePaths() {
        return this.generatedFilePaths;
    }
}

