/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.config;

import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang.ArrayUtils;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.Settings;
import org.sonar.api.config.internal.MultivalueProperty;

public class ConfigurationProvider
extends ProviderAdapter {
    private Configuration configuration;

    public Configuration provide(Settings settings) {
        if (this.configuration == null) {
            this.configuration = new ServerConfigurationAdapter(settings);
        }
        return this.configuration;
    }

    private static class ServerConfigurationAdapter
    implements Configuration {
        private static final Function<String, String> REPLACE_ENCODED_COMMAS = value -> value.replace("%2C", ",");
        private final Settings settings;

        private ServerConfigurationAdapter(Settings settings) {
            this.settings = settings;
        }

        public Optional<String> get(String key) {
            return Optional.ofNullable(this.settings.getString(key));
        }

        public boolean hasKey(String key) {
            return this.settings.hasKey(key);
        }

        public String[] getStringArray(String key) {
            boolean multiValue = this.settings.getDefinition(key).map(PropertyDefinition::multiValues).orElse(false);
            return this.get(key).map(v -> MultivalueProperty.parseAsCsv((String)key, (String)v, multiValue ? REPLACE_ENCODED_COMMAS : Function.identity())).orElse(ArrayUtils.EMPTY_STRING_ARRAY);
        }
    }
}

