/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequestBuilder;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.sort.SortOrder;
import org.joda.time.format.ISODateTimeFormat;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.es.BaseDoc;
import org.sonar.server.es.EsClient;

public class EsUtils {
    public static final int SCROLL_TIME_IN_MINUTES = 3;
    private static final Pattern SPECIAL_REGEX_CHARS = Pattern.compile("[#@&~<>\"{}()\\[\\].+*?^$\\\\|]");

    private EsUtils() {
    }

    public static <D extends BaseDoc> List<D> convertToDocs(SearchHits hits, Function<Map<String, Object>, D> converter) {
        ArrayList<D> docs = new ArrayList<D>();
        for (SearchHit hit : hits.getHits()) {
            docs.add(converter.apply(hit.getSourceAsMap()));
        }
        return docs;
    }

    public static Map<String, Long> termsToMap(Terms terms) {
        LinkedHashMap<String, Long> map = new LinkedHashMap<String, Long>();
        List buckets = terms.getBuckets();
        for (Terms.Bucket bucket : buckets) {
            map.put(bucket.getKeyAsString(), bucket.getDocCount());
        }
        return map;
    }

    public static List<String> termsKeys(Terms terms) {
        return (List)terms.getBuckets().stream().map(MultiBucketsAggregation.Bucket::getKeyAsString).collect(MoreCollectors.toList((int)terms.getBuckets().size()));
    }

    @CheckForNull
    public static Date parseDateTime(@Nullable String s) {
        if (s == null) {
            return null;
        }
        return ISODateTimeFormat.dateTime().parseDateTime(s).toDate();
    }

    @CheckForNull
    public static String formatDateTime(@Nullable Date date) {
        if (date != null) {
            return ISODateTimeFormat.dateTime().print(date.getTime());
        }
        return null;
    }

    public static void optimizeScrollRequest(SearchRequestBuilder esSearch) {
        esSearch.addSort("_doc", SortOrder.ASC);
    }

    public static String escapeSpecialRegexChars(String str) {
        return SPECIAL_REGEX_CHARS.matcher(str).replaceAll("\\\\$0");
    }

    public static <I> Iterator<I> scrollIds(EsClient esClient, SearchResponse scrollResponse, Function<String, I> idConverter) {
        return new IdScrollIterator(esClient, scrollResponse, idConverter);
    }

    private static class IdScrollIterator<I>
    implements Iterator<I> {
        private final EsClient esClient;
        private final String scrollId;
        private final Function<String, I> idConverter;
        private final Queue<SearchHit> hits = new ArrayDeque<SearchHit>();

        private IdScrollIterator(EsClient esClient, SearchResponse scrollResponse, Function<String, I> idConverter) {
            this.esClient = esClient;
            this.scrollId = scrollResponse.getScrollId();
            this.idConverter = idConverter;
            Collections.addAll(this.hits, scrollResponse.getHits().getHits());
        }

        @Override
        public boolean hasNext() {
            if (this.hits.isEmpty()) {
                SearchScrollRequestBuilder esRequest = this.esClient.prepareSearchScroll(this.scrollId).setScroll(TimeValue.timeValueMinutes((long)3L));
                Collections.addAll(this.hits, ((SearchResponse)esRequest.get()).getHits().getHits());
            }
            return !this.hits.isEmpty();
        }

        @Override
        public I next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.idConverter.apply(this.hits.poll().getId());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove item when scrolling");
        }
    }
}

