/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.newindex;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.elasticsearch.common.settings.Settings;
import org.sonar.api.config.Configuration;
import org.sonar.process.ProcessProperties;
import org.sonar.server.es.Index;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.newindex.BuiltIndex;
import org.sonar.server.es.newindex.DefaultIndexSettings;
import org.sonar.server.es.newindex.SettingsConfiguration;
import org.sonar.server.es.newindex.TypeMapping;

public abstract class NewIndex<T extends NewIndex<T>> {
    private static final String ENABLED = "enabled";
    private final Index index;
    private final Map<String, IndexType.IndexRelationType> relations = new LinkedHashMap<String, IndexType.IndexRelationType>();
    private final Settings.Builder settings = DefaultIndexSettings.defaults();
    private final Map<String, Object> attributes = new TreeMap<String, Object>();
    private final Map<String, Object> properties = new TreeMap<String, Object>();

    public NewIndex(Index index, SettingsConfiguration settingsConfiguration) {
        this.index = index;
        this.applySettingsConfiguration(settingsConfiguration);
        this.configureDefaultAttributes();
    }

    private void applySettingsConfiguration(SettingsConfiguration settingsConfiguration) {
        this.settings.put("index.refresh_interval", NewIndex.refreshInterval(settingsConfiguration));
        Configuration config = settingsConfiguration.getConfiguration();
        boolean clusterMode = config.getBoolean(ProcessProperties.Property.CLUSTER_ENABLED.getKey()).orElse(false);
        int shards = config.getInt(String.format("sonar.search.%s.shards", this.index.getName())).orElse(settingsConfiguration.getDefaultNbOfShards());
        int replicas = clusterMode ? config.getInt(ProcessProperties.Property.SEARCH_REPLICAS.getKey()).orElse(1) : 0;
        this.settings.put("index.number_of_shards", shards);
        this.settings.put("index.number_of_replicas", replicas);
        this.settings.put("index.max_ngram_diff", 13);
    }

    private void configureDefaultAttributes() {
        this.attributes.put("dynamic", String.valueOf(false));
        this.attributes.put("_source", ImmutableSortedMap.of((Comparable)((Object)ENABLED), (Object)true));
    }

    private static String refreshInterval(SettingsConfiguration settingsConfiguration) {
        int refreshInterval = settingsConfiguration.getRefreshInterval();
        if (refreshInterval == -1) {
            return "-1";
        }
        return refreshInterval + "s";
    }

    protected Index getIndex() {
        return this.index;
    }

    public abstract IndexType.IndexMainType getMainType();

    Collection<IndexType.IndexRelationType> getRelations() {
        return this.relations.values();
    }

    public Stream<IndexType.IndexRelationType> getRelationsStream() {
        return this.relations.values().stream();
    }

    Settings.Builder getSettings() {
        return this.settings;
    }

    @CheckForNull
    public String getSetting(String key) {
        return this.settings.get(key);
    }

    protected TypeMapping createTypeMapping(IndexType.IndexMainType mainType) {
        Preconditions.checkArgument((boolean)mainType.getIndex().equals(this.index), (String)"Main type must belong to index %s", (Object[])new Object[]{this.index});
        return new TypeMapping(this);
    }

    protected TypeMapping createTypeMapping(IndexType.IndexRelationType relationType) {
        this.checkAcceptsRelations();
        IndexType.IndexMainType mainType = this.getMainType();
        Preconditions.checkArgument((boolean)relationType.getMainType().equals(mainType), (String)"mainType of relation must be %s", (Object[])new Object[]{mainType});
        String relationName = relationType.getName();
        Preconditions.checkArgument((!this.relations.containsKey(relationName) ? 1 : 0) != 0, (String)"relation %s already exists", (Object[])new Object[]{relationName});
        this.relations.put(relationName, relationType);
        return new TypeMapping(this);
    }

    private void checkAcceptsRelations() {
        Preconditions.checkState((boolean)this.getMainType().getIndex().acceptsRelations(), (Object)"Index is not configured to accept relations. Update IndexDefinition.Descriptor instance for this index");
    }

    void setFieldImpl(String fieldName, Object attributes) {
        this.properties.put(fieldName, attributes);
    }

    public T setEnableSource(boolean enableSource) {
        this.attributes.put("_source", ImmutableSortedMap.of((Comparable)((Object)ENABLED), (Object)enableSource));
        return this.castThis();
    }

    private T castThis() {
        return (T)this;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    Map<String, Object> getProperties() {
        return this.properties;
    }

    @CheckForNull
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public abstract BuiltIndex<T> build();
}

