/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.textsearch;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.sonar.server.es.textsearch.ComponentTextSearchFeature;
import org.sonar.server.es.textsearch.JavaTokenizer;

public class ComponentTextSearchQueryFactory {
    private ComponentTextSearchQueryFactory() {
    }

    public static QueryBuilder createQuery(ComponentTextSearchQuery query, ComponentTextSearchFeature ... features) {
        Preconditions.checkArgument((features.length > 0 ? 1 : 0) != 0, (Object)"features cannot be empty");
        BoolQueryBuilder esQuery = QueryBuilders.boolQuery().must(ComponentTextSearchQueryFactory.createQuery(query, features, ComponentTextSearchFeature.UseCase.GENERATE_RESULTS).orElseThrow(() -> new IllegalStateException("No text search features found to generate search results. Features: " + Arrays.toString(features))));
        ComponentTextSearchQueryFactory.createQuery(query, features, ComponentTextSearchFeature.UseCase.CHANGE_ORDER_OF_RESULTS).ifPresent(arg_0 -> ((BoolQueryBuilder)esQuery).should(arg_0));
        return esQuery;
    }

    private static Optional<QueryBuilder> createQuery(ComponentTextSearchQuery query, ComponentTextSearchFeature[] features, ComponentTextSearchFeature.UseCase useCase) {
        BoolQueryBuilder generateResults = QueryBuilders.boolQuery();
        AtomicBoolean anyFeatures = new AtomicBoolean();
        Arrays.stream(features).filter(f -> f.getUseCase() == useCase).peek(f -> anyFeatures.set(true)).flatMap(f -> f.getQueries(query)).forEach(arg_0 -> ((BoolQueryBuilder)generateResults).should(arg_0));
        if (anyFeatures.get()) {
            return Optional.of(generateResults);
        }
        return Optional.empty();
    }

    public static class ComponentTextSearchQuery {
        private final String queryText;
        private final List<String> queryTextTokens;
        private final String fieldKey;
        private final String fieldName;
        private final Set<String> recentlyBrowsedKeys;
        private final Set<String> favoriteKeys;

        private ComponentTextSearchQuery(Builder builder) {
            this.queryText = builder.queryText;
            this.queryTextTokens = JavaTokenizer.split(builder.queryText);
            this.fieldKey = builder.fieldKey;
            this.fieldName = builder.fieldName;
            this.recentlyBrowsedKeys = builder.recentlyBrowsedKeys;
            this.favoriteKeys = builder.favoriteKeys;
        }

        public String getQueryText() {
            return this.queryText;
        }

        public List<String> getQueryTextTokens() {
            return this.queryTextTokens;
        }

        public String getFieldKey() {
            return this.fieldKey;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Set<String> getRecentlyBrowsedKeys() {
            return this.recentlyBrowsedKeys;
        }

        public static Builder builder() {
            return new Builder();
        }

        public Set<String> getFavoriteKeys() {
            return this.favoriteKeys;
        }

        public static class Builder {
            private String queryText;
            private String fieldKey;
            private String fieldName;
            private Set<String> recentlyBrowsedKeys = Collections.emptySet();
            private Set<String> favoriteKeys = Collections.emptySet();

            public Builder setQueryText(String queryText) {
                this.queryText = queryText;
                return this;
            }

            public Builder setFieldKey(String fieldKey) {
                this.fieldKey = fieldKey;
                return this;
            }

            public Builder setFieldName(String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            public Builder setRecentlyBrowsedKeys(Set<String> recentlyBrowsedKeys) {
                this.recentlyBrowsedKeys = ImmutableSet.copyOf(recentlyBrowsedKeys);
                return this;
            }

            public Builder setFavoriteKeys(Set<String> favoriteKeys) {
                this.favoriteKeys = ImmutableSet.copyOf(favoriteKeys);
                return this;
            }

            public ComponentTextSearchQuery build() {
                Objects.requireNonNull(this.queryText, "query text cannot be null");
                Objects.requireNonNull(this.fieldKey, "field key cannot be null");
                Objects.requireNonNull(this.fieldName, "field name cannot be null");
                Objects.requireNonNull(this.recentlyBrowsedKeys, "field recentlyBrowsedKeys cannot be null");
                Objects.requireNonNull(this.favoriteKeys, "field favoriteKeys cannot be null");
                return new ComponentTextSearchQuery(this);
            }
        }
    }
}

