/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.favorite;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.property.PropertyDto;
import org.sonar.db.property.PropertyQuery;

public class FavoriteUpdater {
    static final String PROP_FAVORITE_KEY = "favourite";
    private final DbClient dbClient;

    public FavoriteUpdater(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public void add(DbSession dbSession, ComponentDto componentDto, @Nullable Integer userId, boolean failIfTooManyFavorites) {
        if (userId == null) {
            return;
        }
        List existingFavoriteOnComponent = this.dbClient.propertiesDao().selectByQuery(PropertyQuery.builder().setKey(PROP_FAVORITE_KEY).setUserId(userId).setComponentId(componentDto.getId()).build(), dbSession);
        Preconditions.checkArgument((boolean)existingFavoriteOnComponent.isEmpty(), (String)"Component '%s' is already a favorite", (Object[])new Object[]{componentDto.getDbKey()});
        List existingFavorites = this.dbClient.propertiesDao().selectByKeyAndUserIdAndComponentQualifier(dbSession, PROP_FAVORITE_KEY, userId.intValue(), componentDto.qualifier());
        if (existingFavorites.size() >= 100) {
            Preconditions.checkArgument((!failIfTooManyFavorites ? 1 : 0) != 0, (String)"You cannot have more than 100 favorites on components with qualifier '%s'", (Object[])new Object[]{componentDto.qualifier()});
            return;
        }
        this.dbClient.propertiesDao().saveProperty(dbSession, new PropertyDto().setKey(PROP_FAVORITE_KEY).setResourceId(componentDto.getId()).setUserId(userId));
    }

    public void remove(DbSession dbSession, ComponentDto component, @Nullable Integer userId) {
        if (userId == null) {
            return;
        }
        int result = this.dbClient.propertiesDao().delete(dbSession, new PropertyDto().setKey(PROP_FAVORITE_KEY).setResourceId(component.getId()).setUserId(userId));
        Preconditions.checkArgument((result == 1 ? 1 : 0) != 0, (String)"Component '%s' is not a favorite", (Object[])new Object[]{component.getDbKey()});
    }
}

