/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.index;

import java.util.Map;
import org.sonar.api.rules.RuleType;

public class BranchStatistics {
    private final String branchUuid;
    private final long bugs;
    private final long vulnerabilities;
    private final long codeSmells;

    public BranchStatistics(String branchUuid, Map<String, Long> issueCountByType) {
        this.branchUuid = branchUuid;
        this.bugs = BranchStatistics.getNonNullValue(issueCountByType, RuleType.BUG);
        this.vulnerabilities = BranchStatistics.getNonNullValue(issueCountByType, RuleType.VULNERABILITY);
        this.codeSmells = BranchStatistics.getNonNullValue(issueCountByType, RuleType.CODE_SMELL);
    }

    public String getBranchUuid() {
        return this.branchUuid;
    }

    public long getBugs() {
        return this.bugs;
    }

    public long getVulnerabilities() {
        return this.vulnerabilities;
    }

    public long getCodeSmells() {
        return this.codeSmells;
    }

    private static long getNonNullValue(Map<String, Long> issueCountByType, RuleType type) {
        Long value = issueCountByType.get(type.name());
        return value == null ? 0L : value;
    }
}

