/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.index;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.es.EsQueueDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.server.es.BulkIndexer;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.IndexingListener;
import org.sonar.server.es.IndexingResult;
import org.sonar.server.es.OneToManyResilientIndexingListener;
import org.sonar.server.es.OneToOneResilientIndexingListener;
import org.sonar.server.es.ProjectIndexer;
import org.sonar.server.issue.index.IssueDoc;
import org.sonar.server.issue.index.IssueIndexDefinition;
import org.sonar.server.issue.index.IssueIterator;
import org.sonar.server.issue.index.IssueIteratorFactory;
import org.sonar.server.permission.index.AuthorizationDoc;
import org.sonar.server.permission.index.AuthorizationScope;
import org.sonar.server.permission.index.NeedAuthorizationIndexer;

public class IssueIndexer
implements ProjectIndexer,
NeedAuthorizationIndexer {
    private static final String ID_TYPE_ISSUE_KEY = "issueKey";
    private static final String ID_TYPE_PROJECT_UUID = "projectUuid";
    private static final Logger LOGGER = Loggers.get(IssueIndexer.class);
    private static final AuthorizationScope AUTHORIZATION_SCOPE = new AuthorizationScope(IssueIndexDefinition.TYPE_ISSUE, project -> "TRK".equals(project.getQualifier()));
    private static final ImmutableSet<IndexType> INDEX_TYPES = ImmutableSet.of((Object)IssueIndexDefinition.TYPE_ISSUE);
    private final EsClient esClient;
    private final DbClient dbClient;
    private final IssueIteratorFactory issueIteratorFactory;

    public IssueIndexer(EsClient esClient, DbClient dbClient, IssueIteratorFactory issueIteratorFactory) {
        this.esClient = esClient;
        this.dbClient = dbClient;
        this.issueIteratorFactory = issueIteratorFactory;
    }

    @Override
    public AuthorizationScope getAuthorizationScope() {
        return AUTHORIZATION_SCOPE;
    }

    @Override
    public Set<IndexType> getIndexTypes() {
        return INDEX_TYPES;
    }

    @Override
    public void indexOnStartup(Set<IndexType> uninitializedIndexTypes) {
        try (IssueIterator issues = this.issueIteratorFactory.createForAll();){
            this.doIndex(issues, BulkIndexer.Size.LARGE, IndexingListener.FAIL_ON_ERROR);
        }
    }

    @Override
    public void indexOnAnalysis(String branchUuid) {
        try (IssueIterator issues = this.issueIteratorFactory.createForProject(branchUuid);){
            this.doIndex(issues, BulkIndexer.Size.REGULAR, IndexingListener.FAIL_ON_ERROR);
        }
    }

    @Override
    public Collection<EsQueueDto> prepareForRecovery(DbSession dbSession, Collection<String> projectUuids, ProjectIndexer.Cause cause) {
        switch (cause) {
            case PROJECT_CREATION: 
            case MEASURE_CHANGE: 
            case PROJECT_KEY_UPDATE: 
            case PROJECT_TAGS_UPDATE: 
            case PERMISSION_CHANGE: {
                return Collections.emptyList();
            }
            case PROJECT_DELETION: {
                List items = (List)projectUuids.stream().map(projectUuid -> IssueIndexer.createQueueDto(projectUuid, ID_TYPE_PROJECT_UUID, projectUuid)).collect(MoreCollectors.toArrayList((int)projectUuids.size()));
                return this.dbClient.esQueueDao().insert(dbSession, (Collection)items);
            }
        }
        throw new IllegalStateException("Unsupported cause: " + (Object)((Object)cause));
    }

    public void commitAndIndexIssues(DbSession dbSession, Collection<IssueDto> issues) {
        ArrayListMultimap itemsByIssueKey = ArrayListMultimap.create();
        issues.stream().map(issue -> IssueIndexer.createQueueDto(issue.getKey(), ID_TYPE_ISSUE_KEY, issue.getProjectUuid())).forEach(arg_0 -> IssueIndexer.lambda$commitAndIndexIssues$3((ListMultimap)itemsByIssueKey, arg_0));
        this.dbClient.esQueueDao().insert(dbSession, itemsByIssueKey.values());
        dbSession.commit();
        this.doIndexIssueItems(dbSession, (ListMultimap<String, EsQueueDto>)itemsByIssueKey);
    }

    @Override
    public IndexingResult index(DbSession dbSession, Collection<EsQueueDto> items) {
        ArrayListMultimap itemsByIssueKey = ArrayListMultimap.create();
        ArrayListMultimap itemsByProjectKey = ArrayListMultimap.create();
        items.forEach(arg_0 -> IssueIndexer.lambda$index$4((ListMultimap)itemsByIssueKey, (ListMultimap)itemsByProjectKey, arg_0));
        IndexingResult result = new IndexingResult();
        result.add(this.doIndexIssueItems(dbSession, (ListMultimap<String, EsQueueDto>)itemsByIssueKey));
        result.add(this.doIndexProjectItems(dbSession, (ListMultimap<String, EsQueueDto>)itemsByProjectKey));
        return result;
    }

    private IndexingResult doIndexIssueItems(DbSession dbSession, ListMultimap<String, EsQueueDto> itemsByIssueKey) {
        if (itemsByIssueKey.isEmpty()) {
            return new IndexingResult();
        }
        OneToOneResilientIndexingListener listener = new OneToOneResilientIndexingListener(this.dbClient, dbSession, itemsByIssueKey.values());
        BulkIndexer bulkIndexer = this.createBulkIndexer(BulkIndexer.Size.REGULAR, listener);
        bulkIndexer.start();
        try (IssueIterator issues = this.issueIteratorFactory.createForIssueKeys(itemsByIssueKey.keySet());){
            while (issues.hasNext()) {
                IssueDoc issue = (IssueDoc)issues.next();
                bulkIndexer.add(this.newIndexRequest(issue));
                itemsByIssueKey.removeAll((Object)issue.getId());
            }
        }
        itemsByIssueKey.values().forEach(item -> bulkIndexer.addDeletion(IssueIndexDefinition.TYPE_ISSUE.getMainType(), item.getDocId(), item.getDocRouting()));
        return bulkIndexer.stop();
    }

    private IndexingResult doIndexProjectItems(DbSession dbSession, ListMultimap<String, EsQueueDto> itemsByProjectUuid) {
        if (itemsByProjectUuid.isEmpty()) {
            return new IndexingResult();
        }
        OneToManyResilientIndexingListener listener = new OneToManyResilientIndexingListener(this.dbClient, dbSession, itemsByProjectUuid.values());
        BulkIndexer bulkIndexer = this.createBulkIndexer(BulkIndexer.Size.REGULAR, listener);
        bulkIndexer.start();
        for (String projectUuid : itemsByProjectUuid.keySet()) {
            IssueIterator issues = this.issueIteratorFactory.createForProject(projectUuid);
            Throwable throwable = null;
            try {
                if (issues.hasNext()) {
                    do {
                        IssueDoc doc = (IssueDoc)issues.next();
                        bulkIndexer.add(this.newIndexRequest(doc));
                    } while (issues.hasNext());
                    continue;
                }
                this.addProjectDeletionToBulkIndexer(bulkIndexer, projectUuid);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (issues == null) continue;
                if (throwable != null) {
                    try {
                        issues.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                issues.close();
            }
        }
        return bulkIndexer.stop();
    }

    public void deleteByKeys(String projectUuid, Collection<String> issueKeys) {
        if (issueKeys.isEmpty()) {
            return;
        }
        BulkIndexer bulkIndexer = this.createBulkIndexer(BulkIndexer.Size.REGULAR, IndexingListener.FAIL_ON_ERROR);
        bulkIndexer.start();
        issueKeys.forEach(issueKey -> bulkIndexer.addDeletion(IssueIndexDefinition.TYPE_ISSUE.getMainType(), (String)issueKey, AuthorizationDoc.idOf(projectUuid)));
        bulkIndexer.stop();
    }

    @VisibleForTesting
    protected void index(Iterator<IssueDoc> issues) {
        this.doIndex(issues, BulkIndexer.Size.LARGE, IndexingListener.FAIL_ON_ERROR);
    }

    private void doIndex(Iterator<IssueDoc> issues, BulkIndexer.Size size, IndexingListener listener) {
        BulkIndexer bulk = this.createBulkIndexer(size, listener);
        bulk.start();
        while (issues.hasNext()) {
            IssueDoc issue = issues.next();
            bulk.add(this.newIndexRequest(issue));
        }
        bulk.stop();
    }

    private IndexRequest newIndexRequest(IssueDoc issue) {
        return (IndexRequest)this.esClient.prepareIndex(IssueIndexDefinition.TYPE_ISSUE.getMainType()).setId(issue.getId()).setRouting(issue.getRouting().orElseThrow(() -> new IllegalStateException("IssueDoc should define a routing"))).setSource(issue.getFields()).request();
    }

    private void addProjectDeletionToBulkIndexer(BulkIndexer bulkIndexer, String projectUuid) {
        SearchRequestBuilder search = this.esClient.prepareSearch(IssueIndexDefinition.TYPE_ISSUE.getMainType()).setRouting(AuthorizationDoc.idOf(projectUuid)).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"project", (String)projectUuid)));
        bulkIndexer.addDeletion(search);
    }

    private static EsQueueDto createQueueDto(String docId, String docIdType, String projectUuid) {
        return EsQueueDto.create((String)IssueIndexDefinition.TYPE_ISSUE.format(), (String)docId, (String)docIdType, (String)projectUuid);
    }

    private BulkIndexer createBulkIndexer(BulkIndexer.Size size, IndexingListener listener) {
        return new BulkIndexer(this.esClient, IssueIndexDefinition.TYPE_ISSUE, size, listener);
    }

    private static /* synthetic */ void lambda$index$4(ListMultimap itemsByIssueKey, ListMultimap itemsByProjectKey, EsQueueDto i) {
        if (ID_TYPE_ISSUE_KEY.equals(i.getDocIdType())) {
            itemsByIssueKey.put((Object)i.getDocId(), (Object)i);
        } else if (ID_TYPE_PROJECT_UUID.equals(i.getDocIdType())) {
            itemsByProjectKey.put((Object)i.getDocId(), (Object)i);
        } else {
            LOGGER.error("Unsupported es_queue.doc_id_type for issues. Manual fix is required: " + i);
        }
    }

    private static /* synthetic */ void lambda$commitAndIndexIssues$3(ListMultimap itemsByIssueKey, EsQueueDto i) {
        itemsByIssueKey.put((Object)i.getDocId(), (Object)i);
    }
}

