/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.index;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SecurityStandardHelper {
    public static final String UNKNOWN_STANDARD = "unknown";
    public static final String SANS_TOP_25_INSECURE_INTERACTION = "insecure-interaction";
    public static final String SANS_TOP_25_RISKY_RESOURCE = "risky-resource";
    public static final String SANS_TOP_25_POROUS_DEFENSES = "porous-defenses";
    private static final String OWASP_TOP10_PREFIX = "owaspTop10:";
    private static final String CWE_PREFIX = "cwe:";
    private static final Set<String> INSECURE_CWE = new HashSet<String>(Arrays.asList("89", "78", "79", "434", "352", "601"));
    private static final Set<String> RISKY_CWE = new HashSet<String>(Arrays.asList("120", "22", "494", "829", "676", "131", "134", "190"));
    private static final Set<String> POROUS_CWE = new HashSet<String>(Arrays.asList("306", "862", "798", "311", "807", "250", "863", "732", "327", "307", "759"));
    public static final Map<String, Set<String>> SANS_TOP_25_CWE_MAPPING = ImmutableMap.of((Object)"insecure-interaction", INSECURE_CWE, (Object)"risky-resource", RISKY_CWE, (Object)"porous-defenses", POROUS_CWE);
    private static final Splitter SECURITY_STANDARDS_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();

    private SecurityStandardHelper() {
    }

    public static List<String> getSecurityStandards(@Nullable String securityStandards) {
        return securityStandards == null ? Collections.emptyList() : SECURITY_STANDARDS_SPLITTER.splitToList((CharSequence)securityStandards);
    }

    public static List<String> getSansTop25(Collection<String> cwe) {
        return SANS_TOP_25_CWE_MAPPING.keySet().stream().filter(k -> cwe.stream().anyMatch(SANS_TOP_25_CWE_MAPPING.get(k)::contains)).collect(Collectors.toList());
    }

    public static List<String> getOwaspTop10(Collection<String> securityStandards) {
        List result = securityStandards.stream().filter(s -> s.startsWith(OWASP_TOP10_PREFIX)).map(s -> s.substring(OWASP_TOP10_PREFIX.length())).collect(Collectors.toList());
        return result.isEmpty() ? Collections.singletonList(UNKNOWN_STANDARD) : result;
    }

    public static List<String> getCwe(Collection<String> securityStandards) {
        List result = securityStandards.stream().filter(s -> s.startsWith(CWE_PREFIX)).map(s -> s.substring(CWE_PREFIX.length())).collect(Collectors.toList());
        return result.isEmpty() ? Collections.singletonList(UNKNOWN_STANDARD) : result;
    }

    public static List<String> getSansTop25(String securityStandards) {
        return SecurityStandardHelper.getSansTop25(SecurityStandardHelper.getCwe(SecurityStandardHelper.getSecurityStandards(securityStandards)));
    }

    public static List<String> getOwaspTop10(String securityStandards) {
        return SecurityStandardHelper.getOwaspTop10(SecurityStandardHelper.getSecurityStandards(securityStandards));
    }

    public static List<String> getCwe(String securityStandards) {
        return SecurityStandardHelper.getCwe(SecurityStandardHelper.getSecurityStandards(securityStandards));
    }
}

