/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.sonar.api.notifications.Notification;
import org.sonar.api.notifications.NotificationChannel;
import org.sonar.server.notification.NotificationDispatcher;
import org.sonar.server.notification.NotificationDispatcherMetadata;
import org.sonar.server.notification.NotificationManager;

public class DoNotFixNotificationDispatcher
extends NotificationDispatcher {
    public static final String KEY = "NewFalsePositiveIssue";
    private final NotificationManager notifications;

    public DoNotFixNotificationDispatcher(NotificationManager notifications) {
        super("issue-changes");
        this.notifications = notifications;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    public static NotificationDispatcherMetadata newMetadata() {
        return NotificationDispatcherMetadata.create(KEY).setProperty("globalNotification", String.valueOf(true)).setProperty("perProjectNotification", String.valueOf(true));
    }

    @Override
    public void dispatch(Notification notification, NotificationDispatcher.Context context) {
        String newResolution = notification.getFieldValue("new.resolution");
        if (Objects.equals(newResolution, "FALSE-POSITIVE") || Objects.equals(newResolution, "WONTFIX")) {
            String author = notification.getFieldValue("changeAuthor");
            String projectKey = notification.getFieldValue("projectKey");
            Multimap<String, NotificationChannel> subscribedRecipients = this.notifications.findSubscribedRecipientsForDispatcher(this, projectKey, NotificationManager.SubscriberPermissionsOnProject.ALL_MUST_HAVE_ROLE_USER);
            DoNotFixNotificationDispatcher.notify(author, context, subscribedRecipients);
        }
    }

    private static void notify(String author, NotificationDispatcher.Context context, Multimap<String, NotificationChannel> subscribedRecipients) {
        for (Map.Entry channelsByRecipients : subscribedRecipients.asMap().entrySet()) {
            String login = (String)channelsByRecipients.getKey();
            if (Objects.equals(author, login)) continue;
            for (NotificationChannel channel : (Collection)channelsByRecipients.getValue()) {
                context.addUser(login, channel);
            }
        }
    }
}

