/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.process.ProcessId;
import org.sonar.process.Props;
import org.sonar.process.logging.LogLevelConfig;
import org.sonar.process.logging.LogbackHelper;
import org.sonar.process.logging.RootLoggerConfig;

public abstract class ServerProcessLogging {
    public static final String STARTUP_LOGGER_NAME = "startup";
    protected static final Set<String> JMX_RMI_LOGGER_NAMES = ImmutableSet.of((Object)"javax.management.remote.timeout", (Object)"javax.management.remote.misc", (Object)"javax.management.remote.rmi", (Object)"javax.management.mbeanserver", (Object)"sun.rmi.loader", (Object)"sun.rmi.transport.tcp", (Object[])new String[]{"sun.rmi.transport.misc", "sun.rmi.server.call", "sun.rmi.dgc"});
    protected static final Set<String> LOGGER_NAMES_TO_TURN_OFF = ImmutableSet.of((Object)"com.microsoft.sqlserver.jdbc.internals", (Object)"com.microsoft.sqlserver.jdbc.ResultSet", (Object)"com.microsoft.sqlserver.jdbc.Statement", (Object)"com.microsoft.sqlserver.jdbc.Connection");
    private final ProcessId processId;
    private final String threadIdFieldPattern;
    private final LogbackHelper helper = new LogbackHelper();
    private final LogLevelConfig logLevelConfig;

    protected ServerProcessLogging(ProcessId processId, String threadIdFieldPattern) {
        this.processId = processId;
        this.threadIdFieldPattern = threadIdFieldPattern;
        this.logLevelConfig = this.createLogLevelConfiguration(processId);
    }

    private LogLevelConfig createLogLevelConfiguration(ProcessId processId) {
        LogLevelConfig.Builder builder = LogLevelConfig.newBuilder((String)this.helper.getRootLoggerName());
        builder.rootLevelFor(processId);
        builder.immutableLevel("org.apache.ibatis", Level.WARN);
        builder.immutableLevel("java.sql", Level.WARN);
        builder.immutableLevel("java.sql.ResultSet", Level.WARN);
        builder.immutableLevel("org.elasticsearch", Level.INFO);
        builder.immutableLevel("org.elasticsearch.node", Level.INFO);
        builder.immutableLevel("org.elasticsearch.http", Level.INFO);
        builder.immutableLevel("ch.qos.logback", Level.WARN);
        builder.immutableLevel("org.apache.catalina", Level.INFO);
        builder.immutableLevel("org.apache.coyote", Level.INFO);
        builder.immutableLevel("org.apache.jasper", Level.INFO);
        builder.immutableLevel("org.apache.tomcat", Level.INFO);
        builder.immutableLevel("org.postgresql.core.v3.QueryExecutorImpl", Level.INFO);
        builder.immutableLevel("org.postgresql.jdbc.PgConnection", Level.INFO);
        builder.immutableLevel("org.apache.fop", Level.INFO);
        builder.immutableLevel("org.apache.xmlgraphics.image.loader.spi.ImageImplRegistry", Level.INFO);
        builder.immutableLevel("com.hazelcast.internal.cluster.impl.ClusterHeartbeatManager", Level.INFO);
        builder.immutableLevel("com.hazelcast.internal.cluster.impl.operations.HeartbeatOperation", Level.INFO);
        builder.immutableLevel("com.hazelcast.internal.partition.InternalPartitionService", Level.INFO);
        builder.immutableLevel("com.hazelcast.internal.partition.operation.PartitionStateOperation", Level.INFO);
        builder.immutableLevel("com.hazelcast.replicatedmap.impl.operation.RequestMapDataOperation", Level.INFO);
        builder.immutableLevel("com.hazelcast.replicatedmap.impl.operation.SyncReplicatedMapDataOperation", Level.INFO);
        builder.immutableLevel("io.netty.buffer.PoolThreadCache", Level.INFO);
        this.extendLogLevelConfiguration(builder);
        return builder.build();
    }

    public LoggerContext configure(Props props) {
        LoggerContext ctx = this.helper.getRootContext();
        ctx.reset();
        this.configureRootLogger(props);
        this.helper.apply(this.logLevelConfig, props);
        this.configureDirectToConsoleLoggers(ctx, STARTUP_LOGGER_NAME);
        this.extendConfigure();
        this.helper.enableJulChangePropagation(ctx);
        return ctx;
    }

    public LogLevelConfig getLogLevelConfig() {
        return this.logLevelConfig;
    }

    protected abstract void extendLogLevelConfiguration(LogLevelConfig.Builder var1);

    protected abstract void extendConfigure();

    private void configureRootLogger(Props props) {
        RootLoggerConfig config = RootLoggerConfig.newRootLoggerConfigBuilder().setProcessId(this.processId).setThreadIdFieldPattern(this.threadIdFieldPattern).build();
        String logPattern = this.helper.buildLogPattern(config);
        this.helper.configureGlobalFileLog(props, config, logPattern);
        this.helper.configureForSubprocessGobbler(props, logPattern);
    }

    private void configureDirectToConsoleLoggers(LoggerContext context, String ... loggerNames) {
        RootLoggerConfig config = RootLoggerConfig.newRootLoggerConfigBuilder().setProcessId(ProcessId.APP).setThreadIdFieldPattern("").build();
        String logPattern = this.helper.buildLogPattern(config);
        ConsoleAppender consoleAppender = this.helper.newConsoleAppender((Context)context, "CONSOLE", logPattern);
        for (String loggerName : loggerNames) {
            Logger consoleLogger = context.getLogger(loggerName);
            consoleLogger.setAdditive(false);
            consoleLogger.addAppender((Appender)consoleAppender);
        }
    }
}

