/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import org.sonar.api.config.Configuration;
import org.sonar.server.measure.Rating;

public class DebtRatingGrid {
    private final double[] gridValues;
    private final EnumMap<Rating, Bounds> ratingBounds;

    public DebtRatingGrid(Configuration config) {
        try {
            String[] grades = config.getStringArray("sonar.technicalDebt.ratingGrid");
            this.gridValues = new double[4];
            for (int i = 0; i < 4; ++i) {
                this.gridValues[i] = Double.parseDouble(grades[i]);
            }
            this.ratingBounds = DebtRatingGrid.buildRatingBounds(this.gridValues);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The rating grid is incorrect. Expected something similar to '0.05,0.1,0.2,0.5' and got '" + config.get("sonar.technicalDebt.ratingGrid").orElse("") + "'", e);
        }
    }

    public DebtRatingGrid(double[] gridValues) {
        this.gridValues = Arrays.copyOf(gridValues, gridValues.length);
        this.ratingBounds = DebtRatingGrid.buildRatingBounds(gridValues);
    }

    private static EnumMap<Rating, Bounds> buildRatingBounds(double[] gridValues) {
        Preconditions.checkState((gridValues.length == 4 ? 1 : 0) != 0, (Object)"Rating grid should contains 4 values");
        EnumMap<Rating, Bounds> ratingBounds = new EnumMap<Rating, Bounds>(Rating.class);
        ratingBounds.put(Rating.A, new Bounds(0.0, gridValues[0]));
        ratingBounds.put(Rating.B, new Bounds(gridValues[0], gridValues[1]));
        ratingBounds.put(Rating.C, new Bounds(gridValues[1], gridValues[2]));
        ratingBounds.put(Rating.D, new Bounds(gridValues[2], gridValues[3]));
        ratingBounds.put(Rating.E, new Bounds(gridValues[3], Double.MAX_VALUE));
        return ratingBounds;
    }

    public Rating getRatingForDensity(double value) {
        return this.ratingBounds.entrySet().stream().filter(e -> ((Bounds)e.getValue()).match(value)).map(Map.Entry::getKey).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Invalid value '%s'", value)));
    }

    public double getGradeLowerBound(Rating rating) {
        if (rating.getIndex() > 1) {
            return this.gridValues[rating.getIndex() - 2];
        }
        return 0.0;
    }

    @VisibleForTesting
    public double[] getGridValues() {
        return this.gridValues;
    }

    private static class Bounds {
        private final double lowerBound;
        private final double higherBound;
        private final boolean isLowerBoundInclusive;

        private Bounds(double lowerBound, double higherBound) {
            this.lowerBound = lowerBound;
            this.higherBound = higherBound;
            this.isLowerBoundInclusive = lowerBound == 0.0;
        }

        boolean match(double value) {
            boolean lowerBoundMatch = this.isLowerBoundInclusive ? value >= this.lowerBound : value > this.lowerBound;
            return lowerBoundMatch && value <= this.higherBound;
        }
    }
}

