/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.index;

import org.sonar.api.config.Configuration;
import org.sonar.api.config.internal.MapSettings;
import org.sonar.server.es.Index;
import org.sonar.server.es.IndexDefinition;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.newindex.DefaultIndexSettingsElement;
import org.sonar.server.es.newindex.KeywordFieldBuilder;
import org.sonar.server.es.newindex.NewAuthorizedIndex;
import org.sonar.server.es.newindex.SettingsConfiguration;
import org.sonar.server.es.newindex.TypeMapping;

public class ProjectMeasuresIndexDefinition
implements IndexDefinition {
    public static final Index DESCRIPTOR = Index.withRelations("projectmeasures");
    public static final IndexType.IndexMainType TYPE_AUTHORIZATION = IndexType.main(DESCRIPTOR, "auth");
    public static final IndexType.IndexRelationType TYPE_PROJECT_MEASURES = IndexType.relation(TYPE_AUTHORIZATION, "projectmeasure");
    public static final String FIELD_UUID = "uuid";
    public static final String FIELD_ORGANIZATION_UUID = "organizationUuid";
    public static final String FIELD_KEY = "key";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_ANALYSED_AT = "analysedAt";
    public static final String FIELD_QUALITY_GATE_STATUS = "qualityGateStatus";
    public static final String FIELD_TAGS = "tags";
    public static final String FIELD_MEASURES = "measures";
    public static final String FIELD_MEASURES_KEY = "key";
    public static final String FIELD_MEASURES_VALUE = "value";
    public static final String FIELD_LANGUAGES = "languages";
    public static final String FIELD_NCLOC_LANGUAGE_DISTRIBUTION = "nclocLanguageDistribution";
    public static final String FIELD_DISTRIB_LANGUAGE = "language";
    public static final String FIELD_DISTRIB_NCLOC = "ncloc";
    private final Configuration config;
    private final boolean enableSource;

    private ProjectMeasuresIndexDefinition(Configuration config, boolean enableSource) {
        this.config = config;
        this.enableSource = enableSource;
    }

    public ProjectMeasuresIndexDefinition(Configuration config) {
        this(config, false);
    }

    public static ProjectMeasuresIndexDefinition createForTest() {
        return new ProjectMeasuresIndexDefinition(new MapSettings().asConfig(), true);
    }

    @Override
    public void define(IndexDefinition.IndexDefinitionContext context) {
        NewAuthorizedIndex index = (NewAuthorizedIndex)context.createWithAuthorization(DESCRIPTOR, SettingsConfiguration.newBuilder(this.config).setRefreshInterval(-1).setDefaultNbOfShards(5).build()).setEnableSource(this.enableSource);
        TypeMapping mapping = index.createTypeMapping(TYPE_PROJECT_MEASURES);
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_UUID).disableNorms()).build();
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_ORGANIZATION_UUID).disableNorms()).build();
        ((KeywordFieldBuilder)((KeywordFieldBuilder)mapping.keywordFieldBuilder("key").disableNorms()).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER)).build();
        ((KeywordFieldBuilder)mapping.keywordFieldBuilder(FIELD_NAME).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER, DefaultIndexSettingsElement.SEARCH_GRAMS_ANALYZER)).build();
        mapping.keywordFieldBuilder(FIELD_QUALITY_GATE_STATUS).build();
        mapping.keywordFieldBuilder(FIELD_TAGS).build();
        mapping.keywordFieldBuilder(FIELD_LANGUAGES).build();
        mapping.nestedFieldBuilder(FIELD_MEASURES).addKeywordField("key").addDoubleField(FIELD_MEASURES_VALUE).build();
        mapping.nestedFieldBuilder(FIELD_NCLOC_LANGUAGE_DISTRIBUTION).addKeywordField(FIELD_DISTRIB_LANGUAGE).addIntegerField(FIELD_DISTRIB_NCLOC).build();
        mapping.createDateTimeField(FIELD_ANALYSED_AT);
    }
}

