/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization;

import java.util.Objects;

public class DefaultOrganization {
    private final String uuid;
    private final String key;
    private final String name;
    private final long createdAt;
    private final long updatedAt;

    private DefaultOrganization(Builder builder) {
        this.uuid = Objects.requireNonNull(builder.uuid, "uuid can't be null");
        this.key = Objects.requireNonNull(builder.key, "key can't be null");
        this.name = Objects.requireNonNull(builder.name, "name can't be null");
        this.createdAt = Objects.requireNonNull(builder.createdAt, "createdAt can't be null");
        this.updatedAt = Objects.requireNonNull(builder.updatedAt, "updatedAt can't be null");
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public String toString() {
        return "DefaultOrganization{uuid='" + this.uuid + '\'' + ", key='" + this.key + '\'' + ", name='" + this.name + '\'' + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + '}';
    }

    public static final class Builder {
        private String uuid;
        private String key;
        private String name;
        private Long createdAt;
        private Long updatedAt;

        public Builder setUuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setCreatedAt(long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder setUpdatedAt(long updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public DefaultOrganization build() {
            return new DefaultOrganization(this);
        }
    }
}

