/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.serverid;

import org.apache.commons.codec.digest.DigestUtils;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.config.Configuration;
import org.sonar.api.server.ServerSide;
import org.sonar.process.ProcessProperties;
import org.sonar.server.platform.serverid.JdbcUrlSanitizer;

@ServerSide
@ComputeEngineSide
public class ServerIdChecksum {
    private final Configuration config;
    private final JdbcUrlSanitizer jdbcUrlSanitizer;

    public ServerIdChecksum(Configuration config, JdbcUrlSanitizer jdbcUrlSanitizer) {
        this.config = config;
        this.jdbcUrlSanitizer = jdbcUrlSanitizer;
    }

    public String computeFor(String serverId) {
        String jdbcUrl = (String)this.config.get(ProcessProperties.Property.JDBC_URL.getKey()).orElseThrow(() -> new IllegalStateException("Missing JDBC URL"));
        return DigestUtils.sha256Hex((String)(serverId + "|" + this.jdbcUrlSanitizer.sanitize(jdbcUrl)));
    }
}

