/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.sonar.api.measures.Metric;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.qualitygate.Condition;
import org.sonar.server.qualitygate.ConditionEvaluator;
import org.sonar.server.qualitygate.EvaluatedCondition;
import org.sonar.server.qualitygate.EvaluatedQualityGate;
import org.sonar.server.qualitygate.QualityGate;
import org.sonar.server.qualitygate.QualityGateEvaluator;

public class QualityGateEvaluatorImpl
implements QualityGateEvaluator {
    private static final int MAXIMUM_NEW_LINES_FOR_SMALL_CHANGESETS = 20;
    private static final Set<String> METRICS_TO_IGNORE_ON_SMALL_CHANGESETS = ImmutableSet.of((Object)"new_coverage", (Object)"new_line_coverage", (Object)"new_branch_coverage", (Object)"new_duplicated_lines_density", (Object)"new_duplicated_lines", (Object)"new_duplicated_blocks", (Object[])new String[0]);

    @Override
    public EvaluatedQualityGate evaluate(QualityGate gate, QualityGateEvaluator.Measures measures) {
        EvaluatedQualityGate.Builder result = EvaluatedQualityGate.newBuilder().setQualityGate(gate);
        boolean isSmallChangeset = QualityGateEvaluatorImpl.isSmallChangeset(measures);
        gate.getConditions().forEach(condition -> {
            String metricKey = condition.getMetricKey();
            EvaluatedCondition evaluation = ConditionEvaluator.evaluate(condition, measures);
            if (isSmallChangeset && evaluation.getStatus() != EvaluatedCondition.EvaluationStatus.OK && METRICS_TO_IGNORE_ON_SMALL_CHANGESETS.contains(metricKey)) {
                result.addEvaluatedCondition(new EvaluatedCondition(evaluation.getCondition(), EvaluatedCondition.EvaluationStatus.OK, evaluation.getValue().orElse(null)));
                result.setIgnoredConditionsOnSmallChangeset(true);
            } else {
                result.addEvaluatedCondition(evaluation);
            }
        });
        result.setStatus(QualityGateEvaluatorImpl.overallStatusOf(result.getEvaluatedConditions()));
        return result.build();
    }

    @Override
    public Set<String> getMetricKeys(QualityGate gate) {
        HashSet<String> metricKeys = new HashSet<String>();
        metricKeys.add("new_lines");
        for (Condition condition : gate.getConditions()) {
            metricKeys.add(condition.getMetricKey());
        }
        return metricKeys;
    }

    private static boolean isSmallChangeset(QualityGateEvaluator.Measures measures) {
        Optional<QualityGateEvaluator.Measure> newLines = measures.get("new_lines");
        return newLines.isPresent() && newLines.get().getNewMetricValue().isPresent() && newLines.get().getNewMetricValue().getAsDouble() < 20.0;
    }

    private static Metric.Level overallStatusOf(Set<EvaluatedCondition> conditions) {
        Set statuses = (Set)conditions.stream().map(EvaluatedCondition::getStatus).collect(MoreCollectors.toEnumSet(EvaluatedCondition.EvaluationStatus.class));
        if (statuses.contains((Object)EvaluatedCondition.EvaluationStatus.ERROR)) {
            return Metric.Level.ERROR;
        }
        return Metric.Level.OK;
    }
}

