/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.index;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.RuleType;
import org.sonar.db.rule.RuleDto;
import org.sonar.db.rule.RuleForIndexingDto;
import org.sonar.markdown.Markdown;
import org.sonar.server.es.BaseDoc;
import org.sonar.server.rule.index.RuleIndexDefinition;

public class RuleDoc
extends BaseDoc {
    @VisibleForTesting
    public RuleDoc(Map<String, Object> fields) {
        super(RuleIndexDefinition.TYPE_RULE, new HashMap<String, Object>(fields));
    }

    public RuleDoc() {
        super(RuleIndexDefinition.TYPE_RULE, Maps.newHashMapWithExpectedSize((int)16));
    }

    @Override
    public String getId() {
        return this.idAsString();
    }

    private String idAsString() {
        return (String)this.getField("ruleId");
    }

    public RuleDoc setId(int ruleId) {
        this.setField("ruleId", String.valueOf(ruleId));
        return this;
    }

    @Override
    protected Optional<String> getSimpleMainTypeRouting() {
        return Optional.of(this.idAsString());
    }

    public RuleKey key() {
        return RuleKey.parse((String)this.keyAsString());
    }

    private String keyAsString() {
        return (String)this.getField("key");
    }

    public RuleDoc setKey(@Nullable String s) {
        this.setField("key", s);
        return this;
    }

    @CheckForNull
    public String ruleKey() {
        return (String)this.getNullableField("ruleKey");
    }

    public RuleDoc setRuleKey(@Nullable String s) {
        this.setField("ruleKey", s);
        return this;
    }

    @CheckForNull
    public String repository() {
        return (String)this.getNullableField("repo");
    }

    public RuleDoc setRepository(@Nullable String s) {
        this.setField("repo", s);
        return this;
    }

    @CheckForNull
    public String internalKey() {
        return (String)this.getNullableField("internalKey");
    }

    public RuleDoc setInternalKey(@Nullable String s) {
        this.setField("internalKey", s);
        return this;
    }

    @CheckForNull
    public String language() {
        return (String)this.getNullableField("lang");
    }

    public RuleDoc setLanguage(@Nullable String s) {
        this.setField("lang", s);
        return this;
    }

    public String name() {
        return (String)this.getField("name");
    }

    public RuleDoc setName(@Nullable String s) {
        this.setField("name", s);
        return this;
    }

    @CheckForNull
    public String htmlDescription() {
        return (String)this.getNullableField("htmlDesc");
    }

    public RuleDoc setHtmlDescription(@Nullable String s) {
        this.setField("htmlDesc", s);
        return this;
    }

    @CheckForNull
    public String severity() {
        return (String)this.getNullableField("severity");
    }

    public RuleDoc setSeverity(@Nullable String s) {
        this.setField("severity", s);
        return this;
    }

    @CheckForNull
    public RuleStatus status() {
        return RuleStatus.valueOf((String)((String)this.getField("status")));
    }

    public RuleDoc setStatus(@Nullable String s) {
        this.setField("status", s);
        return this;
    }

    @CheckForNull
    public RuleKey templateKey() {
        String templateKey = (String)this.getNullableField("templateKey");
        return templateKey != null ? RuleKey.parse((String)templateKey) : null;
    }

    public RuleDoc setTemplateKey(@Nullable String s) {
        this.setField("templateKey", s);
        return this;
    }

    public boolean isTemplate() {
        return (Boolean)this.getField("isTemplate");
    }

    public RuleDoc setIsTemplate(@Nullable Boolean b) {
        this.setField("isTemplate", b);
        return this;
    }

    public boolean isExternal() {
        return (Boolean)this.getField("isExternal");
    }

    public RuleDoc setIsExternal(boolean b) {
        this.setField("isExternal", b);
        return this;
    }

    @CheckForNull
    public RuleType type() {
        return RuleType.valueOfNullable((int)((Integer)this.getNullableField("type")));
    }

    public RuleDoc setType(@Nullable RuleType ruleType) {
        this.setField("type", ruleType == null ? null : ruleType.name());
        return this;
    }

    public long createdAt() {
        return (Long)this.getField("createdAt");
    }

    public RuleDoc setCreatedAt(@Nullable Long l) {
        this.setField("createdAt", l);
        return this;
    }

    public long updatedAt() {
        return (Long)this.getField("updatedAt");
    }

    public RuleDoc setUpdatedAt(@Nullable Long l) {
        this.setField("updatedAt", l);
        return this;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public static RuleDoc of(RuleForIndexingDto dto) {
        RuleDoc ruleDoc = new RuleDoc().setId(dto.getId()).setKey(dto.getRuleKey().toString()).setRepository(dto.getRepository()).setInternalKey(dto.getInternalKey()).setIsTemplate(dto.isTemplate()).setIsExternal(dto.isExternal()).setLanguage(dto.getLanguage()).setName(dto.getName()).setRuleKey(dto.getPluginRuleKey()).setSeverity(dto.getSeverityAsString()).setStatus(dto.getStatus().toString()).setType(dto.getTypeAsRuleType()).setCreatedAt(dto.getCreatedAt()).setUpdatedAt(dto.getUpdatedAt());
        if (dto.getTemplateRuleKey() != null && dto.getTemplateRepository() != null) {
            ruleDoc.setTemplateKey(RuleKey.of((String)dto.getTemplateRepository(), (String)dto.getTemplateRuleKey()).toString());
        } else {
            ruleDoc.setTemplateKey(null);
        }
        if (dto.getDescription() != null && dto.getDescriptionFormat() != null) {
            if (RuleDto.Format.HTML == dto.getDescriptionFormat()) {
                ruleDoc.setHtmlDescription(dto.getDescription());
            } else {
                ruleDoc.setHtmlDescription(Markdown.convertToHtml((String)dto.getDescription()));
            }
        }
        return ruleDoc;
    }
}

