/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.index;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.internal.MapSettings;
import org.sonar.server.es.Index;
import org.sonar.server.es.IndexDefinition;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.newindex.DefaultIndexSettingsElement;
import org.sonar.server.es.newindex.KeywordFieldBuilder;
import org.sonar.server.es.newindex.NewRegularIndex;
import org.sonar.server.es.newindex.SettingsConfiguration;
import org.sonar.server.es.newindex.StringFieldBuilder;
import org.sonar.server.es.newindex.TypeMapping;

public class RuleIndexDefinition
implements IndexDefinition {
    public static final Index DESCRIPTOR = Index.withRelations("rules");
    public static final IndexType.IndexMainType TYPE_RULE = IndexType.main(DESCRIPTOR, "rule");
    public static final String FIELD_RULE_ID = "ruleId";
    public static final String FIELD_RULE_KEY = "key";
    public static final String FIELD_RULE_REPOSITORY = "repo";
    public static final String FIELD_RULE_RULE_KEY = "ruleKey";
    public static final String FIELD_RULE_INTERNAL_KEY = "internalKey";
    public static final String FIELD_RULE_NAME = "name";
    public static final String FIELD_RULE_HTML_DESCRIPTION = "htmlDesc";
    public static final String FIELD_RULE_SEVERITY = "severity";
    public static final String FIELD_RULE_STATUS = "status";
    public static final String FIELD_RULE_LANGUAGE = "lang";
    public static final String FIELD_RULE_IS_TEMPLATE = "isTemplate";
    public static final String FIELD_RULE_IS_EXTERNAL = "isExternal";
    public static final String FIELD_RULE_TEMPLATE_KEY = "templateKey";
    public static final String FIELD_RULE_TYPE = "type";
    public static final String FIELD_RULE_CREATED_AT = "createdAt";
    public static final String FIELD_RULE_UPDATED_AT = "updatedAt";
    public static final Set<String> SORT_FIELDS = ImmutableSet.of((Object)"name", (Object)"updatedAt", (Object)"createdAt", (Object)"key");
    public static final IndexType.IndexRelationType TYPE_RULE_EXTENSION = IndexType.relation(TYPE_RULE, "ruleExtension");
    public static final String FIELD_RULE_EXTENSION_SCOPE = "ruleExt_scope";
    public static final String FIELD_RULE_EXTENSION_TAGS = "ruleExt_tags";
    public static final IndexType.IndexRelationType TYPE_ACTIVE_RULE = IndexType.relation(TYPE_RULE, "activeRule");
    public static final String FIELD_ACTIVE_RULE_ID = "activeRule_id";
    public static final String FIELD_ACTIVE_RULE_INHERITANCE = "activeRule_inheritance";
    public static final String FIELD_ACTIVE_RULE_PROFILE_UUID = "activeRule_ruleProfile";
    public static final String FIELD_ACTIVE_RULE_SEVERITY = "activeRule_severity";
    private final Configuration config;
    private final boolean enableSource;

    public RuleIndexDefinition(Configuration config) {
        this(config, false);
    }

    private RuleIndexDefinition(Configuration config, boolean enableSource) {
        this.config = config;
        this.enableSource = enableSource;
    }

    public static RuleIndexDefinition createForTest() {
        return new RuleIndexDefinition(new MapSettings().asConfig(), true);
    }

    @Override
    public void define(IndexDefinition.IndexDefinitionContext context) {
        NewRegularIndex index = (NewRegularIndex)context.create(DESCRIPTOR, SettingsConfiguration.newBuilder(this.config).setRefreshInterval(-1).setDefaultNbOfShards(2).build()).setEnableSource(this.enableSource);
        TypeMapping ruleMapping = index.createTypeMapping(TYPE_RULE);
        ((KeywordFieldBuilder)ruleMapping.keywordFieldBuilder(FIELD_RULE_ID).disableNorms()).build();
        ((KeywordFieldBuilder)ruleMapping.keywordFieldBuilder(FIELD_RULE_KEY).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER)).build();
        ((KeywordFieldBuilder)ruleMapping.keywordFieldBuilder(FIELD_RULE_RULE_KEY).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER)).build();
        ruleMapping.keywordFieldBuilder(FIELD_RULE_REPOSITORY).build();
        ((KeywordFieldBuilder)((KeywordFieldBuilder)ruleMapping.keywordFieldBuilder(FIELD_RULE_INTERNAL_KEY).disableNorms()).disableSearch()).build();
        ((KeywordFieldBuilder)ruleMapping.keywordFieldBuilder(FIELD_RULE_NAME).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER, DefaultIndexSettingsElement.SEARCH_GRAMS_ANALYZER)).build();
        ((StringFieldBuilder)((KeywordFieldBuilder)((KeywordFieldBuilder)ruleMapping.keywordFieldBuilder(FIELD_RULE_HTML_DESCRIPTION).disableSearch()).disableNorms()).disableSortingAndAggregating().addSubFields(DefaultIndexSettingsElement.ENGLISH_HTML_ANALYZER)).build();
        ((KeywordFieldBuilder)ruleMapping.keywordFieldBuilder(FIELD_RULE_SEVERITY).disableNorms()).build();
        ((KeywordFieldBuilder)ruleMapping.keywordFieldBuilder(FIELD_RULE_STATUS).disableNorms()).build();
        ((KeywordFieldBuilder)ruleMapping.keywordFieldBuilder(FIELD_RULE_LANGUAGE).disableNorms()).build();
        ruleMapping.createBooleanField(FIELD_RULE_IS_TEMPLATE);
        ruleMapping.createBooleanField(FIELD_RULE_IS_EXTERNAL);
        ((KeywordFieldBuilder)ruleMapping.keywordFieldBuilder(FIELD_RULE_TEMPLATE_KEY).disableNorms()).build();
        ((KeywordFieldBuilder)ruleMapping.keywordFieldBuilder(FIELD_RULE_TYPE).disableNorms()).build();
        ruleMapping.createLongField(FIELD_RULE_CREATED_AT);
        ruleMapping.createLongField(FIELD_RULE_UPDATED_AT);
        ((KeywordFieldBuilder)((TypeMapping)((KeywordFieldBuilder)((TypeMapping)((KeywordFieldBuilder)((TypeMapping)((KeywordFieldBuilder)index.createTypeMapping(TYPE_ACTIVE_RULE).keywordFieldBuilder(FIELD_ACTIVE_RULE_ID).disableNorms()).build()).keywordFieldBuilder(FIELD_ACTIVE_RULE_PROFILE_UUID).disableNorms()).build()).keywordFieldBuilder(FIELD_ACTIVE_RULE_INHERITANCE).disableNorms()).build()).keywordFieldBuilder(FIELD_ACTIVE_RULE_SEVERITY).disableNorms()).build();
        ((TypeMapping)((KeywordFieldBuilder)index.createTypeMapping(TYPE_RULE_EXTENSION).keywordFieldBuilder(FIELD_RULE_EXTENSION_SCOPE).disableNorms()).build()).keywordFieldBuilder(FIELD_RULE_EXTENSION_TAGS).build();
    }
}

