/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import org.apache.commons.lang.StringUtils;

public final class HttpUrlHelper {
    private HttpUrlHelper() {
    }

    public static String obfuscateCredentials(String originalUrl) {
        HttpUrl parsedUrl = HttpUrl.parse((String)originalUrl);
        if (parsedUrl != null) {
            return HttpUrlHelper.obfuscateCredentials(originalUrl, parsedUrl);
        }
        return originalUrl;
    }

    static String obfuscateCredentials(String originalUrl, HttpUrl parsedUrl) {
        String username = parsedUrl.username();
        String password = parsedUrl.password();
        if (username.isEmpty() && password.isEmpty()) {
            return originalUrl;
        }
        if (!username.isEmpty() && !password.isEmpty()) {
            String encodedUsername = parsedUrl.encodedUsername();
            String encodedPassword = parsedUrl.encodedPassword();
            return Stream.of(() -> HttpUrlHelper.replaceOrDie(originalUrl, username, password), () -> HttpUrlHelper.replaceOrDie(originalUrl, encodedUsername, encodedPassword), () -> HttpUrlHelper.replaceOrDie(originalUrl, encodedUsername, password), () -> HttpUrlHelper.replaceOrDie(originalUrl, username, encodedPassword)).map(Supplier::get).filter(Objects::nonNull).findFirst().orElse(originalUrl);
        }
        if (!username.isEmpty()) {
            return Stream.of(() -> HttpUrlHelper.replaceOrDie(originalUrl, username, null), () -> HttpUrlHelper.replaceOrDie(originalUrl, parsedUrl.encodedUsername(), null)).map(Supplier::get).filter(Objects::nonNull).findFirst().orElse(originalUrl);
        }
        Preconditions.checkState((boolean)password.isEmpty(), (Object)"having a password without a username should never occur");
        return originalUrl;
    }

    @CheckForNull
    private static String replaceOrDie(String original, String username, @Nullable String password) {
        return HttpUrlHelper.replaceOrDieImpl(original, HttpUrlHelper.authentStringOf(username, password), HttpUrlHelper.obfuscatedAuthentStringOf(username, password));
    }

    private static String authentStringOf(String username, @Nullable String password) {
        if (password == null) {
            return username + "@";
        }
        return username + ":" + password + "@";
    }

    private static String obfuscatedAuthentStringOf(String userName, @Nullable String password) {
        return HttpUrlHelper.authentStringOf(StringUtils.repeat((String)"*", (int)userName.length()), password == null ? null : StringUtils.repeat((String)"*", (int)password.length()));
    }

    @CheckForNull
    private static String replaceOrDieImpl(String original, String target, String replacement) {
        String res = original.replace(target, replacement);
        if (!res.equals(original)) {
            return res;
        }
        return null;
    }
}

