/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.System2;
import org.sonar.server.webhook.HttpUrlHelper;
import org.sonar.server.webhook.Webhook;
import org.sonar.server.webhook.WebhookCaller;
import org.sonar.server.webhook.WebhookDelivery;
import org.sonar.server.webhook.WebhookPayload;

@ServerSide
@ComputeEngineSide
public class WebhookCallerImpl
implements WebhookCaller {
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final String PROJECT_KEY_HEADER = "X-SonarQube-Project";
    private final System2 system;
    private final OkHttpClient okHttpClient;

    public WebhookCallerImpl(System2 system, OkHttpClient okHttpClient) {
        this.system = system;
        this.okHttpClient = WebhookCallerImpl.newClientWithoutRedirect(okHttpClient);
    }

    @Override
    public WebhookDelivery call(Webhook webhook, WebhookPayload payload) {
        WebhookDelivery.Builder builder = new WebhookDelivery.Builder();
        long startedAt = this.system.now();
        builder.setAt(startedAt).setPayload(payload).setWebhook(webhook);
        try {
            HttpUrl url = HttpUrl.parse((String)webhook.getUrl());
            if (url == null) {
                throw new IllegalArgumentException("Webhook URL is not valid: " + webhook.getUrl());
            }
            builder.setEffectiveUrl(HttpUrlHelper.obfuscateCredentials(webhook.getUrl(), url));
            Request request = WebhookCallerImpl.buildHttpRequest(url, payload);
            try (Response response = this.execute(request);){
                builder.setHttpStatus(response.code());
            }
        }
        catch (Exception e) {
            builder.setError(e);
        }
        return builder.setDurationInMs((int)(this.system.now() - startedAt)).build();
    }

    private static Request buildHttpRequest(HttpUrl url, WebhookPayload payload) {
        Request.Builder request = new Request.Builder();
        request.url(url);
        request.header(PROJECT_KEY_HEADER, payload.getProjectKey());
        if (StringUtils.isNotEmpty((String)url.username())) {
            request.header("Authorization", Credentials.basic((String)url.username(), (String)url.password(), (Charset)StandardCharsets.UTF_8));
        }
        RequestBody body = RequestBody.create((MediaType)JSON, (String)payload.getJson());
        request.post(body);
        return request.build();
    }

    private Response execute(Request request) throws IOException {
        Response response = this.okHttpClient.newCall(request).execute();
        switch (response.code()) {
            case 301: 
            case 302: 
            case 307: 
            case 308: {
                return this.followPostRedirect(response);
            }
        }
        return response;
    }

    private Response followPostRedirect(Response response) throws IOException {
        String location = response.header("Location");
        if (location == null) {
            throw new IllegalStateException(String.format("Missing HTTP header 'Location' in redirect of %s", response.request().url()));
        }
        HttpUrl url = response.request().url().resolve(location);
        if (url == null) {
            throw new IllegalStateException(String.format("Unsupported protocol in redirect of %s to %s", response.request().url(), location));
        }
        Request.Builder redirectRequest = response.request().newBuilder();
        redirectRequest.post(response.request().body());
        response.body().close();
        return this.okHttpClient.newCall(redirectRequest.url(url).build()).execute();
    }

    private static OkHttpClient newClientWithoutRedirect(OkHttpClient client) {
        return client.newBuilder().followRedirects(false).followSslRedirects(false).build();
    }
}

