/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook;

import com.google.common.base.Throwables;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.webhook.WebhookDeliveryDao;
import org.sonar.db.webhook.WebhookDeliveryDto;
import org.sonar.server.webhook.WebhookDelivery;

@ServerSide
@ComputeEngineSide
public class WebhookDeliveryStorage {
    private static final long ALIVE_DELAY_MS = 2592000000L;
    private final DbClient dbClient;
    private final System2 system;
    private final UuidFactory uuidFactory;

    public WebhookDeliveryStorage(DbClient dbClient, System2 system, UuidFactory uuidFactory) {
        this.dbClient = dbClient;
        this.system = system;
        this.uuidFactory = uuidFactory;
    }

    public void persist(WebhookDelivery delivery) {
        WebhookDeliveryDao dao = this.dbClient.webhookDeliveryDao();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            dao.insert(dbSession, this.toDto(delivery));
            dbSession.commit();
        }
    }

    public void purge(String componentUuid) {
        long beforeDate = this.system.now() - 2592000000L;
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.dbClient.webhookDeliveryDao().deleteComponentBeforeDate(dbSession, componentUuid, beforeDate);
            dbSession.commit();
        }
    }

    private WebhookDeliveryDto toDto(WebhookDelivery delivery) {
        WebhookDeliveryDto dto = new WebhookDeliveryDto();
        dto.setUuid(this.uuidFactory.create());
        dto.setWebhookUuid(delivery.getWebhook().getUuid());
        dto.setComponentUuid(delivery.getWebhook().getComponentUuid());
        delivery.getWebhook().getCeTaskUuid().ifPresent(arg_0 -> ((WebhookDeliveryDto)dto).setCeTaskUuid(arg_0));
        delivery.getWebhook().getAnalysisUuid().ifPresent(arg_0 -> ((WebhookDeliveryDto)dto).setAnalysisUuid(arg_0));
        dto.setName(delivery.getWebhook().getName());
        dto.setUrl(delivery.getEffectiveUrl().orElse(delivery.getWebhook().getUrl()));
        dto.setSuccess(delivery.isSuccess());
        dto.setHttpStatus((Integer)delivery.getHttpStatus().orElse(null));
        dto.setDurationMs((Integer)delivery.getDurationInMs().orElse(null));
        dto.setErrorStacktrace((String)delivery.getError().map(Throwables::getStackTraceAsString).orElse(null));
        dto.setPayload(delivery.getPayload().getJson());
        dto.setCreatedAt(delivery.getAt());
        return dto;
    }
}

