/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.plugins.html.checks.HtmlIssue;
import org.sonar.plugins.html.node.Attribute;
import org.sonar.plugins.html.node.TagNode;
import org.sonar.plugins.html.visitor.DefaultNodeVisitor;

public abstract class AbstractPageCheck
extends DefaultNodeVisitor {
    private RuleKey ruleKey;

    public boolean isUnifiedExpression(@Nullable String value) {
        return value != null && value.length() > 0 && (value.contains("#{") || value.contains("${"));
    }

    public String[] trimSplitCommaSeparatedList(String value) {
        String[] tokens = StringUtils.split(value, ",");
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
        }
        return tokens;
    }

    public QualifiedAttribute[] parseAttributes(String attributesList) {
        String[] qualifiedAttributeList = StringUtils.split(attributesList, ",");
        QualifiedAttribute[] qualifiedAttributes = new QualifiedAttribute[qualifiedAttributeList.length];
        int n = 0;
        for (String qualifiedAttribute : qualifiedAttributeList) {
            qualifiedAttributes[n] = (qualifiedAttribute = qualifiedAttribute.trim()).indexOf(46) >= 0 ? new QualifiedAttribute(StringUtils.substringBefore(qualifiedAttribute, "."), StringUtils.substringAfter(qualifiedAttribute, ".")) : new QualifiedAttribute(null, qualifiedAttribute);
            ++n;
        }
        return qualifiedAttributes;
    }

    protected final void createViolation(int line, String message) {
        this.getHtmlSourceCode().addIssue(new HtmlIssue(this.ruleKey, line == 0 ? null : Integer.valueOf(line), message));
    }

    protected final void createViolation(int line, String message, Double cost) {
        this.getHtmlSourceCode().addIssue(new HtmlIssue(this.ruleKey, line == 0 ? null : Integer.valueOf(line), message, cost));
    }

    public final void setRuleKey(RuleKey ruleKey) {
        this.ruleKey = ruleKey;
    }

    protected List<Attribute> getMatchingAttributes(TagNode element, QualifiedAttribute[] attributes) {
        ArrayList<Attribute> matchingAttributes = new ArrayList<Attribute>();
        for (QualifiedAttribute qualifiedAttribute : attributes) {
            if (qualifiedAttribute.getNodeName() != null && !StringUtils.equalsIgnoreCase(element.getLocalName(), qualifiedAttribute.getNodeName()) && !StringUtils.equalsIgnoreCase(element.getNodeName(), qualifiedAttribute.getNodeName())) continue;
            for (Attribute a : element.getAttributes()) {
                if (!qualifiedAttribute.getAttributeName().equalsIgnoreCase(a.getName())) continue;
                matchingAttributes.add(a);
            }
        }
        return matchingAttributes;
    }

    protected static final class QualifiedAttribute {
        private String attributeName;
        private String nodeName;

        private QualifiedAttribute(@Nullable String nodeName, String attributeName) {
            this.setNodeName(nodeName);
            this.setAttributeName(attributeName);
        }

        public void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public void setNodeName(@Nullable String nodeName) {
            this.nodeName = nodeName;
        }

        @Nullable
        public String getNodeName() {
            return this.nodeName;
        }
    }
}

