/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="ImgWithoutAltCheck")
public class ImgWithoutAltCheck
extends AbstractPageCheck {
    @Override
    public void startElement(TagNode node) {
        if ((ImgWithoutAltCheck.isImgTag(node) || ImgWithoutAltCheck.isImageInput(node)) && !node.hasProperty("ALT")) {
            this.createViolation(node.getStartLinePosition(), "Add an \"alt\" attribute to this image.");
        }
    }

    private static boolean isImgTag(TagNode node) {
        return "IMG".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isImageInput(TagNode node) {
        String type = node.getPropertyValue("TYPE");
        return "INPUT".equalsIgnoreCase(node.getNodeName()) && type != null && "IMAGE".equalsIgnoreCase(type);
    }
}

