/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.node;

import org.apache.commons.lang.StringUtils;
import org.sonar.plugins.html.node.NodeType;

public abstract class Node {
    private String code;
    private int endColumnPosition;
    private int endLinePosition;
    private final NodeType nodeType;
    private int startColumnPosition;
    private int startLinePosition;

    public Node(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public String getCode() {
        return this.code;
    }

    public int getEndColumnPosition() {
        return this.endColumnPosition;
    }

    public int getEndLinePosition() {
        return this.endLinePosition;
    }

    public int getLinesOfCode() {
        return StringUtils.countMatches(this.code, "\n");
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public int getStartColumnPosition() {
        return this.startColumnPosition;
    }

    public int getStartLinePosition() {
        return this.startLinePosition;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setEndColumnPosition(int endColumnPosition) {
        this.endColumnPosition = endColumnPosition;
    }

    public void setEndLinePosition(int endLinePosition) {
        this.endLinePosition = endLinePosition;
    }

    public void setStartColumnPosition(int startColumnPosition) {
        this.startColumnPosition = startColumnPosition;
    }

    public void setStartLinePosition(int startLinePosition) {
        this.startLinePosition = startLinePosition;
    }

    public String toString() {
        return this.code;
    }
}

