/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.visitor;

import com.google.common.collect.Lists;
import java.nio.charset.Charset;
import java.util.List;
import org.sonar.plugins.html.node.CommentNode;
import org.sonar.plugins.html.node.DirectiveNode;
import org.sonar.plugins.html.node.ExpressionNode;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;
import org.sonar.plugins.html.node.TextNode;
import org.sonar.plugins.html.visitor.CharsetAwareVisitor;
import org.sonar.plugins.html.visitor.DefaultNodeVisitor;
import org.sonar.plugins.html.visitor.HtmlSourceCode;

public class HtmlAstScanner {
    private final List<DefaultNodeVisitor> metricVisitors;
    private final List<DefaultNodeVisitor> checkVisitors = Lists.newArrayList();

    public HtmlAstScanner(List<DefaultNodeVisitor> metricVisitors) {
        this.metricVisitors = metricVisitors;
    }

    public void addVisitor(DefaultNodeVisitor visitor) {
        this.checkVisitors.add(visitor);
        visitor.init();
    }

    public void scan(List<Node> nodeList, HtmlSourceCode htmlSourceCode, Charset charset) {
        this.scan(nodeList, htmlSourceCode, charset, this.metricVisitors);
        this.scan(nodeList, htmlSourceCode, charset, this.checkVisitors);
    }

    private void scan(List<Node> nodeList, HtmlSourceCode htmlSourceCode, Charset charset, List<DefaultNodeVisitor> visitors) {
        for (DefaultNodeVisitor visitor : visitors) {
            visitor.setSourceCode(htmlSourceCode);
            if (!(visitor instanceof CharsetAwareVisitor)) continue;
            ((CharsetAwareVisitor)((Object)visitor)).setCharset(charset);
        }
        for (DefaultNodeVisitor visitor : visitors) {
            visitor.startDocument(nodeList);
        }
        for (Node node : nodeList) {
            for (DefaultNodeVisitor visitor : visitors) {
                this.scanElement(visitor, node);
            }
        }
        for (DefaultNodeVisitor visitor : visitors) {
            visitor.endDocument();
        }
    }

    private void scanElement(DefaultNodeVisitor visitor, Node node) {
        switch (node.getNodeType()) {
            case TAG: {
                HtmlAstScanner.scanElementTag(visitor, (TagNode)node);
                break;
            }
            case TEXT: {
                visitor.characters((TextNode)node);
                break;
            }
            case COMMENT: {
                visitor.comment((CommentNode)node);
                break;
            }
            case EXPRESSION: {
                visitor.expression((ExpressionNode)node);
                break;
            }
            case DIRECTIVE: {
                visitor.directive((DirectiveNode)node);
                break;
            }
        }
    }

    private static void scanElementTag(DefaultNodeVisitor visitor, TagNode node) {
        if (!node.isEndElement()) {
            visitor.startElement(node);
        }
        if (node.isEndElement() || node.hasEnd()) {
            visitor.endElement(node);
        }
    }
}

