/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.visitor;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.plugins.html.node.CommentNode;
import org.sonar.plugins.html.node.ExpressionNode;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.visitor.DefaultNodeVisitor;

public class NoSonarScanner
extends DefaultNodeVisitor {
    private static final String NOSONAR = "//NOSONAR";
    private Set<Integer> noSonarLines;
    private final NoSonarFilter noSonarFilter;

    public NoSonarScanner(NoSonarFilter noSonarFilter) {
        this.noSonarFilter = noSonarFilter;
    }

    @Override
    public void startDocument(List<Node> nodes) {
        this.noSonarLines = new HashSet<Integer>();
    }

    @Override
    public void comment(CommentNode node) {
        if (node.getCode().contains(NOSONAR)) {
            this.noSonarLines.add(node.getStartLinePosition());
        }
    }

    @Override
    public void expression(ExpressionNode node) {
        if (node.getCode().contains(NOSONAR)) {
            this.noSonarLines.add(node.getStartLinePosition());
        }
    }

    @Override
    public void endDocument() {
        if (this.noSonarLines != null && !this.noSonarLines.isEmpty()) {
            this.noSonarFilter.noSonarInFile(this.getHtmlSourceCode().inputFile(), this.noSonarLines);
        }
    }
}

