(window.webpackJsonp=window.webpackJsonp||[]).push([[262,21,359],{1408:function(e){e.exports=[{title:"Requirements",children:["/requirements/requirements/","/requirements/benchmark/","/requirements/hardware-recommendations/"]},{title:"Analyzing Source Code",children:["/analysis/overview/","/analysis/analysis-parameters/","/analysis/coverage/","/analysis/external-issues/","/analysis/background-tasks/","/analysis/generic-issue/","/analysis/generic-test/","/analysis/pull-request/","/analysis/scm-integration/"]},{title:"Branches",children:["/branches/overview/","/branches/short-lived-branches/","/branches/long-lived-branches/","/branches/branches-faq/"]},{title:"User Guide",children:["/user-guide/fixing-the-water-leak/","/user-guide/project-page/","/user-guide/applications/","/user-guide/portfolios/","/user-guide/issues/","/user-guide/rules/","/user-guide/security-rules/","/user-guide/built-in-rule-tags/","/user-guide/quality-gates/","/user-guide/metric-definitions/","/user-guide/concepts/","/user-guide/activity-history/","/user-guide/visualizations/","/user-guide/sonarlint-notifications/","/user-guide/security-reports/","/user-guide/user-account/","/user-guide/user-token/","/user-guide/keyboard-shortcuts/"]},{title:"Project Administration",children:["/project-administration/project-existence/","/project-administration/managing-project-history/","/project-administration/narrowing-the-focus/","/project-administration/configuring-portfolios-and-applications/","/project-administration/portfolio-pdf-configuration/","/project-administration/project-settings/","/project-administration/webhooks/"]},{title:"Instance Administration",children:["/instance-administration/quality-profiles/","/instance-administration/security/","/instance-administration/delegated-auth/","/instance-administration/github-application/","/instance-administration/look-and-feel/","/instance-administration/marketplace/","/instance-administration/housekeeping/","/instance-administration/notifications/","/instance-administration/system-info/","/instance-administration/monitoring/","/instance-administration/project-move/","/instance-administration/custom-measures/","/instance-administration/compute-engine-performance/","/instance-administration/db-copy/"]},"/faq/"]},1409:function(e){e.exports=[{title:"Get Started",children:["/integrations/github/","/integrations/bitbucketcloud/","/integrations/vsts/"]},{title:"Analyzing Source Code",children:["/analysis/overview/","/analysis/analysis-parameters/","/analysis/coverage/","/analysis/external-issues/","/analysis/background-tasks/","/analysis/generic-issue/","/analysis/generic-test/","/analysis/pull-request/","/analysis/supported-languages/"]},{title:"Branches",children:["/branches/overview/","/branches/short-lived-branches/","/branches/long-lived-branches/","/branches/branches-faq/"]},{title:"User Guide",children:["/user-guide/fixing-the-water-leak/","/user-guide/project-page/","/user-guide/issues/","/user-guide/rules/","/user-guide/security-rules/","/user-guide/built-in-rule-tags/","/user-guide/quality-gates/","/instance-administration/quality-profiles/","/user-guide/metric-definitions/","/user-guide/concepts/","/user-guide/activity-history/","/user-guide/visualizations/","/user-guide/sonarlint-notifications/","/user-guide/security-reports/","/user-guide/user-token/","/user-guide/keyboard-shortcuts/"]},{title:"Project Admin Guide",children:["/project-administration/webhooks/","/project-administration/narrowing-the-focus/"]},{title:"Organization Admin Guide",children:["/organizations/overview/","/organizations/manage-team/","/organizations/organization-visibility/"]},{title:"Appendices",children:["/sonarcloud-pricing/","/privacy/","/security/","/faq/","/autoscan/"]}]},1518:function(e,n,t){"use strict";e.exports=[{path:"404",content:"---\ntitle: Page not found\nnav: Not found\nurl: /404/\n---\n\n# Error\n\nThis page does not exist\n"},{path:"analysis/analysis-parameters",content:'---\ntitle: Analysis Parameters\nurl: /analysis/analysis-parameters/\n---\n\n## Table of Contents\n\nParameters to configure project analysis can be set in multiple places. Here is the hierarchy of parameters:\n\n* Global analysis parameters, defined in the UI, apply to all the projects (From the top bar, go to **[Administration > Configuration > General Settings](/#sonarqube-admin#/admin/settings)**)\n* Project analysis parameters, defined in the UI, override global parameters (At a project level, go to **Administration > General Settings**)\n* Project analysis parameters, defined in a project analysis configuration file or an analyzer configuration file, override the ones defined in the UI\n* Analysis / Command line parameters, defined when launching an analysis, override project analysis parameters\n\nNote that only parameters set through the UI are stored in the database.\nFor example, if you override the `sonar.exclusions` parameter via command line for a specific project, it will not be stored in the database. Analyses in SonarLint with connected mode, for example, would still be executed with the exclusions defined in the UI and therefore stored in the DB.\n\nNote also that the list of parameters below is not exhaustive. Most of the property keys shown in the interface, at both global and project levels, can also be set as analysis parameters. However, exclusions/inclusions are far easier to manage in the UI. \n\nFor language-specific parameters related to test coverage and execution, see [Test Coverage & Execution](/analysis/coverage/). For language-specific parameters related to external issue reports, see [External Issues)(/analysis/external-issues).\n\n## Mandatory Parameters\n\n### Server\nKey | Description | Default\n---|----|---\n`sonar.host.url`| the server URL | http://localhost:9000\n\n### Project Configuration\nKey | Description | Default\n---|----|---\n`sonar.projectKey`|The project\'s unique key. Allowed characters are: letters, numbers, `-`, `_`, `.` and `:`, with at least one non-digit. | For Maven projects, this defaults to `<groupId>:<artifactId>`\n\n## Optional Parameters\n\n### Project Identity\nKey | Description | Default\n---|----|---\n`sonar.projectName`|Name of the project that will be displayed on the web interface.|`<name>` for Maven projects, otherwise project key. If not provided and there is already a name in the DB, it won\'t be overwritten\n`sonar.projectVersion` | The project version. | `<version>` for Maven projects, otherwise "not provided"\n\n### Authentication\nIf the "Anyone" pseudo-group does not have permission to perform analyses, you\'ll need to supply the credentials of a user with Execute Analysis permission for the analysis to run under.\n\n\nKey | Description | Default\n---|----|---\n`sonar.login` | The login or authentication token of a {instance} user with Execute Analysis permission on the project. |\n`sonar.password` | The password that goes with the `sonar.login` username. This should be left blank if an authentication token is being used. |\n\n### Web Services\nKey | Description | Default\n---|----|---\n`sonar.ws.timeout` | Maximum time to wait for the response of a Web Service call (in seconds). Modifying this value from the default is useful only when you\'re experiencing timeouts during analysis while waiting for the server to respond to Web Service calls. |  60\n\n### Project Configuration\nKey | Description | Default\n---|----|---\n`sonar.projectDescription` | The project description. | `<description>` for Maven projects\n`sonar.links.homepage` | Project home page. | `<url>` for Maven projects\n`sonar.links.ci` | Continuous integration. | `<ciManagement><url>` for Maven projects\n`sonar.links.issue` | Issue tracker. | `<issueManagement><url>` for Maven projects\n`sonar.links.scm` | Project source repository. | `<scm><url>` for Maven projects\n`sonar.sources` | Comma-separated paths to directories containing main source files. | Read from build system for Maven, Gradle, MSBuild projects. Defaults to project base directory when neither `sonar.sources` nor `sonar.tests` is provided.\n`sonar.tests` | Comma-separated paths to directories containing test source files. | Read from build system for Maven, Gradle, MSBuild projects. Else default to empty.\n`sonar.sourceEncoding` | Encoding of the source files. Ex: `UTF-8`, `MacRoman`, `Shift_JIS`. This property can be replaced by the standard property `project.build.sourceEncoding` in Maven projects. The list of available encodings depends on your JVM. | System encoding\n`sonar.externalIssuesReportPaths` | Comma-delimited list of paths to Generic Issue reports. | \n`sonar.projectDate` | Assign a date to the analysis. This parameter is only useful when you need to retroactively create the history of a not-analyzed-before project. The format is `yyyy-MM-dd`, for example: 2010-12-01. Since you cannot perform an analysis dated prior to the most recent one in the database, you must analyze recreate your project history in chronological order, oldest first. ![](/images/exclamation.svg) Note: You may need to adjust your housekeeping settings if you wish to create a long-running history. | Current date\n`sonar.projectBaseDir` | Use this property when you need analysis to take place in a directory other than the one from which it was launched. E.G. analysis begins from `jenkins/jobs/myjob/workspace` but the files to be analyzed are in `ftpdrop/cobol/project1`. The path may be relative or absolute. Specify not the the source directory, but some parent of the source directory. The value specified here becomes the new "analysis directory", and other paths are then specified as though the analysis were starting from the specified value of `sonar.projectBaseDir`. Note that the analysis process will need write permissions in this directory; it is where the `sonar.working.directory` will be created. |\n`sonar.working.directory` | Set the working directory for an analysis triggered with the SonarScanner or the SonarScanner for Ant (versions greater than 2.0). This property is not compatible with the SonarScanner for MSBuild. Path must be relative, and unique for each project. ![](/images/exclamation.svg) Beware: the specified folder is deleted before each analysis. | `.sonar`\n`sonar.scm.provider` | This property can be used to explicitly tell {instance} which SCM plugin should be used to grab SCM data on the project (in case auto-detection does not work). The value of this property is always lowercase and depends on the plugin (ex. "tfvc" for the TFVC plugin). Check the documentation page of each plugin for more. |  \n`sonar.scm.forceReloadAll` | By default, blame information is only retrieved for changed files. Set this property to `true` to load blame information for all files. This can be useful is you feel that some SCM data is outdated but {instance} does not get the latest information from the SCM engine. | \n`sonar.scm.exclusions.disabled`| For supported engines, files ignored by the SCM, i.e. files listed in `.gitignore`, will automatically be ignored by analysis too. Set this property to `true` to disable that feature.|\n`sonar.buildString`| The string passed with this property will be stored with the analysis and available in the results of `api/project_analyses/search`, thus allowing you to later identify a specific analysis and obtain its ID for use with `api/project_analyses/set_baseline`. | |\n`sonar.analysis.[yourKey]`| This property stub allows you to insert custom key/value pairs into the analysis context, which will also be passed forward to [webhooks](/project-administration/webhooks/). | |\n\n\n### Duplications\nKey | Description | Default\n---|----|---\n`sonar.cpd.${language}.minimumtokens` | A piece of code is considered duplicated as soon as there are at least 100 duplicated tokens in a row (overide with `sonar.cpd.${language}.minimumTokens`) spread across at least 10 lines of code (override with `sonar.cpd.${language}.minimumLines`). For Java projects, a piece of code is considered duplicated when there is a series of at least 10 statements in a row, regardless of the number of tokens and lines. This threshold cannot be overridden.  | 100\n`sonar.cpd.${language}.minimumLines` | (see above) | 10\n\n\n### Analysis Logging\nKey | Description | Default\n---|----|---\n`sonar.log.level` | Control the quantity / level of logs produced during an analysis. `DEBUG`: Display `INFO` logs + more details at `DEBUG` level. Similar to `sonar.verbose=true`. `TRACE`: Display `DEBUG` logs + the timings of all ElasticSearch queries and Web API calls executed by the SonarScanner. | `INFO`\n`sonar.verbose` | Add more detail to both client and server-side analysis logs. Activates `DEBUG` mode for the scanner, and adds client-side environment variables and system properties to server-side log of analysis report processing. ![](/images/exclamation.svg)NOTE: There is the potential for this setting to expose sensitive information such as passwords if they are stored as server-side environment variables. | false\n`sonar.showProfiling` | Display logs to see where the analyzer spends time. This parameter generates a file containing these timing infos in `<workingDir>/profiling/<moduleKey>-profiler.xml` where `<workingDir>` is: `.sonar/profiling/` when analysis is run with SonarScanner, and `target/sonar/profiling/` when SonarScanner for Maven is used. | `false`\n`sonar.scanner.dumpToFile` | Outputs to the specified file the full list of properties passed to the scanner API as a means to debug analysis. |  \n`sonar.scanner.metadataFilePath` | Set the location where the scanner writes the `report-task.txt` file containing among other things the `ceTaskId`. | value of `sonar.working.directory`\n\n\x3c!-- sonarqube --\x3e\n### Deprecated\n[[danger]]\n| ![](/images/cross.svg) These parameters are listed for completeness, but are deprecated and should not be used in new analyses.\n\nKey | Description\n---|----|---\n`sonar.branch` **![](/images/cross.svg)Deprecated since SQ 6.7** | _The Developer Edition provides fuller-featured branch functionality._ Manage SCM branches. Two branches of the same project are considered to be different projects in SonarQube. As a consequence issues found in a project A in a branch B1 are not linked to issues found for this project A in a branch B2. There is no way to automatically resolve issues from B2 when they are resolved in B1 as again A-B1 & A-B2 are considered separated projects. \n`sonar.links.scm_dev` **![](/images/cross.svg)Deprecated since SQ 7.1** | Developer connection. | `<scm><developerConnection>` for Maven projects\n\x3c!-- /sonarqube --\x3e\n'},{path:"analysis/background-tasks",content:'---\ntitle: Background Tasks\nurl: /analysis/background-tasks/\n---\n\nA Background Task can be:\n* the import of an Analysis Report\n* the computation of a Portfolio\n* the import or export of a project\n\n## What happens after the scanner is done analyzing?\n\nAnalysis is not complete until the relevant Background Task has been completed. Even though the SonarScanner\'s log shows `EXECUTION SUCCESS`, the analysis results will not be visible in the {instance} project until the Background Task has been completed. After a SonarScanner has finished analyzing your code, the result of the analysis (Sources, Issues, Metrics) -  the Analysis Report - is sent to {instance} Server for final processing by the Compute Engine. Analysis Reports are queued and processed serially.\n\nAt the Project level, when there is a pending Analysis Report waiting to be consumed, you have a "Pending" notification in the header, next to the date of the most recent completed analysis.\n\nGlobal Administrators can view the current queue at **[Administration > Projects > Background Tasks](/#sonarqube-admin#/admin/background_tasks)**. Project administrators can see the tasks for a project at **Administration > Background Tasks**.\n\n## How do I know when analysis report processing fails?\nBackground tasks usually succeed, but sometimes unusual circumstances cause processing to fail. Examples include:\n\n* running out of memory while processing a report from a very large project\n* hitting a clash between the key of an existing module or project and one in the report\n* ...\n\nWhen that happens, the failed status is reflected on the project homepage, but that requires someone to notice it. You can also choose to be notified by email when background tasks fail - either on a project by project basis, or globally on all projects where you have administration rights, in the **Notifications** section of your profile.\n\n## How do I diagnose a failing background task?\nFor each Analysis Report there is a dropdown menu allowing you to access to the "Scanner Context" showing you the configuration of the Scanner at the moment when the code scan has been run.\n\nIf processing failed for the task, an additional option will be available: "Show Error Details", to get the technical details why the processing of the Background Task failed.\n\n## How do I cancel a pending analysis report?\nAdministrators can cancel the processing of a pending task by clicking:\n\n* on the red \'x\' available on each line of a `Pending` task\n* on the red "bulk cancel" option next to the pending jobs count. This button cancels all pending tasks.\n\nOnce processing has begun on a report, it\'s too late to cancel it.\n\n'},{path:"analysis/coverage",content:'---\ntitle: Test Coverage & Execution\nurl: /analysis/coverage/\n---\n\nThis page lists analysis parameters related to test coverage and execution reports. For more other parameters, see [Analysis Parameters](/analysis/analysis-parameters/).\n\nSonarSource analyzers do not run your tests or generate reports. They only import pre-generated reports. Below you\'ll find language- and tool-specific analysis parameters for importing coverage and execution reports.  For information on generating reports, see the language-specific information in the analyzers\' subdirectories [here](https://docs.sonarqube.org/display/PLUG/SonarSource+Plugins).\n\nSome properties support the following wildcards in paths. The remarks for properties that support wildcards will mention that fact. If the remarks do not say wildcards are supported, then they are not.:\n\nSymbol|Meaning\n---|---\n`?`|a single character\n`*`|any number of characters\n`**`|any number of directories\n\n\n\n## Test Coverage\nUnless otherwise specified, these properties require values that are relative to project root.\n\nLangauge|Property|Remarks\n----|----|----\n**Any**|`sonar.coverage.jacoco.xmlReportPaths`|Path to JaCoCo XML coverage reports.\n**Any**|`sonar.coverageReportPaths`|Path to coverage report in the [Generic Test Data](/analysis/generic-test/) format.\nApex|`sonar.apex.coverage.reportPath`|Path to the `test-result-codecoverage.json` report file generated by the [`apex:test:run`](https://developer.salesforce.com/docs/atlas.en-us.sfdx_cli_reference.meta/sfdx_cli_reference/cli_reference_force_apex.htm?search_text=apex%20test#cli_reference_test_run) command of the [Salesforce CLI](https://developer.salesforce.com/tools/sfdxcli). Note, you must have a [Salesforce DX project](https://developer.salesforce.com/docs/atlas.en-us.sfdx_dev.meta/sfdx_dev/sfdx_dev_workspace_setup.htm) set up and linked to your Org\nC / C++ / Objective-C|`sonar.cfamily.gcov.reportsPath`|Path to the directory containing native `*.gcov` reports (not the XML reports generated by gcovr)\nC / C++ / Objective-C|`sonar.cfamily.llvm-cov.reportPath`| &nbsp;\nC / C++ / Objective-C|`sonar.cfamily.vscoveragexml.reportsPath`|Path may be absolute or relative to the solution directory. Path wildcards (see above) are supported. Note that the `.coveragexml` report format offered by Visual Studio is not supported.\nC / C++ / Objective-C|`sonar.cfamily.bullseye.reportPath`|Reports from Bullseye versions 8.9.59 to 8.9.62 are not supported because of format imcompatibility.\nC#|`sonar.cs.vscoveragexml.reportsPaths`|Path to Visual Studio Code Coverage report. Multiple paths may be comma-delimited, or included via wildcards. See _Notes on importing .NET reports_ below.\nC#|`sonar.cs.dotcover.reportsPaths`|Path to dotCover coverage report. See _Notes on importing .NET reports_ below.\nC#|`sonar.cs.opencover.reportsPaths`|Path to OpenCover coverage report. See _Notes on importing .NET reports_ below.\nFlex|`soanr.flex.cobertura.reportPath`|Path to the Cobertura XML report. May be absolute or relative to the project base directory.\nGo|`sonar.go.coverage.reportPaths`|Comma-delimited list of paths to coverage report files. Path wildcards are supported (see above) since SonarGo 1.1.\nJava|`sonar.jacoco.reportPaths`|Path to JaCoCo reports in binary format. **Supported only for Java**. \nJavaScript|`sonar.javascript.lcov.reportPaths`|Comma-delimited list of paths to LCOV coverage report files. Paths may be absolute or relative to project root.\nPHP|`sonar.php.coverage.reportPaths`|Comma-delimited list of paths to Clover XML-format coverage report files. Paths may be absolute or relative to project root.\nPython|`sonar.python.coverage.reportPaths`|Comma-delimited list of paths to coverage reports in the Cobertura XML format. Path wildcards are supported (see above). Leave unset to use the default (`coverage-reports/*coverage-*.xml`).\nRuby|`sonar.ruby.coverage.reportPaths`|Comma-delimited list of paths to SimpleCov `.resultset.json` report files. Paths may be absolute or relative to project-root.\nScala|`sonar.scala.coverage.reportPaths`|Comma-separated list of paths to `scoverage.xml` report files generaged by Scoverage.\nSwift, Xcode 9.3+|&nbsp;|You can use the [xccov-to-sonarqube-generic.sh](https://github.com/SonarSource/sonar-scanning-examples/blob/master/swift-coverage/swift-coverage-example/xccov-to-sonarqube-generic.sh) script from the [sonar-scanning-examples/swift-coverage](https://github.com/SonarSource/sonar-scanning-examples/tree/master/swift-coverage) project convert output from Xcode 9.3\'s xccov tool to the [Generic Test Data](/analysis/generic-test/) format.\nSwift, Xcode 7-9.2|`sonar.swift.coverage.reportPath`|Path to the report generated by `llvm-cov show`. Path may be absolute or relative to project root.\nTypeScript|`sonar.typescript.lcov.reportPaths`|Comma-delimited list of paths to LCOV coverage reports. Paths may be absolute or relative to project root.\nVB.NET|`sonar.vbnet.vscoveragexml.reportsPaths`|Path to Visual Studio Code Coverage report. Multiple paths may be comma-delimited, or included via wildcards. See _Notes on importing .NET reports_ below.\nVB.NET|`sonar.vbnet.dotcover.reportsPaths`|Path to dotCover coverage report. See _Notes on importing .NET reports_ below.\nVB.NET|`sonar.vbnet.opencover.reportsPaths`|Path to OpenCover coverage report. See _Notes on importing .NET reports_ below.\n\n\n## Test Execution\nUnless otherwise specified, these properties require values that are relative to project root.\n\nLanguage|Property|Remarks\n---|---|---\n**All**|`sonar.testExecutionReportPaths`|Comma-delimited list of paths to execution reports in the [Generic Execution Data](/analysis/generic-test/) format.\nC / C++ / Objective-C|`sonar.cfamily.cppunit.reportsPath`|Path to the directory holding the CPPUnit reports. Note that while measures such as the number of tests are displayed at project level, no drilldown is available.\nC#|`sonar.cs.vstest.reportsPaths`|Paths to VSTest reports. Multiple paths may be comma-delimited, or included via wildcards. Note that while measures such as the number of tests are displayed at project level, no drilldown is available.\nC#|`sonar.cs.nunit.reportsPaths`|Paths to NUnit execution reports. Multiple paths may be comma-delimited, or included via wildcards. Note that while measures such as the number of tests are displayed at project level, no drilldown is available.\nC#|`sonar.cs.mstest.reportsPaths`|Paths to MSTest execution reports. Multiple paths may be comma-delimited, or included via wildcards. Note that while measures such as the number of tests are displayed at project level, no drilldown is available.\nC#|`sonar.cs.xunit.reportsPaths`|Paths to xUnit execution reports. Multiple paths may be comma-delimited, or included via wildcards. Note that while measures such as the number of tests are displayed at project level, no drilldown is available.\nGo|`sonar.go.tests.reportPaths`|Comma-delimited list of paths to unit test report files. Paths may be absolute or relative to project root.\nJava|`sonar.junit.reportPaths`|Comma-delimited list of paths to Surefire XML-format reports.\nPHP|`sonar.php.tests.reportPath`|Path to the PHPUnit unit test execution report file. Path may be absolute or relative to project root.\nPython|`sonar.python.xunit.reportPath`|Path to unit test execution report. Leave unset to use the default (`xunit-reports/xunit-result-*.xml`). Path wildcards (see above) are supported. If any paths in the report are invalid, set `sonar.python.xunit.skipDetails=true` to collect only project-level details.\nTypeScript|&nbsp;|You can use [jest-sonar-reporter](https://www.npmjs.com/package/jest-sonar-reporter) or[karma-sonarqube-unit-reporter](https://github.com/tornaia/karma-sonarqube-unit-reporter) to create reports in the [Generic Execution Data](/analysis/generic-test/) format. Both packages are available on npm.\nVB.NET|`sonar.vbnet.vstest.reportsPaths`|Paths to VSTest execution reports. Multiple paths may be comma-delimited, or included via wildcards. Note that while measures such as the number of tests are displayed at project level, no drilldown is available.\nVB.NET|`sonar.vbnet.nunit.reportsPaths`|Paths to NUnit execution reports. Multiple paths may be comma-delimited, or included via wildcards. Note that while measures such as the number of tests are displayed at project level, no drilldown is available.\nVB.NET|`sonar.vbnet.mstest.reportsPaths`|Paths to MSTest execution reports. Multiple paths may be comma-delimited, or included via wildcards. Note that while measures such as the number of tests are displayed at project level, no drilldown is available.\nVB.NET|`sonar.vbnet.xunit.reportsPaths`|Paths to xUnit execution reports. Multiple paths may be comma-delimited, or included via wildcards. Note that while measures such as the number of tests are displayed at project level, no drilldown is available.\n\n**Notes on importing .NET reports**  \n.NET reports are imported into SonarQube in 4 steps:\n\n1. Run the SonarScanner.MSBuild.exe `begin` command, specifying the absolute path where the reports _will be_ available using the `/d:propertyKey="path"` syntax ("propertyKey" depends on the tool)\n1. Build your project using MSBuild\n1. Run your test tool, instructing it to produce a report at the same location specified earlier to the MSBuild SonarQube Runner\n1. Run the SonarScanner.MSBuild.exe `end` command\n'},{path:"analysis/external-issues",content:"---\ntitle: Importing External Issues\nurl: /analysis/external-issues/\n---\n\nThis page lists analysis parameters related to the import of issues raised by external, third-party analyzers. For more other parameters, see [Analysis Parameters](/analysis/analysis-parameters/).\n\nSonarSource analyzers do not run your external analyzers or generate reports. They only import pre-generated reports. Below you'll find language- and tool-specific analysis parameters for importing reports generated by external analzyers. Additional language-specific details on some external analyzers can be found in the subdirectories for the relevant SonarSource language analyzers [here](https://docs.sonarqube.org/display/PLUG/SonarSource+Plugins).\n\nSome properties support the following wildcards in paths. The remarks for properties that support wildcards will mention that fact. If the remarks do not say wildcards are supported, then they are not.:\n\nSymbol|Meaning\n---|---\n`?`|a single character\n`*`|any number of characters\n`**`|any number of directories\n\nUnless otherwise specified, the following properties accept both absolute paths and paths relative to project root.\n\nLangauge|Property|Remarks\n----|----|----\nApex|`sonar.apex.pmd.reportPaths`|Comma-delimited list of paths to [PMD Apex](https://pmd.github.io/pmd-5.5.7/pmd-apex/rules/index.html) reports|\nCSS|`sonar.css.stylelint.reportPaths`|Comma-delimited list of paths to [StyleLint.io](https://stylelint.io/) reports|\nGo|`sonar.go.govet.reportPaths`|Comma-delimited list of paths to [GoVet](https://golang.org/cmd/vet/) reports|\nGo|`sonar.go.golint.reportPaths`|Comma-delimited list of paths to [GoLint](https://github.com/golang/lint) reports|\nGo|`sonar.go.gometalinter.reportPaths`|Comma-delimited list of paths to [GoMetaLinter](https://github.com/alecthomas/gometalinter) reports|\nJava|`sonar.java.spotbugs.reportPaths`|Comma-delimited list of paths to reports from [SpotBugs](https://spotbugs.github.io/), FindSecBugs, or FindBugs|\nJava|`sonar.java.pmd.reportPaths`|Comma-delimited list of paths to reports from [PMD](http://maven.apache.org/plugins/maven-pmd-plugin/usage.html)\nJava|`sonar.java.checkstyle.reportPaths`|Comma-delimited list of paths to reports from [Checkstyle](http://maven.apache.org/plugins/maven-checkstyle-plugin/checkstyle-mojo)\nJavaScript|`sonar.eslint.reportPaths`|Comma-delimited list of paths to JSON ESLint reports\nKotlin|`sonar.androidLint.reportPaths`|Comma-delimited list of paths to AndroidLint reports\nKotlin|`sonar.kotlin.detekt.reportPaths`|Comma-delimited list of paths to [Detekt](https://github.com/arturbosch/detekt) reports\nPython|`sonar.python.pylint`|Path to a [Pylint](http://www.pylint.org/) report. Wildcards are supported|\nPython|`sonar.python.pylint_config` `sonar.python.pylint`|By default SonarPython will execute the pylint command for you if you haven't specified the path to a PyLint report. Use `sonar.python.pylint` to use a pylint executable in a non-default location. The property **must** be set on windows (even for the default location), using either escaped backslashes, or single forward slashes (e.g. `C:\\\\Python26\\\\Scripts\\\\pylint.bat`, `C:/Python26/Scripts/pylint.bat`). Use `sonar.python.pylint_config` to specify the relative or absolute path to a non-default pylint configuration file.\nPython|`sonar.python.bandit.reportPaths`|Comma-delimited list of paths to [Bandit](https://github.com/PyCQA/bandit/blob/master/README.rst) reports\nRuby|`sonar.ruby.rubocop.reportPaths`|Comma-delimited list of paths to [Rubocop](https://github.com/rubocop-hq/rubocop) reports\nScala|`sonar.scala.scalastyle.reportPaths`|Comma-delimited list of paths to [Scalastyle](http://www.scalastyle.org/) reports\nScala|`sonar.scala.scapegoat.reportPaths`|Comma-delimited list of paths to [Scapegoat](https://github.com/sksamuel/scapegoat) reports in the **Scalastyle format**\nSwift|`sonar.swift.swiftLint.reportPaths`|Comma-delimited list of paths to [SwiftLint](https://github.com/realm/SwiftLint) reports in JSON format\nTypeScript|`sonar.typescript.tslint.reportPaths`|Comma-delimited list of paths to TSLint reports in JSON format|\n\n**Notes on external .NET issues**  \nIssues from third-party analyzers are included in the MSBuild output and imported by default into {instance}, so no properties exist to enable that behavior. Instead, properties are available to adjust the import and to _stop_ importing those issues.\n\nNote that Roslyn issues with an *error* severity automatically fail the build, and it is not recommended to run the Scanner for MSBuild's end step if the MSBuild step fails for any reason because it will result in an essentially empty analysis, which will close all outstanding issues in the project.\n\nLangauge|Property|Remarks\n----|----|----\nC#|`sonar.cs.roslyn.ignoreIssues`|Set to `true` to disable import of external issues. Defaults to `false`.\nC#|`sonar.cs.roslyn.bugCategories` `sonar.cs.roslyn.vulnerabilityCategories` `sonar.cs.roslyn.codeSmellCategories`|Comma-delimited list of categories whose issues should be classified as Bugs, Vulnerabilities, or Code Smells. \nVB.NET|`sonar.vbnet.roslyn.ignoreIssues`|Set to `true` to disable import of external issues. Defaults to `false`.\nVB.NET|`sonar.vbnet.roslyn.bugCategories` `sonar.vbnet.roslyn.vulnerabilityCategories` `sonar.vbnet.roslyn.codeSmellCategories`|Comma-delimited list of categories whose issues should be classified as Bugs, Vulnerabilities, or Code Smells. \n"},{path:"analysis/generic-issue",content:'---\ntitle: Generic Issue Data\nurl: /analysis/generic-issue/\n---\n\n{instance} supports a generic import format for raising "external" issues in code. It is intended to allow you to import the issues from your favorite linter even if no plugin exists for it.\n\nExternal issues suffer from two important limitations:\n\n* they cannot be managed within {instance}; for instance, there is no ability to mark them False Positive.\n* the activation of the rules that raise these issues cannot be managed within {instance}. In fact, external rules are not visible in the Rules page or reflected in any Quality Profile.\n\nExternal issues and the rules that raise them must be managed in the configuration of your linter. \n\n## Import \nThe analysis parameter `sonar.externalIssuesReportPaths` accepts a comma-delimited list of paths to reports.\n\nEach report must contain, at top-level, an array of `Issue` objects named `issues`.\n\n#### Issue fields:\n\n* `engineId` - string\n* `ruleId` - string\n* `primaryLocation` - Location object \n* `type` - string. One of BUG, VULNERABILITY, CODE_SMELL\n* `severity` - string. One of BLOCKER, CRITICAL, MAJOR, MINOR, INFO\n* `effortMinutes` - integer, optional. Defaults to 0\n* `secondaryLocations` - array of Location objects, optional\n\n#### Location fields:\n\n* `message` - string\n* `filePath` - string\n* `textRange` - TextRange object, optional for secondary locations only\n\n#### TextRange fields:\n\n* `startLine` - integer. 1-indexed\n* `endLine` - integer, optional. 1-indexed\n* `startColumn` - integer, optional. 0-indexed\n* `endColumn` - integer, optional. 0-indexed\n\n## Example\nHere is an example of the expected format:\n\n\t{ "issues": [\n\t\t{\n\t\t  "engineId": "test",\n\t\t  "ruleId": "rule1",\n\t\t  "severity":"BLOCKER",\n\t\t  "type":"CODE_SMELL",\n\t\t  "primaryLocation": {\n\t\t\t"message": "fully-fleshed issue",\n\t\t\t"filePath": "sources/A.java",\n\t\t\t"textRange": {\n\t\t\t  "startLine": 30,\n\t\t\t  "endLine": 30,\n\t\t\t  "startColumn": 9,\n\t\t\t  "endColumn": 14\n\t\t\t}\n\t\t  },\n\t\t  "effortMinutes": 90,\n\t\t  "secondaryLocations": [\n\t\t\t{\n\t\t\t  "message": "cross-file 2ndary location",\n\t\t\t  "filePath": "sources/B.java",\n\t\t\t  "textRange": {\n\t\t\t\t"startLine": 10,\n\t\t\t\t"endLine": 10,\n\t\t\t\t"startColumn": 6,\n\t\t\t\t"endColumn": 38\n\t\t\t  }\n\t\t\t}\n\t\t  ]\n\t\t},\n\t\t{\n\t\t  "engineId": "test",\n\t\t  "ruleId": "rule2",\n\t\t  "severity": "INFO",\n\t\t  "type": "BUG",\n\t\t  "primaryLocation": {\n\t\t\t"message": "minimal issue raised at file level",\n\t\t\t"filePath": "sources/Measure.java"\n\t\t  }\n\t\t}\n\t]}\n'},{path:"analysis/generic-test",content:'---\ntitle: Generic Test Data\nurl: /analysis/generic-test/\n---\n\nOut of the box, {instance} supports generic formats for test coverage and test execution import. If your coverage engines\' native output formats aren\'t supported by your language plugins, simply covert them to these formats.\n\n## Generic Coverage\nReport paths should be passed in a comma-delimited list to:\n\n * `sonar.coverageReportPaths`\n\nThe supported format is described by the `sonar-generic-coverage.xsd`:\n\n\t<xs:schema>\n\t  <xs:element name="coverage">\n\t\t<xs:complexType>\n\t\t  <xs:sequence>\n\t\t\t<xs:element name="file" minOccurs="0" maxOccurs="unbounded">\n\t\t\t  <xs:complexType>\n\t\t\t\t<xs:sequence>\n\t\t\t\t  <xs:element name="lineToCover" minOccurs="0" maxOccurs="unbounded">\n\t\t\t\t\t<xs:complexType>\n\t\t\t\t\t  <xs:attribute name="lineNumber" type="xs:positiveInteger" use="required"/>\n\t\t\t\t\t  <xs:attribute name="covered" type="xs:boolean" use="required"/>\n\t\t\t\t\t  <xs:attribute name="branchesToCover" type="xs:nonNegativeInteger"/>\n\t\t\t\t\t  <xs:attribute name="coveredBranches" type="xs:nonNegativeInteger"/>\n\t\t\t\t\t</xs:complexType>\n\t\t\t\t  </xs:element>\n\t\t\t\t</xs:sequence>\n\t\t\t  <xs:attribute name="path" type="xs:string" use="required"/>\n\t\t\t  </xs:complexType>\n\t\t\t</xs:element>\n\t\t  </xs:sequence>\n\t\t  <xs:attribute name="version" type="xs:positiveInteger" use="required"/>\n\t\t</xs:complexType>\n\t  </xs:element>\n\t</xs:schema>\n\nand looks like this:\n\n\t<coverage version="1">\n\t  <file path="xources/hello/NoConditions.xoo">\n\t\t<lineToCover lineNumber="6" covered="true"/>\n\t\t<lineToCover lineNumber="7" covered="false"/>\n\t  </file>\n\t  <file path="xources/hello/WithConditions.xoo">\n\t\t<lineToCover lineNumber="3" covered="true" branchesToCover="2" coveredBranches="1"/>\n\t  </file>\n\t</coverage>\n\nThe root node should be named `coverage`. Its version attribute should be set to `1`.\n\nInsert a `file` element for each file which can be covered by tests. Its `path` attribute can be either absolute or relative to the root of the module.\nInside a `file` element, insert a `lineToCover` for each line which can be covered by unit tests. It can have the following attributes:\n* `lineNumber` (mandatory)\n* `covered` (mandatory): boolean value indicating whether tests actually hit that line\n* `branchesToCover` (optional): number of branches which can be covered\n* `coveredBranches` (optional): number of branches which are actually covered by tests\n\n## Generic Execution\nReport paths should be passed in a comma-delimited list to:\n\n* `sonar.testExecutionReportPaths`\n\nThe supported format looks like this:\n\n\t<testExecutions version="1">\n\t  <file path="testx/ClassOneTest.xoo">\n\t\t<testCase name="test1" duration="5"/>\n\t\t<testCase name="test2" duration="500">\n\t\t  <skipped message="short message">other</skipped>\n\t\t</testCase>\n\t\t<testCase name="test3" duration="100">\n\t\t  <failure message="short">stacktrace</failure>\n\t\t</testCase>\n\t\t<testCase name="test4" duration="500">\n\t\t  <error message="short">stacktrace</error>\n\t\t</testCase>\n\t  </file>\n\t</testExecutions>\n\t\nThe root node should be named `testExecutions`. Its version attribute should be set to `1`.\n\nInsert a `file` element for each test file. Its `path` attribute can be either absolute or relative to the root of the module.\n\n**Note** unlike for coverage reports, the files present in the report must be test file names, not source code files covered by tests.\n\nInside a `file` element, insert a `testCase` for each test run by unit tests. It can have the following attributes/children:\n\n* `testCase` (mandatory)\n  * `name` (mandatory): name of the test case\n  * `duration` (mandatory): long value in milliseconds\n \n  * `failure|error|skipped` (optional): if the test is not OK, report the cause with a message and a long description\n    * `message` (mandatory): short message describing the cause\n    * `stacktrace` (optional): long message containing details about `failure|error|skipped` status\n'},{path:"analysis/overview",content:"---\ntitle: Overview\nurl: /analysis/overview/\n---\n\n\x3c!-- sonarcloud --\x3e\n## Prepare your organization\n\nA project must belong to an [organization](/organizations/overview/). Create one if you intend to collaborate with your team mates, or use your personal organization for test purposes.\n\n[[info]]\n| ** Important note for private code:** Newly created organizations and personal organizations are under a free plan by default. This means projects analyzed on these organizations are public by default: the code will be browsable by anyone. If you want private projects, you should [upgrade your organization to a paid plan](/sonarcloud-pricing/).\n\nFind the key of your organization, you will need it at later stages. It can be found on the top right corner of your organization's header.\n\n## Run analysis\n\nSonarCloud currently does not trigger analyses automatically - this feature will come in a near future. Currently, it's up to you to launch them inside your existing CI scripts using the available scanners:\n* Gradle - [SonarScanner for Gradle](https://redirect.sonarsource.com/doc/gradle.html)\n* MSBuild - [SonarScanner for MSBuild](https://redirect.sonarsource.com/doc/install-configure-scanner-msbuild.html)\n* Maven - use the [SonarScanner for Maven](https://redirect.sonarsource.com/doc/install-configure-scanner-maven.html)\n* Ant - [SonarScanner for Ant](https://redirect.sonarsource.com/doc/install-configure-scanner-ant.html)\n* anything else (CLI) - [SonarScanner](https://redirect.sonarsource.com/doc/install-configure-scanner.html)\n\nAfter creating a project, the tutorial available on its homepage will guide you to find how to trigger an analysis.\n\n![Info](/images/info.svg) Remember that depending on which cloud solution you are using for your developments, you can rely on dedicated integrations to help you:\n\n* [GitHub](/integrations/github/)\n* [Bitbucket Cloud](/integrations/bitbucketcloud/)\n* [Azure DevOps (formerly VSTS)](/integrations/vsts/)\n\n\x3c!-- /sonarcloud --\x3e\n\n\x3c!-- sonarqube --\x3e\nOnce the SonarQube platform has been installed, you're ready to install an analyzer and begin creating projects. To do that, you must install and configure the scanner that is most appropriate for your needs. Do you build with:\n\n* Gradle - [SonarScanner for Gradle](https://redirect.sonarsource.com/doc/gradle.html)\n* MSBuild - [SonarScanner for MSBuild](https://redirect.sonarsource.com/doc/install-configure-scanner-msbuild.html)\n* Maven - use the [SonarScanner for Maven](https://redirect.sonarsource.com/doc/install-configure-scanner-maven.html)\n* Jenkins - [SonarScanner for Jenkins](https://redirect.sonarsource.com/plugins/jenkins.html)\n* Azure DevOps - [SonarQube Extension for Azure DevOps](https://redirect.sonarsource.com/doc/install-configure-scanner-tfs-ts.html)\n* Ant - [SonarScanner for Ant](https://redirect.sonarsource.com/doc/install-configure-scanner-ant.html)\n* anything else (CLI) - [SonarScanner](https://redirect.sonarsource.com/doc/install-configure-scanner.html)\n\n**Note** that we do not recommend running an antivirus scanner on the machine where a SonarQube analysis runs, it could result in unpredictable behavior.\n\n\nA project is created in the platform automatically on its first analysis. However, if you need to set some configuration on your project before its first analysis, you have the option of provisioning it via Administration options.\n\x3c!-- /sonarqube --\x3e\n\n## What does analysis produce? \n{instance} can perform analysis on 20+ different languages. The outcome of this analysis will be quality measures and issues (instances where coding rules were broken). However, what gets analyzed will vary depending on the language:\n\n* On all languages, \"blame\" data will automatically be imported from supported SCM providers. [Git and SVN are supported automatically](/analysis/scm-integration/). Other providers require additional plugins.\n* On all languages, a static analysis of source code is performed (Java files, COBOL programs, etc.)\n* A static analysis of compiled code can be performed for certain languages (.class files in Java, .dll files in C#, etc.)\n* A dynamic analysis of code can be performed on certain languages.\n\n## Will all files be analyzed?\nBy default, only files that are recognized by a language analyzer are loaded into the project during analysis. \n\x3c!-- sonarqube --\x3e\nFor example if your SonarQube instance had only SonarJava SonarJS on board, all .java and .js files would be loaded, but .xml files would be ignored.\n\n## What about branches and pull requests?\n_Developer Edition_ adds the ability to analyze your project's release / [long-lived branches](/branches/long-lived-branches/), feature / [short-lived branches](/branches/short-lived-branches/), and [pull requests](/analysis/pull-request/) as well as the ability to automatically decorate pull requests in some SCM interfaces. For more on branches see the [branches overview](/branches/overview/).\n\x3c!-- /sonarqube --\x3e\n\n## What happens during analysis?\nDuring analysis, data is requested from the server, the files provided to the analysis are analyzed, and the resulting data is sent back to the server at the end in the form of a report, which is then analyzed asynchronously server-side.\n\nAnalysis reports are queued, and processed sequentially, so it is quite possible that for a brief period after your analysis log shows completion, the updated values are not visible in your {instance} project. However, you will be able to tell what's going on because an icon will be added on the project homepage to the right of the project name. Mouse over it for more detail (and links if you're logged in with the proper permissions).\n\n![background task processing in progress.](/images/backgroundTaskProcessingInProgress.jpeg)\n\n\nThe icon goes away once processing is complete, but if analysis report processing fails for some reason, the icon changes:\n\n![background task processing failed.](/images/backgroundTaskProcessingFailedIcon.jpeg)\n\n\n## FAQ\n\n**Q.** Analysis errors out with `java.lang.OutOfMemoryError: GC overhead limit exceeded`. What do I do?  \n**A.** This means your project is too large or too intricate for the scanner to analyze with the default memory allocation. To fix this you'll want to allocate a larger heap (using `-Xmx[numeric value here]`) to the process running the analysis. Some CI engines may give you an input to specify the necessary values, for instance if you're using a Maven Build Step in a Jenkins job to run analysis. Otherwise, use Java Options to set a higher value. Note that details of setting Java Options are omitted here because they vary depending on the environment.\n"},{path:"analysis/pull-request",content:"---\ntitle: Pull Request Analysis\nurl: /analysis/pull-request/\n---\n\n\x3c!-- sonarqube --\x3e\n\n_Pull Request analysis is available as part of [Developer Edition](https://redirect.sonarsource.com/editions/developer.html) and [above](https://www.sonarsource.com/plans-and-pricing/)._\n\n\x3c!-- /sonarqube --\x3e\nPull Requests (PRs) are visible in {instance} from the branches and pull requests dropdown menu of your project.\n\nPR analysis allows you to:\n\n* see your PR's Quality Gate status in the {instance} UI.\n* automatically decorate your PRs with {instance} issues in your SCM provider's interface.\n\n## Quality Gate\n\nThe PR quality gate:\n* **Focuses on new code** – The PR quality gate only uses your project's quality gate conditions that apply to \"on New Code\" metrics.\n* **Assigns a status** – Each PR shows a quality gate status reflecting whether it Passed (green) or Failed (red).\n\nWhen PR decoration is enabled, {instance} publishes the status of the analysis (Quality Gate) on the PR.\n\nPR analyses on {instance} are deleted automatically after 30 days with no analysis. This can be updated in **Configuration > General > Number of days before purging inactive short living branches**. \n\n\x3c!-- sonarcloud --\x3e\n## Integrations for GitHub, Bitbucket Cloud and Azure DevOps\nIf your repositories are hosted on GitHub, Bitbucket Cloud or Azure DevOps, check out first the dedicated Integrations for: [BitBucketCloud](/integrations/bitbucketcloud/), [GitHub](/integrations/github/), and [Azure DevOps](/integrations/vsts/). Chances are that you do not need to read this page further since those integrations handle the configuration and analysis parameters for you.\n\x3c!-- /sonarcloud --\x3e\n\n## Analysis Parameters\n### Pull Request Analysis in {instance}\nThese parameters enable PR analysis:\n\n| Parameter Name        | Description |\n| --------------------- | ------------------ |\n| `sonar.pullrequest.branch` | The name of your PR<br/> Ex: `sonar.pullrequest.branch=feature/my-new-feature`|\n| `sonar.pullrequest.key` | Unique identifier of your PR. Must correspond to the key of the PR in GitHub or TFS. <br/> E.G.: `sonar.pullrequest.key=5` |\n| `sonar.pullrequest.base` | The long-lived branch into which the PR will be merged. <br/> Default: master <br/> E.G.: `sonar.pullrequest.base=master`|\n\n### Pull Request Decoration\nTo activate PR decoration, you need to:\n\n* (For GitHub \x3c!-- sonarqube --\x3eEnterprise\x3c!-- /sonarqube --\x3e) Specify your pull request provider\x3c!-- sonarqube --\x3e, create a GitHub App and configure your SonarQube instance,\x3c!-- /sonarqube --\x3e and set your GitHub parameters.\n* (For Azure DevOps and Bitbucket) Specify your pull request provider and set an authentication token/personal access token.\n\n#### Specifying Your Pull Request Provider\n| Parameter Name        | Description |\n| --------------------- | ------------------ |\n| `sonar.pullrequest.provider` | `github` or `vsts` \x3c!-- sonarcloud --\x3eor `bitbucketcloud`\x3c!-- /sonarcloud --\x3e. This is the name of the system managing your PR. In Azure DevOps, when the {instance} Extension for Azure DevOps is used, `sonar.pullrequest.provider` is automatically populated with \"vsts\". \x3c!-- sonarcloud --\x3eSame on GitHub if you are using the Travis CI Add-on, and on Bitbucket Cloud if you are building with Bitbucket Pipelines.\x3c!-- /sonarcloud --\x3e|\n\nNote: if you were relying on the GitHub Plugin, its properties are no longer required and they must be removed from your configuration: `sonar.analysis.mode`, `sonar.github.repository`, `sonar.github.pullRequest`, `sonar.github.oauth`.\n\n\x3c!-- sonarqube --\x3e\n#### Creating Your GitHub App\nTo add PR decoration to Checks in GitHub Enterprise, an instance administrator needs to create a GitHub App and configure your SonarQube instance. See [GitHub Enterprise Integration](/instance-administration/github-application/) for more information.\n\x3c!-- /sonarqube --\x3e\n\n#### Setting Your GitHub Parameters\n| Parameter Name        | Description |\n| --------------------- | ------------------ |\n| `sonar.pullrequest.github.repository` | SLUG of the GitHub Repo |\n\n#### Setting Your Authentication Token/Personal Access Token\n\nIf you are using Azure DevOps or Bitbucket, you need to configure the authentication token/personal access token that will be used by {instance} to decorate the PRs. This can be configured in **Administration > General Settings > Pull Requests > VSTS > Personal access token**.\n\n\x3c!-- sonarcloud --\x3e\n#### Bitbucket Cloud Parameters\n| Parameter Name        | Description | Example value |\n| --------------------- | ------------------ |------------------ |\n| `sonar.pullrequest.bitbucketcloud.repository` | UUID of the Bitbucket Cloud Repo | `{d2615dd4-550d-43e5-80c4-665f951e5d6e}` |\n| `sonar.pullrequest.bitbucketcloud.owner` | UUID of the Bitbucket Cloud Owner | `{4f9fd128-1b08-49ec-bf2c-f094163cff4d}` |\n\x3c!-- /sonarcloud --\x3e\n\n\x3c!-- sonarqube --\x3e\n#### Bitbucket Server Parameters\n| Parameter Name        | Description |\n| --------------------- | ------------------ |\n| `sonar.pullrequest.bitbucketserver.serverUrl` | The base URL for your Bitbucket Server instance. Usually defined in global server settings.<br/> Ex.: `https://bitbucket.company.com/` |\n| `sonar.pullrequest.bitbucketserver.project` | Bitbucket project key. Can be set in project settings, or passed through scanner properties.<br/> Ex.: `MYPRJ` |\n| `sonar.pullrequest.bitbucketserver.repository` | SLUG of the Bitbucket repository. Can be set in project settings, or passed through scanner properties.<br/> Ex.: `my-repo` |\n\n#### Issue links\nDuring pull request decoration, individual issues will be linked to their SonarQube counterparts automatically. However, for this to work correctly, the instance's **Server base URL** (**[Administration > General](/#sonarqube-admin#/admin/settings)**) must be set correctly. Otherwise the links will default to `localhost`.\n\x3c!-- /sonarqube --\x3e\n"},{path:"analysis/scm-integration",content:"---\ntitle: SCM Integration\nurl: /analysis/scm-integration/\n---\n\n## Table of Contents\n\nCollecting SCM data during code analysis can unlock a number of SonarQube features:\n\n* Automatic Issue Assignment\n* code annotation (blame data) in the Code Viewer\n* SCM-driven detection of new code (to help with [Fixing the Water Leak](/user-guide/fixing-the-water-leak/)). Without SCM data, SonarQube determines new code using analysis dates (to timestamp modification of lines).\n\nSCM integration requires support for your individual SCM provider. Git and SVN are supported by default. \x3c!-- sonarqube --\x3eFor other SCM providers, see the Marketplace.\x3c!-- /sonarqube --\x3e\n\nIf need be, you can toggle it off at global/project level via administration settings.\n\n## Git\n[Git](http://www.git-scm.com/) integration is supported out of the box with a pure Java implementation so there's no need to have Git command line tool installed on the machine where analysis is performed.\n\nAuto-detection of Git during analysis will happen if there is a .git folder in the project root directory or in one of its parent folders. Otherwise you can force the provider using `-Dsonar.scm.provider=git`. A full clone is required for this integration to be able to collect the required blame information (see Known Issues). If a shallow clone is detected, a warning will be logged and no attempt will be made to retrieve blame information..\n\n### Known Issues\n\n* Git doesn't consider old \"Mac\" line ends (CR) as new lines. As a result the blame operation will contain fewer lines than expected by SonarQube and analysis will fail. The solution is to fix line ends to use either Windows (CR/LF) or Unix (LF) line ends.\n* JGit doesn't support .mailmap file to \"clean\" email adress during the blame\n\n### Advanced information\nThe plugin uses [JGit](https://www.eclipse.org/jgit/) 4.9.0. JGit is a pure Java implementation of Git client.\n\n### How to investigate error during blame (only possible on Unix/Linux)?\n\nIf you get an error when blame is executed on a file, it may be a limitation or a bug in JGit. To confirm please follow these steps:\n\n1. Download the standalone JGit command line distribution\n\n2. Try to execute the blame command on the offending file:  \n    `chmod +x /path/to/org.eclipse.jgit.pgm-4.9.0.201710071750-r.sh /path/to/org.eclipse.jgit.pgm-4.9.0.201710071750-r.sh blame -w /path/to/offending/file`\n\n3. If you get the same error as during analysis, then this really looks like a bug in JGit (especially if you don't have an issue with the native git command line tool). Please try to do the previous steps with latest version of JGit and report all information to the [SonarQube Community Forum](https://community.sonarsource.com/).\n\n\n## Subversion\n[Subversion](https://subversion.apache.org/) integration is supported out of the box for Subversion 1.6 to 1.9.x.\n\nAuto-detection of SVN during analysis will happen if there is a `.svn` folder somewhere in the parent hierarchy of the project root. Otherwise you can force the provider using `-Dsonar.scm.provider=svn` on the analysis command line.\n\n### Known issues\nIf you get errors like:\n\n`Caused by: org.tmatesoft.svn.core.SVNException: svn: E200007: Retrieval of mergeinfo unsupported by 'https://pmd.svn.sourceforge.net/svnroot/pmd/trunk/pmd/src/main/java/net/sourceforge/pmd/AbstractConfiguration.java';`\nIt means the SVN server is not advertising the 'mergeinfo' capability. You can check the advertised capabilities by simply connecting to it:\n\n`telnet <svn_server> 3690`\nOften this is because your SVN server is not >= 1.5 or your project was not properly migrated after a server upgrade. It could also be a misconfiguration of the server.\n\nYou should try to run svnadmin upgrade **on the server**. For more information, please read https://subversion.apache.org/docs/release-notes/1.5.html#repos-upgrades.\n\n"},{path:"architecture/architecture-integration",content:"---\ntitle: Architecture and Integration\nurl: /architecture/architecture-integration/\n---\n## Overview\nThe SonarQube Platform is made of 4 components:  \n![SonarQube Platform.](/images/architecture-scanning.png)\n\n1. One SonarQube Server starting 3 main processes:\n    * Web Server for developers, managers to browse quality snapshots and configure the SonarQube instance\n    * Search Server based on Elasticsearch to back searches from the UI\n    * Compute Engine Server in charge of processing code analysis reports and saving them in the SonarQube Database\n2. One SonarQube Database to store:\n    * the configuration of the SonarQube instance (security, plugins settings, etc.)\n    * the quality snapshots of projects, views, etc.\n3. Multiple SonarQube Plugins installed on the server, possibly including language, SCM, integration, authentication, and governance plugins\n4. One or more SonarScanners running on your Build / Continuous Integration Servers to analyze projects\n\n## Integration\nThe following schema shows how SonarQube integrates with other ALM tools and where the various components of SonarQube are used.  \n![SonarQube Integration.](/images/architecture-integrate.png)\n\n1. Developers code in their IDEs and use [SonarLint](https://sonarlint.org) to run local analysis.\n2. Developers push their code into their favourite SCM : git, SVN, TFVC, ...\n3. The Continuous Integration Server triggers an automatic build, and the execution of the SonarScanner required to run the SonarQube analysis.\n4. The analysis report is sent to the SonarQube Server for processing.\n5. SonarQube Server processes and stores the analysis report results in the SonarQube Database, and displays the results in the UI.\n6. Developers review, comment, challenge their Issues to manage and reduce their Technical Debt through the SonarQube UI.\n7. Managers receive Reports from the analysis.\nOps use APIs to automate configuration and extract data from SonarQube.\nOps use JMX to monitor SonarQube Server.\n\n## About Machines and Locations\n* The SonarQube Platform cannot have more than one SonarQube Server and one SonarQube Database.\n* For optimal performance, each component (server, database, scanners) should be installed on a separate machine, and the server machine should be dedicated.\n* SonarScanners scale by adding machines.\n* All machines must be time synchronized.\n* The SonarQube Server and the SonarQube Database must be located in the same network\n* SonarScanners don't need to be on the same network as the SonarQube Server.\n* There is **no communication** between **SonarScanners** and the **SonarQube Database**.\n"},{path:"branches/branches-faq",content:"---\ntitle: Frequently Asked Branches Questions\nurl: /branches/branches-faq/\n---\n\n\x3c!-- sonarqube --\x3e\n\n_Branch analysis is available as part of [Developer Edition](https://redirect.sonarsource.com/editions/developer.html) and [above](https://www.sonarsource.com/plans-and-pricing/)._\n\n\x3c!-- /sonarqube --\x3e\n\n\n## How long are branches retained?  \nLong-lived branches are retained until you delete them manually (**Administration > Branches**).\nShort-lived branches are deleted automatically after 30 days with no analysis.\nThis can be updated in **Configuration > General > Number of days before purging inactive short living branches**. For more, see [Housekeeping](/instance-administration/housekeeping/).\n\n## Does my project need to be stored in an SCM like Git or SVN?  \nNo, you don't need to be connected to a SCM. But if you use Git or SVN we can better track the new files on short-lived branches and so better report new issues on the files that really changed during the life of the short-lived branch.\n\n## What if I mark an Issue \"Won't Fix\" or \"False-Positive\" in a branch?\nIt be replicated as such when merging my short-lived branch into the Master. Each time there is an analysis of a long-lived branch, we look at the issues on the short-lived branches and try to synchronize them with the newly raised issues on the long-lived branch. In case you made some changes on the issues (false-positive, won't fix), these changes will be reported on the long-lived branch.\n\n## Can I still use 'sonar.branch'?  \n`sonar.branch` is deprecated. You can still use it but it will behave the same way it always has: a separate project will be created. We encourage you to smoothly migrate your users to the new parameter `sonar.branch.name`.\nPlease note you cannot use `sonar.branch` together with `sonar.branch.name`.\n\n## Can I manually delete a branch?  \nThis can be achieved by going into the Administration menu at Project's level, then Branches.\n\n## How do I control the lifespan of a short-lived branch?  \nAs a global admin, you can set the parameter `sonar.dbcleaner.daysBeforeDeletingInactiveShortLivingBranches` to control how many days you want to keep an inactive short-lived branch.\n\n## Does the payload of the Webhook include branch information?  \nYes, an extra node called \"branch\" is added to the payload.\n\n## When are Webhooks called?  \nWhen the computation of the background task is done for a given branch but also when an issue is updated on a short-lived branch.\n\n## What is the impact on my LOCs consumption vs my license?  \nThe LOC of your largest branch are counted toward your license limit. All other branches are ignored.  \n"},{path:"branches/long-lived-branches",content:"---\ntitle: Long-lived Branches\nurl: /branches/long-lived-branches/\n---\n\n\x3c!-- sonarqube --\x3e\n\n_Branch analysis is available as part of [Developer Edition](https://redirect.sonarsource.com/editions/developer.html) and [above](https://www.sonarsource.com/plans-and-pricing/)._\n\n\x3c!-- /sonarqube --\x3e\n\n## Status vs Quality Gate\n\nThe same quality gate that is applied to the project as a whole is automatically applied to long-lived branches as well. This is not editable.\n\n## Issue Creation and Synchronization\n\nDuring the **first analysis only**, issues (type, severity, status, assignee, change log, comments) are synchronized with the Main Branch. In each synchronized issue, a comment is added to the change log of the issue on the long-lived branch: \"The issue has been copied from branch 'master' to branch yyy\".\n\nThen, at each subsequent analysis of the long-lived branch, any new issue that comes from a short-lived branch automatically inherits the attributes (type, severity, ...) the issue had in the short-lived branch. A comment is added to the change log of the issue on the long-lived branch: \"The issue had been copied from branch 'the short-live branch' to branch yyy\".\n\n## New Code Period\n\nBecause long-lived branches will persist for a long time, you are likely to develop and release multiple versions from it, and so you can change the New Code period of a long-lived branch in **Administration > Branches**.\n\n## Settings and Quality Profiles on Branches\n\nBranch settings and quality profiles default to those set for the master branch, and by design, it's not possible to configure other values.\n"},{path:"branches/overview",content:'---\ntitle: Overview\nurl: /branches/overview/\n---\n\n\x3c!-- sonarqube --\x3e\n_Branch analysis is available as part of [Developer Edition](https://redirect.sonarsource.com/editions/developer.html) and [above](https://www.sonarsource.com/plans-and-pricing/)._\n\x3c!-- /sonarqube --\x3e\n\n## Table of Contents\n\n\nBranch analysis allows you to\n\n* analyze long-lived branches\n* analyze short-lived branches\n* notify external systems when the status of a short-lived branch is impacted\n\n## Branch Types\n\n### Short-lived\n\nShort-Lived\nThis corresponds to Pull/Merge Requests or Feature Branches. This kind of branch:\n\n* will disappear quickly\n* will be merged rapidly to prevent integration issues\n* is developed for a given version, so the version does not change,\n  and there is no way to set the New Code period; everything that has been changed in the branch is new code\n* tracks all the new issues related to the code that changed on it.\n\n![conceptual illustration of short-lived branches.](/images/short-lived-branch-concept.png)\n\nFor more, see [Short-lived Branches](/branches/short-lived-branches/)\n\n### Long-lived\n\nThis corresponds to "Maintenance" Branches that will house several release versions.\nThis kind of branch will:\n\n* last for a long time\n* inevitably diverge more and more from the other branches\n* house several release versions, each of which must pass the quality gate\n  to go to production not be expected to be merged into another branch\n\n![conceptual illustration of long-lived branches.](/images/long-lived-branch-concept.png)\n\nFor more, see [Long-lived Branches](/branches/long-lived-branches/)\n\n### Master / Main Branch\n\nThis is the default, and typically corresponds to what\'s being developed for\nyour next release. This is usually known within a development team as\n"master" or "head", and is what is analyzed when no specific branch parameters\nare provided. It is labeled "Main Branch" and defaults to the name "master",\nbut can be renamed from within the interface. When you are not using Developer Edition, this is the only branch you see.\n\n## Analysis\n\nA branch is created when the `sonar.branch.name` parameter is passed during analysis.\n\n| Parameter Name        | Description                                                                                                                                                                                                                                                             |\n| --------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |\n| `sonar.branch.name`   | Name of the branch (visible in the UI)                                                                                                                                                                                                                                  |\n| `sonar.branch.target` | Name of the branch where you intend to merge your short-lived branch at the end of its life. If left blank, this defaults to the master branch. It can also be used while initializing a long-lived branch to sync the issues from a branch other than the Main Branch. |\n\n### Git History\n\nBy default, TravisCI only fetches the last 50 git commits. You must use `git fetch --unshallow` to get the full history. If you don\'t, new issues may not be assigned to the correct developer.\n\n### Configuring the Branch type\n\nA regular expression is used to determine whether a branch is treated as long-lived or short-lived. By default, branches that have names starting with either "branch" or "release" will be treated as long-lived.\n\nThis can be updated globally in **Configuration > General > Detection** of long-lived branches or at project\'s level in the **Admininstration > Branches**.\n\nOnce a branch type has been set, it cannot be changed. Explicitly, you cannot transform a long-lived to short-lived branch, or vice-versa.\n\n## See also\n* [Short-lived Branches](/branches/short-lived-branches/)\n* [Long-lived Branches](/branches/long-lived-branches/)\n* [Frequently Asked Questions](/branches/branches-faq/)\n'},{path:"branches/short-lived-branches",content:"---\ntitle: Short-lived Branches\nurl: /branches/short-lived-branches/\n---\n\n\x3c!-- sonarqube --\x3e\n\n_Branch analysis is available as part of [Developer Edition](https://redirect.sonarsource.com/editions/developer.html) and [above](https://www.sonarsource.com/plans-and-pricing/)._\n\n\x3c!-- /sonarqube --\x3e\n\nShort-lived branch analysis shows your analysis and quality gate status in the {instance} UI.\n\n## Quality Gate\n\nThe short-lived branch quality gate:\n\n* **Focuses on new code** – The short-lived branch quality gate only uses your project's quality gate conditions that apply to \"on New Code\" metrics.\n* **Assigns a status** – Each short-lived branch shows a quality gate status reflecting whether it Passed (green) or Failed (red).\n\n## Issue Creation and Synchronization\n\nThe issues visible on the short-lived branch are the new issues corresponding to files modified in the branch.\n\nModified files are determined based on the checksum of each file on the sonar.branch.target and the short-lived branch.\n\n## New Code Period\n\nThe ephemeral nature of short-lived branches means the New Code Period is implicit; everything changed in the branch is new code.\n\n## Settings and Quality Profiles on Branches\n\nBranch settings and quality profiles default to those set for the master branch, and by design, it's not possible to configure other values.\n\n## Known Limitations\n\n* Only the issue-focused, hard-coded quality gate is available on a short-lived branch.\n* You cannot connect SonarLint to a short-lived branch.\n* Analysis of a short-lived branch based on another short-lived branch is not supported.\n"},{path:"faq",content:"---\ntitle: Frequently Asked Questions\nurl: /faq/\n---\n\n## Table of Contents\n\n## How do I get rid of issues that are False-Positives?\n**False-Positive and Won't Fix**  \nYou can mark individual issues False Positive or Won't Fix through the issues interface. If you're using Short-lived branch and PR analysis provided by the Developer Edition, issues marked False Positive or Won't Fix will retain that status after merge. This is the preferred approach.\n\n**//NOSONAR**  \nMost language analyzers support the use of the generic mechanism: `//NOSONAR` at the end of the line of the issue. This will suppress the all issues - now and in the future - that might be raised on the line.\n\n## How do I find and remove projects that haven't been analyzed in a while?\nIn **[Administration > Projects > Management](/#sonarqube-admin#/admin/projects_management)** you can search for **Last analysis before** to filter projects not analyzed since a specific date, and then use bulk **Delete** to remove the projects that match your filter.\n\nThis can be automated by using the corresponding Web API: `api/projects/bulk_delete?analyzedBefore=YYYY-MM-DD`.\n\n\x3c!-- sonarqube --\x3e\n## How do I trigger a full ElasticSearch reindex?\nCurrently, the only way to force a reindex is to:\n\n* Stop your server\n* Remove the contents of the $SQ_HOME/data/es5 directory\n* Start your server\n\nBefore doing this, you should be aware first that processes are in place on the SonarQube side that out-of-sync indices are detected and corrected, and second that a full re-index can be quite lengthy depending on the size of your instance.\n\n## Why can't I use my HTTP Proxy since I upgraded to Java8u111?\n\nIf you are getting this error in the logs when trying to use the Marketplace:\n```\njava.io.IOException: Unable to tunnel through proxy. Proxy returns \"HTTP/1.1 407 Proxy Authentication Required\n```\n... you probably upgraded your Java8 installation with an update greater than 111. To fix that, update _$SONARQUBE_HOME/conf/sonar.properties` like this:\n```\nsonar.web.javaOpts=-Xmx512m -Xms128m -XX:+HeapDumpOnOutOfMemoryError -Djdk.http.auth.tunneling.disabledSchemes=\"\"\n```\nReference: http://www.oracle.com/technetwork/java/javase/8u111-relnotes-3124969.html\n\x3c!-- /sonarqube --\x3e\n\n"},{path:"index",content:"---\ntitle: Documentation\nurl: /\n---\n\n\x3c!-- sonarcloud --\x3e\n\nSonarCloud is the leading product for Continuous Code Quality online, totally free for open-source projects. It supports all major programming languages, including Java, C#, JavaScript, TypeScript, C/C++ and many more. If your code is closed source, SonarCloud also offers [a paid plan](/sonarcloud-pricing/) to run private analyses.\n\nSonarCloud offers end-to-end integrations for teams leveraging the following solutions in their development processes:\n\n* [GitHub](/integrations/github/)\n* [Bitbucket Cloud](/integrations/bitbucketcloud/)\n* [Azure DevOps](/integrations/vsts/)\n\nAre you ready to eliminate bugs and vulnerabilities? Will you champion quality code in your projects?\n\n\x3c!-- /sonarcloud --\x3e\n\x3c!-- static --\x3e\n\n[[info]]\n| **Welcome to the new SonarQube documentation**  \n| If you already have a SonarQube instance, you should be aware that we've made this documentation available within SonarQube itself (from v7.4). Just look under the \"?\" in the top menu to be sure you're always looking at the right documentation for _your_ version!\n\x3c!-- /static --\x3e\n\x3c!-- sonarqube --\x3e\n\n[SonarQube](http://www.sonarqube.org/)® is an automatic code review tool to detect bugs, vulnerabilities and code smells in your code. It can integrate with your existing workflow to enable continuous code inspection across your project branches and pull requests.\n\nBelow are a few key pointers, otherwise head over to the left pane for full documentation content and search capabilities.\n\n### I write code\n* Why [new code](/user-guide/fixing-the-water-leak/) is the most important\n* [Concepts](/user-guide/concepts/)\n* [Quality Gates](/user-guide/quality-gates/)\n* [Issues](/user-guide/issues/)\n\n### I need to set up analysis\n* [Analyzing Source Code](/analysis/overview/)\n* [Branches](/branches/overview/)\n* [Pull Requests](/analysis/pull-request/)\n\n### I administer a project\n* [Project Existence](/project-administration/project-existence/)\n* What's [included, excluded](/project-administration/narrowing-the-focus/) from analysis \n* [Webhooks](/project-administration/webhooks/)\n* [Project Settings](/project-administration/project-settings/)\n\n### I administer a SonarQube Instance\n* [Security](/instance-administration/security/)\n* [Notifications](/instance-administration/notifications/)\n* [Housekeeping](/instance-administration/housekeeping/)\n\n### I do DevOps\n* [Upgrading](/setup/upgrading/)\n* [Monitoring](/instance-administration/monitoring/)\n* [Running a Cluster](/setup/operate-cluster/)\n\n### Stay in touch!\n* [Get help in the community](https://www.sonarqube.org/community/)\n* [Source code](https://github.com/SonarSource)\n* [Issue tracker](https://jira.sonarsource.com/)\n\n---\nNot using the current version?  \n[6.7.x (current LTS)](https://docs.sonarqube.org/display/SONARQUBE67/Documentation)  \n[Documentation for other versions](/previous-versions/)  \n\x3c!-- /sonarqube --\x3e\n"},{path:"instance-administration/compute-engine-performance",content:"---\ntitle: Compute Engine Performance\nurl: /instance-administration/compute-engine-performance/\n---\n\n_The ability to manage Compute Engine performance is available as part of [Enterprise Edition](https://redirect.sonarsource.com/editions/enterprise.html) and [above](https://www.sonarsource.com/plans-and-pricing/)._\n\n\n### How can I get analyses through the Compute Engine Queue faster?\nIf analyses are taking too long to process, it may be that you need to increase the number of Compute Engine (CE) workers (**[Administration > Projects > Background Tasks > Number of Workers](/#sonarqube-admin#/admin/background_tasks)**). \n\nThere are two cases to consider:\n\n1. slowness comes from the fact that the queue is often full of pending tasks\n1. individual tasks take a long time to process\n\nIn the first case, increasing the number of workers could help. The second case should be carefully evaluated. In either case, when considering increasing the number of CE workers, two questions should be answered.\n\n* does my infrastructure allow me to increase the number of workers?\n* to what extent should I increase the number of workers? I.E. What number should I configure?\n\nIncreasing the number of workers will increase the stress on the resources consumed by the Compute Engine. Those resources are:\n\n* the DB\n* disk I/O\n* network\n* heap\n* CPU\n\nOf those, only the last two are internal to the CE.\n\nIf slowness comes from any of the external resources (DB, disk I/O, network), then increasing the number of workers could actually slow the processing of individual reports (think of two people trying to go through a door at  the same time). However, if your slowness is caused by large individual analysis reports hogging the CE worker for extended periods of time, then enabling parallel processing by adding another worker could help. But if you do, you need to take a look at the internal resources.\n\nCE workers are not CPU-intensive and memory use depends entirely on the project that was analyzed. Some need a lot of memory, others don't. But with multiple CE workers, you should increase CE heap size by a multiple of the number of workers. The same logic applies to CPU: if running with one worker consumes up to Y% of CPU, then you should plan for Z workers requiring Y*Z% of CPU.\n\nTo accurately diagnose your situation, monitor network latency, the I/O of the SonarQube instance, and the database CPU and memory usage to evaluate whether slowness is mainly/mostly/only related to external resources. \n"},{path:"instance-administration/custom-measures",content:'---\ntitle: Custom Measures\nurl: /instance-administration/custom-measures/\n---\n\nSonarQube collects a maximum of measures in an automated manner but there are some measures for which this is not possible, such as when: the information is not available for collection, the measure is computed by a human, and so on. Whatever the reason, SonarQube provides a service to inject those measures manually and allow you to benefit from other services: the Manual Measures service. The manual measures entered will be picked during the next analysis of the project and thereafter treated as "normal" measures.\n\n## Managing Custom Metrics\nAs with measures that are collected automatically, manual measures are the values collected in each analsis for manual metrics. Therefore, the first thing to do is create the metric you want to save your measure against. In order to do so, log in as a system administrator and go to **[Administration > Configuration > Custom Metrics](/#sonarqube-admin#/admin/custom_metrics)**, where the interface will guide you in creating the Metric you need. \n\n## Managing Custom Measures\nCustom measures can be entered at project level. To add a measure, sign in as a project administrator, navigate to the desired project and choose **Administration > Custom Measures**, where you will find a table with the latest measure value entered for each metric. \n\nValues entered in this interface are "Pending", and will not be visible outside this administrative interface until the next analysis. \n\n'},{path:"instance-administration/db-copy",content:"---\ntitle: SonarQube DB Copy Tool\nurl: /instance-administration/db-copy/\n---\n\n_The SonarQube DB Copy Tool is available to [Enterprise Edition](https://redirect.sonarsource.com/editions/enterprise.html) customers and [above](https://www.sonarsource.com/plans-and-pricing/)._\n\nThis tool is provided to help you migrate your SonarQube database from one DB vendor to another. If, for instance, you've been using your SonarQube instance with Oracle and you want to migrate to PostgreSQL without loosing your analysis history, the SonarQube DB Copy Tool is what you need. \n\nIn the following lines we will talk about \"source\" and \"target\" SonarQube database instances. The source instance is the database you want to discard and the target is the one you want to move to.\n\nThe procedure is basically as follows:\n\n* connect to both the source and target databases\n* read the data from the source database table by table\n* save the data into the target database table by table\n* recreate the sequences, index, ... on the target database\n\n## Installation\nThe SonarQube DB Copy Tool is provided as a standalone JAR file. **It must not be installed on your source or target SonarQube instances**. Put the JAR wherever your want on your machine, the only prerequisite is that this machine must be authorized to access your source and target SonarQube databases.\n\nThe version of the JAR to use must be at least **1.3.1.48**\n\n## DB Copy Preparation Phase\nIn the preparation phase, you ready the target database by setting up SonarQube schema and populating it with the necessary tables so that you end up with the same  database schema in the source and the target.\n\n1. Make sure your target database is up and running\n1. On your target database, create the `sonar` schema. \n1. Download and expand a copy of SonarQube that exactly matches the version you're running. \n1. Configure your SonarQube copy to connect to the target database. (If you've placed your SonarQube copy on the same server that runs your primary SonarQube instance, you'll also need to configure non-default ports for your copy SonarQube instance.)\n1. Start your copy SonarQube instance. It will connect to your empty target and populate the schema.\n1. Once your copy instance is up and running (this indicates that the schema is fully populated), you can stop and delete it.\n1. Refresh the Database Statistics on the target database before restarting SonarQube\n\nAt this point, you have in your source and target databases the exact same lists of tables.\n\n## DB Copy Run Phase\nThere are only four steps in this phase:\n\n1. **Stop your primary SonarQube instance.**\n1. Execute the base command jar with the correct parameters. \n1. Update your primary SonarQube instance's configuration to point to the target DB\n1. Restart your primary SonarQube instance.\n\n### Base command\n```\njava -jar sonar-db-copy-1.3.1.480-jar-with-dependencies.jar\n```\n\n### Parameters\nName | Description | Required\n---|---|---|---\n`-help`|Print this parameters help| no  \n`-urlSrc`|JDBC URL of the source database|yes\n`-userSrc`|Username of the source database|yes\n`-pwdSrc`|Password of the source database|yes\n`-urlDest`|JDBC URL of the target database|yes\n`-userDest`|Username of the target database|yes\n`-pwdDest`|Password of the target database|yes\n`-driverDest`|JDBC Driver of the target database|no\n`-driverSrc`|JDBC Driver of the source database|no\n`-T`|Comma separated list of tables to migrate|no\n\n## Execution Examples\nFirst sonar-db-copy verifies if URLs can be reached and the database versions:  \n![verify urls](/images/db-copy/verify-urls.png)\n\nWhen the versions are different, the application stops.  \n![stop for different versions](/images/db-copy/verify-versions.png)\n\nSometime when you have restarted the copy, the destination database version is 0. This is not a problem, the copy will continue.  \n![version 0 in target is okay](/images/db-copy/version0-ok.png)\n\nThen it searches tables in source and destination database:  \n![search tables](/images/db-copy/search-tables.png)\n\nIf there are missing tables, you will read this log:  \n![missing table warning](/images/db-copy/missing-table-warning.png)\n\nSecond sonar-db-copy truncates tables in target database and indicates the number of tables purged:  \n![truncate tables in target](/images/db-copy/truncate-tables.png)\n\nOf course, the tables missing can not be purged:  \n![missing tables aren't purged](/images/db-copy/missing-table-not-purged.png)\n\nThird, sonar-db-copy reproduces data from source to destination and adjusts the sequence of destination database after the copy:  \n![copy data](/images/db-copy/copy-data.png)\n\nIf there are some missing tables:  \n![missing tables not copied](/images/db-copy/missing-table-not-copied.png)\n\nIf errors appear during the copy, the process does NOT stop but the errors are displayed:  \n![copy errors displayed](/images/db-copy/copy-errors-shown.png)\n\nAt the end sonar-db-copy reiterates the difference between source and destination database.  \n![final warning of remaining differences](/images/db-copy/summary-of-differences.png)\n\n\n"},{path:"instance-administration/delegated-auth",content:"---\ntitle: Delegating Authentication\nurl: /instance-administration/delegated-auth/\n---\n\n## Table of Contents\n\n\nSonarQube comes with an onboard user database, as well as the ability to delegate authentication via HTTP Headers, or LDAP.\n\n## HTTP Header Authentication\nThis feature is designed to delegate user authentication to third-party systems (proxies/servers).\n\nWhen this feature is activated, SonarQube expects that the authentication is handled prior any query reaching the server. \nThe tool that handles the authentication should:\n\n* intercept calls to the SonarQube server\n* take care of the authentication\n* update the HTTP request header with the relevant SonarQube user information\n* re-route the request to SonarQube with the appropriate header information\n\n![HTTP Header Authentication flow](/images/http-header-authentication.png)\n\nAll the parameters required to activate and configure this feature are available in SonarQube server configuration file (in _$SONARQUBE-HOME/conf/sonar.properties_).\n\nUsing Http header authentication is an easy way integrate your SonarQube deployment with an in-house SSO implementation.\n\n## LDAP Authentication\nYou can configure SonarQube authentication and authorization to an LDAP server (including LDAP Service of Active Directory) by configuring the correct values in _$SONARQUBE-HOME/conf/sonar.properties_.\n\nThe main features are:\n\n* Password checking against the external authentication engine.\n* Automatic synchronization of usernames and emails.\n* Automatic synchronization of relationships between users and groups (authorization).\n* Ability to authenticate against both the external and the internal authentication systems. There is an automatic fallback on SonarQube internal system if the LDAP server is down.\n* During the first authentication trial, if the user's password is correct, the SonarQube database is automatically populated with the new user. Each time a user logs into SonarQube, the username, the email and the groups this user belongs to that are refreshed in the SonarQube database. You can choose to have group membership synchronized as well, but this is not the default.\n\n\n&nbsp;| Apache DS | OpenLDAP | Open DS | Active Directory\n----|-----------|----------|---------|-----------------\nAnonymous | ![](/images/check.svg) |![](/images/check.svg) |![](/images/check.svg) |  &nbsp;\nSimple|![](/images/check.svg)|![](/images/check.svg)|![](/images/check.svg)|![](/images/check.svg)\nLDAPS|![](/images/check.svg)|![](/images/check.svg)|  |![](/images/check.svg)\nDIGEST-MD5|![](/images/check.svg)|  |![](/images/check.svg)|![](/images/check.svg)\nCRAM-MD5|![](/images/check.svg)|  |![](/images/check.svg)|![](/images/check.svg)\nGSSAPI|![](/images/check.svg)|  |  |  \n![](/images/check.svg) = successfully tested\n\n### Setup\n1. Configure the LDAP plugin by editing _$SONARQUBE-HOME/conf/sonar.properties_ (see table below)\n2. Restart the SonarQube server and check the log file for:\n```\nINFO org.sonar.INFO Security realm: LDAP ...\nINFO o.s.p.l.LdapContextFactory Test LDAP connection: OK\n```\n1. Log into SonarQube\n1. On logout users will be presented a login page (_/sessions/login_), where they can choose to login as technical user or a domain user by passing appropriate credentials\n\nFrom SonarScanners, we recommend using [local technical users](/instance-administration/security/) for authentication against SonarQube Server.\n\n**General Configuration**\n\nProperty|Description|Default value|Required|Example\n---|---|---|---|---\n`sonar.security.realm`|Set this to `LDAP` authenticate first against the external sytem. If the external system is not reachable or if the user is not defined in the external system, authentication will be performed against SonarQube's internal database.| none |Yes|`LDAP` (only possible value)\n`sonar.authenticator.downcase`|Set to true when connecting to a LDAP server using a case-insensitive setup.|`false`|No\n`ldap.url`|URL of the LDAP server. If you are using ldaps, you should install the server certificate into the Java truststore.| none |Yes|`ldap://localhost:10389`\n`ldap.bindDn`|The username of an LDAP user to connect (or bind) with. Leave this blank for anonymous access to the LDAP directory.|none|No|`cn=sonar,ou=users,o=mycompany`\n`ldap.bindPassword`|The password of the user to connect with. Leave this blank for anonymous access to the LDAP directory.|none|No|`secret`\n`ldap.authentication`|Possible values: `simple`, `CRAM-MD5`, `DIGEST-MD5`, `GSSAPI`. See [the tutorial on authentication mechanisms](http://java.sun.com/products/jndi/tutorial/ldap/security/auth.html)|`simple`|No\n`ldap.realm`|See [Digest-MD5 Authentication](http://java.sun.com/products/jndi/tutorial/ldap/security/digest.html), [CRAM-MD5 Authentication](http://java.sun.com/products/jndi/tutorial/ldap/security/crammd5.html)| none|No|example.org\n`ldap.contextFactoryClass`|Context factory class.|`com.sun.jndi.ldap.LdapCtxFactory`|No\n`ldap.StartTLS`|Enable use of `StartTLS`|`false`|No\n`ldap.followReferrals`|Follow referrals or not. See [Referrals in the JNDI](http://docs.oracle.com/javase/jndi/tutorial/ldap/referral/jndi.html)|`true`\n\n**User Mapping**\n\nProperty|Description|Default value|Required|Example for Active Directory\n---|---|---|---|---\n`ldap.user.baseDn`|Distinguished Name (DN) of the root node in LDAP from which to search for users.|None|Yes|`cn=users,dc=example,dc=org`\n`ldap.user.request`|LDAP user request.|`(&(objectClass=inetOrgPerson)(uid={login}))`|No|`(&(objectClass=user)(sAMAccountName={login}))`\n`ldap.user.realNameAttribute`|Attribute in LDAP defining the user’s real name.|`cn`|No|  \n`ldap.user.emailAttribute`|Attribute in LDAP defining the user’s email.|`mail`|No| \n\n**Group Mapping**\nOnly [groups](http://identitycontrol.blogspot.fr/2007/07/static-vs-dynamic-ldap-groups.html) are supported (not [roles](http://identitycontrol.blogspot.fr/2007/07/static-vs-dynamic-ldap-groups.html)). Only [static groups](http://identitycontrol.blogspot.fr/2007/07/static-vs-dynamic-ldap-groups.html) are supported (not [dynamic groups](http://identitycontrol.blogspot.fr/2007/07/static-vs-dynamic-ldap-groups.html)).\n\n[[warning]]\n|When group mapping is configured (i.e the below `ldap.group.*` properties are configured), membership in LDAP server will override any membership locally configured in SonarQube. LDAP server becomes the one and only place to manage group membership (and the info is fetched each time the user logs in).\n\nFor the delegation of authorization, [groups must be first defined in SonarQube](/instance-administration/security/). Then, the following properties must be defined to allow SonarQube to automatically synchronize the relationships between users and groups.\n\nProperty|Description|Default value|Required|Example for Active Directory\n---|---|---|---|---\n`ldap.group.baseDn`|Distinguished Name (DN) of the root node in LDAP from which to search for groups.|none|No|`cn=groups,dc=example,dc=org`\n`ldap.group.request`|LDAP group request.|`(&(objectClass=groupOfUniqueNames)(uniqueMember={dn}))`|No|`(&(objectClass=group)(member={dn}))`\n`ldap.group.idAttribute`|Property used to specifiy the attribute to be used for returning the list of user groups in the compatibility mode.|`cn`|No|`sAMAccountName`\n\n### Sample Configuration\n```\n# LDAP configuration\n# General Configuration\nsonar.security.realm=LDAP\nldap.url=ldap://myserver.mycompany.com\nldap.bindDn=my_bind_dn\nldap.bindPassword=my_bind_password\n  \n# User Configuration\nldap.user.baseDn=ou=Users,dc=mycompany,dc=com\nldap.user.request=(&(objectClass=inetOrgPerson)(uid={login}))\nldap.user.realNameAttribute=cn\nldap.user.emailAttribute=mail\n \n# Group Configuration\nldap.group.baseDn=ou=Groups,dc=sonarsource,dc=com\nldap.group.request=(&(objectClass=posixGroup)(memberUid={uid}))\n```\n\n## Advanced LDAP Topics\n### Authentication Methods\n* **`Anonymous`** -  Used when only read-only access to non-protected entries and attributes is needed when binding to the LDAP server.\n* **`Simple`** Simple authentication is not recommended for production deployments not using the ldaps secure protocol since it sends a cleartext password over the network.\n* **`CRAM-MD5`** - The Challenge-Response Authentication Method (CRAM) based on the HMAC-MD5 MAC algorithm ([RFC 2195](http://tools.ietf.org/html/rfc2195)).\n* **`DIGEST-MD5`** - This is an improvement on the CRAM-MD5 authentication method ([RFC 2831](http://www.ietf.org/rfc/rfc2831.txt)).\n* **`GSSAPI`** - GSS-API is Generic Security Service API ([RFC 2744](http://www.ietf.org/rfc/rfc2744.txt)). One of the most popular security services available for GSS-API is the Kerberos v5, used in Microsoft's Windows 2000 platform.\n\nFor a full discussion of LDAP authentication approaches, see [RFC 2829](http://www.ietf.org/rfc/rfc2829.txt) and [RFC 2251](http://www.ietf.org/rfc/rfc2251.txt).\n\n### Multiple Servers\nTo configure multiple servers:\n```\n# List the different servers\nldap.servers=server1,server2\n  \n# Configure server1\nldap.server1.url=ldap://server1:1389\nldap.server1.user.baseDn=dc=dept1,dc=com\n...\n \n# Configure server2\nldap.server2.url=ldap://server2:1389\nldap.server2.user.baseDn=dc=dept2,dc=com\n...\n```\n\nAuthentication will be tried on each server, in the order they are listed in the configurations, until one succeeds. User/Group mapping will be performed against the first server on which the user is found.\n\nNote that all the LDAP servers must be available while (re)starting the SonarQube server.\n\n### Troubleshooting\n* Detailed connection logs (and potential error codes received from LDAP server) are output to SonarQube's _$SONARQUBE_HOME/logs/web.log_, when logging is in `DEBUG` mode.\n\n* Time out when running SonarQube analysis using LDAP\nJava parameters are documented here: http://docs.oracle.com/javase/jndi/tutorial/ldap/connect/config.html. Such parameters can be set in `sonar.web.javaAdditionalOpts` in _$SONARQUBE-HOME/conf/sonar.properties_.\n\n* Kerberos Troubleshooting resources\n   * [Enabling Kerberos Logging](http://support.microsoft.com/kb/262177/en-us)\n   * [Troubleshooting Kerberos Delegation](https://gallery.technet.microsoft.com/Troubleshooting-Kerberos-72837743)\n* Troubleshooting NTLM\n   * [Enabling NTLM Logging](http://blogs.technet.com/b/askds/archive/2009/10/08/ntlm-blocking-and-you-application-analysis-and-auditing-methodologies-in-windows-7.aspx)\n\n## Authenticating Via Other Systems\nAdditionally, several plugins are available to allow delegation to other providers: \n* Crowd - [SonarQube Crowd Plugin](https://github.com/SonarCommunity/sonar-crowd)\n* GitHub - [GitHub Authentication Plugin](https://redirect.sonarsource.com/plugins/authgithub.html)\n* Bitbucket - [Bitbucket Authentication Plugin](https://github.com/SonarQubeCommunity/sonar-auth-bitbucket)\n"},{path:"instance-administration/github-application",content:'---\ntitle: GitHub Enterprise Integration\nurl: /instance-administration/github-application/\n---\n_GitHub Enterprise Integration is available as part of [Developer Edition](https://redirect.sonarsource.com/editions/developer.html) and [above](https://www.sonarsource.com/plans-and-pricing/)._\n\n## Adding Pull Request Decoration to GitHub Checks\n\nYou can add Pull Request decoration to Checks in GitHub Enterprise by creating a GitHub Application, configuring your SonarQube instance, and installing the app in your organizations.\n\n### Creating a GitHub Application\n\nClick [here](https://developer.github.com/apps/building-github-apps/creating-a-github-app/) for general instructions on creating a GitHub App.\n\nFrom the "Register new GitHub App" page, follow these steps to create your GitHub App for PR decoration:\n\n1. Under **GitHub App name**, give your app a name (such as SonarQubePRChecks).\n2. GitHub requires a **Homepage URL** and a **Webhook URL**. These values aren\'t important for Pull Request decoration, so you can use any URL (such as https://www.sonarqube.org/).\n3. Set the following "Permissions" to **Read & write**:\n\t* Checks\n\t* _Developer Edition v7.2+ Only_: Pull requests (Note: This is only needed to clean up PR decoration in GitHub Conversation. PR decoration in Checks is replacing PR decoration in Conversation.)\n\t* Commit statuses\n4. Under "Where can this GitHub App be installed?," select **Any account**.\n5. Click **Create GitHub App**.\n\n### Generating and Setting Your Private Key\n\nAfter creating your app, you\'ll be prompted with a link to "generate a private key" at the top of the page. Click the link to download your .pem private key file. You can also download your .pem file by scrolling down to "Private Key" and clicking **Generate Private Key**.\n\nAfter downloading your .pem file, you\'ll need to set your private key at a global level in SonarQube by following these steps:\n\n1. Generate a base64 encoded string with your .pem private key file using `base64 -w0 /path/to/key.pem` on Linux or `base64 -i /path/to/key.pem` on MacOS.\n2. Copy and paste the base64-encoded content of your private key file into the text box at [**Administration > Pull Requests > GitHub > GitHub App private key**](/#sonarqube-admin#/sonarqube/admin/settings?category=pull_request/).\n\n### Configuring Your SonarQube Instance\n\nYou\'ll need to configure the following settings at a global level in SonarQube.\n\n#### Setting Your GitHub Enterprise Instance API URL\n\nEnter your GitHub Enterprise Instance API URL in the text box at [**Administration > Pull Requests > GitHub > GitHub API URL**](/#sonarqube-admin#/sonarqube/admin/settings?category=pull_request/).\nYour GitHub Enterprise instance API URL is formatted as follows: `https://<your-github-enterprise-address>/api/v3`\n\n#### Setting Your App Name and ID\n \n1. Enter your app name in the text box at [**Administration > Pull Requests > GitHub > GitHub App name**](/#sonarqube-admin#/sonarqube/admin/settings?category=pull_request/).\n2. Enter your app ID in the text box at [**Administration > Pull Requests > GitHub > GitHub App ID**](/#sonarqube-admin#/sonarqube/admin/settings?category=pull_request/). You can find your GitHub App ID on the app\'s settings page at `https://<your-github-enterprise>/settings/apps/<appname>`.\n\n### Installing Your App\n\nTo install your app in your organizations:\n\n1. Go to your GitHub App URL.\n\t* GitHub App URLs are specific to your GitHub Enterprise Address and your app name and are formatted as follows: `https://<your-github-enterprise-address>/github-apps/<YourAppName>`.\n\t* For example, if your GitHub Enterprise address is `github-enterprise-1.yoursite.com` and your app name is `SonarQubePRChecks`, your GitHub App URL will be `https://github-enterprise-1.yoursite.com/github-apps/SonarQubePRChecks`.\n2. From your GitHub App page, click the **Install** or **Configure** button.\n3. Choose the organization where you want to install your app from the list.\n4. Click the **Install** button.\n'},{path:"instance-administration/housekeeping",content:"---\ntitle: Housekeeping\nurl: /instance-administration/housekeeping/\n---\n\nWhen you run a new analysis of your project or its branches or pull requests(PRs), some data that was previously available is cleaned out of the database. For example the source code of the previous analysis, measures at directory and file levels, and so on are automatically removed at the end of a new analysis. Additionally, some old analysis snapshots, PR analyses, and branches are also removed.\n\nWhy? Well, it's useful to analyze a project frequently to see how its quality evolves. It is also useful to be able to see the trends over weeks, months, years. But when you look back in time, you don't really need the same level of detail as you do for the project's current state. To save space and to improve overall performance, the Database Cleaner deletes some rows in the database. Here is its default configuration:\n\n* For each project:\n  * only one snapshot per day is kept after 1 day. Snapshots marked by an event are not deleted.\n  * only one snapshot per week is kept after 1 month. Snapshots marked by an event are not deleted.\n  * only one snapshot per month is kept after 1 year. Snapshots marked by an event are not deleted.\n  * only snapshots with version events are kept after 2 years. Snapshots without events or with only other event types are deleted.\n  * **all snapshots** older than 5 years are deleted, including snapshots marked by an event. \n* All closed issues more than 30 days old are deleted\n* History at package/directory level is removed\n\nThese settings can be changed at [Administration > General > Database Cleaner](/#sonarqube-admin#/admin/settings).\n"},{path:"instance-administration/look-and-feel",content:'---\ntitle: Look and Feel\nurl: /instance-administration/look-and-feel/\n---\n\n## Home logo\nYou can set your own "home" logo in **[Administration > General > Look & Feel](/#sonarqube-admin#/admin/settings)**. Simply provide an image URL and width. Ideally, the width will scale the height to 30 pixels. This logo will be used in both the menu bar and on the About page.\n\n## Content of the "About" page\nYou also have the ability to add content to the About page, which anonymous users land on by default: **[Administration > General > Look & Feel](/#sonarqube-admin#/admin/settings)**.\n\n## Gravatar\nGravatar support is enabled by default, using gravatar.com. You can configure a different server or disable the feature altogether. When enabled, gravatars show up next to most uses of the user name.\n'},{path:"instance-administration/marketplace",content:"---\ntitle: Marketplace\nurl: /instance-administration/marketplace/\n---\n\n## Table of Contents\n\nAdministrators can access the Marketplace via **[Administration > Marketplace](/#sonarqube-admin#/admin/marketplace)**. The Marketplace is the place for keeping the pieces of the SonarQube platform up to date. It lets you:\n\nSee\n\n* The currently installed SonarQube Edition\n* Which plugins are installed\n* Whether plugin updates are available\n* Which other plugins are compatible with your version of SonarQube\n\nDiscover\n\n* Which other Editions are available, to enable more features\n\nInstall\n\n* New plugins\n* Plugin updates\n\nTo view/install plugin updates, your SonarQube server needs internet access. Installations require the platform to be restarted before they take effect.\n\n## Pending Operations\n\nWhen you perform an action in the Markplace (install, update or uninstall a plugin), a yellow banner appears at the top of the page showing pending operations that will be executed once SonarQube is restarted. Pending operations can be canceled until the server is restarted.\n\n## Restart SonarQube\nRestarting SonarQube can be done manually from the command line by running `sonar.sh restart` or directly from the UI:\n\n* in the Update Center when you have Pending Changes, the restart button will be displayed in the yellow banner (see Pending Operations)\n* in the System Info page at any time\n\n## Manual Updates\nIf your server has no access to the internet, you won't be able to rely on the Marketplace for plugins, and will have to handle plugin installations and upgrades manually.\n\nTo see what plugins are available and which version of a plugin is appropriate for your server, use the [plugin version matrix](https://redirect.sonarsource.com/doc/plugin-version-matrix.html), which is kept up to date with plugin availability and compatibility.\n\nTo install a plugin, simply download it using the manual download link on the plugin documentation page, place it in _$SONARQUBE_HOME/extensions/downloads_, and restart the server.\n\n## Which URLs does the Marketplace connect to?\nThe SonarQube Marketplace connects to https://update.sonarsource.org/ to get the list of plugins. Most of the referenced plugins are downloaded from:\n* https://binaries.sonarsource.com/\n* https://github.com/\n\n## Using the Marketplace behind a Proxy\nMarketplace uses HTTP(S) connections to external servers to provide these services. If SonarQube is located behind a proxy, additional information must be provided in the _$SONARQUBE-HOME/conf/sonar.properties_ configuration file:\n```\nhttp.proxyHost=<your.proxy.host>\nhttp.proxyPort=<yout.proxy.port>\n\n#If proxy authentication is required\nhttp.proxyUser=<your.proxy.user>\nhttp.proxyPassword=<your.proxy.password> \n```\nNote: the same properties can be used in the 'https.' form for HTTPS connections.\n"},{path:"instance-administration/monitoring",content:"---\ntitle: Monitoring\nurl: /instance-administration/monitoring/\n---\n\n## Table of Contents\n\nMonitoring your SonarQube instance is key to keeping it healthy and having happy users.\n\nAs a start, you can use this Web API to get an overview of the health of your SonarQube installation:\n\n* [api/system/health](/#sonarqube-admin#/api/system/health)\n\n## Java Process Memory\n\nThe SonarQube application server consists of three main Java processes:\n\n* Web (including embedded web server)\n* ElasticSearch\n* Compute Engine\n\nEach of these Java processes has its own memory settings that can be configured in the _$SONARQUBE-HOME/conf/sonar.properties_ file. The default memory settings that ship with SonarQube are fine for most instances. If you are supporting a large SonarQube instance (more than 100 users or more than 5,000,000 lines of code) or an instance that is part of your Continuous Integration pipeline, you should monitor the memory and CPU usage of all three key Java processes on your instance, along with overall disk space. Monitoring will allow you to see if any of the processes is running short of resources and take action ahead of resource shortages. There are a large number of monitoring tools available, both open source and commercial, to help you with this task. SonarSource does not recommend or endorse any particular tool.\n\n## Memory settings\n\nYou may need to increase your memory settings if you see the following symptoms:\n\n* Your monitoring tools show one or more of the SonarQube processes is reaching its memory limit\n* Any of the SonarQube processes crashes and/or generates an out-of-memory error in the sonar.log file\n* A SonarQube background task fails with an out-of-memory error in the background task log\n* The size of the Issues index of your ElasticSearch instance (visible in the System Info) is greater than or equal to the memory allocated to the ElasticSearch Java process\n\nYou can increase the maximum memory allocated to the appropriate process by increasing the  -Xmx memory setting for the corresponding Java process in your _$SONARQUBE-HOME/conf/sonar.properties_ file:\n\n* For Web: sonar.web.javaOpts\n* For ElasticSearch: sonar.search.javaOpts\n* For Compute Engine: sonar.ce.javaOpts\n\nThe -Xmx parameter accepts numbers in both megabytes (e.g. -Xmx2048m) and gigabytes (e.g. -Xmx2G)\n\nFor detailed information on JMX Beans exposed by SonarQube and more ElasticSearch monitoring options, please visit our Monitoring Details page.\n\n## Exposed JMX MBeans\n\nThe SonarQube Server offers visibility about what happens internally through the exposure of JMX MBeans.\n\nIn addition to the classical Java MBeans providing information about the ClassLoader, OS, Memory and Threads you have access to four more MBeans in the SonarQube Server:\n\n* ComputeEngine\n* Database\n* SonarQube\n\nAll these MBeans are read-only. It's not possible to modify or reset their values in real time.\n\n## ComputeEngineTasks MBean\n\n[[collapse]]\n| ## ComputeEngineTasks MBean\n| Attribute Name | Description\n| ---|---\n| ProcessingTime | Measure the time (in ms) spent to process Background Tasks since the last restart of SonarQube. Its value will always increase and will be reset by a restart of SonarQube.  This measure is very powerful when combined with SuccessCount and ErrorCount measures to get the average time to handle a Background Task, or when used to understand how much time the SonarQube Server is spending during a day to handle Background Tasks. It gives you an indication of the load on your server.\n| ErrorCount | Number of Background Tasks which failed since the last restart of SonarQube\n| PendingCount | Number of Background Tasks waiting to be processed since the last restart of SonarQube\n| InProgressCount | Number of Background Tasks currently under processing. Its value is either 1 or 0, since SonarQube can process only one task at a time.\n| SuccessCount | Number of Background Tasks successfully processed since the last restart of SonarQube\n| WorkerCount | Number of Background Tasks that can be processed at the same time\n|\n| Note:\n| * the total number of Background Tasks handled since the last restart of SonarQube is equal to SuccessCount + ErrorCount\n| * these values are reset to their default values by restarting SonarQube\n\n[[collapse]]\n| ## Database MBean\n| ### Same attributes are available for both ComputeEngineServer and WebServer.\n| Attribute Name | Description\n| ---|---\n| MigrationStatus | Possible values are: UP_TO_DATE, REQUIRES_UPGRADE, REQUIRES_DOWNGRADE, FRESH_INSTALL (only available for WebServer).\n| PoolActiveConnections\t| Number of active database connections\n| PoolIdleConnections | Number of database connections waiting to be used\n| PoolInitialSize | Initial size of the database connections pool.\n| PoolMaxActiveConnections | Maximum number of active database connections\n| PoolMaxIdleConnections | Maximum number of database connections waiting to be used\n| PoolMaxWaitMillis | In milliseconds\n| PoolRemoveAbandoned | Possible values : true, false\n| PoolRemoveAbandonedTimeoutSeconds | In Seconds\n\n[[collapse]]\n| ## SonarQube MBean\n| Attribute Name | Description\n| ---|---\n| LogLevel | Log Level: INFO, DEBUG, TRACE\n| ServerId | SonarQube Server ID\n| Version | SonarQube Version\n\n## How do I Activate JMX?\n\n### Local Access\n\nThere is nothing to activate to view SonarQube MBeans if your tool is running on the same server as the SonarQube Server.\n\n### Remote Access\n\nHere are examples of configuration to activate remote access to JMX MBeans.\n\nFor the WebServer:\n```\n# JMX WEB - 10443/10444\nsonar.web.javaAdditionalOpts=-Dcom.sun.management.jmxremote=true -Dcom.sun.management.jmxremote.ssl=false -Dcom.sun.management.jmxremote.authenticate=true -Dcom.sun.management.jmxremote.port=10443 -Dcom.sun.management.jmxremote.rmi.port=10444 -Dcom.sun.management.jmxremote.password.file=/opt/sonarsource/sonar/conf/jmxremote.password -Dcom.sun.management.jmxremote.access.file=/opt/sonarsource/sonar/conf/jmxremote.access\n```\n\nFor the ComputeEngine:\n\nThere is no specific javaAdditionalOpts entry, simply amend the sonar.ce.javaOpts one.\n\nExample of `jmxremote.access`:\n\n```\n#\n# JMX Access Control file\n#\nreader readonly\nadmin  readwrite \\\n    create javax.management.monitor.*,javax.management.timer.*,com.sun.management.*,com.oracle.jrockit.* \\\n    unregister\n```\n\nExample of `jmxremote.password`:\n\n```\n#\n# JMX Access Password file\n#\nreader readerpassword\nadmin  adminpassword\n```\n\nNote: on `jmxremote.password`, you should apply `chmod 600` or `400` for security reasons.\n\n"},{path:"instance-administration/notifications",content:"---\ntitle: Notifications\nurl: /instance-administration/notifications/\n---\nAt the end of each analysis, notifications are computed for each subscribed user. Then, asynchronously, these notifications are sent via email.\n\nTo set the frequency with which the notification queue is processed, set `the sonar.notifications.delay` property (in seconds) in _$SONARQUBE-HOME/conf/sonar.properties_. The server must be restarted for the new value to be taken into account.\n\n## Who gets notifications\nOnly users who subscribe themselves will get notifications. With only one exception, there is no admin functionality to proactively subscribe another user. If you believe a user should be receiving notifications, then it's time to practice the gentle art of persuasion.\n\n### The exception\nNotifications will automatically (without user opt-in) be sent to users with Quality Profile Administration rights when built-in quality profiles are updated. These updates can only happen via an upgrade of the relevant analyzer. This type of notification is on by default, and can be toggled globally in **[Administration > General Settings > General](/#sonarqube-admin#/admin/settings/)**.\n\n## Email Configuration\nTo configure the email server, go to **[Administration > General Settings > Email](/#sonarqube-admin#/admin/settings)**.\n\nCheck also the Server base URL property at Administration > General Settings > General to make sure that links in those notification emails will redirect to the right SonarQube server URL.\n"},{path:"instance-administration/project-move",content:'---\ntitle: Project Move\nurl: /instance-administration/project-move/\n---\n\n_Project Move is available as part of [Enterprise Edition](https://redirect.sonarsource.com/editions/enterprise.html) and [above](https://www.sonarsource.com/plans-and-pricing/)._\n\n## Table of Contents\n\nProject Move allows you to export a project from one SonarQube instance and import it into another, identically configured SonarQube instance. To use Project Move, you must have the Administer permission on the project in the source instance, and access to the file systems of both instances.\n\n## When to Use "Project Move"\nIn the following cases:\n\n* you want to create a central SonarQube instance at enterprise level and you want to keep the history created on N instances used previously at the team level\n* your company is acquiring another company that already has a central SonarQube instance\n* an application is transferred from one team to another in a large company and that company has several SonarQube instances\n\n## Prerequisites\nIn order to be able to export and then load your Project\'s data, the two SonarQube instances must have:\n\n* the exact same version\n* the same plugins with the same versions\n* the same custom metrics\n* the same custom rules\n\n## How To Export\nOn the source instance:\n* reanalyze the project one last time to make sure it is populated with data corresponding to your current SonarQube installation\n* navigate to the project and at the project level, choose **Administration > Import / Export**\n* click on the **Export** button to generate a zip file containing the settings and history of your Project (but not the source code). Note that if you need to change the Project\'s key, you must to do it before performing the export.\n\nA zip file containing all project data ex is generated in _$SONAR_SOURCE_HOME/data/governance/project_dumps/export/_ named _<project_key>.zip_\n\n## How To Import\nOn the target instance:\n\n* With a user having the "Administer System" and "Create Projects" permissions, go to [**Administration > Projects > Management**](/#sonarqube-admin#/admin/projects_management/) and [provision the project](/project-administration/project-existence/) using the same key the project had in the source instance.\n* Configure the Project\'s permissions, and the Quality Profiles and Quality Gate associated to the Project\n* Put the generated zip file into the directory *$SONAR\\_TARGET\\_HOME/data/governance/project_dumps/import*\n* Go to the Project\'s Home Page and choose **Administration > Import / Export**\n* Click on the Import button to start importing your data\n* Source code is not included in the zip file. Once the import is finished, trigger an analysis to import source files into the new instance.\n\nNotes:\n\n* If the import is successful, the zip file will automatically be deleted.\n* It is not possible to import a Project that has been already analyzed on the target instance.\n'},{path:"instance-administration/quality-profiles",content:"---\ntitle: Quality Profiles\nurl: /instance-administration/quality-profiles/\n---\n\n## Overview\n\nThe Quality Profiles service is central to {instance}, since it is where you define your requirements by defining sets of **rules** (ex: Methods should not have a Cognitive Complexity greater than 15).\n\nIdeally, all projects will be measured with the same profile for any given language, but that's not always practical. For instance, you may find that:\n\n* The technological implementation differs from one application to another (for example, different coding rules may apply when building threaded or non-threaded Java applications).\n* You want to ensure stronger requirements on some of your applications (internal frameworks for example).\n* Etc.\n\nWhich is why you can define as many quality profiles as you wish even though it is recommended to have as few Quality Profiles as possible to ensure consistency across the projects in your company. To manage quality profiles, go to \x3c!-- sonarqube --\x3e[**Quality Profiles**](/#sonarqube#/profiles)\x3c!-- /sonarqube --\x3e\x3c!-- sonarcloud --\x3e**Quality Profiles** page of your organization\x3c!-- /sonarcloud --\x3e, where you'll find profiles grouped by language.\n\nEach language plugin comes with a predefined, built-in profile (usually called \"Sonar way\") so that you can get started very quickly with {instance} analyses. This is why as soon as you install a new language plugin, at least one quality profile will be available for you. Each language must have a default profile (marked with the Default tag). Projects that are not explicitly associated with a specific profile will be analyzed using the language's default profile.\n\nWhen starting from a new installation, it's tempting to use Sonar way as your default profile because it contains all the rules that are generally applicable to most projects. But as a best practice, you should create a new profile (you can populate it by copying the contents of Sonar way) and use it instead. Why? First because Sonar way profiles aren't editable, so you won't be able to customize it to your needs. Also, that lets you treat Sonar way as a baseline against which you can track your own profile as you make changes to it (and you will). Plus, Sonar way is typically updated with each new version of the plugin to add rules and sometimes adjust rule severities. Any profile that inherits from the built-in Sonar Way will de-facto be automatically updated at the same time.\n\n## How do I...\n\n### Delegate the management of Quality Profiles to someone else?\n\nBy default, only users with the \"Administer Quality Profiles\" permission can edit Quality Profiles. But in large organizations, it may not be desirable to grant permissions to change all the Quality Profiles without distinction. That's why you can also grant users/groups the permission to edit an individual Quality Profile so that, for instance, the management of the Swift profile can be delegated to a group of Swift experts, and the same for COBOL, ...\n\nThis delegation of permission can only be performed by someone who already has the \"Administer Quality Profiles\" permission or individual edit rights on the profile to which additional permissions should be granted. The interface to grant individual permissions is available on the profile detail page.\n\n### Copy the rules from one profile to another?\n\nMany times people want to work from a profile that's based on a built-in profile without actually using the built-in profile. The easiest thing to do in this case is to go to the original profile, we'll call it _Source_, in **Quality Profiles**. From there, click through on the total number of rules in _Source_ to land on the **Rules** page at a pre-narrowed search of _Source_'s rules. Use **Bulk Activate** to turn Source's rules on in your target profile.\n\n### Know what's changed in a profile?\n\nWhen {instance} notices that an analysis was performed with a profile that is different in some way from the previous analysis, a Quality Profile event is added to the project's event log. To see the changes in a profile, navigate to the profile (**Quality Profiles > [ Profile Name ]**), and choose **Changelog**. This may help you understand how profile changes impact the issues raised in an analysis.\n\nAdditionally, users with Quality Profile administration privileges are notified by email each time a built-in profile (one that is provided directly by an analyzer) is updated. These updates can only be caused by analyzer updates.\n\n### Copy a profile from one SonarQube instance to another?\n\nUse the **Back up** feature on the source instance to export the profile to an XML file. Use the **Restore Profile** feature on the target instance to import the file. Note that some [limitations](https://jira.sonarsource.com/browse/SONAR-5366) on this feature exist.\n\n### Apply a core set of rules plus additional rules to a project?\n\nLet's say your company has a minimum set of coding rules that all teams must follow, but you want to add rules that are specific to the in use technology in your project. Those rules are good for your team, but irrelevant or even misleading for others. This situation calls for inheritance. Set up a base profile, we'll call it _Root_ with your core set of rules. Then create a child profile, we'll call it _Sprout_. Once it's created, you can **Change parent** to inherit from _Root_, then add your missing rules.\n\n### Make sure my non-default profile is used on a project?\n\nOne profile for each language is marked the default. Barring any other intervention, all projects that use that language will be analyzed with that profile. To have a project analyzed by a non-default profile instead, start from **Quality Profiles**, and click through on your target profile, then use the Projects part of the interface to manage which projects are explicitly assigned to the profile.\n\n### Make sure I've got all the relevant new rules in my profile?\n\nEach time a language plugin update is released, new rules are added, but they won't appear automatically in your profile unless you're using a built-in profile such as _Sonar way_.\n\nIf you're not using a built-in profile, you can compare your profile to the built-in profile to see what new on-by-default rules you're missing.\n\nAnother option is to go to the **Rules** space, and use the **Available Since** search facet to see what rules have been added to the platform since the day you upgraded the relevant plugin.\n\nAnd finally, the profile interface itself will help you be aware of rules added in a new plugin version in the **Latest New Rules** section on the right of the interface.\n\n### Compare two profiles?\n\nStarting from the **Quality Profiles** page, click through on one of the profiles you'd like to compare, then use the **Actions > Compare** interface to select the second profile and see the differences.\n\n### Make sure I don't have any deprecated rules in my profile?\n\nThe **Deprecated Rules** section of the rules interface itself is your first warning that a profile contains deprecated rules. This pink-background section gives the total number of instances of deprecated rules that are currently active in profiles, and a breakdown of deprecated count per profile. A click-through here takes you to the **Rules** page to edit the profile in question.\n\nAlternately, you can perform a **Rules** search for the rules in a profile (either manually or by clicking-through from **Quality Profiles** page) and use the **Status** rule search facet to narrow the list to the ones that need attention.\n\n## Security\n\nThe Quality Profiles service can be accessed by any user (even anonymous users). All users can view every aspect of a profile. That means anyone can see which rules are included in a profile, and which ones have been left out, see how a profile has changed over time, and compare the rules in any two profiles.\n\nTo make rule profile changes (create, edit or delete) users must be granted the **Administer Quality Profiles and Gates** permission.\n\nA **project administrator** can choose which profiles his project is associated with. See Project Settings for more.\n"},{path:"instance-administration/security",content:"---\ntitle: Security\nurl: /instance-administration/security/\n---\n\n## Table of Contents\n\n## Overview\n\nSonarQube comes with a number of global security features:\n\n* on-board authentication and authorization mechanisms\n* the ability to force users to authenticate before they can see any part of a SonarQube instance\n* the ability to delegate to authentication (for more see [Delegating Authentication](/instance-administration/delegated-auth/))\n\nAdditionally, you can configure at a group or user level who can:\n* see that a project even exists\n* access a project's source code \n* administer a project (set exclusion patterns, tune plugin configuration for that project, etc.)\n* administer Quality Profiles, Quality Gates, and the SonarQube instance itself.\n\n\nAnother aspect of security is the encryption of settings such as passwords. SonarQube provides a built-in mechanism to encrypt settings.\n\n## Authentication\nThe first question that should be answered when setting the security strategy for SonarQube is: Can anonymous users browse the SonarQube instance or is authentication be required? \n\nTo force user authentication, log in as a system administrator, go to **[Administration > Configuration > General Settings > Security](/#sonarqube-admin#/admin/settings?category=security)**, and set the **Force user authentication** property to true. \n\n[[info]]\n| SonarQube does not support sharing email addresses across multiple users.\n\n\n### Authentication Mechanisms\nAuthentication can be managed through a number of mechanisms:\n\n* Via the SonarQube built-in users/groups database\n* Via external identity providers such as an LDAP server (including LDAP Service of Active Directory), GitHub etc. See the Authentication & Authorization section of the Plugin Library.\n* Via HTTP headers\n\n### Technical Users\nWhen you create a user in SonarQube's own database, it is considered local and will only be authenticated against SonarQube's own user/group database rather than against any external tool (LDAP, Active Directory, Crowd, etc.). By default `admin` is a local account.\n\nSimilarly, all non-local accounts will be authenticated only against the external tool. \n\nAn Administrator can manage tokens on a user's behalf via **[Administration > Security > Users](/#sonarqube-admin#/admin/users)**. From here, click in the user's **Tokens** column to see the user's existing tokens, and either revoke existing tokens or generate new ones. Once established, a token is the only credential needed to run an analysis. Tokens should be passed as the value of the `sonar.login` property.\n\n### Default Admin Credentials\nWhen installing SonarQube, a default user with Administer System permission is created automatically:\n\n* Login: admin\n* Password: admin\n\n## Reinstating Admin Access\nIf you changed and then lost the `admin` password, you can reset it using the following query:\n```\nupdate users set crypted_password = '$2a$12$uCkkXmhW5ThVK8mpBvnXOOJRLd64LJeHTeCkSuB3lfaR2N0AYBaSi', salt=null, hash_method='BCRYPT' where login = 'admin'\n```\nIf you've deleted `admin` and subsequently locked out the other users with global administrative permissions, you'll need to re-grant `admin` to a user with the following query:\n```\nINSERT INTO user_roles(user_id, role) VALUES ((select id from users where login='mylogin'), 'admin');\n```\n\n## Authorization\nThe way authorization is implemented in SonarQube is pretty standard. It is possible to create as many users and groups of users as needed. The users can then be attached (or not) to (multiple) groups. Groups and / or users are then given (multiple) permissions. The permissions grant access to projects, services and functionalities.\n\nTo administer groups and users, choose **Administration > Security**, and use the sub-menu items.\n\n### User\nMultiple integrations that allow the delegation of authentication are available (see the [Plugin Library](https://redirect.sonarsource.com/doc/plugin-library.html) and [Other Plugins](https://docs.sonarqube.org/display/PLUG/Other+Plugins), but you can manually create and edit users at **[Settings > Security > Users](/#sonarqube-admin#/admin/users)**. For manually-created users, login and password can be set at creation. Manually-created users can edit their passwords.\n\nDuring both user creation and edit, you can set an account's screen name, email address. User login and email address will be implicitly recognized by the Issue Assignment feature as SCM accounts if applicable, but you can set additional SCM accounts explicitly. \n\n### Group\nA group is a set of users.\n\nTo administer groups, go to **[Administration > Security > Groups](/#sonarqube-admin#/admin/groups)**.\n\nTo edit the membership of a group, click the icon next to the membership total.\n\nTwo groups have a special meaning:\n\n* **Anyone** is a group that exists in the system, but that cannot be managed. Every user belongs to this group, including Anonymous user.\n* **sonar-users** is the default group to which users are automatically added.\n\n### Global Permissions\nTo set global permissions, log in as a System administrator and go to **[Administration > Security > Global Permissions](/#sonarqube-admin#/admin/permissions)**. \n\n* **Administer System**: All administration functions for the instance: global configuration.\n* **Administer Quality Profiles**: Any action on quality profiles.\n* **Administer Quality Gates**: Any action on quality gates\n* **Execute Analysis**: Execute analyses (project, view, report, developer), and to get all settings required to perform the analysis, even the secured ones like the scm account password, and so on.\n* **Create Projects**: Initialize the structure of a new project before its first analysis. This permission is also required when doing the very first analysis of a project that has not already been created via the GUI. * **\n* **Create Applications**: Create a new Application. * **\n* **Create Portfolios**: Create a new Portfolio. * **\n\n\\* Users with any explicit create permission will see a \"+\" item in the top menu giving access to these functions. If these permissions are removed from global administrators, they will loose quick access to them via the \"+\" menu, **but retain access to creation** via the **Administration** menu.\n\n** Creating an item does not automatically grant rights to administer it. For that, see _Creators permission_ below.\n\n### Project Permissions\nProject permissions are available from the project-level Administration menu: **Administration > Permissions**.\n\nProject visibility may be toggled between public or private. Making a project private hides its source code and measures from the `Anyone` group. For both public and private projects, four different permissions can be set:\n\n* **Administer Issues**: Change the type and severity of issues, resolve issues as being \"Won't Fix\" or \"False Positive\" (users also need \"Browse\" permission).\n* **Administer Security Hotspots**: \"Detect\" (convert) a Vulnerability from a \"Security Hotspot\", reject, clear, accept or reopen a \"Security Hotspot\" (users also need \"Browse\" permission).\n* **Administer**: Access project settings and perform administration tasks (users also need \"Browse\" permission).\n* **Execute Analysis**: Execute analyses (project, view, report, developer), and to get all settings required to perform the analysis, even the secured ones like the scm account password, the jira account password, and so on.\n\nPrivate projects have two additional permissions:\n* **Browse**: Access a project, browse its measures, issues and perform some issue edits (confirm/resolve/reopen, assignment, comment).\n* **See Source Code**: View the project's source code.\n\nNote that permissions _are not_ cumulative. For instance, if you want to be able to administer the project, you also have to be granted the Browse permission to be able to access the project (which is the default for Public project).\n\nYou can either manually grant permissions for each project to some users and groups or apply permission templates to projects. \n\n## Permission Templates for Default Permissions\nSonarQube ships with a default permissions template, which automatically grants specific permissions to certain groups when a project, portfolio, or application is created. It is possible to edit this template, and to create additional templates. A separate template can be set for each type of resource. Further, for projects you can have a template apply only to a subset of new projects using a project key regular expression (the template's **Project Key Pattern**). By default, every new project with a key that matches the supplied pattern will have template's permissions applied.\n\nTemplates are empty immediately after creation. Clicking on the template name will take you to its permission editing interface.\n\nTemplates are administered through **[Administration > Security > Permission Templates](/#sonarqube-admin#/admin/permission_templates)**.\n\n### Creators permissions\n**Creators** is a special group that appears only in the permission template editing interface. Any permissions assigned to this group will at the time of project/portfolio/application creation be granted to the single user account used to create the project. This allows SonarQube administrators to let users autonomously create and administer their own projects.\n\nWhile templates can be applied after project creation, applying a template that includes \"Creators\" permissions to an existing project/portfolio/application will not grant the relevant permissions to the project's original creator because that association is not stored.\n\n### Reset project permissions to a template\nTo apply permission templates to projects go to **[Administration > Projects > Management](/#sonarqube-admin#/admin/projects_management)**. You can  either apply a template to a specific project using the project-specific **Actions > Apply Permission Template** option or use the Bulk Apply Permission Template to apply a template to all selected projects.\n\nNote that there is no relation between a project and a permission template, meaning that:\n* the permissions of a project can be modified after a permission template has been applied to this project\n* none of the project permissions is changed when a permission template is modified\n\n## Settings Encryption\nEncryption is mostly used to remove clear passwords from settings (database or SCM credentials for instance). The implemented solution is based on a symetric key algorithm. The key point is that the secret key is stored in a secured file on disk. This file must owned by and readable only by the system account that runs the SonarQube server.\n\nThe algorithm is AES 128 bits. Note that 256 bits cipher is not used because it's not supported by default on all Java Virtual Machines ([see this article](https://confluence.terena.org/display/~visser/No+256+bit+ciphers+for+Java+apps)).\n\n1. **Generate the secret key**  \nA unique secret key must be shared between all parts of the SonarQube infrastructure (server and analyzers). To generate it, go to **[Administration > Configuration > Encryption](/#sonarqube-admin#/admin/settings/encryption)** and click on Generate Secret Key.\n1. **Store the secret key on the SonarQube server**  \n   * Copy the generated secred key to a file on the machine hosting the SonarQube server. The default location is _~/.sonar/sonar-secret.txt_. If you want to store it somewhere else, set its path through the `sonar.secretKeyPath` property in _$SONARQUBE-HOME/conf/sonar.properties_\n   * Restrict file permissions to the account running the SonarQube server (ownership and read-access only).\n   * Restart your SonarQube server\n1. **Generate the encrypted values of your settings**  \nGo back to **[Administration > Configuration > Encryption](/#sonarqube-admin#/admin/settings/encryption)** and use the form that has been added to the interface to generated encrypted versions of your values.\n![Encrypt values through the admin interface](/images/encrypt-value.png)\n1. **Use the encrypted values in your SonarQube server configuration**  \nSimply copy these encrypted values into _$SONARQUBE-HOME/conf/sonar.properties_\n```\nsonar.jdbc.password={aes}CCGCFg4Xpm6r+PiJb1Swfg==  # Encrypted DB password\n...\nsonar.secretKeyPath=C:/path/to/my/secure/location/my_secret_key.txt\n```\n\n"},{path:"instance-administration/system-info",content:"---\ntitle: Server Logs & System Info\nurl: /instance-administration/system-info/\n---\n\n## Table of Contents\n\nThe System Info page is found at **[Administration > System](/#sonarqube-admin#/admin/system)**. It gives you access to detailed information on the state of your SonarQube instance. \n\n## System Info\n\nYou can browse details about your running instance on this page. \n\n### Download\n\nAdditionally, if you have a Support contract, you might be asked by a Support representative to send in your System Info, which can be downloaded from the page **[Administration > System](/#sonarqube-admin#/admin/system)** using the **\"Download System Info\"** button at the top.\n\n### Server Id\nYour server id can be obtained from this page by expanding the **System** section. If you're running a commercial instance, you can also find this value on the License page (**[Administration > Configuration > License Manager](/#sonarqube-admin#/admin/extension/license/app)**)\n\n## Logs\nServer-side logging is controlled by properties set in _$SONARQUBE-HOME/conf/sonar.properties_.\n\n4 logs files are created: one per SonarQube process.\n\n### Log Level\nThe server-side log level can be customized via the `sonar.log.level` property. Supported values are:\n\n* **`INFO`** - the default\n* **`DEBUG`** - for advanced logs.\n* **`TRACE`** - show advanced logs and all SQL and Elasticsearch requests. `TRACE` level logging slows down the server environment, and should be used only for tracking web request performance problems.\n\n### Log Level by Process\nThe server-side log level can be adjusted more precisely for the 4 processes of SonarQube Server via the following property:\n\n* **`sonar.log.level.app`** - for the Main process of SonarQube (aka WrapperSimpleApp, the bootstrapper process starting the 3 others) \n* **`sonar.log.level.web`** - for the WebServer\n* **`sonar.log.level.ce`** - for the ComputeEngineServer\n* **`sonar.log.level.es`** - for the SearchServer\n\n### Log Rotation\nTo control log rolling, use the `sonar.log.rollingPolicy`\n\n* **`time:[value]`** - for time-based rotation. For example, use `time:yyyy-MM-dd` for daily rotation, and * `time:yyyy-MM` for monthly rotation.\n* **`size:[value]`** - for size-based rotation. For example, `size:10MB`.\n* **`none`** - for no rotation. Typically this would be used when logs are handled by an external system like logrotate.\n\n`sonar.log.maxFiles` is the maximum number of files to keep. This property is ignored if `sonar.log.rollingPolicy=none`.\n\n### UI Access to Logs and Log Levels\n\nThe System Info page gives you the ability to download your instance's current log files (log files rotate on a regular basis), and to tune the log level via controls at the top of the page. Changes made here are temporary, and last only until the next time the instance is restarted, at which point the level will be reset to the more permanent value set in _$SONARQUBE-HOME/conf/sonar.properties_. Regardless, if you change your log level _from_ `INFO`, but sure to change it back as soon as is practical; log files can get very large very quickly at lower log levels.\n\n## Total Lines of Code\n\n### SonarQube 6.7 LTS and newer\nThe number of Lines of Code (for licensing purposes) in an instance can be found in the **System** section of the System Info page on, and on the License page (**[Administration > Configuration > License Manager](/#sonarqube-admin#/admin/extension/license/app)** in commercial editions. \n\nIf you're on a commercial edition and using Branch or PR analysis, rest assured that only lines from the single largest branch in a project are considered for licensing purposes. The Lines of Code in the rest of the branches are ignored.\n\n### Versions older than 6.7\nThe best approach there is to query the database. The actual query varies based on the version of SonarQube and the database engine. Two queries are provided:\n\n* one query that counts LOCs across *all* projects\n& one query that filters out project branches (i.e. projects analysed with the `sonar.branch` parameter). However, this query is accurate only if projects with branches are also analysed once without sonar.branch.\n\n**SonarQube LTS v5.6.x**\n\n[[collapse]]\n| ## MySQL\n| Global LOCs\n| ```\n| select sum(pm.value) as global_loc from projects p\n| inner join snapshots s on s.project_id = p.id\n| inner join project_measures pm on pm.snapshot_id = s.id\n| inner join metrics m on m.id=pm.metric_id\n| where s.islast = true\n| and p.enabled = true\n| and p.qualifier = 'TRK'\n| and p.scope = 'PRJ'\n| and p.copy_resource_id is null\n| and pm.person_id is null\n| and m.name='ncloc';\n| ```\n| LOCs without `sonar.branch`\n|```\n| select sum(pm.value) as loc_without_branch from projects p\n| inner join snapshots s on s.project_id = p.id\n| inner join project_measures pm on pm.snapshot_id = s.id\n| inner join metrics m on m.id=pm.metric_id\n| where s.islast = true\n| and p.enabled = true\n| and p.qualifier = 'TRK'\n| and p.scope = 'PRJ'\n| and p.copy_resource_id is null\n| and pm.person_id is null\n| and m.name='ncloc'\n| and (\n| INSTR(p.kee, ':') = 0 or not exists(\n| select * from projects p_root where p_root.kee = SUBSTR(p.kee, 1, LENGTH(p.kee) - INSTR(REVERSE(p.kee), ':'))\n| ));\n|```\n\n[[collapse]]\n| ## PostgreSQL 8.0-9.0\n| Global LOCs\n| ```\n| select sum(pm.value) as global_loc from projects p\n| inner join snapshots s on s.project_id = p.id\n| inner join project_measures pm on pm.snapshot_id = s.id\n| inner join metrics m on m.id=pm.metric_id\n| where s.islast = true\n| and p.enabled = true\n| and p.qualifier = 'TRK'\n| and p.scope = 'PRJ'\n| and p.copy_resource_id is null\n| and pm.person_id is null\n| and m.name='ncloc';\n| ```\n| LOCs without `sonar.branch`\n| Not feasible on this specific database\n\n[[collapse]]\n| ## PostgreSQL 9.1+\n| Global LOCs\n| ```\n| select sum(pm.value) as global_loc from projects p\n| inner join snapshots s on s.project_id = p.id\n| inner join project_measures pm on pm.snapshot_id = s.id\n| inner join metrics m on m.id=pm.metric_id\n| where s.islast = true\n| and p.enabled = true\n| and p.qualifier = 'TRK'\n| and p.scope = 'PRJ'\n| and p.copy_resource_id is null\n| and pm.person_id is null\n| and m.name='ncloc';\n| ```\n| LOCs without `sonar.branch`\n| ```\n| select sum(pm.value) as loc_without_branch from projects p\n| inner join snapshots s on s.project_id = p.id\n| inner join project_measures pm on pm.snapshot_id = s.id\n| inner join metrics m on m.id=pm.metric_id\n| where s.islast = true\n| and p.enabled = true\n| and p.qualifier = 'TRK'\n| and p.scope = 'PRJ'\n| and p.copy_resource_id is null\n| and pm.person_id is null\n| and m.name='ncloc'\n| and (\n| POSITION(':' IN p.kee) = 0 or not exists(\n| select * from projects p_root where p_root.kee = SUBSTRING(p.kee, 0, LENGTH(p.kee) - POSITION(':' in REVERSE(p.kee)) + 1)\n| ));\n| ```\n\n[[collapse]]\n| ## Oracle\n| Global LOCs\n| ```\n| select sum(pm.value) as global_loc from projects p\n| inner join snapshots s on s.project_id = p.id\n| inner join project_measures pm on pm.snapshot_id = s.id\n| inner join metrics m on m.id=pm.metric_id\n| where s.islast = 1\n| and p.enabled = 1\n| and p.qualifier = 'TRK'\n| and p.scope = 'PRJ'\n| and p.copy_resource_id is null\n| and pm.person_id is null\n| and m.name='ncloc';\n| ```\n| LOCs without `sonar.branch`\n| ```\n| select sum(pm.value) as loc_without_branch from projects p\n| inner join snapshots s on s.project_id = p.id\n| inner join project_measures pm on pm.snapshot_id = s.id\n| inner join metrics m on m.id=pm.metric_id\n| where s.islast = 1\n| and p.enabled = 1\n| and p.qualifier = 'TRK'\n| and p.scope = 'PRJ'\n| and p.copy_resource_id is null\n| and pm.person_id is null\n| and m.name='ncloc'\n| and (\n| INSTR(p.kee, ':') = 0 or not exists(\n| select * from projects p_root where p_root.kee = SUBSTR(p.kee, 0, INSTR(p.kee, ':', -1) - 1)\n| ));\n| ```\n\n[[collapse]]\n| ## Microsoft SQL Server (a.k.a MSSQL)\n| Global LOCs\n| ```\n| select sum(pm.value) as global_loc from projects p\n| inner join snapshots s on s.project_id = p.id\n| inner join project_measures pm on pm.snapshot_id = s.id\n| inner join metrics m on m.id=pm.metric_id\n| where s.islast = 1\n| and p.enabled = 1\n| and p.qualifier = 'TRK'\n| and p.scope = 'PRJ'\n| and p.copy_resource_id is null\n| and pm.person_id is null\n| and m.name='ncloc';\n| ```\n| LOCs without `sonar.branch`\n| ```\n| select sum(pm.value) as loc_without_branch from projects p\n| inner join snapshots s on s.project_id = p.id\n| inner join project_measures pm on pm.snapshot_id = s.id\n| inner join metrics m on m.id=pm.metric_id\n| where s.islast = 1\n| and p.enabled = 1\n| and p.qualifier = 'TRK'\n| and p.scope = 'PRJ'\n| and p.copy_resource_id is null\n| and pm.person_id is null\n| and m.name='ncloc'\n| and (\n| CHARINDEX(':', p.kee) = 0 or not exists(\n| select * from projects p_root where p_root.kee = SUBSTRING(p.kee, 0, LEN(p.kee) - CHARINDEX(':', REVERSE(p.kee)) + 1 )\n| ));\n| ```\n\n**SonarQube 6.0-6.6**\n[[collapse]]\n| ## MySQL\n| Global LOCs\n| ```\n| select sum(pm.value) as global_loc from projects p\n| inner join snapshots s on s.component_uuid = p.uuid\n| inner join project_measures pm on pm.analysis_uuid = s.uuid\n| inner join metrics m on m.id=pm.metric_id\n| where s.islast = true\n| and p.enabled = true\n| and p.qualifier = 'TRK'\n| and p.scope = 'PRJ'\n| and p.copy_component_uuid is null\n| and pm.component_uuid = p.uuid\n| and pm.person_id is null\n| and m.name='ncloc';\n| ```\n| LOCs without `sonar.branch`\n| ```\n| select sum(pm.value) as loc_without_branch from projects p\n| inner join snapshots s on s.component_uuid = p.uuid\n| inner join project_measures pm on pm.analysis_uuid = s.uuid\n| inner join metrics m on m.id=pm.metric_id\n| where s.islast = true\n| and p.enabled = true\n| and p.qualifier = 'TRK'\n| and p.scope = 'PRJ'\n| and p.copy_component_uuid is null\n| and pm.component_uuid = p.uuid\n| and pm.person_id is null\n| and m.name='ncloc'\n| and (\n| INSTR(p.kee, ':') = 0 or not exists(\n| select * from projects p_root where p_root.kee = SUBSTR(p.kee, 1, LENGTH(p.kee) - INSTR(REVERSE(p.kee), ':'))\n| ));\n| ```\n\n[[collapse]]\n| ## PostgreSQL 8.0-9.0\n| Global LOCs\n| ```\n| select sum(pm.value) as global_loc from projects p\n| inner join snapshots s on s.component_uuid = p.uuid\n| inner join project_measures pm on pm.analysis_uuid = s.uuid\n| inner join metrics m on m.id=pm.metric_id\n| where s.islast = true\n| and p.enabled = true\n| and p.qualifier = 'TRK'\n| and p.scope = 'PRJ'\n| and p.copy_component_uuid is null\n| and pm.component_uuid = p.uuid\n| and pm.person_id is null\n| and m.name='ncloc';\n| ```\n| LOCs without `sonar.branch`\n| Not feasible on this specific database\n\n\n[[collapse]]\n| ## PostgreSQL 9.1+\n| Global LOCs\n| ```\n| select sum(pm.value) as global_loc from projects p\n| inner join snapshots s on s.component_uuid = p.uuid\n| inner join project_measures pm on pm.analysis_uuid = s.uuid\n| inner join metrics m on m.id=pm.metric_id\n| where s.islast = true\n| and p.enabled = true\n| and p.qualifier = 'TRK'\n| and p.scope = 'PRJ'\n| and p.copy_component_uuid is null\n| and pm.component_uuid = p.uuid\n| and pm.person_id is null\n| and m.name='ncloc';\n| ```\n| LOCs without `sonar.branch`\n| ```\n| select sum(pm.value) as loc_without_branch from projects p\n| inner join snapshots s on s.component_uuid = p.uuid\n| inner join project_measures pm on pm.analysis_uuid = s.uuid\n| inner join metrics m on m.id=pm.metric_id\n| where s.islast = true\n| and p.enabled = true\n| and p.qualifier = 'TRK'\n| and p.scope = 'PRJ'\n| and p.copy_component_uuid is null\n| and pm.component_uuid = p.uuid\n| and pm.person_id is null\n| and m.name='ncloc' and (\n| POSITION(':' IN p.kee) = 0 or not exists(\n| select * from projects p_root where p_root.kee = SUBSTRING(p.kee, 0, LENGTH(p.kee) - POSITION(':' in REVERSE(p.kee)) + 1)\n| ));\n| ```\n\n\n[[collapse]]\n| ## Oracle\n| Global LOCs\n| ```\n| select sum(pm.value) as global_loc from projects p\n| inner join snapshots s on s.component_uuid = p.uuid\n| inner join project_measures pm on pm.analysis_uuid = s.uuid\n| inner join metrics m on m.id=pm.metric_id\n| where s.islast = 1\n| and p.enabled = 1\n| and p.qualifier = 'TRK'\n| and p.scope = 'PRJ'\n| and p.copy_component_uuid is null\n| and pm.component_uuid = p.uuid\n| and pm.person_id is null\n| and m.name='ncloc';\n| ```\n| LOCs without `sonar.branch`\n| ```\n| select sum(pm.value) as loc_without_branch from projects p\n| inner join snapshots s on s.component_uuid = p.uuid\n| inner join project_measures pm on pm.analysis_uuid = s.uuid\n| inner join metrics m on m.id=pm.metric_id\n| where s.islast = 1\n| and p.enabled = 1\n| and p.qualifier = 'TRK'\n| and p.scope = 'PRJ'\n| and p.copy_component_uuid is null\n| and pm.component_uuid = p.uuid\n| and pm.person_id is null\n| and m.name='ncloc' \n| and (\n| INSTR(p.kee, ':') = 0 or not exists(\n| select * from projects p_root where p_root.kee = SUBSTR(p.kee, 0, INSTR(p.kee, ':', -1) - 1)\n| ));\n| ```\n\n\n[[collapse]]\n| ## Microsoft SQL Server (a.k.a. MSSQL)\n| Global LOCs\n| ```\n| select sum(pm.value) as global_loc from projects p\n| inner join snapshots s on s.component_uuid = p.uuid\n| inner join project_measures pm on pm.analysis_uuid = s.uuid\n| inner join metrics m on m.id=pm.metric_id\n| where s.islast = 1\n| and p.enabled = 1\n| and p.qualifier = 'TRK'\n| and p.scope = 'PRJ'\n| and p.copy_component_uuid is null\n| and pm.component_uuid = p.uuid\n| and pm.person_id is null\n| and m.name='ncloc';\n| ```\n| LOCs without `sonar.branch`\n| ```\n| select sum(pm.value) as loc_without_branch from projects p\n| inner join snapshots s on s.component_uuid = p.uuid\n| inner join project_measures pm on pm.analysis_uuid = s.uuid\n| inner join metrics m on m.id=pm.metric_id\n| where s.islast = 1\n| and p.enabled = 1\n| and p.qualifier = 'TRK'\n| and p.scope = 'PRJ'\n| and p.copy_component_uuid is null\n| and pm.component_uuid = p.uuid\n| and pm.person_id is null\n| and m.name='ncloc' \n| and (\n| CHARINDEX(':', p.kee) = 0 or not exists(\n| select * from projects p_root where p_root.kee = SUBSTRING(p.kee, 0, LEN(p.kee) - CHARINDEX(':', REVERSE(p.kee)) + 1 )\n| ));\n| ```\n\n\n"},{path:"previous-versions",content:"---\ntitle: Docs for Previous Versions\nurl: /previous-versions/\n---\n\n**Not using the latest and greatest version of SonarQube?**\n\nLinks to recently archived versions are available from the navigation of this site. For older versions, see below:\n\n* [Documentation for 7.3](https://docs.sonarqube.org/display/SONARQUBE73)\n* [Documentation for 7.2](https://docs.sonarqube.org/display/SONARQUBE72)\n* [Documentation for 7.1](https://docs.sonarqube.org/display/SONARqube71)\n* [Documentation for 7.0](https://docs.sonarqube.org/display/SONARQUBE70)\n* [Documentation for 6.7 LTS](https://docs.sonarqube.org/display/SONARQUBE67)\n"},{path:"project-administration/configuring-portfolios-and-applications",content:'---\ntitle: Managing Portfolios and Applications\nurl: /project-administration/configuring-portfolios-and-applications/\n---\n\n*Portfolios and Applications are available as part of the [Enterprise Edition](https://redirect.sonarsource.com/editions/enterprise.html) and [above](https://www.sonarsource.com/plans-and-pricing/).*\n\n## Table of Contents\n\n## Permissions\nUsers with the Create Portfolios or Create Applications permission have access to the creation interfaces from the "+" item in the top menu.  \n\nGlobal Administrators  have access to the overall Portfolio and Application administration interface at **[Administration > Configuration > Portfolios](/#sonarqube-admin#/admin/extension/governance/views_console)**. From this page, Portfolios and Applications can be created and edited. \n\nUsers of either type can edit an individual Portfolio or Application definition from the lower-level **Administration > Edit Definition** interface.\n\nGlobal Administrators also have access to the Projects Management page at **[Administration > Projects > Management](/#sonarqute-admin#/admin/projects_management)**. Changing the selection mechanism on this page to “Portfolios” or “Applications” lets you manage the Portfolios or Applications of your SonarQube instance. The dropdown menu to the right of each item lets you edit permissions, apply Permission Templates or restore access to a Portfolio or Application.\n\n## Populating Portfolios\nOnce your Portfolio exists, you can populate it with any mix of projects, Applications, and sub-portfolios. Applications may only be populated with projects.\n\n## Adding a Sub-portfolio\nTo add a sub-portfolio, click on “Add Portfolio” at the top of the third column, and choose:\n\n* **Standard** - This option allows you to create a new sub-Portfolio from scratch. Once created, you can add projects, applications, and more layers of sub-portfolios.\n* **Local Reference** - This option allows you to reference an existing Portfolio/Application as a sub-portfolio. Once added, it is not editable here, but must be chosen in the left-most column to be edited.\n\n## Adding Projects to a Portfolio\nTo add projects directly to a Portfolio or standard sub-Portfolio first make sure the correct item is selected, then choose the **Project selection mode**:\n\n* **Manual** – choose the projects individually.\n* **Tags** - select one or more project tags. Projects with those tags will automatically be included.\n* **Regular Expression** – specify a regular expression and projects with a matching name OR key will be included.\n* **All Remaining Projects** – choose this option to add all projects not already included in this Portfolio (directly or via sub-Portfolio).\n\n[[info]]\n|**Project unicity under a portfolio**<br/><br/>\n|Projects, applications and sub-portfolios can only appear once in any given hierarchy in order to avoid magnifying their impacts on aggregated ratings. The portfolio configuration interface has some logic to prevent obvious duplications (e.g. manually adding the same project), however in case of more subtle duplications (e.g. due to regex, or other bulk definition), then the calculation of that portfolio will fail with a helpful error message.\n\n## Populating Applications\nOnce your Application exists, you can populate it with manually-selected projects. By default, the configuration interface shows the list of projects currently selected for the application. To add additional projects, choose the "Unselected" or "All" filter.\n\n## Creating Application Branches\nOnce your Application is populated with projects, you can create application branches by choosing long-lived branches from the application\'s component projects. This option is available in the Application\'s **Administration > Edit Definition** interface, or from the global administration interface.\n\n## Calculation\nApplications and Portfolios are queued to be re-calculated after each analysis of an included project. For each relevant Portfolio and Application, a “Background Task” is created, and you can follow the progress on each in the **[Administration > Projects > Background Tasks](/#sonarqube-admin#/admin/background_tasks)** by looking at the logs available for each item.\n'},{path:"project-administration/managing-project-history",content:"---\ntitle: Managing Project History\nurl: /project-administration/managing-project-history/\n---\n\nOne of the most powerful features of {instance} is that it shows you not just your project health today, but how it has changed over time. It does that by selectively keeping data from previous analyses (see [Housekeeping](/instance-administration/housekeeping/)). It doesn't keep all previous analyses - that would bloat the database. Similarly, for the analyses it does keep, {instance} doesn't keep all the data. Once a project snapshot moves from the \"Last analysis\" (i.e. the most recent) to being part of the project's history, data below the project level is purged - again to keep from bloating the database.\n\nTypically these aren't things you need to even think about; {instance} just handles them for you. But occasionally you may need to remove a bad snapshot from a project's history or change the housekeeping algorithms.\n\n## Managing History\nOccasionally, you may need to manually delete a project snapshot, whether because the wrong quality profile was used, or because there was a problem with analysis, and so on. Note that the most recent snapshot (labeled \"Last snapshot\") can never be deleted.\n\n[[warning]]\n|**About deleting snapshots**<br/><br/>\n|Deleting a snapshot is a 2-step process:<br/><br/>\n|* The snapshot must first be removed from the project history by clicking on Delete snapshot. It won't be displayed anymore on this History page but will still be present in the database.\n|* The snapshot is actually deleted during the next project analysis.\n\nAt project level, from the front page **Activity** list, choose **Show More** to see the full activity list.\n\nFor every snapshot, it is possible to manually:\n\n* Add, rename or remove a version\n* Add, rename or remove an event\n* Delete the snapshot\n"},{path:"project-administration/narrowing-the-focus",content:'---\ntitle: Narrowing the Focus\nurl: /project-administration/narrowing-the-focus/\n---\n\n## Table of Contents\n\nIf {instance}\'s results aren\'t relevant, no one will want to use it. That\'s why precisely configuring what to analyze for each project is a very important step. Doing so allows you to remove noise, like the issues and duplications marked on generated code, or the issues from rules that aren\'t relevant for certain types of objects.\n\n{instance} gives you several options for configuring exactly what will be analyzed. You can\n\n* completely ignore some files or directories\n* exclude files/directories from Issues detection (specific rules or all of them) but analyze all other aspects\n* exclude files/directories from Duplications detection but analyze all other aspects\n* exclude files/directories from Coverage calculations but analyze all other aspects\n\nYou can make these changes globally or at a project level. At both levels, the navigation path is the same: **Administration > General Settings > Analysis Scope**.\n\n## Ignore Files\nWe recommend that you exclude generated code, source code from libraries, etc. There are four different ways to narrow your analysis to the source code that will be relevant to the development team. You can combine them all together to tune your analysis scope.\n\n### Source Directories\nSet the [sonar.sources](/analysis/analysis-parameters/) property to limit the scope of the analysis to certain directories.\n\n### File Suffixes\nMost language plugins offer a way to restrict the scope of analysis to files matching a set of extensions. Go to **Administration > General Settings > [Language]** to set the File suffixes property.\n\n### Choosing Files\nYour first line of defence having a well-defined set of files in your analysis is your `sonar.sources` value. For projects built and analysed with Maven, Gradle, or MSBuild, this value is defined automatically with a generally thorough, yet sane value. For other projects, you want to make sure `sonar.sources` is set to your project _sub-directory_ that actually contains your source files. Setting it to `.` will cast a wider net than most people intend. \n\n![Set sonar.sources to the project sub-directory that contains your source files](/images/sources.jpg)\n\nOnce you\'ve got all the files _in_ your analysis that you want, it\'s time to look at whether you have any files you\'d rather leave _out_ of your analysis, such as JavaScript libraries, and generated files. Those can be handled with Exclusions. Specifying an exclusion means that everything under your `sonar.sources` directory will be included in analysis _except_ the files with paths that match your exclusion regular expression.\n\n![Use exclusions to keep libraries and generated files out of analysis](/images/exclusions.jpg)\n\nTo use exclusions to analyze everything but the specified files, go to **Administration > General Settings > Analysis Scope > Files**.\n\n* **Source File Exclusions** (`sonar.exclusions`) - to exclude source code files\n* **Test File Exclusions** (`sonar.test.exclusions`) - to exclude test files\n\nThe vast majority of needs are met simply by setting `sonar.sources` carefully. Most other needs are met with the addition of a few simple exclusions. In a few corner cases, it is necessary to be explicit about what\'s _included_ in analysis and leave out everything else, but that is not the normal case, and setting inclusions should not be the first thing you try when configuring a new project.\n\n![Use inclusions in the rare case that you want to analyze only a subset of files](/images/inclusions.jpg)\n\nTo use exclusions to analyze _only_ the specified subset(s) of files in `sonar.sources`, go to **Administration > General Settings > Analysis Scope > Files**.\n\n* **Source File Inclusions** (`sonar.inclusions`)\n* **Test File Inclusions** (`sonar.test.inclusions`)\n\nYou can set these properties at both the project and global levels.\n\nSee the Patterns section below for more details on the syntax to use in these inputs.\n\n## Ignore Issues\nYou can have {instance} ignore issues on certain components and against certain coding rules. Go to **Administration > General Settings > Analysis Scope > Issues**.\n\nNote that the properties below can only be set through the web interface because they are multi-valued.\n\n### Ignore Issues on Files\nYou can ignore all issues on files that contain a block of code matching a given regular expression.\n\nExample:\n* *Ignore all issues in files containing "@javax.annotation.Generated"*  \n`@javax\\.annotation\\.Generated`\n\n### Ignore Issues in Blocks\nYou can ignore all issues on specific blocks of code, while continuing to scan and mark issues on the remainder of the file. Blocks to be ignored are delimited by start and end strings which can be specified by regular expressions (or plain strings).\n\nNotes:\n\n* If the first regular expression is found but not the second one, the end of the file is considered to be the end of the block.\n* Regular expressions are not matched on a multi-line basis.\n\n### Ignore Issues on Multiple Criteria\nYou can ignore issues on certain components and for certain coding rules. To list a specific rule, use the fully qualified rule ID.\n\n[[info]]\n| ![](/images/info.svg) You can find the fully qualified rule ID on the Rule definition.\n\nExamples:\n\n* *Ignore all issues on all files*  \nKEY = `*`  \nPATH = `**/*`\n* *Ignore all issues on COBOL program "bank/ZTR00021.cbl"*  \nKEY = `*`  \nPATH = `bank/ZTR00021.cbl`  \n* *Ignore all issues on classes located directly in the Java package "com.foo", but not in its sub-packages*  \nKEY = `*`  \nPATH = `com/foo/*`\n* *Ignore all issues against coding rule "cpp:Union" on files in the directory "object" and its sub-directories*  \nKEY = `cpp:Union`  \nPATH = `object/**/*`  \n\n### Restrict Scope of Coding Rules\n\nYou can restrict the application of a rule to only certain components, ignoring all others.\n\nExamples:\n\n* *Only check the rule "Magic Number" on "Bean" objects and not on anything else*  \nKEY = `checkstyle:com.puppycrawl.tools.checkstyle.checks.coding.MagicNumberCheck`  \nPATH = `**/*Bean.java`\n* *Only check the rule "Prevent GO TO statement from transferring control outside current module on COBOL programs" located in the directories "bank/creditcard" and "bank/bankcard". This requires two criteria to define it:*  \nKEY #1 = `cobol:COBOL.GotoTransferControlOutsideCurrentModuleCheck`  \nPATH #1 = `bank/creditcard/**/*`  \nKEY #2 = `cobol:COBOL.GotoTransferControlOutsideCurrentModuleCheck`  \nPATH #2 = `bank/bankcard/**/*`\n\n## Ignore Duplications\n\nYou can prevent some files from being checked for duplications.\n\nTo do so, go to **Administration > General Settings > Analysis Scope > Duplications** and set the *Duplication Exclusions* property. See the Patterns section for more details on the syntax.\n\n## Ignore Code Coverage\n\nYou can prevent some files from being taken into account for code coverage by unit tests.\n\nTo do so, go to **Administration > General Settings > Analysis Scope > Code Coverage** and set the *Coverage Exclusions* property. See the Patterns section for more details on the syntax.\n\n## Patterns\n\nPaths are relative to the project base directory.\n\nThe following wildcards can be used:\n\n* `*`\t- zero or more characters  \n* `**` - zero or more directories  \n* `?` - a single character  \n\nRelative paths are based on the fully qualified name of the component.\n\nExamples:\n\n`# Exclude all classes ending by "Bean"`  \n`# Matches org/sonar.api/MyBean.java, org/sonar/util/MyOtherBean.java, org/sonar/util/MyDTO.java, etc.`  \n`sonar.exclusions=**/*Bean.java,**/*DTO.java`\n\n`# Exclude all classes in the "src/main/java/org/sonar" directory`  \n`# Matches src/main/java/org/sonar/MyClass.java, src/main/java/org/sonar/MyOtherClass.java`  \n`# But does not match src/main/java/org/sonar/util/MyClassUtil.java`  \n`sonar.exclusions=src/main/java/org/sonar/*`  \n\n`# Exclude all COBOL programs in the "bank" directory and its sub-directories`  \n`# Matches bank/ZTR00021.cbl, bank/data/CBR00354.cbl, bank/data/REM012345.cob`  \n`sonar.exclusions=bank/**/*`  \n\n`# Exclude all COBOL programs in the "bank" directory and its sub-directories whose extension is .cbl`  \n`# Matches bank/ZTR00021.cbl, bank/data/CBR00354.cbl`  \n`sonar.exclusions=bank/**/*.cbl`\n'},{path:"project-administration/portfolio-pdf-configuration",content:'---\ntitle: Portfolio PDF Configuration\nurl: /project-administration/portfolio-pdf-configuration/\n---\n\n*Portfolio PDFs are available as part of the [Enterprise Edition](https://redirect.sonarsource.com/editions/enterprise.html) and [above](https://www.sonarsource.com/plans-and-pricing/).*\n\nA user with administrative rights on a portfolio can configure email distribution of the PDF. From a Portfolio Home Page go to **Administration > Executive Report**.\n\n###Frequency\nYou can tune the email frequency of the PDF Report. The possible values are:\n\n* Daily: report is sent during the first portfolio calculation of the day (if any)\n* Weekly: report is sent during the first portfolio calculation of the week (if any) from Monday\n* Monthly (default): report is sent during the first portfolio calculation of the month (if any), starting from the first day of the current month\n\n###Other Recipients\nIf people without SonarQube accounts want to receive the PDF, you can feed the administrative "Other Recipients" field with their email addresses.\n'},{path:"project-administration/project-existence",content:"---\ntitle: Project Existence\nurl: /project-administration/project-existence/\n---\n\nTypically, projects are created during their first analysis and never deleted (because old software never dies). For atypical situations, there is the page at **[Administration > Projects > Management](/#sonarqube-admin#/admin/projects_management/)**, which allows you to manage project existence.\n\n## How do I provision a project before its first analysis?\nProvisioning a project allows you to declare and configure it (define permissions, set quality profiles, etc.) before running the first analysis. To be able to provision projects, you have to be logged in and be granted the Provision Projects permission.\n\nTo provision a new project either use the '+' menu in the top menu or if you have global administration privileges, go to **[Administration > Projects > Management](/#sonarqube-admin#/admin/projects_management/)** and click on **Create Project**. The only required information is the key and the name of your project.\n\nOnce the project is provisioned, you can configure it (define permissions, set quality profiles, etc.), and when you're finished with the configuration, you can simply run the project's first analysis.\n\nYou can also provision and configure projects using the Web API.\n\n## How do I find provisioned projects (that haven't been analyzed yet)?\nThe **[Projects Management](/#sonarqube-admin#/admin/projects_management/)** search interface includes a toggle to allow you to narrow your results on this page to only projects that have never been analyzed. From there you can deal with them on this page as a set, or click through to the individual project homepages for individual attention and administration.\n\n## How do I lock down permissions on a project? (Private vs Public)\nBy default, any newly created project will be considered \"Public\". It means every SonarQube user, authenticated or not, will be able to:\n\n* **Browse**: Access a project, browse its measures, issues and perform some issue edits (confirm/resolve/reopen, assignment, comment).\n* **See Source Code**: View the project's source code.\n\nIf you want to be sure only a limited list of Groups and Users can see the project, you need to mark it Private. Once a project is private you will be able to define which Groups and Users can **Browse** the project or **See Source Code**.\n\nIf you want all newly created projects to be considered \"Private\", you can change the default visibility in **[Administration > Projects > Management](/#sonarqube-admin#/admin/projects_management/)**.\n\n## How do I delete projects?\nA project may be deleted individually from the Administration page of the project. See Project Settings for more details. To delete projects in bulk, use **[Administration > Projects > Management](/#sonarqube-admin#/admin/projects_management/)**. Here you can select the projects to delete. A deleted project is gone for good, there is no way to undo this action.\n\n## How do I find projects that are no longer analyzed?\nThe **[Projects Management](/#sonarqube-admin#/admin/projects_management/)** search interface includes a date picker to help you find all projects last analyzed before your specified date. From there you can deal with them on this page as a set, or click through to the individual project homepages for individual attention and administration.\n"},{path:"project-administration/project-settings",content:"---\ntitle: Project Settings\nurl: /project-administration/project-settings/\n---\n\n## Table of Contents\n\n## Tags\n\nProject tags allow you to categorize and group projects for easier selection on the **Projects** page. Project tags can be administered from the project home page. Administrators will see a dropdown menu indicator next to the project's list of current tags (or next to the \"No tags\" indicator). If the tag you want isn't visible in the dropdown, use the built in \"search\" input to find what you're looking for or create it on the fly.\n\n## Administration Items\n\nProject administration is accessible through the **Administration** menu of each project.  \n\nOnly project administrators can access project's settings (see [Authorization](/instance-administration/security/)).\n\n### Adding a Project\n\nA project is automatically added at its first analysis. Note that you can also [provision projects](/project-administration/project-existence/).\n\n### Analysis Report Processing\n\nA project-level Background Tasks page is available at **Administration > Background Tasks** to allow project administrators to check their projects' processing. It offers analysis report details and logs.\n\n### Deleting a Project\n\nYou can delete a project through **Administration > Deletion**:\n\nNote also that projects can also be deleted in bulk.\n\n### Setting the New Code Period  \n\nThe new code period can be set on a per-project basis through **Administration > General Settings > New Code > New Code Period**. The default value is `previous_version`, which is most appropriate value for projects that version/release regularly. For other projects, a time period such as 30 days (enter \"30\", the \"days\" part is understood) may be more appropriate.\n\nNote that this can be set at the global level as well.\n\n### Updating Project Key  \n\nThe project key can be updated (without losing the history on the project) at **Administration > Update Key**.\n\nThe new key must contain at least one non-digit character. Allowed characters are: 'a' through 'z', 'A' through 'Z', '-' (dash), '\\_' (underscore), '.' (dot), ':' (colon) and digits '0' to '9'.\n\n### Default Issue Assignee\n\nWhen new issues are created during an analysis, they are assigned to the last committer where the issue was raised. When it is not possible to identify the last committer, issues can be assigned to a default assignee, at **Administration > General Settings > Issues**.\n\n### Setting Quality Gate and Quality Profiles  \n\nProject administrators can select which ...\n\n* Quality profiles (go to **Administration > Quality Profiles**)\n* Quality gate (go to **Administration > Quality Gate**)\n\n... to use on their project.\n\n### Setting Exclusions  \n\nSee [Narrowing the Focus](/project-administration/narrowing-the-focus/).\n\n### Customizing Links\n\nOn top of standard links which may only be set as [Analysis Parameters](/analysis/analysis-parameters/), additional custom links can be added through the web interface (under **Administration > Links**). Those links will then be displayed in the [Project Page](/user-guide/project-page/).\n"},{path:"project-administration/webhooks",content:'---\ntitle: Webhooks\nurl: /project-administration/webhooks/\n---\n\nWebhooks notify external services when a project analysis is complete. An HTTP POST request including a JSON payload is sent to each URL. URLs may be specified at both the project and global levels. Project-level specification does not replace global-level webhooks. All hooks at both levels are called.\nPlugins\n\nThe HTTP(S) call:\n\n* is made regardless of the status of the Background Task\n* includes a JSON document as payload, using the POST method\n* has a content type of "application/json", with UTF-8 encoding\n\n## Configuration\n\nYou can configure up to 10 webhooks in in **Administration > Webhooks**.\n\nAn additional set of 10 webhooks can be configured at the global level in **Administration > Configuration > Webhooks**.\n\nIf configured, all 20 will be executed.\n\n## Delivery and Payload\n\n### Delivery\n\nThe Webhook administration console shows the result and timestamp of the most recent delivery of each webhook with the payload available via the list icon. Results and payloads of earlier deliveries are available from the tools menu to the right of each webhook\n\nResponse records are purged after 30 days.\n\nThe URL must respond within 10 seconds or the delivery is marked as failed.\n\n### Payload\n\nAn HTTP header "X-SonarQube-Project" with the project key is sent to allow quick identification of the project involved\n\nThe Payload is a JSON document which includes:\n\n* when the analysis was performed: see "analysedAt"\n* the identification of the project analyzed: see "project"\n* each Quality Gate criterion checked and its status: see "qualityGate"\n* the Quality Gate status of the project: see "qualityGate.status"\n* the status and the identifier of the Background Task : see "status" and "taskId"\n* user-specified properties: see "properties"\n\n#### Example\n\n```\n{\n    "analysedAt": "2016-11-18T10:46:28+0100",\n    "project": {\n        "key": "org.sonarqube:example",\n        "name": "Example"\n    },\n    "properties": {\n    },\n    "qualityGate": {\n        "conditions": [\n            {\n                "errorThreshold": "1",\n                "metric": "new_security_rating",\n                "onLeakPeriod": true,\n                "operator": "GREATER_THAN",\n                "status": "OK",\n                "value": "1"\n            },\n            {\n                "errorThreshold": "1",\n                "metric": "new_reliability_rating",\n                "onLeakPeriod": true,\n                "operator": "GREATER_THAN",\n                "status": "OK",\n                "value": "1"\n            },\n            {\n                "errorThreshold": "1",\n                "metric": "new_maintainability_rating",\n                "onLeakPeriod": true,\n                "operator": "GREATER_THAN",\n                "status": "OK",\n                "value": "1"\n            },\n            {\n                "errorThreshold": "80",\n                "metric": "new_coverage",\n                "onLeakPeriod": true,\n                "operator": "LESS_THAN",\n                "status": "NO_VALUE"\n            }\n        ],\n        "name": "SonarQube way",\n        "status": "OK"\n    },\n    "serverUrl": "http://localhost:9000",\n    "status": "SUCCESS",\n    "taskId": "AVh21JS2JepAEhwQ-b3u"\n}\n```\n\n## Additional parameters\n\nA basic authentication mechanism is supported by providing user/password in the URL of the Webhook such as `https://myLogin:myPassword@my_server/foo`.\n\nIf you provide additional properties to your SonarScanner using the pattern `sonar.analysis.*`, these properties will be automatically added to the section "properties" of the payload.\n\nFor example these additional parameters:\n\n```\nsonar-scanner -Dsonar.analysis.scmRevision=628f5175ada0d685fd7164baa7c6382c1f25cab4 -Dsonar.analysis.buildNumber=12345\n```\n\nWould add this to the payload:\n\n```\n"properties": {\n  "sonar.analysis.scmRevision": "628f5175ada0d685fd7164baa7c6382c1f25cab4",\n  "sonar.analysis.buildNumber": "12345"\n}\n```\n'},{path:"requirements/benchmark",content:"---\ntitle: Benchmark\nurl: /requirements/benchmark/\n---\n## Context\nThe following figures have been produced on common hardware available in most mid-size companies :\n\n| App ESXi Server Configuration                           | DB ESXi Server Configuration                            |\n| ------------------------------------------------------- | ------------------------------------------------------- |\n| 2* Intel(R) Xeon(R) CPU E5-2650 v2 @ 2.60GHz (32 VCPUs) | 2* Intel(R) Xeon(R) CPU E5-2650 v2 @ 2.60GHz (32 VCPUs) |\n| 128GB RAM                                               | 128GB RAM                                               |\n| 1.9 TB volume (RAID5 of 8 Hard Drives of 300GB SAS 15K) | 1.9TB volume (RAID5 of 8 hard drives of 300GB SAS 15k)  |\n| 2*1 GB NICs                                             | 2*1 GB NICs                                             |\n| ESXi 6.0                                                | ESXi 6.0                                                |\n\nWe created 2 VMs, one for SonarQube Server, one for SonarQube Database inside two ESXi 6.0 Servers :\n\n| App VM Server Configuration                                                                        | DB VM Server Configuration                               |\n| -------------------------------------------------------------------------------------------------- | -------------------------------------------------------- |\n| 8 VCPUs                                                                                            | 4 VCPUs                                                  |\n| 16GB RAM                                                                                           | 8GB RAM                                                  |\n| 20 GB storage for system + 200 GB storage for data (LVM) (RAID5 of 8 hard drives of 300GB SAS 15k) | 20 GB storage for system + 200 GB storage for data (LVM) |\n| 1GB NIC                                                                                            | 1GB NIC                                                  |\n| CentOS 7 64bits                                                                                    | CentOS 7 64bits                                          |\n|                                                                                                    | MySQL 5.6.27 (Oracle Community Edition)                  |\n\n## Goals\nFrom SonarQube 5.2+ Source Lines are no longer indexed by Elasticsearch, so quantity of code under analysis analyze will not affect the performance of the SearchServer.\n\nBy running this benchmark, we wanted to validate the number of Millions of Issues a given hardware hosting SonarQube can support.\n* can SonarQube digest millions of Issues and how many time does it take?\n* can we still use the UI of SonarQube with these millions of Issues?\n\n## Results\n### Indexation Throughput\nIssues Indexation done by the Search Server is not linear:\n\n| Millions of issues | Indexation time (hours) |\n| ------------------ | ----------------------- |\n| 25                 | 1                       |\n| 60                 | 2-3                     |\n| 100                | 6-7                     |\n\n### RAM to Allocate to Elasticsearch\nRAM to allocate to ElastSearch is linear according to the number of Issues:\n\n| Millions of issues | SearchServer RAM in GB |\n| ------------------ | ---------------------- |\n| 25                 | 4                      |\n| 60                 | 7                      |\n| 100                | 12                     |\n\n*Elasticsearch's RAM can be configured in _$SONARQUBE_HOME/conf/sonar.properties_ using: `sonar.search.javaOpts*`\n\n### CPU Allocation\nWith SonarQube 5.2+, Elasticsearch is configured to use 5 [ElasticSearch Primary Shards](https://www.elastic.co/guide/en/elasticsearch/reference/2.0/glossary.html#glossary-primary-shard). This allows SonarQube to handle by default 50 Millions of Issues on a server having at least 4 CPU Cores dedicated to the SearchServer.\n\n| Millions of issues | \\#Shards | \\# Cores |                       |\n| ------------------ | -------- | -------- | --------------------- |\n| 50                 | 5        | 4        | default configuration |\n| 30                 | 3        | 2        |                       |\n\nShard configuration must be adjusted according to the quantity of Issues you have to manage. The rule is to have 1 Shard by block of 10M Issues. So for 100M Issues, you need 10 Shards, so at least 9 Cores.\n"},{path:"requirements/hardware-recommendations",content:"---\ntitle: Hardware Recommendations\nurl: /requirements/hardware-recommendations/\n---\n## Database\nWe recommend that for large instances, the database used by SonarQube is hosted on a machine which is physically separate from SonarQube Server but close to it on the network.\n\n### Oracle\nIn case your SonarQube Server is running on Linux and you are using Oracle, the Oracle JDBC Driver may be blocked due to /dev/random. See [this Oracle article](http://www.usn-it.de/index.php/2009/02/20/oracle-11g-jdbc-driver-hangs-blocked-by-devrandom-entropy-pool-empty/) for more details about this problem.\n\n To avoid it, you may want to add this JVM parameter to your SonarQube Web Server (`sonar.web.javaOpts`) configuration :\n ```\n -Djava.security.egd=file:///dev/urandom\n ```\n\n ## Elasticsearch (aka ES)\n* [Elasticsearch](https://www.elastic.co/) is used by SonarQube in the background in the SearchServer process. To ensure good performance of your SonarQube, you need to follow these recommendations that are linked to ES usage.\n\n## JVM\n* It is recommended to set the min and max memory to the same value to prevent the heap from resizing at runtime, a very costly process. See -Xms and  -Xmx of property `sonar.search.javaOpts`.\n\n## Disk\n* Disk can easily become the bottleneck of ES. If you can afford SSDs, they are by far superior to any spinning media. SSD-backed nodes see boosts in both query and indexing performance. If you use spinning media, try to obtain the fastest disks possible (high performance server disks 15k RPM drives).\n* Make sure to increase the number of open files descriptors on the machine (or for the user running SonarQube server). Setting it to 32k or even 64k is recommended. See [this ElasticSearch article](https://www.elastic.co/guide/en/elasticsearch/reference/current/file-descriptors.html).\n* Using RAID 0 is an effective way to increase disk speed, for both spinning disks and SSD. There is no need to use mirroring or parity variants of RAID because of Elasticsearch replicas and database primary storage.\n8 Do not use remote-mounted storage, such as NFS, SMB/CIFS or network-attached storages (NAS). They are often slower, display larger latencies with a wider deviation in average latency, and are a single point of failure.\n\n**Advanced**\n* If you are using SSD, make sure your OS I/O Scheduler is configured correctly. When you write data to disk, the I/O Scheduler decides when that data is actually sent to the disk. The default under most *nix distributions is a scheduler called cfq (Completely Fair Queuing). This scheduler allocates \"time slices\" to each process, and then optimizes the delivery of these various queues to the disk. It is optimized for spinning media: the nature of rotating platters means it is more efficient to write data to disk based on physical layout. This is very inefficient for SSD, however, since there are no spinning platters involved. Instead, deadline or noop should be used instead. The deadline scheduler optimizes based on how long writes have been pending, while noop is just a simple FIFO queue. This simple change can have dramatic impacts.\n* If SQ home directory is located on a slow disk, then the property `sonar.path.data` can be used to move data to a faster disk (RAID 0 local SSD for instance).\n\n## Memory\n* Machine available memory for OS must be at least the Elasticsearch heap size. The reason is that Lucene (used by ES) is designed to leverage the underlying OS for caching in-memory data structures. That means that by default OS must have at least 1Gb of available memory.\n* Don't allocate more than 32Gb. See [this ElasticSearch article](http://www.elasticsearch.org/guide/en/elasticsearch/guide/current/heap-sizing.html) for more details.\n\n**Advanced**\n* Elasticsearch uses a hybrid mmapfs / niofs directory by default to store its indices. The default operating system limits on mmap counts is likely to be too low, which may result in out of memory exceptions. On Linux, you can increase the limits by running the following command as root :\n```\nsysctl -w vm.max_map_count=262144\n```\nTo set this value permanently, update the `vm.max_map_count` setting in `/etc/sysctl.conf`.\n\n## CPU\n* If you need to choose between faster CPUs or more cores, then choose more cores. The extra concurrency that multiple cores offers will far outweigh a slightly faster clock-speed.\n* By nature data are distributed on multiples nodes, so execution time depends on the slowest node. It's better to have multiple medium boxes than one fast + one slow.\n"},{path:"requirements/requirements",content:'---\ntitle: Prerequisites and Overview\nurl: /requirements/requirements/\n---\n## Table of Contents\n\n## Prerequisite\nThe only prerequisite for running SonarQube is to have Java (Oracle JRE 8 or OpenJDK 8) installed on your machine.\n\n![](/images/exclamation.svg) **Note:** _On Mac OS X it is highly recommended to install Oracle JDK 8 instead of the corresponding Oracle JRE since the JRE installation does not fully set up your Java environment properly. See [this post](http://stackoverflow.com/questions/15624667/mac-osx-java-terminal-version-incorrect) for more information._\n\n## Hardware Requirements\n1. A small-scale (individual or small team) instance of the SonarQube server requires at least 2GB of RAM to run efficiently and 1GB of free RAM for the OS. If you are installing an instance for a large teams or Enterprise, please consider the additional recommendations below.\n2. The amount of disk space you need will depend on how much code you analyze with SonarQube. As an example, [SonarCloud](https://sonarcloud.io) the public instance of SonarQube, has more than 350 million lines of code under analysis with 5 years of history. SonarCloud is currently running on clustered [Amazon EC2 m5.large](http://aws.amazon.com/ec2/instance-types/) instances with allocations of 50 Gb of drive space per node. It handles 19,000+ projects with roughly 14M open issues. SonarCloud runs on PostgreSQL 9.5 and it is using about 250Gb of disk space for the database.\n3. SonarQube must be installed on hard drives that have excellent read & write performance. Most importantly, the "data" folder houses the Elasticsearch indices on which a huge amount of I/O will be done when the server is up and running. Great read & write hard drive performance will therefore have a great impact on the overall SonarQube server performance.\n4. SonarQube does not support 32-bit systems on the server side. SonarQube does, however, support 32-bit systems on the scanner side.\n\n### Enterprise Hardware Recommendations\nFor large teams or Enterprise-scale installations of SonarQube, additional hardware is required. At the Enterprise level, monitoring your SonarQube instance/instance-administration/java-process-memory is essential and should guide further hardware upgrades as your instance grows. A starting configuration should include at least:\n\n* 8 cores, to allow the main SonarQube platform to run with multiple Compute Engine workers\n* 16GB of RAM\nFor additional requirements and recommendations relating to database and ElasticSearch, see Hardware Recommendations/requirements/hardware-recommendations.\n\n## Supported Platforms\n### Java\nThe SonarQube Java analyzer is able to analyze any kind of Java source files regardless of the version of Java they comply to. But SonarQube analysis and the SonarQube Server require specific versions of the JVM.\n\nWe recommend using the Critical Path Update (CPU) releases.\n\n| Java           |                          |\n| -------------- | ------------------------ |\n| Oracle JRE     | ![](/images/cross.svg) 9 |\n|                | ![](/images/check.svg) 8 |\n|                | ![](/images/cross.svg) 7 |\n| Open JDK       | ![](/images/cross.svg) 9 |\n|                | ![](/images/check.svg) 8 |\n|                | ![](/images/cross.svg) 7 |\n| IBM JRE        | ![](/images/cross.svg)   |\n| GCJ            | ![](/images/cross.svg)   |\n| Oracle JRockit | ![](/images/cross.svg)   |\n\n| Database                                                    |                                                                                                                                                                                                                                                                   |\n| ----------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |\n| [PostgreSQL](http://www.postgresql.org/)                    | ![](/images/check.svg) 9.3 - 9.6                                                                                                                                                                                                                                  |\n|                                                             | ![](/images/check.svg) 10                                                                                                                                                                                                                                         |\n|                                                             | ![](/images/exclamation.svg) Must be configured to use UTF-8 charset                                                                                                                                                                                              |\n| [Microsoft SQL Server](http://www.microsoft.com/sqlserver/) | ![](/images/cross.svg) 2012 (MSSQL Server 11.0)                                                                                                                                                                                                                   |\n|                                                             | ![](/images/check.svg) 2014 (MSSQL Server 12.0) with bundled Microsoft JDBC driver. Express Edition is supported.                                                                                                                                                 |\n|                                                             | ![](/images/check.svg) 2016 (MSSQL Server 13.0) with bundled Microsoft JDBC driver. Express Edition is supported.                                                                                                                                                 |\n|                                                             | ![](/images/check.svg) 2017 (MSSQL Server 14.0) with bundled Microsoft JDBC driver. Express Edition is supported.                                                                                                                                                 |\n|                                                             | ![](/images/exclamation.svg) Collation must be case-sensitive (CS) and accent-sensitive (AS) (example: Latin1_General_CS_AS)                                                                                                                                      |\n|                                                             | ![](/images/exclamation.svg) READ_COMMITTED_SNAPSHOT must be set on the SonarQube database to avoid potential deadlocks under heavy load                                                                                                                          |\n|                                                             | ![](/images/info.svg) Both Windows authentication (“Integrated Security”) and SQL Server authentication are supported. See the Microsoft SQL Server section in Installing/installation/installing-the-server page for instructions on configuring authentication. |\n| [Oracle] (http://www.oracle.com/database/)                  | ![](/images/cross.svg) 10G                                                                                                                                                                                                                                        |\n|                                                             | ![](/images/check.svg) 11G with backward-compatible [Oracle 12.2.x](http://www.oracle.com/technetwork/database/features/jdbc/jdbc-ucp-122-3110062.html) drivers                                                                                                   |\n|                                                             | ![](/images/check.svg) 12C with [Oracle 12.2.x](http://www.oracle.com/technetwork/database/features/jdbc/jdbc-ucp-122-3110062.html) drivers                                                                                                                       |\n|                                                             | ![](/images/check.svg) XE Editions are supported\n|                                                             | ![](/images/exclamation.svg) Must be configured to use a UTF8-family charset (see NLS_CHARACTERSET)                                                                                                                                                               |\n|                                                             | ![](/images/exclamation.svg) The driver ojdbc14.jar is not supported                                                                                                                                                                                              |\n|                                                             | ![](/images/exclamation.svg) Only the thin mode is supported, not OCI                                                                                                                                                                                             |\n| [MySQL](http://www.mysql.com/)                              | Not recommended for large instances                                                                                                                                                                                                                               |\n|                                                             | ![](/images/check.svg) 5.6                                                                                                                                                                                                                                       |\n|                                                             | ![](/images/check.svg) 5.7                                                                                                                                                                                                                                       |\n|                                                             | ![](/images/exclamation.svg) Must be configured to use UTF8 charset and a case-sensitive (CS) collation                                                                                                                                                           |\n|                                                             | ![](/images/exclamation.svg) Only InnoDB storage engine is supported, but not MyISAM                                                                                                                                                                              |\n|                                                             | ![](/images/exclamation.svg)Only the bundled mysql-connector-java jar is supported                                                                                                                                                                                |\n\n### Web Browser\nTo get the full experience SonarQube has to offer, you must enable JavaScript in your browser.\n\n|                             |                                         |\n| --------------------------- | --------------------------------------- |\n| Microsoft Internet Explorer | ![](/images/cross.svg) IE 9             |\n|                             | ![](/images/cross.svg) IE 10            |\n|                             | ![](/images/check.svg) IE 11            |\n| Microsoft Edge              | ![](/images/check.svg) Latest           |\n| Mozilla Firefox             | ![](/images/check.svg) Latest           |\n| Google Chrome               | ![](/images/check.svg) Latest           |\n| Opera                       | ![](/images/exclamation.svg) Not tested |\n| Safari                      | ![](/images/check.svg) Latest           |\n\n\x3c!-- sonarqube --\x3e\n## GitHub Enterprise Integration\nTo add Pull Request analysis to Checks in GitHub Enterprise, you must be running GitHub Enterprise version 2.14+.\n\x3c!-- /sonarqube --\x3e\n\n## Platform notes\n### Linux\nIf you\'re running on Linux, you must ensure that:\n\n* `vm.max_map_count` is greater or equals to 262144\n* `fs.file-max` is greater or equals to 65536\n* the user running SonarQube can open at least 65536 file descriptors\n* the user running SonarQube can open at least 2048 threads\n\nYou can see the values with the following commands:\n```\nsysctl vm.max_map_count\nsysctl fs.file-max\nulimit -n\nulimit -u\n```\n\nYou can set them dynamically for the current session by running  the following commands as `root`:\n```\nsysctl -w vm.max_map_count=262144\nsysctl -w fs.file-max=65536\nulimit -n 65536\nulimit -u 2048\n```\n\nTo set these values more permanently, you must update either _/etc/sysctl.d/99-sonarqube.conf_ (or _/etc/sysctl.conf_ as you wish) to reflect these values.\n\nIf the user running SonarQube (`sonarqube` in this example) does not have the permission to have at least 65536 open descriptors, you must insert this line in _/etc/security/limits.d/99-sonarqube.conf_ (or _/etc/security/limits.conf_ as you wish):\n```\nsonarqube   -   nofile   65536\nsonarqube   -   nproc    2048\n```\n\nYou can get more detail in the [Elasticsearch documentation](https://www.elastic.co/guide/en/elasticsearch/reference/5.6/system-config.html).\n\nIf you are using `systemd` to start SonarQube, you must specify those limits inside your unit file in the section \\[service\\] :\n```\n[Service]\n...\nLimitNOFILE=65536\nLimitNPROC=2048\n...\n```\n\n### seccomp filter\nBy default, Elasticsearch uses [seccomp filter](https://www.kernel.org/doc/Documentation/prctl/seccomp_filter.txt). On most distribution this feature is activated in the kernel, however on distributions like Red Hat Linux 6 this feature is deactivated. If you are using a distribution without this feature and you cannot upgrade to a newer version with seccomp activated, you have to explicitly deactivate this security layer by updating `sonar.search.javaAdditionalOpts` in _$SONARQUBE_HOME/conf/sonar.properties_:\n```\nsonar.search.javaAdditionalOpts=-Dbootstrap.system_call_filter=false\n```\n\nYou can check if seccomp is available on your kernel with:\n```\n$ grep SECCOMP /boot/config-$(uname -r)\n```\n\nIf your kernel has seccomp, you will see:\n```\nCONFIG_HAVE_ARCH_SECCOMP_FILTER=y\nCONFIG_SECCOMP_FILTER=y\nCONFIG_SECCOMP=y\n```\nFor more detail, see the [Elasticsearch documentation](https://www.elastic.co/guide/en/elasticsearch/reference/5.6/breaking-changes-5.6.html).\n'},{path:"setup/get-started-2-minutes",content:"---\ntitle: Get Started in Two Minutes Guide\nurl: /setup/get-started-2-minutes/\n---\n\n## Installing from a zip file\n\n1. [Download](https://www.sonarqube.org/downloads/) the SonarQube Community Edition\n\n2. Unzip it, let's say in _C:\\sonarqube_ or _/opt/sonarqube_\n\n3. Start the SonarQube Server:\n\n```\n# On Windows, execute:\nC:\\sonarqube\\bin\\windows-x86-xx\\StartSonar.bat\n\n# On other operating systems, as a non-root user execute:\n/opt/sonarqube/bin/[OS]/sonar.sh console\n```\n\n4. Log in to [http://localhost:9000](http://localhost:9000) with System Administrator credentials (admin/admin) and follow the embedded tutorial to analyze your first project.\n\n![](/images/exclamation.svg) This play instance is suitable for demonstration purposes, when you are ready to move to production, take some time to read the [Install the Server](/setup/install-server/) documentation.\n\n## Using Docker\n\nA Docker image of the Community Edition is available on [Docker Hub](https://hub.docker.com/_/sonarqube/), see usage and configuration examples there.\n\n![](/images/exclamation.svg) This instance is suitable for demonstration or testing purposes only.\n"},{path:"setup/install-cluster",content:"---\ntitle: Install the Server as a Cluster\nurl: /setup/install-cluster/\n---\n\n\x3c!-- sonarqube --\x3e\n\n_Running SonarQube as a Cluster is only possible with a [Data Center Edition](https://www.sonarsource.com/plans-and-pricing/data-center/)_.\n\nThe Data Center Edition allows SonarQube to run in a clustered configuration to make it resilient to failures.\n\n## Requirements\n\n### App Servers\n\nYou need five servers dedicated to SonarQube. Servers can be VMs, it's not necessary to have physical machines.\n\nServers must be co-located (geographical redundancy is not supported).\n\nYou can find the operating system requirements for servers in the [Requirements](/requirements/requirements/) page.\n\n\n### Database Server\n\nThe Data Center Edition supports PostgreSQL, Oracle, and Microsoft SQL Server. If your data is currently stored in MySQL you can use the [SonarQube DB Copy Tool](/instance-administration/db-copy/) to move it.\n\n### Load Balancer\nIn addition to the five SonarQube servers, you must configure a reverse proxy / load balancer to load balance traffic between the two application nodes. The precise configuration of the reverse proxy / load balancer will vary by vendor, but the SonarQube Data Center Edition requirements are very simple:\n\n- Share requests (load) between the two application nodes configured in the SonarQube cluster\n- If you are using HTTPS, ensure you are meeting the requirements set out in Securing SonarQube Behind a Proxy\n- **Note**: there is no requirement for the load balancer to preserve sessions; this is handled by the in-built JWT mechanism\n\n### License\nYou need a dedicated license to activate the DC Edition. If you don't have it yet, please contact the SonarSource Sales Team.\n\n### Support\nDon't start this journey alone; as a Data Center Edition customer SonarSource will assist with the setup and configuration of your cluster. Get in touch with [SonarSource Support](https://support.sonarsource.com/) for help.\n\n## Cluster Topology\nThere are two types of nodes:\n\n- an **application** node responsible for handling web requests from users (**WebServer** process) and handling analysis reports (**ComputeEngine** process)\n- a **search** node that is an Elasticsearch process that will store indices of data\n\nIn order to achieve high availability, the **only supported configuration** for the Data Center Edition comprises 5 servers:\n\n- 2 **application** nodes containing both WebServer and ComputeEngine\n- 3 **search** nodes that host Elasticsearch. For performance reasons, SSD are significantly better than HDD for these nodes\n\n_With this configuration, a node can be lost without impacting the service. More precisely, one application node and one search node can be lost without impacting users._\n\nHere is a schema for the supported topology:\n\n![DCE Cluster Machines Topology.](/images/cluster-dce.png)\n\n### Machines\n\nHere are the type of machines we used to perform our validation with a 200M Issues database. This could be used as a minimum recommendation to build your cluster.\n\n- Search Node made of [Amazon EC2 m4.2xlarge](https://aws.amazon.com/ec2/instance-types/): 8 vCPUs, 32GB RAM - 16GB allocated to Elasticsearch\n- App Node made of [Amazon EC2 m4.xlarge](https://aws.amazon.com/ec2/instance-types/): 4 vCPUs, 16GB RAM\n\n## Installation Details\n\n**Prepare your personalized SonarQube package:**\n\n1. Install the SonarQube Data Center Edition, following the usual [Installing the Server](/setup/install-server/) documentation\n2. Install all the other plugins you may want, confirm the connectivity with the DB is working well. If you do this step manually be sure to check compatibility with your SonarQube version using the [Plugin Version Matrix](https://docs.sonarqube.org/display/PLUG/Plugin+Version+Matrix)\n3. Zip the directory $SONARQUBE_HOME\n4. You now have your own personalized SonarQube Data Center Edition package\n\n**Deploy your SonarQube package on the 4 other nodes:**\n\nIt is expected that all **application** nodes are identical in term of hardware and software (same JVM build). Similarly, all **search** nodes should be identical to each other. But **application** and **search** nodes can differ. Generally, **search** nodes are configured with more CPU and RAM than **application** nodes.\n\n1. Unzip your personalized SonarQube package from the previous step on the 4 others nodes\n2. Congratulations, you now have 2 applications nodes and 3 search nodes completely identical in term of SonarQube softwares\n\n\n## Configuration\n\nNow you have 5 machines with the same SonarQube software it's time to start configuring them to specialize them. Some will become **application** nodes, some **search** nodes.\n\nThe idea is as follows: you need to edit the sonar.properties file on each node to configure the node's specialization. In the following example we will assume:\n\n- The VMs (server1, server2) having IP addresses ip1 and ip2 are going to be application nodes\n- The VMs having IP addresses ip3, ip4 and ip5 (server3, server4 and server5) are going to be search nodes\n\nThe default configuration to be applied for each node is the following:\n\n**server1**\n```\nsonar.cluster.enabled=true\nsonar.cluster.hosts=ip1,ip2,ip3,ip4,ip5\nsonar.cluster.search.hosts=ip3,ip4,ip5\nsonar.cluster.node.type=application\nsonar.auth.jwtBase64Hs256Secret=Vf4TRrfS6tvsFIHsQlgfhDUkiw3r8=\n```\n\n**server2**\n```\nsonar.cluster.enabled=true\nsonar.cluster.hosts=ip1,ip2,ip3,ip4,ip5\nsonar.cluster.search.hosts=ip3,ip4,ip5\nsonar.cluster.node.type=application\nsonar.auth.jwtBase64Hs256Secret=Vf4TRrfS6tvsFIHsQlgfhDUkiw3r8=\n```\n\n**server3**\n```\nsonar.cluster.enabled=true\nsonar.cluster.hosts=ip1,ip2,ip3,ip4,ip5\nsonar.cluster.search.hosts=ip3,ip4,ip5\nsonar.cluster.node.type=search\nsonar.search.host=ip3\n```\n\n**server4**\n```\nsonar.cluster.enabled=true\nsonar.cluster.hosts=ip1,ip2,ip3,ip4,ip5\nsonar.cluster.search.hosts=ip3,ip4,ip5\nsonar.cluster.node.type=search\nsonar.search.host=ip4\n```\n\n**server5**\n```\nsonar.cluster.enabled=true\nsonar.cluster.hosts=ip1,ip2,ip3,ip4,ip5\nsonar.cluster.search.hosts=ip3,ip4,ip5\nsonar.cluster.node.type=search\nsonar.search.host=ip5\n```\n\nThe full set of cluster parameters is listed [here](/setup/operate-cluster/).\n\nOnce this configuration is done, take a break and a coffee, then you can [Operate your Cluster](/setup/operate-cluster/).\n\n\x3c!-- /sonarqube --\x3e\n"},{path:"setup/install-plugin",content:'---\ntitle: Install a Plugin\nurl: /setup/install-plugin/\n---\n\n\x3c!-- sonarqube --\x3e\nThere are two options to install a plugin into SonarQube:\n\n- Marketplace - Installs plugins automatically, from the SonarQube UI. \n- Manual Installation - You\'ll use this method if your SonarQube instance doesn\'t have access to the Internet.\n\n## Marketplace\n\nIf you have access to the Internet and you are connected with a SonarQube user having the Global Permission "Administer System", you can go to Administration > Marketplace.\n\n- Find the plugin you want to install\n- Click on Install and wait for the download to be processed\n\nOnce download is complete, a "Restart" button will be available to restart your instance.\n\nSee [Marketplace](/instance-administration/marketplace/) for more details on how to configure your SonarQube Server to connect to the Internet.\n\n## Manual Installation\n\nIn the page dedicated to the plugin you want to install (ex: for Python: SonarPython), click on the "Download" link of the version compatible with your SonarQube version.  \n\nPut the downloaded jar in `$SONARQUBE_HOME/extensions/plugins`, removing any previous versions of the same plugins.\n\nOnce done, you will need to restart your SonarQube Server.\n\n### License\n\nIf you installed a Commercial Edition, you will need to set the License Key in Administration > Configuration > License Manager before being able to use it.\n\n\x3c!-- /sonarqube --\x3e\n'},{path:"setup/install-server",content:"---\ntitle: Install the Server\nurl: /setup/install-server/\n---\n\n\n## Installing the Database\n\nSeveral [database engines](/requirements/requirements/) are supported. Be sure to follow the requirements listed for your database, they are real requirements not recommendations.\n\nCreate an empty schema and a `sonarqube` user. Grant this `sonarqube` user permissions to `create`, `update`, and `delete` objects for this schema.\n\n### Microsoft SQL Server\n\n![](/images/exclamation.svg) Collation **MUST** be case-sensitive (CS) and accent-sensitive (AS).\n\n![](/images/exclamation.svg) `READ_COMMITED_SNAPSHOT` **MUST** be set on the SonarQube database.\n\nMS SQL database's shared lock strategy may impact SonarQube runtime. Making sure that `is_read_committed_snapshot_on` is set to `true` to prevent SonarQube from facing potential deadlocks under heavy loads. \n\nExample of query to check `is_read_committed_snapshot_on`:\n```\nSELECT is_read_committed_snapshot_on FROM sys.databases WHERE name='YourSonarQubeDatabase';\n```\nExample of query to update `is_read_committed_snapshot_on`:\n```\nALTER DATABASE YourSonarQubeDatabase SET READ_COMMITTED_SNAPSHOT ON WITH ROLLBACK IMMEDIATE;\n```\n\nIf you want to use integrated security, you have to download the Microsoft SQL JDBC Driver 6.2 package from [https://www.microsoft.com/en-us/download/details.aspx?id=55539](https://www.microsoft.com/en-us/download/details.aspx?id=55539) and copy `sqljdbc_auth.dll` to any folder in your path. You should use the 64-bit version of the dll to match the architecture of your server machine. If you are running the SonarQube as a windows service and want to use Integrated security, please make sure the Windows account under which the service is running has permission to connect your SQL Server. The account should have `db_owner` database role membership. Otherwise, if you are running the SonarQube server from a command prompt and want to use Integrated security, the user under which the command prompt is running should have `db_owner` database role membership. Also ensure that `sonar.jdbc.username` or `sonar.jdbc.password properties` are commented out, otherwise SonarQube will use SQL Authentication.\n\n```\nsonar.jdbc.url=jdbc:sqlserver://localhost;databaseName=sonar;integratedSecurity=true\n```\n\nIf you want to use SQL Authentication, use the following connection string. Also ensure that `sonar.jdbc.username` and `sonar.jdbc.password` are set appropriately.\n\n```\nsonar.jdbc.url=jdbc:sqlserver://localhost;databaseName=sonar\nsonar.jdbc.username=sonarqube\nsonar.jdbc.password=mypassword\n```\n\n### Oracle\n\nIf there are two SonarQube schemas on the same Oracle instance, especially if they are for two different versions, SonarQube gets confused and picks the first it finds. To avoid this issue:\n\n- Either privileges associated to the SonarQube Oracle user should be decreased\n- Or a trigger should be defined on the Oracle side to automatically alter the SonarQube Oracle user session when establishing a new connection:\n\n[[warning]]\n| Oracle JDBC driver versions 12.1.0.1 and 12.1.0.2 have major bugs, and are not recommended for use with the SonarQube ([see more details](https://groups.google.com/forum/#!msg/sonarqube/Ahqt1iarqJg/u0BVRJZnBQAJ)).\n\n### PostgreSQL\n\nIf you want to use a custom schema and not the default \"public\" one, the PostgreSQL `search_path` property must be set:\n\n```\nALTER USER mySonarUser SET search_path to mySonarQubeSchema\n```\n\n### MySQL (not recommended)\n\n[[warning]]\n| MySQL is not supported for [Data Center Edition](https://www.sonarsource.com/plans-and-pricing/data-center/).\n\nThere are two well-known engines that can be used in MySQL: MyISAM and InnoDB. MyISAM is the oldest of the two engines and is being progressively replaced by InnoDB. InnoDB is clearly faster and scales better with SonarQube as the number of projects under quality control increases. If you were an early adopter of SonarQube, you probably have a series of tables that are still using MyISAM. To improve performance, you should change the engine for all tables to InnoDB.\n\nOnce all SonarQube tables are using the InnoDB engine, the first thing to do is allocate a maximum amount of RAM to your MySQL instance with the `innodb_buffer_pool_size` parameter and give at least 15Mb to the `query_cache_size` parameter. Read this article about [InnoDB Performance Optimization Basics](https://www.percona.com/blog/2007/11/01/innodb-performance-optimization-basics/) for more information.\n\n## Installing the Web Server\n\nFirst, check the [requirements](/requirements/requirements/). Then download and unzip the [distribution](http://www.sonarqube.org/downloads/) (do not unzip into a directory starting with a digit). \n\nSonarQube cannot be run as `root` on Unix-based systems, so create a dedicated user account to use for SonarQube if necessary.\n\n_$SONARQUBE-HOME_ (below) refers to the path to the directory where the SonarQube distribution has been unzipped.\n\n### Setting the Access to the Database\n\nEdit _$SONARQUBE-HOME/conf/sonar.properties_ to configure the database settings. Templates are available for every supported database. Just uncomment and configure the template you need and comment out the lines dedicated to H2:\n\n```\nExample for PostgreSQL\nsonar.jdbc.username=sonarqube\nsonar.jdbc.password=mypassword\nsonar.jdbc.url=jdbc:postgresql://localhost/sonarqube\n```\n\n### Adding the JDBC Driver\n\nDrivers for the supported databases (except Oracle) are already provided. Do not replace the provided drivers; they are the only ones supported.\n\nFor Oracle, copy the JDBC driver into _$SONARQUBE-HOME/extensions/jdbc-driver/oracle_.\n\n### Configuring the Elasticsearch storage path\n\nBy default, Elasticsearch data is stored in _$SONARQUBE-HOME/data_, but this is not recommended for production instances. Instead, you should store this data elsewhere, ideally in a dedicated volume with fast I/O. Beyond maintaining acceptable performance, doing so will also ease the upgrade of SonarQube.\n\nEdit _$SONARQUBE-HOME/conf/sonar.properties_ to configure the following settings:\n\n```\nsonar.path.data=/var/sonarqube/data\nsonar.path.temp=/var/sonarqube/temp\n```\n\nThe user used to launch SonarQube must have read and write access to those directories.\n\n### Starting the Web Server\n\nThe default port is \"9000\" and the context path is \"/\". These values can be changed in _$SONARQUBE-HOME/conf/sonar.properties_:\n\n```\nsonar.web.host=192.0.0.1\nsonar.web.port=80\nsonar.web.context=/sonarqube\n```\n\nExecute the following script to start the server:\n\n- On Linux/Mac OS: bin/<YOUR OS>/sonar.sh start\n- On Windows: bin/windows-x86-XX/StartSonar.bat\n\nYou can now browse SonarQube at _http://localhost:9000_ (the default System administrator credentials are `admin`/`admin`).\n\n### Tuning the Web Server\n\nBy default, SonarQube is configured to run on any computer with a simple Java JRE.\n\nFor better performance, the first thing to do when installing a production instance is to use a Java JDK and activate the server mode by uncommenting/setting the following line in _$SONARQUBE-HOME/conf/sonar.properties_:\n\n```\nsonar.web.javaOpts=-server\n```\n\nTo change the Java JVM used by SonarQube, simply edit _$SONARQUBE-HOME/conf/wrapper.conf_ and update the following line:\n\n```\nwrapper.java.command=/path/to/my/jdk/bin/java\n```\n\n### Advanced Installation Features\n\n- Running SonarQube as a Service on [Windows](/setup/operate-server/) or [Linux](/setup/operate-server/)\n- Running SonarQube [behind a Proxy](/setup/operate-server/)\n- Running SonarQube Community Edition with [Docker](https://hub.docker.com/_/sonarqube/)\n\n## Next Steps\n\nOnce your server is installed and running, you may also want to [Install Plugins](/setup/install-plugin/). Then you're ready to begin [Analyzing Source Code](/analysis/overview/).\n\n## Troubleshooting/FAQ\n\n### Grant more memory to the web server / compute engine / elastic search\n\nTo grant more memory to a server-side process, uncomment and edit the relevant javaOpts property in `$SONARQUBE_HOME/conf/sonar.properties`, specifically:\n\n- `sonar.web.javaOpts` (minimum values: `-server -Xmx768m`)\n- `sonar.ce.javaOpts`\n- `sonar.search.javaOpts`\n\n### Cannot connect to MySQL database\n\nBy default, remote access to MySQL database server is disabled for security reasons. If you want to remotely access the database server, you need to follow this [quick guide](https://www.cyberciti.biz/tips/how-do-i-enable-remote-access-to-mysql-database-server.html).\n\n### Failed to start on Windows Vista\n\nSonarQube seems unable to start when installed under the `Program Files` directory on Windows Vista. It should therefore not be installed there.\n\n### Failed to start SonarQube with Oracle due to bad `USERS` table structure\n\nWhen other `USERS` tables exist in the Oracle DB, if the `sonarqube` user has read access on this other `USERS` table, the SonarQube web server can't start and an exception like the following one is thrown:\n\n```\nActiveRecord::ActiveRecordError: ORA-00904: \"TOTO\": invalid identifier\n: INSERT INTO users (login, name, email, crypted_password, salt, \ncreated_at, updated_at, remember_token, remember_token_expires_at, toto, id)\nVALUES('admin', 'Administrator', '', 'bba4c8a0f808f9798cf8b1c153a4bb4f9178cf59', '2519754f77ea67e5d7211cd1414698f465aacebb',\nTIMESTAMP'2011-06-24 22:09:14', TIMESTAMP'2011-06-24 22:09:14', null, null, null, ?)\nActiveRecord::ActiveRecordError: ORA-00904: \"TOTO\": invalid identifier\n \n: INSERT INTO users (login, name, email, crypted_password, salt, \ncreated_at, updated_at, remember_token, remember_token_expires_at, toto, id)\nVALUES('admin', 'Administrator', '', 'bba4c8a0f808f9798cf8b1c153a4bb4f9178cf59', \n'2519754f77ea67e5d7211cd1414698f465aacebb', TIMESTAMP'2011-06-24 22:09:14', TIMESTAMP'2011-06-24 22:09:14', null, null, null, ?)\n```\n\nTo fix this issue, the rights of the `sonarqube` Oracle user must be decreased to remove read access on the other `USERS` table(s).\n\n### Failed to connect to the Marketplace via proxy\n\nDouble check that settings for proxy are correctly set in `$SONARQUBE_HOME/conf/sonar.properties`.\nNote that if your proxy username contains \"\\\" (backslash), then it should be escaped - for example username \"domain\\user\" in file should look like:\n\n```\nhttp.proxyUser=domain\\\\user\n```\n\nFor some proxies, the exception \"java.net.ProtocolException: Server redirected too many times\" might mean an incorrect username or password has been configured.\n\n### Exception java.lang.RuntimeException: can not run elasticsearch as root\n\nSonarQube starts an Elasticsearch process, and the same account that is running SonarQube itself will be used for the Elasticsearch process. Since Elasticsearch cannot be run as `root`, that means SonarQube can't be either. You must choose some other, non-`root` account with which to run SonarQube, preferably an account dedicated to the purpose.\n"},{path:"setup/operate-cluster",content:"---\ntitle: Configure & Operate a Cluster\nurl: /setup/operate-cluster/\n---\n\n_High Availability is a feature of the [Data Center Edition](https://redirect.sonarsource.com/editions/datacenter.html)._\n\n\n\n## Table of Contents\n\nOnce the the [SonarQube cluster is installed](/setup/install-cluster/), you have a High Availability configuration that will allow your SonarQube instance to stay up and running even if there is a crash or failure in one of the nodes of the cluster.\n\n## Start/Stop/Upgrade the Cluster\n### Start the Cluster\n1. Start the search nodes\n1. Start the application nodes\n\n### Stop the Cluster\n1. Stop the application nodes\n1. Stop the search nodes\n\n### Upgrade SonarQube\n1. Stop the cluster\n1. Upgrade SonarQube on all nodes (app part, plugins, JDBC driver if required) following the usual Upgrade procedure but without triggering the /setup phase\n1. Once all nodes have the same binaries: start the cluster \n1. At this point only one of the application nodes is up. Try to access `node_ip:port/setup` on each server, and trigger the setup operation on the one that responds.\n\n## Install/Upgrade a Plugin\n1. Stop the cluster\n1. Upgrade the plugin on all nodes\nStart the cluster\n\n## Monitoring \nCPU and RAM usage on each node have to be monitored separately with an APM. \n\nIn addition, we provide a Web API _api/system/health_ you can use to validate that all of the nodes in your cluster are operational.  \n\n* GREEN: SonarQube is fully operational\n* YELLOW: SonarQube is usable, but it needs attention in order to be fully operational\n* RED: SonarQube is not operational\n\nTo call it from a monitoring system without having to give admin credentials, it is possible to setup a System Passcode through the property `sonar.web.systemPasscodez. This must be configured in _$SONARQUBE-HOME/conf/sonar.properties_.\n\n### Manually Check the Status of your SQ Cluster from the UI\nIn the System Info page, you can check whether your cluster is running safely (green) or has some nodes with problems (orange or red).\n\n## Compute Engine Workers\nIf you change the number of [Compute Engine workers](/instance-administration/compute-engine-performance/) in the UI, you must restart each application node to have the change take effect.\n\n## Project Move\nWhen the [Project Move](/instance-administration/project-move/) feature is used in a DC installation:\n\n* Projects are exported on only one of the application nodes \n* The archive of the exported projects must be copied to all the applications nodes in the target server\n\n## Configuration details\nStart with the [default configuration](/setup/install-cluster/); it's good in most cases. The details below are only needed in specific cases.\n\n[Hazelcast](https://hazelcast.org/) is used to manage the communication between the nodes of the cluster. You don't need to install it yourself, it's provided out of the box.\n\nThe following properties may be defined in the _$SONARQUBE-HOME/conf/sonar.properties_ file of each node in a cluster. When defining a property that contains a list of hosts (`*.hosts`) the port is not required if the default port was not overridden in the configuration.\n\n### All nodes\nProperty | Description | Default | Required | \n---|---|---|---|\n`sonar.cluster.enabled`|Set to `true` in each node to activate the cluster mode|`false`|yes\n`sonar.cluster.name`|The name of the cluster. **Required if multiple clusters are present on the same network.** For example this prevents mixing Production and Preproduction clusters. This will be the name stored in the Hazelcast cluster and used as the name of the Elasticsearch cluster.|`sonarqube`|no\n`sonar.cluster.hosts`|Comma-delimited list of all **application** hosts in the cluster. This value must contain **only application hosts**. Each item in the list must contain the port if the default `sonar.cluster.node.port` value is not used. Item format is `sonar.cluster.node.host` or `sonar.cluster.node.host:sonar.cluster.node.port`.| |yes\n`sonar.cluster.search.hosts`|Comma-delimited list of search hosts in the cluster. Each item in the list must contain the port if the default `sonar.search.port` value is not used. Item format is `sonar.search.host` or `sonar.search.host:sonar.search.port`.| |yes\n`sonar.cluster.node.name`|The name of the node that is used on Elasticsearch and stored in Hazelcast member attribute (NODE_NAME) for sonar-application|`sonarqube-{UUID}`|no\n`sonar.cluster.node.type`|Type of node: either `application` or `search`| |yes\n`sonar.cluster.node.host`|IP address of the network card that will be used by Hazelcast to communicate with the members of the cluster. If not specified, the first interface will be chosen (note that loopback interfaces won't be selected)| |no\n\n\n### Application nodes\nProperty  | Description | Required \n---|---|---|---\n`sonar.cluster.node.port`|The Hazelcast port for communication with each application member of the cluster. Default: `9003`|no|\n`sonar.cluster.node.web.port`|Hazelcast port for communication with the ComputeEngine process. Port must be accessible to all other search and application nodes. If not specified, a dynamic port will be chosen and all ports must be open among the nodes.|no\n`sonar.cluster.node.ce.port`|Hazelcast port for communication with the WebServer process. Port must be accessible to all other search and application nodes. If not specified, a dynamic port will be chosen and all ports must be open among the nodes.|no\n`sonar.auth.jwtBase64Hs256Secret`|Required for authentication with multiple web servers. It is used to keep user sessions opened when they are redirected from one web server to another by the load balancer. See _$SONARQUBE-HOME/conf/sonar.properties_) for details about how to generate this secret key.| yes\n\n### Search nodes\nProperty  | Description | Default | Required \n---|---|---|---\n`sonar.search.host`|Listening IP. IP must be accessible to all other search and application nodes.|`127.0.0.1`|yes\n`sonar.search.port`|Listening port. Port must be accessible to all other search and application nodes.|`9001`|yes\n`sonar.search.initialStateTimeout`|The timeout for the Elasticsearch nodes to elect a master node. The default value will be fine in most cases, but in a situation where startup is failing because of a timeout, this may need to be adjusted. The value must be set in the format: `{integer}{timeunit}`. Valid `{timeunit}` values are: `ms` (milliseconds); `s` (seconds); `m` (minutes); `h` (hours); `d` (days); `w` (weeks)|cluster: 120s; standalone: 30s|no\n\n## Limitations\n* Cluster downtime is required for SonarQube upgrades or plugin installations.\n* All application nodes must be stopped when installing, uninstalling or upgrading a plugin.\n* Plugins are not shared, it means if you install/uninstall/upgrade a given plugin in one application node, you need to perform the same actions on the other application node.\n* There is no way to perform actions on the cluster from a central app - all operations must be done manually on each node of the cluster.\n\n\n## Frequently Asked Questions\n### Does Elasticsearch discover automatically other ES nodes? \nNo. Multicast is disabled. All hosts (IP+port) must be listed.\n### Can different nodes run on the same machine? \nYes, but the best is to have 5 machines to be really resilient to failures.\n### Can the members of a cluster be discovered automatically? \nNo, all nodes must be configured in _$SONARQUBE-HOME/conf/sonar.properties_\n\n"},{path:"setup/operate-server",content:"---\ntitle: Configure & Operate the Server\nurl: /setup/operate-server/\n---\n\n\x3c!-- sonarqube --\x3e\n\n## Running SonarQube as a Service on Windows\n\n### Install/uninstall NT service (may have to run these files via Run As Administrator):\n\n```\n%SONARQUBE_HOME%/bin/windows-x86-64/InstallNTService.bat\n%SONARQUBE_HOME%/bin/windows-x86-64/UninstallNTService.bat\n```\n\n### Start/stop the service:\n\n```\n%SONARQUBE_HOME%/bin/windows-x86-64/StartNTService.bat\n%SONARQUBE_HOME%/bin/windows-x86-64/StopNTService.bat\n```\n\n## Running SonarQube as a Service on Linux with SystemD\n\nOn Unix system using SystemD, you can install SonarQube as a service. You cannot run SonarQube as `root` in 'nix systems. Ideally, you will created a new account dedicated to the purpose of running SonarQube.\nLet's suppose:\n\n* The user used to start the service is `sonarqube`\n* The group used to start the service is `sonarqube`\n* The Java Virtual Machine is installed in `/opt/java/`\n* SonarQube has been unzipped into `/opt/sonarqube/`\n\nThen create the file `/etc/systemd/system/sonarqube.service` _based on_ the following \n\n```\n[Unit]\nDescription=SonarQube service\nAfter=syslog.target network.target\n\n[Service]\nType=simple\nUser=sonarqube\nGroup=sonarqube\nPermissionsStartOnly=true\nExecStart=/bin/nohup /opt/java/bin/java -Xms32m -Xmx32m -Djava.net.preferIPv4Stack=true -jar /opt/sonarqube/lib/sonar-application-7.4.jar\nStandardOutput=syslog\nLimitNOFILE=65536\nLimitNPROC=8192\nTimeoutStartSec=5\nRestart=always\n\n[Install]\nWantedBy=multi-user.target\n```\n**Note**\n* Because the sonar-application jar name ends with the version of SonarQube, you will need to adjust the `ExecStart` command accordingly on install and at each upgrade.\n* The SonarQube data directory, `/opt/sonarqube/data`, and the extensions directory, `/opt/sonarqube/extensions` should be owned by the `sonarqube` user. As a good practice, the rest should be owned by `root`\n\nOnce your `sonarqube.service` file is created and properly configured, run\n```\nsudo systemctl enable sonarqube.service\nsudo systemctl start sonarqube.service\n```\n\n## Running SonarQube as a Service on Linux with initd\n\nThe following has been tested on Ubuntu 8.10 and CentOS 6.2.\n\nCreate the file /etc/init.d/sonar with this content:\n\n```\n#!/bin/sh\n#\n# rc file for SonarQube\n#\n# chkconfig: 345 96 10\n# description: SonarQube system (www.sonarsource.org)\n#\n### BEGIN INIT INFO\n# Provides: sonar\n# Required-Start: $network\n# Required-Stop: $network\n# Default-Start: 3 4 5\n# Default-Stop: 0 1 2 6\n# Short-Description: SonarQube system (www.sonarsource.org)\n# Description: SonarQube system (www.sonarsource.org)\n### END INIT INFO\n \n/usr/bin/sonar $*\n```\n\nRegister SonarQube at boot time (RedHat, CentOS, 64 bit):\n\n```\nsudo ln -s $SONAR_HOME/bin/linux-x86-64/sonar.sh /usr/bin/sonar\nsudo chmod 755 /etc/init.d/sonar\nsudo chkconfig --add sonar\n```\n\n## Securing the Server Behind a Proxy\n\nThis section helps you configure the SonarQube Server if you want to run it behind a proxy. This can be done for security concerns or to consolidate multiple disparate applications.\n\n### Server Configuration\n\nTo run the SonarQube server over HTTPS, you must build a standard reverse proxy infrastructure.\n\nThe reverse proxy must be configured to set the value `X_FORWARDED_PROTO: https` in each HTTP request header. Without this property, redirection initiated by the SonarQube server will fall back on HTTP.\n\n### Using an Apache Proxy\n\nWe assume that you've already installed Apache 2 with module mod_proxy, that SonarQube is running and available on `http://private_sonar_host:sonar_port/` and that you want to configure a Virtual Host for `www.public_sonar.com`.\n\nAt this point, edit the HTTPd configuration file for the `www.public_sonar.com` virtual host. Include the following to expose SonarQube via `mod_proxy` at `http://www.public_sonar.com/`:\n\n```\nProxyRequests Off\nProxyPreserveHost On\n<VirtualHost *:80>\n  ServerName www.public_sonar.com\n  ServerAdmin admin@somecompany.com\n  ProxyPass / http://private_sonar_host:sonar_port/\n  ProxyPassReverse / http://www.public_sonar.com/\n  ErrorLog logs/somecompany/sonar/error.log\n  CustomLog logs/somecompany/sonar/access.log common\n</VirtualHost>\n```\n\nApache configuration is going to vary based on your own application's requirements and the way you intend to expose SonarQube to the outside world. If you need more details about Apache HTTPd and mod_proxy, please see [http://httpd.apache.org](http://httpd.apache.org).\n\n### Using Nginx\n\nWe assume that you've already installed Nginx, that you are using a Virtual Host for www.somecompany.com and that SonarQube is running and available on `http://sonarhost:sonarport/`.\n\nAt this point, edit the Nginx configuration file. Include the following to expose SonarQube at http://www.somecompany.com/:\n\n```\n# the server directive is nginx's virtual host directive\nserver {\n  # port to listen on. Can also be set to an IP:PORT\n  listen 80;\n \n  # sets the domain[s] that this vhost server requests for\n  server_name www.somecompany.com;\n \n  location / {\n    proxy_pass http://sonarhost:sonarport;\n  }\n}\n```\n\nNginx configuration will vary based on your own application's requirements and the way you intend to expose SonarQube to the outside world. If you need more details about Nginx, please see [https://www.nginx.com/resources/admin-guide/reverse-proxy/](https://www.nginx.com/resources/admin-guide/reverse-proxy/).\n\nNote that you may need to increase the max URL length since SonarQube requests can have URLs longer than 2048.\n\n### Using IIS\n\nPlease see: [http://blog.jessehouwing.nl/2016/02/configure-ssl-for-sonarqube-on-windows.html](http://blog.jessehouwing.nl/2016/02/configure-ssl-for-sonarqube-on-windows.html)\n\nNote that the setup described in this blog post is not approprite for SAML through IIS.\n\n\x3c!-- /sonarqube --\x3e\n"},{path:"setup/overview",content:"---\ntitle: Overview\nurl: /setup/overview/\n---\n\n\x3c!-- sonarqube --\x3e\n### Get Started in Two Minutes\nTo give the SonarQube Platform a quick try, follow the [Get Started in Two Minutes Guide](/setup/get-started-2-minutes/).\n\n### Install a Production Instance\nTo install a production instance, read the [Requirements](/requirements/requirements/), and then follow the [Installation Guide](/setup/install-server/).\n\n### After the Installation\nAfter your server is up and running, you'll need to install one or more [SonarScanners](https://docs.sonarqube.org/display/SCAN) on the machines where analysis will be performed.\n\n### Upgrade your Production Instance\nTo upgrade your production instance, read the [Upgrade Guide](/setup/upgrading/) and the relevant, version-specific upgrade notes.\n\n\x3c!-- /sonarqube --\x3e\n"},{path:"setup/troubleshooting",content:"---\ntitle: Troubleshooting\nurl: /setup/troubleshooting/\n---\n\n\x3c!-- sonarqube --\x3e\n\n## Checking the logs\n\nIf you're having trouble starting your server for the first time (or any subsequent time!) the first thing to do is check your server logs. You'll find them in `$SONARQUBE_HOME/logs`:\n\n* sonar.log - Log for the main process. Holds general information about startup and shutdown. You'll get overall status here but not details. Look to the other logs for that.\n* web.log - Information about initial connection to the database, database migration and reindexing, and the processing of HTTP requests. This includes database and search engine logs related to those requests.\n* ce.log - Information about background task processing and the database and search engine logs related to those tasks.\n* es.log - Ops information from the search engine, such as Elasticsearch startup, health status changes, cluster-, node- and index-level operations, etc.\n\n## Understanding the logs\n\nWhen there's an error, you'll very often find a stacktrace in the logs. If you're not familiar stacktraces, they can be intimidatingly tall walls of incomprehensible text. As a sample, here's a fairly short one:\n\n```\njava.lang.IllegalStateException: Unable to blame file **/**/foo.java\n    at org.sonarsource.scm.git.JGitBlameCommand.blame(JGitBlameCommand.java:128)\n    at org.sonarsource.scm.git.JGitBlameCommand.access$000(JGitBlameCommand.java:44)\n    at org.sonarsource.scm.git.JGitBlameCommand$1.call(JGitBlameCommand.java:112)\n    at org.sonarsource.scm.git.JGitBlameCommand$1.call(JGitBlameCommand.java:109)\n    at java.util.concurrent.FutureTask.run(Unknown Source)\n    at java.util.concurrent.ThreadPoolExecutor.runWorker(Unknown Source)\n    at java.util.concurrent.ThreadPoolExecutor$Worker.run(Unknown Source)\n    at java.lang.Thread.run(Unknown Source)\nCaused by: java.lang.NullPointerException\n    at org.eclipse.jgit.treewalk.filter.PathFilter.create(PathFilter.java:77)\n    at org.eclipse.jgit.blame.BlameGenerator.<init>(BlameGenerator.java:161)\n    at org.eclipse.jgit.api.BlameCommand.call(BlameCommand.java:203)\n    at org.sonarsource.scm.git.JGitBlameCommand.blame(JGitBlameCommand.java:126)\n    ... 7 more\n```\n\nUnless you wrote the code that produced this error, you really only care about:\n* the first line, which ought to have a human-readable message after the colon. In this case, it's Unable to blame file `**/**/foo.java`\n* and any line that starts with `Caused by:`. There are often several `Caused by` lines, and indentation makes them easy to find as you scroll through the error. Be sure to read each of these lines. Very often one of them - the last one or next to last one - contains the real problem.\n\n\x3c!-- /sonarqube --\x3e\n"},{path:"setup/upgrade-notes",content:'---\ntitle: Release Upgrade Notes\nurl: /setup/upgrade-notes/\n---\n\n## Release 7.7 Upgrade Notes  \n**Deprecated parameters dropped**  \n`sonar.language`, and  `sonar.profile`, both deprecated since 4.5, are dropped in this version as is `sonar.analysis.mode`, which as been deprecated since 6.6. These now-unrecognized parameters will simply be ignored, rather than failing analysis.\n\n**PR decoration below GitHub Enterprise 2.14 swapped for GitHub checks**  \nThis version adds support for GitHub Enterprise (GHE) checks, which were introduced in GHE 2.14, and drops support for PR decoration in GHE versions prior to 2.14. To use the new checks implementation, an application will need to be created in GHE, and further configuration will be required via the SonarQube UI. ([Details in the docs.](/instance-administration/github-application/).)\n\n**ElasticSearch update requires index rebuild, potentially more filespace**\nWhile it is generally possible to keep ElasticSearch indices in an upgrade (see [Configuring the Elasticsearch storage path](/setup/install-server/)), this version\'s upgrade of ElasticSearch will force all indices to be rebuilt. Additionally, more filespace may be required for this version\'s data ([SONAR-11826](https://jira.sonarsource.com/browse/SONAR-11826)).\n\n**32-bit architecture support dropped**  \nSupport for 32-bit architectures has been dropped as part of this version\'s upgrade of ElasticSearch, and those scripts removed from the distributions. \n\n**Deprecated metrics dropped**  \nSeveral deprecated ([SONAR-1794](https://jira.sonarsource.com/browse/SONAR-11794)) or obsolete ([SONAR-11664](https://jira.sonarsource.com/browse/SONAR-11664)) metrics have been dropped from the platform.\n\n[Full Release Notes](https://jira.sonarsource.com/jira/secure/ReleaseNote.jspa?projectId=10930&version=14848)\n\n## Release 7.6 Upgrade Notes\n**Quality Gates Simplified**  \nQuality Gates have been streamlined to remove a number of confusing options. Conditions previously using the "on new code" checkbox will be migrated to On New Code metrics. For example, a condition previously using the overall Coverage metric with the "on new code" checkbox enabled will be migrated to a condition using the Coverage on New Code metric. The ability to set Warning conditions has been dropped, as have some metric/operator conditions have been removed. Conditions using dropped options will be removed in the upgrade. ([MMF-473](https://jira.sonarsource.com/browse/MMF-473))\n\n**Concept of module removed from the UI**  \nThis version drops the concept of module from the interface. There is no longer a homepage presentation for any level below the project itself. Additionally, the presentation of the project has been updated in the Measures and Code pages to display the project tree as it is in the file system. For the most part (see below) analysis of multi-module projects will continue to work as it has.\n\n**Multi-Module analysis properties removed**  \nMulti-module analysis configuration may need to be changed ([MMF-365](https://jira.sonarsource.com/browse/MMF-365)):\n\n* When the following inclusion / exclusion types are specified in the analysis properties at project level, they must be relative to the project / analysis root: source files, test files, coverage, and duplications. Paths specified at project level will continue to be re-applied at module level but will raise a warning. This backward-compatibile behavior is considered deprecated and will be dropped in a future version. \n* Specifying source encoding, and issue inclusions / exclusions at module level is no longer supported.\n\n**Incompatibility with Findbugs plugin version 3.9.1 and earlier**  \nThis version embeds SonarHTML, which analyzes both `.html` and `.jsp` files. Because of this change, the community plugin Findbugs versions 3.9.1 and earlier are incompatible with SonarQube 7.6+ ([MMF-1567](https://jira.sonarsource.com/browse/MMF-1567)).\n\n[Full Release Notes](https://jira.sonarsource.com/jira/secure/ReleaseNote.jspa?projectId=10930&version=14693)\n\n## Release 7.5 Upgrade Notes  \n**More Issues Backdated**  \nAdditional cases of issue backdating have been added, so fewer genuinely old issues will be reported in the New Code period ([MMF-1287](https://jira.sonarsource.com/browse/MMF-1287))\n\n**Two Vulnerabilities Patched**  \nAn open redirect vulnerability on login was corrected ([SONAR-11475](https://jira.sonarsource.com/browse/SONAR-11475)).\n\nAn XSS vulnerability in custom project links was also patched. ([SONAR-11506](https://jira.sonarsource.com/browse/SONAR-11506)).\n\n**Deadlock Fixed**  \nThe deadlock that could occur with the combination of \n* SQL Server\n* Multiple workers\n* Analysis of projects and portfolios  \n\nhas been fixed ([SONAR-11467](https://jira.sonarsource.com/browse/SONAR-11467)).\n\n\n**DB Connection Pool Defaults Restored**  \nDatabase connection pool defaults have been restored to their pre-SonarQube 7.4 values. They were inadvertently affected by a change of connection pooling in 7.4 ([SONAR-11539](https://jira.sonarsource.com/browse/SONAR-11539)). \n\n[Full Release Notes](https://jira.sonarsource.com/jira/secure/ReleaseNote.jspa?projectId=10930&version=14693)\n\n\n## Release 7.4 Upgrade Notes\n**Analysis Failure on Invalid New Code Period**  \nAnalysis will fail if the New Code Period (see below) is not set to one of:\n* valid, in-the-past date\n* positive integer (number of days)\n* `previous_version`\n* the version string of an existing snapshot  \n\nFor more, see [SONAR-10555](https://jira.sonarsource.com/browse/SONAR-10555)\n\n**New Create Portfolios and Create Applications permissions**  \nTwo distinct new create permissions have been added. Users who have any creation permission will see a new "+" item in the top menu giving access to these permissions. For more, see the Global Permissions topic in [Security](/instance-administration/security/) \n\n**Issues from third party Roslyn analyzers**  \nAnalyzing a C# / VB.NET solution now automatically imports issues found by attached Roslyn analyzers into SonarQube, and no longer suppresses them from the MSBuild output. The Quality Gate status of projects may be impacted.\n\n**More memory may be needed for analysis**  \nChanges in the advanced security analysis available in Developer Edition and above may mean that a larger heap is needed during analysis.\n\n**Analysis warnings in UI**  \nSome `WARN` messages generated during analysis are now available via the UI ([MMF-1244](https://jira.sonarsource.com/browse/MMF-1244)). More messages will be available as new versions of language analyzers are released.\n\n**"Leak" replaced with "New Code"**  \nWording has been updated throughout the interface to replace "Leak" and "Leak Period" with "New Code" and "New Code Period".\n\n[Full release notes](https://jira.sonarsource.com/jira/secure/ReleaseNote.jspa?projectId=10930&version=14549)\n\n\n## Release 7.3 Upgrade Notes\n\n**New "Administer Security Hotspots" Permission**  \nDuring the upgrade, the new "Administer Security Hotspots" permission is granted to all users/groups who already have the "Administer Issues" permission.\n\n**Expanded Compute Engine Logs**  \nStarting with this version, Compute Engine logs will be more verbose. These logs are rotated automatically, but on a daily basis, not based on file size. \n\n**PostgreSQL < 9.3 No Longer Supported**  \nSonarQube 7.3+ only supports PostgreSQL 9.3 to 10. SonarQube will not start if you are using a lower version of PostgreSQL.\n\n**Some 3rd-party Plugins Incompatible**  \nAPIs deprecated before SonarQube 5.6 are dropped in this version, making some third-party plugins incompatible. It is always advised to check plugin compatibility in the Plugin Version Matrix with each new upgrade, and more so for this version. \n\n[Full release notes](https://jira.sonarsource.com/jira/secure/ReleaseNote.jspa?projectId=10930&version=14464)\n\n## Release 7.2 Upgrade Notes\n\n**License Incompatibility**  \n**Users coming from 6.7.5 must not upgrade to this version.** Your license will be incompatible. Instead, if you seek an upgrade to an intermediate version before the next L.T.S. version, you must start from 7.3 or higher.\n\n**Pull Request Analysis**  \nPull Requests are now a first class citizen feature in SonarQube for Developer, Enterprise and Data Center Edition users.\n\nIf you are using GitHub, you need to be sure to NOT have the GitHub Plugin in your SONARQUBE_HOME/extensions/plugins directory.\n\n**New Edition Packaging**  \nSonarSource Commercial Editions are now distributed individually, so you directly get the features and functionalities that match your needs. This means that upgrade/downgrade from one edition to another is no longer possible within the SonarQube Marketplace. In order to use a different edition you must download its dedicated package, and have a license ready for using that edition.\n\n**Deprecated Features**  \nSonarQube 7.2 is the last version supporting PostgreSQL < 9.3. Starting from SonarQube 7.3 the minimal supported version of PostgreSQL will be 9.3: SONAR-10668\n\n[Full release notes](https://jira.sonarsource.com/jira/secure/ReleaseNote.jspa?projectId=10930&version=14213)\n\n## Release 7.1 Upgrade Notes\n\n**License Incompatibility**  \n**Users coming from 6.7.5 must not upgrade to this version.** Your license will be incompatible. Instead, if you seek an upgrade to an intermediate version before the next L.T.S. version, you must start from 7.3 or higher.\n\n**Live Portfolios**  \nPortfolio measures are now updated without having to explicitly trigger recalculation. As a result, the "views" scanner task no longer has any effect, and will fail with a clear error message. \n\n**Deprecated Features**  \nSupport for MySQL is deprecated for all editions below Data Center Edition (see below).\n\n**Dropped Features**  \n- Support for MySQL in Data Center Edition.\n- The "accessors" metric, which was deprecated in SonarQube 5.0.\n\n[Full release notes](https://jira.sonarsource.com/jira/secure/ReleaseNote.jspa?projectId=10930&version=14178)\n\n## Release 7.0 Upgrade Notes\n\n**License incompatibility**  \n**Users coming from 6.7.5 must not upgrade to this version.** Your license will be incompatible. Instead, if you seek an upgrade to an intermediate version before the next L.T.S. version, you must start from 7.3 or higher.\n\n**Measures: Live Update**  \nProject measures, including the Quality Gate status, are computed without having to trigger another code scan when issue changes may impact them.\n\n**Built-In Read-Only Quality Gate**  \nIn order to make clear the default, minimum and recommended criteria Quality Gates, the "Sonar way" Quality Gate is now read-only, and the default if one is not already set. It may be updated automatically at each upgrade of SonarQube.\n\n**Dropped Features**  \nIt\'s no longer possible to unset the default Quality Gate. \n\n[Full release notes](https://jira.sonarsource.com/jira/secure/ReleaseNote.jspa?projectId=10930&version=14041)\n\n\n## Release 6.7.5 Upgrade Notes\n\n**Commercial Edition Must Be Upgraded**  \nBecause a new server identifier will be generated at upgrade to this version, startup will fail unless you upgrade your commercial edition to the latest compatible version. I.E. don\'t just copy over your edition plugins from one instance to the next, but make sure to download the latest edition bundle.\n\n**SonarLint Must Be Upgraded**  \nAnalyzers provided as part of a commercial package will be disabled in old versions of SonarLint. SonarLint users must upgrade to the latest available version:\n\n- SonarLint for Eclipse: 3.3+.\n- SonarLint for IntelliJ: 3.1+\n\n**Multi-Version Upgrade**  \nDon\'t forget to read all the intermediate upgrade notes if you\'re upgrading more than a single version.\n\n[Full release notes](https://jira.sonarsource.com/jira/secure/ReleaseNote.jspa?projectId=10930&version=14467)\n\n\n## Release 6.7 Upgrade Notes\n\n**Drop of Issues Report**  \nThe deprecated Issues Report feature has been removed.\n\n[Full release notes](https://jira.sonarsource.com/jira/secure/ReleaseNote.jspa?projectId=10930&version=13972)\n'},{path:"setup/upgrading",content:"---\ntitle: Upgrade the Server\nurl: /setup/upgrading/\n---\n\n\x3c!-- sonarqube --\x3e\nUpgrading across multiple, non-LTS versions is handled automatically. However, if in your migration path you have an LTS version, you must first migrate to this LTS and then migrate to your target version.\n\nExample 1 : 5.1 -> 7.0, migration path is 5.1 -> 5.6.7 LTS -> 6.7.x LTS -> 7.0\nExample 2 : 6.2 -> 6.7, migration path is 6.2 -> 6.7.x LTS (where x is the latest patch available for 6.7 - you don't need to install all the intermediary patches, just take the latest)\n\n## How to Upgrade?\n\nThis is a generic upgrade guide, please read carefully the Upgrade Notes of your target version and of each intermediate version, if any (below).\n\n![](/images/info.svg) Planning to Upgrade to a Commercial Editions?\nIf you are targetting to move to 6.7 LTS and to install a commercial Edition, please read this [documentation](https://docs.sonarqube.org/display/SONARQUBE67/SonarSource+Editions).\n\nBefore you start, backup your SonarQube Database. Upgrade problems are rare, but you'll want the backup if anything does happen.\n\n1. Download and unzip the SonarQube distribution of your edition in a fresh directory, let's say `$NEW_SONARQUBE_HOME`\n2. Manually install the non-default plugins that are compatible with your version of SonarQube. Use the [Compatibility Matrix](https://docs.sonarqube.org/display/PLUG/Plugin+Version+Matrix) to ensure that the versions you install are compatible with your server version. Note that the most recent versions of all SonarSource code analyzers available in your edition are installed by default. Simply copying plugins from the old server to the new is not recommended; incompatible or duplicate plugins could cause startup errors.\n3. Update the contents of `sonar.properties` and `wrapper.conf` files (in `$NEW_SONARQUBE_HOME/conf`) with the settings of the related files in the `$OLD_SONARQUBE_HOME/conf` directory (web server URL, database, ldap settings, etc.). Do not copy-paste the old files.\nIf you are using the Oracle DB, copy its JDBC driver into `$NEW_SONARQUBE_HOME/extensions/jdbc-driver/oracle`\n4. Stop your old SonarQube Server\n5. Start your new SonarQube Server\n6. Browse to `http://yourSonarQubeServerURL/setup` and follow the setup instructions\n7. Reanalyze your projects to get fresh data\n\n## Anything Else?\n\n### Oracle Clean-up\n\nStarting with 6.6, there's an additional step you may want to perform if you're using Oracle. On Oracle the database columns to be dropped are now marked as UNUSED and are not physically dropped anymore. To reclaim disk space, Oracle administrators must drop these unused columns manually. The SQL request is `ALTER TABLE foo DROP UNUSED COLUMNS`. The relevant tables are listed in the system table `all_unused_col_tabs`.\n\n### Additional Database Maintenance\n\nRefreshing your database's statistics and rebuilding your database's indices are recommended once the technical upgrade is done (just before the very last step).\n\nFor PostgreSQL, that means executing `VACUUM FULL`. According to the PostgreSQL documentation:\n\n```\nIn normal PostgreSQL operation, tuples that are deleted or obsoleted by an update are not physically removed from their table; they remain present until a VACUUM is done.\n```\n\n### Scanner Update\n\nWhen upgrading SonarQube, you should also make sure you’re using the latest versions of the SonarQube scanners to take advantage of features and fixes on the scanner side. Please check the documentation pages of the Scanners you use for the most recent version compatible with SonarQube and your build tools.\n\n### SonarQube as a Linux or Windows Service\n\nIf you use external configuration, such as a script or Windows Service to control your server, you'll need to update it to point to `$NEW_SONARQUBE_HOME`.\n\nIn case you used the InstallNTService.bat to install SonarQube as a Windows Service, run the $OLD_SONARQUBE_HOME/bin/.../UninstallNTService.bat before running the InstallNTService.bat of the $NEW_SONARQUBE_HOME.\n\n## Release Upgrade Notes\n\nUsually SonarQube releases come with some specific recommendations for upgrading from the previous version. You should read the upgrade notes for each version between your current version and the target version. To upgrade from a version not listed in [Release Upgrade Notes](/setup/upgrade-notes/), see [Documentation for Previous Versions](/previous-versions/).\n\n\x3c!-- /sonarqube --\x3e\n"},{path:"sonarcloud/autoscan",content:"---\ntitle: AutoScan Beta Feature\nnav: AutoScan\nurl: /autoscan/\n---\n\nSonarCloud can autonomously scan your code, by simply reading it from your repository! We call that AutoScan.\n\n[[info]]\n| This is currently a Beta feature, with a limited scope and some caveats. Those limitations will be removed along the way.\n\n\n## Prerequisites\n\n* The first version of this Beta feature works only for GitHub repositories. \n* The automatic analysis can be activated only on projects which were set up through the SonarCloud web interface.\n\n## What to expect\n\nOnce activated, SonarCloud will automatically analyze: \n* the default branch of the repository\n* the pull requests (PR) on that default branch\n\nIt will take care of doing it whenever you push on your repository.\n\nThe following languages are currently supported: \n* ABAP\n* Apex\n* CSS\n* Flex\n* Go\n* HTML\n* JS\n* Kotlin\n* PHP\n* Python\n* Ruby\n* Scala\n* Swift\n* TypeScript\n* TSQL\n* XML\n\n## How to activate the feature?\n\nTo enable the automatic analysis, you need to add a `.sonarcloud.properties` file in your repository.\n\nIf you're starting from scratch:\n\n1. Do the [setup for your project](/#sonarcloud#/projects/create) (from the `+ > Analyze new project` top right menu)\n    * ![](/images/exclamation.svg) Remember that your project must absolutely be created by selecting a GitHub repository - otherwise it won't work.\n1. Once the setup is done on SonarCloud, you end up on the project home page which shows a tutorial. Ignore it and simply add a `.sonarcloud.properties` file in the base directory of your default branch (or on a PR which targets this default branch). \n1. After a while, the analysis results will be visible in SonarCloud (and your PR will be annotated with comments if you pushed the file on a PR)\n\nHere are the supported optional settings for the `.sonarcloud.properties` file:\n```\n# Path to sources\n#sonar.sources=.\n#sonar.exclusions=\n#sonar.inclusions=\n\n# Path to tests\n#sonar.tests=\n#sonar.test.exclusions=\n#sonar.test.inclusions=\n\n# Source encoding\n#sonar.sourceEncoding=UTF-8\n\n# Exclusions for copy-paste detection\n#sonar.cpd.exclusions=\n```\n\nNote that you can just push an empty `.sonarcloud.properties` file, this will work fine. In this case, every file in the repository will be considered as a source file.\n\n## Current limitations/caveats\n\n* There is no visual feedback (yet) in the UI when SonarCloud runs an analysis.\n* A consequence of the previous point is that if - for any reason, SonarCloud fails to successfully run the analysis, nothing will be displayed. In that case, just come on [the forum](https://community.sonarsource.com/tags/c/help/sc/autoscan) and ask a question, we'll monitor that closely.\n* Pull requests from forks are not analyzed (only PRs from the same repository)\n* Code coverage information is not supported\n* Import of external rule engine reports is not supported\n\n## Noteworthy\n\n* This Beta feature works for any project - public or private.\n* It can be activated with no extra cost.\n* Sources are cloned only during the analysis, and only when the `.sonarcloud.properties` file exists (i.e. when the feature is activated). The cloned repository is fully deleted at the end of the analysis, and SonarCloud does not keep a copy of it.\n* Non supported languages (Java, C#, VB.NET, C/C++, ObjectiveC) are not analyzed at all.\n\n## How to give feedback?\n\nCreate a new thread on the forum, under [\"Get Help > SonarCloud\"](https://community.sonarsource.com/tags/c/help/sc/autoscan), with the \"autoscan\" tag.\n\nWe'd love to hear your feedback about this new upcoming feature, may it be about bugs, improvements, or anything you want to share with us!\n"},{path:"sonarcloud/integrations/bitbucketcloud",content:'---\ntitle: Get started with Bitbucket Cloud\nnav: Bitbucket Cloud\nurl: /integrations/bitbucketcloud/\n---\n\n## Sign up and set up your first project\n1. On the [login page](/#sonarcloud#/sessions/new), click on the "Log in with Bitbucket" button and connect to SonarCloud using your Bitbucket Cloud account.\n2. Click on "Analyze your code" and follow the path to set up a first project\n3. You will be asked to install the SonarCould application on your team or user account, which will allow you to \n  choose which repositories you want to analyze.\n\n## Analyzing with Pipelines\n\nOnce your project is created and initiated from the repository you selected:\n\n1. Generate a token to allow to publish analysis from Bitbucket Pipelines. To generate a token, follow the first step of the tutorial on the dashboard of the project, or go to your user security page.\n\n2. On Bitbucket Cloud, go to the "Settings > Pipelines > Account variables" page of your team, and add a new SONAR_TOKEN variable that contains the value of the SonarCloud token (something like `9ad01c85336b265406fa6554a9a681a4b281135f`).\n   * **Make sure that you click on the "Lock" icon to encrypt and hide this token.**\n\n3. Edit the `bitbucket-pipelines.yml` file of your repository to trigger the SonarCloud analysis. See [our various example projects](https://bitbucket.org/account/user/sonarsource/projects/SAMPLES) to see how to achieve this.\n   * Note: if you did not activate Pipelines prior to this step, you should go to the "Pipelines" menu entry on your repository to enable it.\n\nOnce those changes are pushed, Pipelines will automatically trigger analyses on the repository.\n\n## Analyzing pull requests with Pipelines\n\nIn order to trigger SonarCloud analysis on each pull request update, you have to supply the same command in the `pull-requests` section of `bitbucket-pipelines.yml` (check [Configure bitbucket-pipelines.yml](https://confluence.atlassian.com/bitbucket/configure-bitbucket-pipelines-yml-792298910.html#Configurebitbucket-pipelines.yml-ci_pull-requests) for more details about that section). Here is a sample configuration:\n```\npipelines:\n  ...\n  pull-requests:\n    feature/*:\n      - step:\n          script:\n            - mvn sonar:sonar\n  ...\n```\n\nIn order to avoid duplication between the different sections of your `bitbucket-pipelines.yml`, you can use [yaml anchors and aliases](https://confluence.atlassian.com/bitbucket/yaml-anchors-960154027.html).\n\n## Quality widget\n\nSonarCloud can provide a widget that shows the current quality metrics of your project directly on the repository\'s Overview page on Bitbucket Cloud.\n\nIf you want to see this widget, you can go to the "Settings > SonarCloud" page of your repository and check "Show repository overview widget".\n\n## FAQ\n\n**Do you have sample projects on Bitbucket Cloud?**\nYou can take a look at these various projects: [Sample projects analysed on SonarCloud](https://bitbucket.org/account/user/sonarsource/projects/SAMPLES)\n\n**I don\'t see the widget with quality information whereas I configured everything**\nMake sure that your browser is not using some extensions like AdBlocks. They tend to break the integration of third-party applications in BitBucket Cloud.\n\n## Upcoming features and improvements\n\nThere are various areas in which you can expect new features and improvements:\n\n* Pull request decoration with inline comments to show the issues within the PR\n* Better and easier team onboarding\n* Automatic analysis (i.e. no need to configure anything from Pipelines)\n'},{path:"sonarcloud/integrations/github",content:'---\ntitle: Get started with GitHub\nnav: GitHub\nurl: /integrations/github/\n---\n\n## Sign up and set up your first project\n\n1. On the [login page](/#sonarcloud#/sessions/new), click on the "Log in with GitHub" button and connect to SonarCloud using your GitHub account.\n2. Click on "Analyze your code" and follow the path to set up a first project\n3. You will be asked to install the SonarCould application on your organization, which will allow you to choose which\n   repository you want to analyze.\n\n## Trigger analyses\n\nFor GitHub repositories, there are 2 ways to have your code analyzed:\n\n### ... with AutoScan\n\nWith AutoScan, SonarCloud will autonomously pull your code and scan your default branch and your pull requests.\nPlease read the ["AutoScan Beta Feature"](/autoscan/) documentation page to get the details.\n\n![](/images/exclamation.svg) This is currently a Beta feature which does not work for all languages and comes with limitations. \n\n### ... using your CI service\n\nIf AutoScan does not make sense yet for your repository, you need to configure your CI service to trigger the analysis.\n\n**If you are using Travis CI**, the SonarCloud Travis Add-on will make it easier to activate analyses:\n\n* Read the [guide to integrate with Travis CI](https://docs.travis-ci.com/user/sonarcloud/)\n* Check out the [various sample projects](https://github.com/SonarSource/sonarcloud_examples) (Java, TypeScript, C/C++, Go, ... etc) that are analyzed on SonarCloud on a frequent basis\n\n**If you are using another CI service**, you will need to read:\n\n* the ["Analyzing Source Code" overview page](/analysis/overview/)\n* the ["Branches" overview page](/branches/overview/)\n* the ["Pull Request Analysis" page](/analysis/pull-request/)\n\nHere is an example of configuration for pull requests when you are not on Travis CI and you need to configure your CI jobs:\n```\nsonar.pullrequest.base=master\nsonar.pullrequest.branch=feature/my-new-feature\nsonar.pullrequest.key=5\nsonar.pullrequest.provider=GitHub\nsonar.pullrequest.github.repository=my-company/my-repo\n```\n\n[[info]]\n| Pull request decoration works only if [the SonarCloud application](https://github.com/apps/sonarcloud) is installed on your GitHub organization(s) and configured to have acccess to the repositories.\n'},{path:"sonarcloud/integrations/vsts",content:'---\ntitle: Get started with Azure DevOps\nnav: Azure DevOps\nurl: /integrations/vsts/\n---\n\n[[info]]\n| This page is about Azure DevOps, formerly known as VSTS.\n\nYou can connect to SonarCloud using your Azure DevOps account. On the [login page](/#sonarcloud#/sessions/new), just click on the "Log in with Azure DevOps" button.\n\n[[warning]]\n| ![Warning](/images/exclamation.svg) Only work and school Azure DevOps accounts are authorized to login on SonarCloud.\n\n## Install the SonarCloud Azure DevOps extension\n\nThe SonarCloud Azure DevOps extension brings everything you need to have your projects analyzed on SonarCloud \nvery quickly:\n* Integration with the Build definitions to easily trigger the analysis\n* Pull request decoration to get quick feedback on the code changes\n* Widget to have the overview quality of your projects inside Azure DevOps dashboards\n\nInstall [SonarCloud extension for Azure DevOps](https://marketplace.visualstudio.com/items?itemName=SonarSource.sonarcloud)by clicking on the "Get it free" button.\n\nThen follow the comprehensive [Microsoft lab on how to integrate Azure DevOps with SonarCloud](https://aka.ms/sonarcloudlab).\n\n## Quality Gate Status widget \n\nYou can monitor the Quality Gate status of your projects directly in your Azure DevOps dashboard. Follow these simple steps to configure your widget:\n\n1. Once the Azure DevOps extension is installed and your project has been successfully analyzed, go to one of your Azure DevOps dashboards (or create one). Click on the pen icon in the bottom right corner of the screen, and then on the "+" icon to add a widget. \n\n2. In the list of widgets, select the "Code Quality" one and then click on the "Add" button. An empty widget is added to your dashboard. \n\n3. You can then click on the widget\'s cogwheel icon to configure it.\n\n    * **For public projects:** you can simply select your project from the dropdown. A searchbar inside the dropdown will help you find it easily. Just select it and click on the "Save" button.\n\n    * **For private projects:** you\'ll have to log in using the links provided under the dropdown. Once logged in, your private projects will appear in the dropdown. Select the one you are interested in, and click on "Save".\n'},{path:"sonarcloud/organizations/index",content:'---\ntitle: Organizations\nurl: /organizations/overview/\n---\n\n## Overview\n\nAn organization is a space where a team or a whole company can collaborate across many projects.\n\nAn organization consists of:\n* Projects, on which users collaborate\n* [Members](/organizations/manage-team/), who can have different persmissions on the projects\n* [Quality Profiles](/instance-administration/quality-profiles/) and [Quality Gates](/user-guide/quality-gates/), which can be customized and shared accross projects\n\nThere are 2 kind of organizations:\n* **Personal organizations**. Each account has a personal organization linked to it. This is typically where open-source developers host their personal projects. It is not possible to delete this kind of organization.\n* **Standard organization**. This is the kind of organization that users want to create for their companies or for their open-source communities. As soon as you want to collaborate, it is a good idea to create such an organization.\n\nOrganizations can be on:\n* **Free plan**. This is the default plan. Every project in an organization on the free plan is public.\n* **Paid plan**. This plan unlocks the ability to have private projects. Go to the "Billing" page of your organization to upgrade it to the paid plan.\n\nDepending on which plan the organization is in, its [visibility](/organizations/organization-visibility/) will change.\n\nYou can create organizations from the top right menu "+ > Create new organization"\n\n## How to bind an existing organization to GitHub or Bitbucket Cloud?\n\nYou might notice the following warning message on your pull requests inside SonarCloud:\n\n    The SonarCloud GitHub application is installed on your GitHub organization, but the \n    SonarCloud organization is not bound to it. Please read "How to bind an existing \n    organization?" section in the "Organizations" documentation page to fix your setup.\n\nThis means that your SonarCloud organization is not bound to GitHub or Bitbucket Cloud whereas you had already installed the SonarCloud application (probably to annotate pull requests). To fix your setup, here are the steps to follow.\n\n**For GitHub:**\n\n1. Click your profile picture in the top right menu and select the organization.\n2. In the organization menu, click "Administration > Organization settings"\n3. Click on "Choose an organization on GitHub".\n4. On GitHub page, you should see a list of organization you are admin of. The organization you want to bind is marked as already configured. Click on it.\n5. Click on "Uninstall" at the bottom of the page.\n6. Go back to SonarCloud, to the settings page of your organization, and click on "Choose an organization on GitHub" again. The organization you want to bind should not be marked as configured anymore. Click on it, and then on "Install". After the installation, you will be redirected to SonarCloud.\n7. You are all set! You should see a GitHub icon close to the name of your organization at the top of the page.\n\n**For Bitbucket Cloud:**\n\n1. Click your profile picture in the top right menu and select the organization.\n2. In the organization menu, click "Administration > Organization settings"\n3. Click on "Choose a team on Bitbucket".\n4. On Bitbucket Cloud page, select the name of the team you want to bind and click on "Grant access". You will then be redirected to SonarCloud.\n   [[warning]]\n   | If you get a 405 error page from Bitbucket Cloud at this stage, this means that you did not approve a recent scope change - for which you should have received an email from Bitbucket Cloud. The easiest way to get around this is to uninstall the SonarCloud application in your Bitbucket Cloud "Install apps" settings, and reinstall it.\n5. You are all set! You should see a Bitbucket Cloud icon close to the name of your organization at the top of the page.\n'},{path:"sonarcloud/organizations/manage-team",content:'---\ntitle: Manage a Team\nurl: /organizations/manage-team/\n---\n\nMembers can collaborate on the projects in the organizations to which they belong. Depending on their permisssions within the organization, members can:\n* Analyze projects\n* Manage project settings (permissions, visibility, quality profiles, ...)\n* Update issues\n* Manage quality gates and quality profiles\n* Administer the organization itself\n\nMembers are managed on the "Members" page of the organization. Only organization administrators can manage members. \n\n## Managing Members Manually\nMembers are managed manually when synchronization is not available (for Bitbucket Cloud or Azure Devops for example) or when synchronization is deactivated.\n\n### Adding Members\nYou can add members to an organization using the "Add a member" button. Administrators can search manually for SonarCloud users and add them as members.\n\n## Managing Members in GitHub\nFor organizations that are bound to GitHub, members can be synchronized with GitHub organizations or managed manually. \n\nNote that in all cases, members should have a SonarCloud account before being synchronized with GitHub or added manually.\n\n### Synchronizing Members with your GitHub Organization\nWhen [importing](/organizations/overview/) a GitHub organization into SonarCloud, members are automatically synchronized with your GitHub organization.  \nThis means that each member of your GitHub organization who has a SonarCloud account will be automatically added to the SonarCloud organization, \nand will have direct access in SonarCloud to the organizations they\'ve been added to. \n\nYou can synchronize a bound organization with manually managed members using the "Configure synchronization" button. \nDuring synchronization, members of the SonarCloud organization who are not part of the GitHub organization are removed from the SonarCloud \norganization and members of the GitHub organization who are not members of the SonarCloud organization are added to the SonarCloud organization.\n\nAfter creating an organization or activating synchronization, SonarCloud users that are added or removed from the GitHub organization are automatically added or removed from \nthe SonarCloud organization. It\'s not possible to manually add or remove a member when synchronization is activated.\n\nPermissions are not synchronized and must be managed manually (see below).\n\n### Deactivating Member Synchronization\nYou can deactivate member synchronization using the "Configure synchronization" button. \nWhen you deactivate member synchronization, no members will be added or removed automatically.\nAfter deactivating synchronization, members will be managed manually.\n\n\n## Granting permissions\nOnce users are added or synchronized, organization administrators can grant them permissions to perform specific operations in the organization. It is up to the \nadministrators to make sure each member gets the relevant permissions.\n\nTo avoid having to manage individual permissions at a project level, organization admins can create groups to manage permissions \nand add new users to those groups on the "Members" page.\n\n## Future evolutions\nFuture versions of SonarCloud will make this onboarding process easier for BitBucket Cloud, Azure Devops, and others. \nUsers\' permissions will be retrieved from systems and mapped to SonarCloud permissions on a best-effort basis.'},{path:"sonarcloud/organizations/organization-visibility",content:'---\ntitle: Organization Visibility\nurl: /organizations/organization-visibility/\n---\n\n## Free plan organization\n\nFree plan organizations are public. This means that almost everything is visible to any user - even anonymous ones:\n\n* Projects\n* Issues\n* Quality Profiles\n* Quality Gates\n* Rules\n\nThe following pages are restricted:\n\n* Members: to members of the organization\n* Administration pages: to administrators of the organization\n\n## Paid plan organization\n\nPaid plan organizations are private. This means that nothing is visible to non-members of the organization. In other words, you need to be a member of the organization to see:\n\n* Projects - which are private by default\n* Issues\n* Quality Profiles\n* Quality Gates\n* Rules\n* Members\n\nThe administration pages are obviously also restricted to administrators of the organization.\n\n### Want to make one project public?\n\nIf you are on a paid plan organization but want to make a project public (for instance because you are developing an open-source library), this is possible. You will have to manually make the project public in its **Administration > Permissions** page. Once done, you will notice the "Public" badge on the project.\n\nAs soon as you have one public project, the following pages will become visible to any user:\n\n* Projects\n* Issues\n* Rules\n\n"Quality Profiles" and "Quality Gates" pages will remain restricted to members only - since you might not want to unveil some information used by your private projects.\n'},{path:"sonarcloud/privacy",content:"---\ntitle: Privacy Policy\nurl: /privacy/\n---\n\nThe privacy policy specifies how data collected on this website is used. Thank you for visiting our website and your interest in our services and products. As the protection of your personal data is an important concern for us, we will explain below what information we collect during your visit to our website, as they are processed and whether or how these may be used.\n\n## PERSONAL DATA\n\nPersonal information is data about personal or material circumstances of an identified or identifiable natural person. This includes information such as your first and last name, your postal or residential address, telephone numbers and date of birth. Information that can not be directly related to your real identity – such as your favorite websites or the number of users of a page – are not considered as personal data.\n\n## COLLECTION AND PROCESSING OF PERSONAL DATA\n\nAs the operator and creator of the website, we do not store personal data itself automatically. If you go to our website, the provider – where the web server is hosted – may temporarily store data for the purpose of system security such as the connection of the computer, the web pages you visit, the date and duration of the visit, data about the used browser software and operating system and the web page from which you visit us. In addition to that, personal information such as your name, address, phone number or e-mail will only be stored, if you have provided this information voluntarily, eg. as part of a registration, a survey, a contest, to carry out an order or contract or an information request.\n\n## USE AND DISCLOSURE OF PERSONAL DATA\n\nPersonal data you provided may be used solely for the purpose of technical website administration and to fulfill your wishes and requirements, thus primarily to processing the order with you or to respond to your request. Only if you have previously given your consent or – if stipulated by legal regulations – you entered no objection, we use this data for product surveys and marketing purposes. We don’t share, sell or transfer your personal data to third parties, unless this is necessary for the purpose of the contract or unless you have explicitly consented. For example it may be necessary, that in case of an product order we share your address and order with our suppliers.\n\n## USE OF WEB ANALYSIS SOFTWARE\n\nTo improve the structure and the data we offer on our website, we might use open source or proprietary web analysis software. Our evaluations will be based on summary or averaged information amalgamated for the large numbers of people visiting the vebsite. The data provided by won’t be matched with any individual’s data from other sources.\n\nData collected might include IP, time and duration of the visit, what pages are visited, used browser and add-ons/plugins, search-engines and referrer. While statistic tools might use a “cookie” to distinguish between individual visitors, the collected data doesn’t allow to identify individuals.\n\n## SECURITY\n\nWe take all the necessary technical and organisational security measures to protect your personal data from loss and misuse. Your data is stored in a secure operating environment that is not accessible to the public. If you communicate with us via e-mail, please note that the confidentiality of the information is not guaranteed. The contents of e-mails can be intercepted by third parties. In case of doubt we therefore recommend to send confidential information only by snail mail.\n\n## RIGHT OF ACCESS TO PERSONAL DATA\n\nUpon written request you will be informed by us what information we stored about you (such as name or address).\n\n## CONTACT\n\nIf you have questions regarding the processing of personal data or in case of requests for information, suggestions or complaints, please [contact us](/#sonarcloud#/about/contact) directly.\n"},{path:"sonarcloud/security",content:"---\ntitle: Security Statement\nurl: /security/\n---\n\nWe know that your code is very important to you and your business. We also know that no one wants proven bugs or vulnerabilities found on their source code to be unveiled to third-parties. This is why we take security extremely seriously.\n\n## Hosting\n\nSonarCloud is hosted on Amazon AWS in Frankfurt. \n\n## System security\n\nWe keep system up to date, OS packages are updated at least weekly. SonarCloud is on its own AWS VPC. We have firewall at VPC and VM level.\n\nExcept the Operations team, no SonarSource employee has access to the system, especially the database which stores source code and analysis results.\n\nThe Operations team has access to the system through secured channels (SSH) only. \n\n## Data security\n\nAll the data is stored on a Postgres RDS instance which only the Operation has access to.\n\nIsolation of data per organization is ensured at software level, which secures access to source code to organization members only.\n\nThe source code is not encrypted in the database, but the access to the database is restricted to SonarSource operations team and can be done only through a SSH tunnel.\n\nThe DB is backed up everyday by Amazon RDS mechanism, with 7 days retention.\n\n## Software security\n\nThe Web Application and Web APIs regularly pass penetration testing conducted by a an external company, specialized in cyber and application security, certified in accordance to ISO-27001 and which is also member of the OWASP.\n\n## Communications\n\nAll communications are done over TLS 1.2:\n* Navigating in the Web application\n* Using WS APIs\n* Running analysis (by the scanners) from CI services and pushing analysis reports to SonarCloud\n\n## SonarCloud Webhook IPs\n\nSonarCloud performs webhook calls from the following list of IPs:\n```\n3.120.158.225\n3.121.87.141 \n52.59.209.17\n52.59.246.1\n54.93.180.144\n18.184.94.137\n18.184.195.184 \n18.185.94.218 \n18.194.44.125\n18.194.206.183\n18.194.244.158\n18.195.64.198\n```\n\n## Authentication\n\nPrimary authentication on the system is available only through OAuth authentication with GitHub, Bitbucket Cloud and Microsoft Azure DevOps. As a consequence, users don’t have a password on SonarCloud, and are as protected as what they expect (especially with 2FA activated on those systems). \n \nFor WS API calls or source code analysis triggered from CI services, only revocable user tokens are accepted.\n\n## Payment\n\nWhen you subscribe to the paid plan on SonarCloud, your credit card information never transit through our system nor it gets stored on the server. It's handed off to [Braintree Payment Solutions](https://www.braintreepayments.com), a company dedicated to storing your sensitive data on [PCI-Compliant](http://en.wikipedia.org/wiki/Payment_Card_Industry_Data_Security_Standard) servers.\n"},{path:"sonarcloud/sonarcloud-pricing",content:'---\ntitle: Pricing\nurl: /sonarcloud-pricing/\n---\n\nSubscribing to a paid plan on SonarCloud allows you to analyze unlimited private projects, to know more about all the advantages of a paid plan check our [pricing page](/#sonarcloud#/about/pricing).\n\n## How do I activate the paid plan?\n\nYou can activate the paid plan on the **Administration > Billing** page of your organization.\n\n## How do I get invoices?\n\nYou can download PDF invoices for every payment from the **Administration > Billing** page of your organization.\n\nIf you want to get invoices by email, go to **Administration > Billing > Edit billing info** and check "Send the monthly receipt to this email".\n'},{path:"sonarcloud/supported-languages",content:"---\ntitle: Supported languages\nurl: /analysis/supported-languages/\n---\n\nHere is the list of all the languages currently supported in SonarCloud :\n\n* [ABAP](https://redirect.sonarsource.com/plugins/abap.html)\n* [Apex](https://redirect.sonarsource.com/plugins/apex.html)\n* [C](https://redirect.sonarsource.com/plugins/cpp.html)\n* [C++](https://redirect.sonarsource.com/plugins/cpp.html)\n* [C#](https://redirect.sonarsource.com/plugins/csharp.html)\n* [Objective-C](https://redirect.sonarsource.com/plugins/objectivec.html)\n* [COBOL](https://redirect.sonarsource.com/plugins/cobol.html)\n* [CSS](https://redirect.sonarsource.com/plugins/css.html)\n* [Flex](https://redirect.sonarsource.com/plugins/flex.html)\n* [Go](https://redirect.sonarsource.com/plugins/go.html)\n* [HTML](https://redirect.sonarsource.com/plugins/web.html)\n* [Java](https://redirect.sonarsource.com/plugins/java.html)\n* [JavaScript](https://redirect.sonarsource.com/plugins/javascript.html)\n* [Kotlin](https://redirect.sonarsource.com/plugins/kotlin.html)\n* [PHP](https://redirect.sonarsource.com/plugins/php.html)\n* [PL/SQL](https://redirect.sonarsource.com/plugins/plsql.html)\n* [Python](https://redirect.sonarsource.com/plugins/python.html)\n* [Ruby](https://redirect.sonarsource.com/plugins/ruby.html)\n* [Scala](https://redirect.sonarsource.com/plugins/scala.html)\n* [Swift](https://redirect.sonarsource.com/plugins/swift.html)\n* [TypeScript](https://redirect.sonarsource.com/plugins/typescript.html)\n* [T-SQL](https://redirect.sonarsource.com/plugins/tsql.html)\n* [Visual Basic .NET](https://redirect.sonarsource.com/plugins/vbnet.html)\n* [XML](https://redirect.sonarsource.com/plugins/xml.html)\n"},{path:"user-guide/activity-history",content:"---\ntitle: Activity and History\nurl: /user-guide/activity-history/\n---\n\nThe Project Activity page offers a comprehensive list of the analyses on file for a project (subject to [Housekeeping](/instance-administration/housekeeping/)), and the ability to see the evolution of project measures over time.\n\nGraphs on the activity page help you understand the evolution of up to three measures of your choice against each other. Graph mouseovers show the measure values and events associated with particular analyses.\n\n## Events\nThere are four types of events:\n\n* Quality Gate - the status of the [quality gate](/user-guide/quality-gates/) changed.\n* Profile - the [quality profile](/instance-administration/quality-profiles/) used to analyze the project changed - either the profile was edited, or a different profile was used to analyze the project.\n* Version - the project's version changed.\n* Other - an event was manually created on a snapshot. See [Managing History](/project-administration/managing-project-history/)\n\nEvents are shown on the [project front page](/user-guide/project-page/) and in the project Activity page. \n"},{path:"user-guide/applications",content:"---\ntitle: Applications\nurl: /user-guide/applications/\n---\n\n*Applications are available as part of the [Enterprise Edition](https://redirect.sonarsource.com/editions/enterprise.html) and [above](https://www.sonarsource.com/plans-and-pricing/).*\n\n## Using Applications\n\nAn Application is an aggregation of projects into a synthetic project. Assume you have a set of projects which has been split for technical reasons, but which shares a lifecycle; they interact directly in production and are always released together. With an Application, they can be treated as a single entity in {instance} with a unified Project Homepage, Issues list, Measures space, and most importantly: Quality Gate.\n\n### Applications vs. Portfolios\n\nApplications and Portfolios are both aggregations of projects, but they have different goals and therefore different presentations. A Portfolio is designed to be a very high-level, executive overview that shows how a package of projects that may only be tangentially related are doing quality-wise, and what the trends are. Applications allow you to see your set of projects as a larger, overall meta-project. For instance, because all the projects in an application ship together, if one of them isn't releasable then none of them are, and an Application's consolidated Quality Gate gives you an immediate summary of what must be fixed across all projects in order to allow you to release the set.\n\n## Application Setup\n\nApplications are created and edited in the global Portfolio administration interface: **Administration > Configuration > Portfolios**. For more, see [Configuring Portfolios and Applications](/project-administration/configuring-portfolios-and-applications/). Applications must be created initially by a user with global administration rights, but after set-up, administration of an individual Application can be delegated to other users.\n\n### Populating Application Data\n\nAn Application is automatically re-calculated after each analysis of one of its projects. If you want immediate (re)calculation, a user with administration rights on the Application can use the **Recompute** button in the Application-level **Administration > Edit Definition** interface. The global Portfolio administration interface: **Administration > Configuration > Portfolios** offers the ability to queue re-computation of all Applications and Portfolios at once.\n\n## Applications and Branch Analysis\n\nLong-lived Branches are available for applications. They allow you to aggregate long-lived branches from the projects in an application.\n\nOnce an Application has been set up, anyone with administration rights on the Application can manually create a new branch in the **Administration > Edit Definition** interface. Branches can also be managed from the global **Administration > Configuration > Portfolios** interface. For each Application branch you can choose which project branch should be included, or whether the project should be represented in the branch at all.\n"},{path:"user-guide/built-in-rule-tags",content:"---\ntitle: Built-in Rule Tags\nurl: /user-guide/built-in-rule-tags/\n---\nTags are a way to categorize rules and issues. Issues inherit the tags on the rules that raised them. Some tags are language-specific, but many more appear across languages. Users can add tags to rules and issues, but most rules have some tags out of the box. Here is a non-comprehensive list of what some of those built-in tags mean:\n\n*NOTE : Links below to [rules.sonarsource.com](https://rules.sonarsource.com) will be initially filtered for Java language rules*\n\n* [brain-overload](https://rules.sonarsource.com/java/tag/brain-overload) - there is too much to keep in your head at one time\n* [bad-practice](https://rules.sonarsource.com/java/tag/bad-practice) - the code likely works as designed, but the way it was designed is widely recognized as being a bad idea.\n* [cert](https://rules.sonarsource.com/java/tag/cert) - relates to a rule in a [CERT](https://www.securecoding.cert.org/confluence/x/BgE) standard. There are currently three CERT standards: [C](https://www.securecoding.cert.org/confluence/x/HQE), [C++](https://www.securecoding.cert.org/confluence/x/fQI), and [Java](https://www.securecoding.cert.org/confluence/x/Ux). Many of these rules are not language-specific, but are good programming practices. That's why you'll see this tag on non-C/C++, Java rules.\n* [clumsy](https://rules.sonarsource.com/java/tag/clumsy) - extra steps are used to accomplish something that could be done more clearly and concisely. (E.G. calling .toString() on a String).\n* [confusing](https://rules.sonarsource.com/java/tag/confusing) - will take maintainers longer to understand than is really justified by what the code actually does\n* [convention](https://rules.sonarsource.com/java/tag/convention) - coding convention - typically formatting, naming, whitespace...\n* [cwe](https://rules.sonarsource.com/java/tag/cwe) - relates to a rule in the [Common Weakness Enumeration](http://cwe.mitre.org/). For more on CWE and on security-related rules in general, see [Security-related rules](/user-guide/security-rules/).\n* [design](https://rules.sonarsource.com/java/tag/design) - there is something questionable about the design of the code\n* [lock-in](https://rules.sonarsource.com/java/tag/lock-in) - environment-specific features are used\n* [misra](https://rules.sonarsource.com/java/tag/misra) - relates to a rule in one of the [MISRA](http://www.misra.org.uk/) standards. While the MISRA rules are primarily about C and C++, many of them are not language-specific (E.G. don't use a float as a loop counter) but are simply good programming practices. That's why you'll see these tags on non-C/C++ rules.\n* [owasp](https://rules.sonarsource.com/java/tag/owasp) - relates to a rule in the [OWASP Top Ten](https://www.owasp.org/index.php/Category:OWASP_Top_Ten_Project) security standards. Note, that the OWASP Top Ten is a list of high-level vulnerabilities which translates to many, many potential rules.\n* [pitfall](https://rules.sonarsource.com/java/tag/pitfall) - nothing is wrong yet, but something could go wrong in the future; a trap has been set for the next guy and he'll probably fall into it and screw up the code.\n* [sans-top25](https://rules.sonarsource.com/java/tag/sans-top25) - relates to the [SANS Top 25 Coding Errors](http://www.sans.org/top25-software-errors/), which are security-related. Note that  the SANS Top 25 list is pulled directly from the CWE.\n* [suspicious](https://rules.sonarsource.com/java/tag/suspicious) - it's not guaranteed that this is a **bug**, but it looks suspiciously like one. At the very least, the code should be re-examined & likely refactored for clarity.\n* [unpredictable](https://rules.sonarsource.com/java/tag/unpredictable) - the code may work fine under current conditions, but may fail erratically if conditions change.\n* [unused](https://rules.sonarsource.com/java/tag/unused) - unused code, E.G. a private variable that is never used.\n* [user-experience](https://rules.sonarsource.com/java/tag/user-experience) - there's nothing technically wrong with your code, but it may make some or all of your users hate you.\n"},{path:"user-guide/concepts",content:"---\ntitle: Concepts\nurl: /user-guide/concepts/\n---\n\n\n\x3c!-- sonarqube --\x3e\n## Architecture\n| Concept  | Definition                                                                            |\n| -------- | ------------------------------------------------------------------------------------- |\n| Analyzer | A client application that analyzes the source code to compute **snapshots**.          |\n| Database | Stores configuration and **snapshots**                                                |\n| Server   | Web interface that is used to browse **snapshot** data and make configuration changes | \n\nSee also the [SonarQube Platform Overview](/architecture/architecture-integration/).\n\x3c!-- /sonarqube --\x3e\n\n## Quality\n| Concept                    | Definition                                                                                                                                                                                                                                                                                                                                                                                                         |\n| -------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |\n| Bug                        | An issue that represents something wrong in the code. If this has not broken yet, it will, and probably at the worst possible moment. This needs to be fixed. Yesterday.                                                                                                                                                                                                                                           |\n| Code Smell                 | A maintainability-related issue in the code. Leaving it as-is means that at best maintainers will have a harder time than they should making changes to the code. At worst, they'll be so confused by the state of the code that they'll introduce additional errors as they make changes.                                                                                                                         |\n| Cost                       | See Remediation Cost                                                                                                                                                                                                                                                                                                                                                                                               |\n| Debt                       | See Technical Debt                                                                                                                                                                                                                                                                                                                                                                                                 |\n| Issue                      | When a piece of code does not comply with a rule, an issue is logged on the **snapshot**. An issue can be logged on a source file or a unit test file. There are 3 types of issue: **Bugs**, **Code Smells** and **Vulnerabilities**                                                                                                                                                                    |\n| Measure                    | The value of a **metric** for a given file or project at a given time. For example, 125 lines of code on class MyClass or density of duplicated lines of 30.5% on project myProject                                                                                                                                                                                                                                  |\n| Metric                     | A type of measurement. Metrics can have varying values, or **measures**, over time. Examples: number of lines of code, complexity, etc. A metric may be either _qualitative_ (gives a quality indication on the component, E.G. density of duplicated lines, line coverage by tests, etc.) or _quantitative_ (does not give a quality indication on the component, E.G. number of lines of code, complexity, etc.) |\n| New Code Period                | The period for which you're keeping a close watch on the introduction of new problems in the code. Ideally this is since the `previous_version`, but if you don't use a Maven-like versioning scheme you may need to set a relatively arbitrary time period such as 21 days or since a specific date.                                                                                                            |\n| Quality Profile            | A set of **rules**. Each **snapshot** is based on a single quality profile. See also [Quality Profiles](/instance-administration/quality-profiles/)                                                                                                                                                                                                                                                         | \n| Rule                | A coding standard or practice which should be followed. Not complying with coding rules leads to **Bugs**, **Vulnerabilities**, **Security Hotspots**, and **Code Smells**. Rules can check quality on code files or unit tests.                                                                                                                                                                                                                                 |\n| Remediation Cost           | The estimated time required to fix Vulnerability and Reliability Issues.                                                                                                                                                                                                                                                                                                                                           |\n| Snapshot                   | A set of **measures** and **issues** on a given project at a given time. A snapshot is generated for each analysis.                                                                                                                                                                                                                                                                                          |\n| Security Hotspot           | A security-related issue highlighting a piece of code that uses a security-sensitive API (E.G. use of a weak algorithm, connection to a database without a password, ...). Security hotspots must be reviewed by a security auditor who may determine that the APIs are used in ways that introduce Vulnerabilities.                                                                                               |\n| Technical Debt             | The estimated time required to fix all Maintainability Issues / code smells                                                                                                                                                                                                                                                                                                                                        |\n| Vulnerability              | A security-related issue which represents a backdoor for attackers. See also [Security-related rules](/user-guide/security-rules/).                                                                                                                                                                                                                                                                                |\n"},{path:"user-guide/fixing-the-water-leak",content:"---\ntitle: Fixing the Water Leak\nurl: /user-guide/fixing-the-water-leak/\n---\n\n## What is the Water Leak\n\nImagine you come home one day to find a puddle of water on the kitchen floor. As you watch, the puddle slowly gets larger.\n\nDo you reach for the mop? Or do you try to find the source and fix it? The choice is obvious, right? You find the source of the leak!\n\nSo why do anything different with code quality? When you analyze an application with {instance} and realize that it has a lot of technical debt, the knee-jerk reaction is generally to start remediating – either that or put together a remediation plan. This is like mopping the floor once a day while ignoring the source of the water.\n\nTypically in this traditional approach, just before release a periodic code quality audit result in findings the developers should act on before releasing. This approach might work in the short term, especially with strong management backing, but it consistently fails in the mid to long run, because:\n\n* The code review comes too late in the process, and no stakeholder is keen to get the problems fixed; everyone wants the new version to ship.\n* Developers typically push back on the recommendations made by an external team that doesn't know the context of the project. And by the way the code under review is obsolete already.\n* There is a clear lack of ownership for code quality with this approach. Who owns quality? No one!\n* What gets reviewed is the entire application before it goes to production and it is obviously not possible to apply the same criteria to all applications. A negotiation will happen for each project, which will drain all credibility from the process\n\nInstead, why not apply the same simple logic you use at home to the way you manage code quality? Fixing the leak means putting the focus on the “new” code, i.e. the code that was added or changed since the last release. Then things get much easier:\n\n* The [Quality Gate](/user-guide/quality-gates/) can be run every day, and passing it is achievable. There are no surprises at release time.\n* It's pretty difficult for developers to push back on problems they introduced the previous day. Instead, they're generally happy to fix the problems while the code is still fresh.\n* There is a clear ownership of code quality\n* The criteria for go/no-go are consistent across applications, and are shared among teams. Indeed new code is new code, regardless of which application it is done in\n* The cost is insignificant because it is part of the development process\n\nAs a bonus, the code that gets changed the most has the highest maintainability, and the code that doesn't get changed has the lowest, which makes a lot of sense. Because of the nature of software, and the fact that we keep making changes to it, the debt will naturally be reduced. Where it isn’t is where it doesn't need to be.\n\n## How to do it\n\n\x3c!-- sonarqube --\x3eSonarQube\x3c!-- /sonarqube --\x3e\x3c!-- sonarcloud --\x3eSonarCloud\x3c!-- /sonarcloud --\x3e offers two main tools to help you find your leaks:\n\n* New Code metrics show the variance in your measures between the current code and a specific point you choose in its history, typically the `previous_version`\n* New Code is primarily detected based on SCM \"blame\" data starting from the first analysis within your New Code Period (formerly the \"Leak Period\"), with fallback mechanisms when needed. See [SCM integration](/analysis/scm-integration/) for more details.\n* [Quality Gates](/user-guide/quality-gates/) allow you to set boolean thresholds against which your code is measured. Use them with differential metrics to ensure that your code quality moves in the right direction over time.\n"},{path:"user-guide/issues",content:"---\ntitle: Issues\nurl: /user-guide/issues/\n---\n\n## Table of Contents\n\nWhile running an analysis, {instance} raises an issue every time a piece of code breaks a coding rule. The set of coding rules is defined through the associated [quality profile](/instance-administration/quality-profiles/) for each language in the project. \n\nEach issue has one of five severities:\n\n1. **BLOCKER**  \nBug with a high probability to impact the behavior of the application in production: memory leak, unclosed JDBC connection, .... The code MUST be immediately fixed.\n1. **CRITICAL**  \nEither a bug with a low probability to impact the behavior of the application in production or an issue which represents a security flaw: empty catch block, SQL injection, ... The code MUST be immediately reviewed. \n1. **MAJOR**  \nQuality flaw which can highly impact the developer productivity: uncovered piece of code, duplicated blocks, unused parameters, ...\n1. **MINOR**  \nQuality flaw which can slightly impact the developer productivity: lines should not be too long, \"switch\" statements should have at least 3 cases, ...\n1. **INFO**  \nNeither a bug nor a quality flaw, just a finding.\n\nIdeally, the team wouldn't introduce any new issues (any new technical debt). [SonarLint](https://sonarlint.org) can help developers because it provides the ability to perform local analyses to check their code before pushing it back to the SCM. But in real life, it's not always possible to code without any new technical debt, and sometimes it's not worth it.\n\nSo new issues get introduced.\n\n## Understanding issue context\nSometimes, issues are self-evident once they're pointed out. For instance, if your team has agreed to a init-lower, camelCase variable naming convention, and an issue is raised on `My_variable`, you don't need a lot of context to understand the problem. But in other situations context may be essential to understanding why an issue was raised. That's why {instance} supports not just the primary issue location, where the issue message is shown, but also secondary issue locations. For instance, secondary issues locations are used to mark the pieces of code in a method which add Cognitive Complexity to a method. \n\nBut there are times when a simple laundry list of contributing locations isn't enough to understand an issue. For instance, when a null pointer can be dereferenced on some paths through the code, what you really need are issue flows. Each flow is a _set_ of secondary locations ordered to show the exact path through the code on which a problem can happen. And because there can be multiple paths through the code on which, for instance a resource is not released, {instance} supports multiple flows.\n\n\n## Lifecycle of Code Smell, Bug, and Vulnerability Issues\n### Statuses\nAfter creation, issues flow through a lifecycle, taking one of five possible statuses:\n\n* **Open** - set by {instance} on new issues\n* **Confirmed** - set manually to indicate that the issue is valid\n* **Resolved** - set manually to indicate that the next analysis should Close the issue\n* **Reopened** - set automatically by {instance} when a Resolved issue hasn't actually been corrected\n* **Closed** - set automatically by {instance} for automatically created issues. \n\n### Resolutions\nClosed issues will have one of two resolutions:\n\n* **Fixed** - set automatically when a subsequent analysis shows that the issue has been corrected or the file is no longer available (removed from the project, excluded or renamed)\n* **Removed** - set automatically when the related rule is no longer available. The rule may not be available either because it has been removed from the Quality Profile or because the underlying plugin has been uninstalled.\n\nResolved issues will have one of two resolutions:\n* **False Positive** - set manually\n* **Won't Fix** - set manually\n\n### Issue Workflow \nIssues are automatically closed (status: Closed) when:\n* an issue (of any status) has been properly fixed => Resolution: Fixed\n* an issue no longer exists because the related coding rule has been deactived or is no longer available (ie: plugin has been removed) => Resolution: Removed\n\nIssues are automatically reopened (status: Reopened) when:\n* an issue that was manually Resolved as Fixed(but Resolution is not False positive) is shown by a subsequent analysis to still exist\n\n### Security Hotspot Issue Lifecycle\nSecurity Hotspot issues have a dedicated lifecycle. They aren't considered actionable, and must be reviewed by a user with the \"Administer Security Hotspots\" permission. \n\n## Lifecycle of Security Hotspot Issues\nSecurity Hotspot issues have a dedicated lifecycle. They aren't considered actionable, and must be reviewed by a user with the \"Administer Security Hotspots\" permission. \n\n### Statuses\nAfter creation, Security Hotspot issues flow through a dedicated lifecycle, taking one of four possible statuses:\n\n* **Open** - set by {instance} on new issues\n* **Resolved** (Won't Fix) - set automatically by {instance} when a Security Auditor Accepts the fix done by a developer on a Manual Vulnerability or when an Open Hotspot or Manual Vulnerability is Cleared by a Security Auditor.\n* **To Review** - set automatically when a developer requests a security auditor to Review the fix she has done on a Manual Vulnerability\n* **Reopened** - set when a developer Dismisses an Open Manual Vulnerability or when a Security Auditor manually reopens issues in order to run a new audit on already Resolved issues\n\nSecurity Hotspot issues are only ever closed if the code containing the Security Hotspot is deleted.  A Security Hotspot may also become Removed if the rule which identified the hotspot is removed from the project's Quality Profile.\n\n## Understanding which Issues are \"New\"\nTo determine the creation date of an issue, an algorithm is executed during each analysis to determine whether an issue is new or existed previously. This algorithm relies on content hashes (excluding whitespace) for the line the issue is reported on. For multi-line issues, the hash of the first line is used. For each file (after detection of file renaming), the algorithm takes the base list of issues from the previous analysis, and tries to match those issues with the raw issue list reported by the new analysis. The algorithm tries to first match using the strongest evidence, and then falls back to weaker heuristics.\n\n* if the issue is on the same rule, with the same line number and with the same line hash (but not necessarily with the same message) > MATCH\n* detect block move inside file, then if the issue is on the same (moved) line and on the same rule (but not necessarily with the same message) > MATCH\n* on the same rule, with the same message and with the same line hash (but not necessarily with the same line) > MATCH\n* on the same rule, with the same message and with the same line number (but not necessarily with the same line hash) > MATCH\n* on the same rule and with the same line hash (but not the same message and not the same line) > MATCH\n* is there a matching **CLOSED** issue > MATCH and Reopen\n\nUnmatched \"base\" issues are closed as fixed.\n\nUnmatched \"raw\" issues are new.\n\n## Understanding Issue Backdating\nOnce an issue has been determied to be \"new\", as described above, the next question is what date to give it. For instance, what if it has existed in code for a long time, but only found in the most recent analysis because new rules were added to the profile? Should this issue be given the date of the last change on its line, or the date of the analysis where it was first raised? That is, should it be backdated? If the date of the last change to the line is available (this requires [SCM integration](/analysis/scm-integration/)) then under certain circumstances, the issue will be backdated:\n\n* On first analysis of a project or branch\n* When the rule is new in the profile (a brand new rule activated or a rule that was deactivated and is now activated)\n* When the analyzer has just been upgraded (because rule implementations could be smarter now)\n* When the rule is external\n\nAs a consequence, it is possible that backdating will keep newly raised issues out of the New Code Period.\n\n\n## Automatic Issue Assignment\n### For Bug, Vulnerability and Code Smell\nNew issues are automatically assigned during analysis to the last committer on the issue line if the committer can be correlated to a {instance} user. Note that currently, issues on any level above a file, e.g. directory / project, cannot be automatically assigned.\n\n### For Security Hotspot\nIssues are automatically assigned only when the Security Hotspot is transformed into a Vulnerability through the \"Detect\" action.\n\n### User Correlation\nLogin and email correlations are made automatically. I.e. if the user commits with her email address and that email address is part of her {instance} profile, then new issues raised on lines where she was the last committer will be automatically assigned to her.\n\nAdditional correlations can be made manually in the user's profile (see \"SCM accounts\" in Authorization for more).\n\n### Known Limitation\nIf the SCM login associated with an issue is longer than 255 characters allowed for an issue author, the author will be left blank.\n\n## Issue edits\n{instance}'s issues workflow can help you manage your issues. There are seven different things you can do to an issue (other than fixing it in the code!): Comment, Assign, Confirm, Change Severity, Resolve, Won't Fix, and False Positive.\n\nThese actions break out into three different categories. First up is the \"technical review\" category.\n\n### Technical Review\nThe Confirm, False Positive, Won't Fix, Severity change, and Resolve actions all fall into this category, which presumes an initial review of an issue to verify its validity. Assume it's time to review the technical debt added in the last review period - whether that's a day, a week, or an entire sprint. You go through each new issue and do one:\n\n* **Confirm** - By confirming an issue, you're basically saying \"Yep, that's a problem.\" Doing so moves it out of \"Open\" status to \"Confirmed\".\n* **False Positive** - Looking at the issue in context, you realize that for whatever reason, this issue isn't actually a problem. So you mark it False Positive and move on. Requires Administer Issues permission on the project.\n* **Won't Fix** - Looking at the issue in context, you realize that while it's a valid issue it's not one that actually needs fixing. In other words, it represents accepted technical debt. So you mark it Won't Fix and move on. Requires Administer Issues permission on the project.\n* **Severity change** - This is the middle ground between the first two options. Yes, it's a problem, but it's not as bad a problem as the rule's default severity makes it out to be. Or perhaps it's actually far worse. Either way, you adjust the severity of the issue to bring it in line with what you feel it deserves.  Requires Administer Issues permission on the project.\n* **Resolve** - If you think you've fixed an open issue, you can Resolve it. If you're right, the next analysis will move it to closed status. If you're wrong, its status will go to re-opened.\n\nAdditionally, Security Hotspots allow the following:\n\n* **Detect** - Confirms a Security Hotspot as a true issue and manually opens a Vulnerability. Requires Administer Security Hotspots on the project.\n* **Clear** - Marks a Security Hotspot or manually opened Vulnerability as being without issue and shouldn't be fixed. Requires Administer Security Hotspots on the project.\n* **Request Review** - Request that a Security Auditor review changes made to remediate a manually opened Vulnerability.\n* **Reject** - After review ,reject the remediation for a manually opened Vulnerability and return it to an open issue. Requires Administer Security Hotspots on the project.\n\nIf you tend to mark a lot of issues False Positive or Won't Fix, it means that some coding rules are not appropriate for your context. So, you can either completely deactivate them in the quality profile or use issue exclusions to narrow the focus of the rules so they are not used on specific parts (or types of object) of your application. Similarly, making a lot of severity changes should prompt you to consider updating the rule severities in your profiles.\n\nAs you edit issues, the related metrics (e.g. New Bugs), will update automatically, as will the Quality Gate status if it's relevant.\n\n### Dispositioning\nOnce issues have been through technical review, it's time to decide who's going to deal them. By default they're assigned to the last committer on the issue line (at the time the issue is raised), but you can certainly reassign them to yourself or someone else. The assignee will receive email notification of the assignment if he signed up for notifications, and the assignment will show up everywhere the issue is displayed, including in the My Issues list in the My Account space.\n\n### General\nAt any time during the lifecycle of an issue, you can log a comment on it. Comments are displayed in the issue detail in a running log. You have the ability to edit or delete the comments you made.\n\nYou can also edit an issue's tags. Issues inherit the tags of the rules that created them, but the tag set on an issue is fully editable. Tags can be created, added and removed at will for users with the Browse permission on the project.\n\nAlthough they are initially inherited from the relevant rule, the tags on an issue are not synchronized with the rule, so adding tags to a rule will not add those tags to the rule's issues. \n\n### Bulk Change\nAll of these changes and more can be made to multiple issues at once using the Bulk Change option in the issues search results pane.\n\n\n## Purging Closed Issues\nBy default, Closed issues are kept for 30 days. For more details, see [Housekeeping](/instance-administration/housekeeping/).\n\n"},{path:"user-guide/keyboard-shortcuts",content:"---\ntitle: Keyboard Shortcuts\nurl: /user-guide/keyboard-shortcuts/\n---\n\n## Global\n\n| Shortcut | Action          |\n| -------- | --------------- |\n| `s`      | open search bar |\n| `?`      | open help       |\n\n## Code Page\n\n| Shortcut | Action                                        |\n| -------- | --------------------------------------------- |\n| `↑` `↓`  | select files                                  |\n| `→`      | open file                                     |\n| `←`      | return back to the list                       |\n\n## Issues Page\n\n| Shortcut         | Action                                        |\n| ---------------- | --------------------------------------------- |\n| `↑` `↓`          | navigate between issues                       |\n| `→`              | go from the list of issues to the source code |\n| `←`              | return back to the list                       |\n| `alt` + `↑` `↓`  | to navigate issue locations                   |\n| `alt` + `←` `→`  | to switch flows                               |\n| `f`              | do an issue transition                        |\n| `a`              | assign issue                                  |\n| `m`              | assign issue to the current user              |\n| `i`              | change severity of issue                      |\n| `c`              | comment issue                                 |\n| `ctrl` + `enter` | submit comment                                |\n| `t`              | change tags of issue                          |\n\n## Measures Page\n\n| Shortcut | Action                                        |\n| -------- | --------------------------------------------- |\n| `↑` `↓`  | select files                                  |\n| `→`      | open file                                     |\n| `←`      | return back to the list                       |\n\n## Rules Page\n\n| Shortcut | Action                                        |\n| -------- | --------------------------------------------- |\n| `↑` `↓`  | navigate between rules                        |\n| `→`      | go from the list of rules to the rule details |\n| `←`      | return back to the list                       |\n"},{path:"user-guide/metric-definitions",content:"---\ntitle: Metric Definitions\nurl: /user-guide/metric-definitions/\n---\n\n## Table of Contents\n\n   \n## Complexity\n**Complexity** (`complexity`)  \nIt is the Cyclomatic Complexity calculated based on the number of paths through the code. Whenever the control flow of a function splits, the complexity counter gets incremented by one. Each function has a minimum complexity of 1. This calculation varies slightly by language because keywords and functionalities do.\n\n[[collapse]]\n| ## Language-specific details\n| Language | Notes\n| ---|---\n| ABAP | The following keywords increase the complexity by one: `AND`, `CATCH`, `CONTINUE`, `DO`, `ELSEIF`, `IF`, `LOOP`, `LOOPAT`, `OR`, `PROVIDE`, `SELECT…ENDSELECT`, `TRY`, `WHEN`, `WHILE`\n| C/C++/Objective-C | The complexity gets incremented by one for: function definitions, `while`, `do while`, `for`, `throw` statements, `switch`, `case`, `default`, `&&` operator, `||` operator, `?` ternary operator, `catch`, `break`, `continue`, `goto`.\n| COBOL | The following commands increase the complexity by one (except when they are used in a copybook): `ALSO`, `ALTER`, `AND`, `DEPENDING`, `END_OF_PAGE`, `ENTRY`, `EOP`, `EXCEPTION`, `EXIT`, `GOBACK`, `CONTINUE`, `IF`, `INVALID`, `OR`, `OVERFLOW`, `SIZE`, `STOP`, `TIMES`, `UNTIL`, `USE`, `VARYING`, `WHEN`, `EXEC CICS HANDLE`, `EXEC CICS LINK`, `EXEC CICS XCTL`, `EXEC CICS RETURN`\n| Java | Keywords incrementing the complexity: `if`, `for`, `while`, `case`, `catch`, `throw`, `&&`, `||`, `?`\n| JavaScript, PHP | Complexity is incremented by one for each: function (i.e non-abstract and non-anonymous constructors, functions, procedures or methods), `if`, short-circuit (AKA lazy) logical conjunction (`&&`), short-circuit (AKA lazy) logical disjunction (`||`), ternary conditional expressions, loop, `case` clause of a `switch` statement, `throw` and `catch` statement, `go to` statement (only for PHP)\n| PL/I | The following keywords increase the complexity by one: `PROC`, `PROCEDURE`, `GOTO`, `GO TO`, `DO`, `IF`, `WHEN`, `|`, `!`, `|=`, `!=`, `&`, `&=`\n| PL/SQL | The complexity gets incremented by one for: the main PL/SQL anonymous block (not inner ones), create procedure, create trigger, procedure_definition, basic loop statement, when_clause_statement (the “when” of simple_case_statement and searched_case_statement), continue_statement, cursor_for_loop_statement, continue_exit_when_clause (The “WHEN” part of the continue and exit statements), exception_handler (every individual “WHEN”), exit_statement, for_loop_statement, forall_statement, if_statement, elsif_clause, raise_statement, return_statement, while_loop_statement, and_expression (“and” reserved word used within PL/SQL expressions), or_expression (“or” reserved word used within PL/SQL expressions), when_clause_expression (the “when” of simple_case_expression and searched_case_expression)\n| VB.NET | The complexity gets incremented by one for: method or constructor declaration (Sub, Function), `AndAlso`, `Case`, `Continue`, `End`, `Error`, `Exit`, `If`, `Loop`, `On Error`, `GoTo`, `OrElse`, `Resume`, `Stop`, `Throw`, `Try`.\n\n**Cognitive Complexity** (`cognitive_complexity`)  \nHow hard it is to understand the code's control flow. See [the Cognitive Complexity White Paper](https://www.sonarsource.com/resources/white-papers/cognitive-complexity.html) for a complete description of the mathematical model applied to compute this measure.\n\n---\n## Duplications\n**Duplicated blocks** (`duplicated_blocks`)  \nNumber of duplicated blocks of lines.\n\n[[collapse]]\n| ## Language-specific details\n| For a block of code to be considered as duplicated:\n|\n| Non-Java projects:  \n| * There should be at least 100 successive and duplicated tokens.\n| * Those tokens should be spread at least on:\n| * 30 lines of code for COBOL\n| * 20 lines of code for ABAP\n| * 10 lines of code for other languages\n|\n|Java projects:  \n| There should be at least 10 successive and duplicated statements whatever the number of tokens and lines. Differences in indentation and in string literals are ignored while detecting duplications.\n \n**Duplicated files** (`duplicated_files`)  \nNumber of files involved in duplications.\n\n**Duplicated lines** (`duplicated_lines`)  \nNumber of lines involved in duplications.\n\n**Duplicated lines (%)** (`duplicated_lines_density`)  \n= `duplicated_lines` / `lines` * 100\n\n---\n## Issues\n**New issues** (`new_violations`)  \nNumber of issues raised for the first time in the New Code period.\n\n**New xxx issues** (`new_xxx_violations`)  \nNumber of issues of the specified severity raised for the first time in the New Code period, where xxx is one of: `blocker`, `critical`, `major`, `minor`, `info`.\n\n**Issues** (`violations`)  \nTotal count of issues in all states.\n\n**xxx issues** (`xxx_issues`)  \nTotal count of issues of the specified severity, where xxx is one of: `blocker`, `critical`, `major`, `minor`, `info`.\n\n**False positive issues** (`false_positive_issues`)  \nTotal count of issues marked False Positive\n\n**Open issues** (`open_issues`)  \nTotal count of issues in the Open state.\n\n**Confirmed issues** (`confirmed_issues`)  \nTotal count of issues in the Confirmed state.\n\n**Reopened issues** (`reopened_issues`)  \nTotal count of issues in the Reopened state\n\n---\n## Maintainability\n**Code Smells** (`code_smells`)   \nTotal count of Code Smell issues.\n\n**New Code Smells** (`new_code_smells`)  \nTotal count of Code Smell issues raised for the first time in the New Code period.\n\n**Maintainability Rating** (`sqale_rating`)  \n(Formerly the SQALE rating.)\nRating given to your project related to the value of your Technical Debt Ratio. The default Maintainability Rating grid is:\n\nA=0-0.05, B=0.06-0.1, C=0.11-0.20, D=0.21-0.5, E=0.51-1\n\nThe Maintainability Rating scale can be alternately stated by saying that if the outstanding remediation cost is:\n\n* <=5% of the time that has already gone into the application, the rating is A\n* between 6 to 10% the rating is a B\n* between 11 to 20% the rating is a C\n* between 21 to 50% the rating is a D\n* anything over 50% is an E\n\n**Technical Debt** (`sqale_index`)  \nEffort to fix all Code Smells. The measure is stored in minutes in the database. An 8-hour day is assumed when values are shown in days.\n\n**Technical Debt on New Code** (`new_technical_debt`)  \nEffort to fix all Code Smells raised for the first time in the New Code period.\n\n**Technical Debt Ratio** (`sqale_debt_ratio`)  \nRatio between the cost to develop the software and the cost to fix it. The Technical Debt Ratio formula is:  \n\t`Remediation cost / Development cost`  \nWhich can be restated as:  \n\t`Remediation cost / (Cost to develop 1 line of code * Number of lines of code)`  \nThe value of the cost to develop a line of code is 0.06 days.\n\n**Technical Debt Ratio on New Code** (`new_sqale_debt_ratio`)  \nRatio between the cost to develop the code changed in the New Code period and the cost of the issues linked to it.\n\n---\n## Quality Gates\n**Quality Gate Status** (`alert_status`)  \nState of the Quality Gate associated to your Project. Possible values are : `ERROR`, `OK`\nWARN value has been removed since 7.6.\n\n**Quality Gate Details** (`quality_gate_details`)  \nFor all the conditions of your Quality Gate, you know which condition is failing and which is not.\n\n---\n## Reliability\n**Bugs** (`bugs`)  \nNumber of bug issues.\n\n**New Bugs** (`new_bugs`)  \nNumber of new bug issues.\n\n**Reliability Rating** (`reliability_rating`)  \nA = 0 Bugs  \nB = at least 1 Minor Bug  \nC = at least 1 Major Bug  \nD = at least 1 Critical Bug  \nE = at least 1 Blocker Bug  \n\n**Reliability remediation effort** (`reliability_remediation_effort`)  \nEffort to fix all bug issues. The measure is stored in minutes in the DB. An 8-hour day is assumed when values are shown in days.\n\n**Reliability remediation effort on new code** (`new_reliability_remediation_effort`)  \nSame as _Reliability remediation effort_ but on the code changed in the New Code period.\n\n---\n## Security\n**Vulnerabilities** (`vulnerabilities`)  \nNumber of vulnerability issues.\n\n**New Vulnerabilities** (`new_vulnerabilities`)  \nNumber of new vulnerability issues.\n\n**Security Rating** (`security_rating`)  \nA = 0 Vulnerabilities  \nB = at least 1 Minor Vulnerability  \nC = at least 1 Major Vulnerability  \nD = at least 1 Critical Vulnerability  \nE = at least 1 Blocker Vulnerability  \n\n**Security remediation effort** (`security_remediation_effort`)  \nEffort to fix all vulnerability issues. The measure is stored in minutes in the DB. An 8-hour day is assumed when values are shown in days.\n\n**Security remedation effort on new code** (`new_security_remediation_effort`)  \nSame as _Security remediation effort_ but on the code changed in the New Code period.\n\n---\n## Size\n**Classes** (`classes`)  \nNumber of classes (including nested classes, interfaces, enums and annotations).\n\n**Comment lines** (`comment_lines`)  \nNumber of lines containing either comment or commented-out code.\n\nNon-significant comment lines (empty comment lines, comment lines containing only special characters, etc.) do not increase the number of comment lines.\n\nThe following piece of code contains 9 comment lines:\n```\n/**                                    +0 => empty comment line\n *                                     +0 => empty comment line\n * This is my documentation            +1 => significant comment\n * although I don't                    +1 => significant comment\n * have much                           +1 => significant comment\n * to say                              +1 => significant comment\n *                                     +0 => empty comment line\n ***************************           +0 => non-significant comment\n *                                     +0 => empty comment line\n * blabla...                           +1 => significant comment\n */                                    +0 => empty comment line\n  \n/**                                    +0 => empty comment line\n * public String foo() {               +1 => commented-out code\n *   System.out.println(message);      +1 => commented-out code\n *   return message;                   +1 => commented-out code\n * }                                   +1 => commented-out code\n */                                    +0 => empty comment line\n ```\n[[collapse]]\n| ## Language-specific details\n| Language | Note\n| ---|---\n| COBOL | Lines containing the following instructions are counted both as comments and lines of code: `AUTHOR`, `INSTALLATION`, `DATE-COMPILED`, `DATE-WRITTEN`, `SECURITY`.\n| Java | File headers are not counted as comment lines (becuase they usually define the license).\n\n**Comments (%)** (`comment_lines_density`)  \nDensity of comment lines = Comment lines / (Lines of code + Comment lines) * 100\n\nWith such a formula:\n* 50% means that the number of lines of code equals the number of comment lines  \n* 100% means that the file only contains comment lines  \n\n**Directories** (`directories`)  \nNumber of directories.\n\n**Files** (`files`)  \nNumber of files.\n\n**Lines** (`lines`)  \nNumber of physical lines (number of carriage returns).\n\n**Lines of code** (`ncloc`)  \nNumber of physical lines that contain at least one character which is neither a whitespace nor a tabulation nor part of a comment.\n[[collapse]]\n| ## Language-specific details\n| Language | Note\n| --- | ---\n| COBOL | Generated lines of code and pre-processing instructions (`SKIP1`, `SKIP2`, `SKIP3`, `COPY`, `EJECT`, `REPLACE`) are not counted as lines of code.\n\n**Lines of code per language** (`ncloc_language_distribution`)  \nNon Commenting Lines of Code Distributed By Language\n\n**Functions** (`functions`)  \nNumber of functions. Depending on the language, a function is either a function or a method or a paragraph.\n[[collapse]]\n| ## Language-specific details\n| Language | Note\n| ---|---\n| COBOL | It is the number of paragraphs.\n| Java | Methods in anonymous classes are ignored.\n| VB.NET | Accesors are not considered to be methods.\n\n**Projects** (`projects`)  \nNumber of projects in a Portfolio.\n\n**Statements** (`statements`)  \nNumber of statements.\n\n---\n## Tests\n**Condition coverage** (`branch_coverage`)  \nOn each line of code containing some boolean expressions, the condition coverage simply answers the following question: 'Has each boolean expression been evaluated both to true and false?'. This is the density of possible conditions in flow control structures that have been followed during unit tests execution.\n\n`Condition coverage = (CT + CF) / (2*B)`   \nwhere  \n* CT = conditions that have been evaluated to 'true' at least once\n* CF = conditions that have been evaluated to 'false' at least once\n* B = total number of conditions\n\n**Condition coverage on new code** (`new_branch_coverage`)  \nIdentical to Condition coverage but restricted to new / updated source code.\n\n**Condition coverage hits** (`branch_coverage_hits_data`)  \nList of covered conditions.\n\n**Conditions by line** (`conditions_by_line`)  \nNumber of conditions by line.\n\n**Covered conditions by line** (`covered_conditions_by_line`)  \nNumber of covered conditions by line.\n\n**Coverage** (`coverage`)  \nIt is a mix of Line coverage and Condition coverage. Its goal is to provide an even more accurate answer to the following question: How much of the source code has been covered by the unit tests?\n\n`Coverage = (CT + CF + LC)/(2*B + EL)`  \nwhere  \n* CT = conditions that have been evaluated to 'true' at least once\n* CF = conditions that have been evaluated to 'false' at least once\n* LC = covered lines = lines_to_cover - uncovered_lines\n* B = total number of conditions\n* EL = total number of executable lines (`lines_to_cover`)\n\n**Coverage on new code** (`new_coverage`)  \nIdentical to Coverage but restricted to new / updated source code.\n\n**Line coverage** (`line_coverage`)  \nOn a given line of code, Line coverage simply answers the following question: Has this line of code been executed during the execution of the unit tests?. It is the density of covered lines by unit tests:\n\n`Line coverage = LC / EL`  \nwhere\n* LC = covered lines (`lines_to_cover` - `uncovered_lines`)\n* EL = total number of executable lines (`lines_to_cover`)\n\n**Line coverage on new code** (`new_line_coverage`)  \nIdentical to Line coverage but restricted to new / updated source code.\n\n**Line coverage hits** (`coverage_line_hits_data`)  \nList of covered lines.\n\n**Lines to cover** (`lines_to_cover`)  \nNumber of lines of code which could be covered by unit tests (for example, blank lines or full comments lines are not considered as lines to cover).\n\n**Lines to cover on new code** (`new_lines_to_cover`)  \nIdentical to Lines to cover but restricted to new / updated source code.\n\n**Skipped unit tests** (`skipped_tests`)  \nNumber of skipped unit tests.\n\n**Uncovered conditions** (`uncovered_conditions`)  \nNumber of conditions which are not covered by unit tests.\n\n**Uncovered conditions on new code** (`new_uncovered_conditions`)  \nIdentical to Uncovered conditions but restricted to new / updated source code.\n\n**Uncovered lines** (`uncovered_lines`)  \nNumber of lines of code which are not covered by unit tests.\n\n**Uncovered lines on new code** (`new_uncovered_lines`)  \nIdentical to Uncovered lines but restricted to new / updated source code.\n\n**Unit tests** (`tests`)  \nNumber of unit tests.\n\n**Unit tests duration** (`test_execution_time`)  \nTime required to execute all the unit tests.\n\n**Unit test errors** (`test_errors`)  \nNumber of unit tests that have failed.\n\n**Unit test failures** (`test_failures`)  \nNumber of unit tests that have failed with an unexpected exception.\n\n**Unit test success density (%)** (`test_success_density`)  \n`Test success density = (Unit tests - (Unit test errors + Unit test failures)) / Unit tests * 100`\n"},{path:"user-guide/portfolios",content:'---\ntitle: Portfolios\nurl: /user-guide/portfolios/\n---\n\n*Portfolios are available as part of the [Enterprise Edition](https://redirect.sonarsource.com/editions/enterprise.html) and [above](https://www.sonarsource.com/plans-and-pricing/).*\n\n### Portfolios Home Page\n\nThe Portfolio Home Page is the central place for managers and tech leads to keep an eye on the Releasability of the projects under their supervision. Releasability is based on the project\'s quality gate: green (pass) is releasable. Red (error) is not. Each Portfolio home page offers an aggregate view of the releasability of all the projects in the Portfolio.\n\nAt the top of the page, you can easily see whether overall Portfolio is currently rated as releasable and if any projects in the Portfolio have failed their Quality Gate. And the Reliability, Security, and Maintainability ratings show the overall health of the Portfolio in these three domains, along with an indicator of the worst-performing project(s) in each domain.\n\nFor each domain you see:\n\n* the rating (see [Metric Definitions](/user-guide/metric-definitions/) for more details about how they are computed)\n* an indicator of when the rating last changed\n* an indicator of the worst-performing project(s) in the domain\n\n### Releasability Rating\n\nThe Releasability Rating tells you the ratio of projects in the Portfolio that do NOT have a **FAILED** Quality Gate (ie QG being **PASSED**) :\n\n**A**: > 80%  \n**B**: > 60%  \n**C**: > 40%  \n**D**: > 20%  \n**E**: <= 20%  \n\n### Reliability, Security and Maintainability Ratings\n\nEach of the Reliability, Security and Maintainability Ratings for a Portfolio is calculated as the average of the ratings for all projects included in the Portfolio. SonarQube converts the rating for each project to a number (see conversion table below), calculates an average for the portfolio and converts that average back to a rating. Averages that land exactly on the 0.5 mark are rounded up (i.e. the result is the "lower" of the two possible ratings, so an average of 2.5 would result in a "C" rating).\n\nThis gives an “issue density" measure on the three axes of Reliability, Security and Maintainability for your Portfolio.\n\nRating conversion:\n\n**E**: 5  \n**D**: 4  \n**C**: 3  \n**B**: 2  \n**A**: 1  \n\n*Note: the Portfolio Home Page is also available at Sub-Portfolio level*\n\n### Print as PDF or Subscribe\n\nOn a Portfolio Home Page you can choose to download an overview of the Portfolio as a PDF. To do that, simply click on the "Print as PDF" button. This is really convenient, for example, if you\'re going into a meeting where you may not have access to your SonarQube instance.\n\nIf you don\'t want to perform this action every time, you can subscribe to receive the PDF by email. The frequency of the mailing is decided by the administrator of the Portfolio.\n\nPlease note you will receive the PDF only if the Portfolio is computed.\n\nPortfolios are created and edited in the global Portfolio administration interface: **Administration > Configuration > Portfolios**. For more information, see [Configuring Portfolios and Applications](/project-administration/configuring-portfolios-and-applications/).\n'},{path:"user-guide/project-page",content:"---\ntitle: Project Page\nurl: /user-guide/project-page/\n---\n\n## Table of Contents\n\n\nThe Project Hompepage is the entry point of any project showing:\n* the releasability status of the project\n* the current state of its quality\n* the quality of what has been produced since the beginning of its [New Code Period](/user-guide/fixing-the-water-leak/).\n \n\nThe Project Page answers two questions:\n* can I release my project today?\n* if not, what should I improve to make the project pass the Quality Gate? \n\n## Can I release today?\n\nSince the [Quality Gate](/user-guide/quality-gates/) is your most powerful tool to enforce your quality policy, the page starts with the project's current Quality Gate status. If the project passes, a simple, green all-clear is shown.\n\nIf not, details and drill-downs are immediately available to quickly identify what went wrong, with a section for each error condition showing what the current project value is and what it should be. As usual, you'll be able to click through on current values to get to drilldowns.\n\n## What should I fix first?\nBecause the best way to improve a project's quality is to catch and fix new problems before they become entrenched, the first view of a project is centered around the New Code Period, which is highlighted in yellow on the right of the project homepage. The project space page shows a high-level summary of critical metrics, both current values and their New Code Period values.\n\nJust below the Quality Gate information, you have the numbers of old and new Issues in the Reliability and Security domains and then the Maintainability domain. Clicking on any figure on the page will take you to a detailed view, either in the Measures Page or the Issues Page.\n\nThe most important thing a developer must do is to ensure the new Issues in the yellow part of the screen are acknowledged, reviewed and fixed and to make sure that new code is covered by tests to help prevent future regressions. Regardless of how many Issues were introduced in the past or how little test coverage there is overall, a focus on the newly added Issues will ensure that the situation won't degrade versus the version you previously released in production.\n\nSo, which issues should you go after first: Bugs, Vulnerabilities or Code Smells? It depends, because the answer is dependent on the nature of your Issues. Let's say you have issues for a block of code that is duplicated 5 times, and inside this duplicated block of code, you have 3 Bugs and 5 Security Issues. The best approach is probably to fix the duplication first and then resolve the Bugs and Vulnerabilities in the newly centralized location, rather than fixing them 5 times.\n\nThat's why you need to review your new Issues before jumping into resolving them. \n\n## How can I ...\n### How can I see project measures at a lower level?\nThe project-level **Measures** menu item takes you to a dedicated sub-space where you see all project measures. Choose a measure for more details. Both list and tree views are available for each measure, and treemaps are available for percentages and ratings.\n\n### How can I see all the issues in a project?\nThe project-level **Issues** menu item takes you to a project-specific Issues page, where you can perform all the same actions you can at the higher level.\nOn this page, you can easily narrow the list to the New Issues introduced during the New Code Period, by selecting `New Code` in **Creation Date** facet.\n\n### How can I see the project structure and code?\nThe project-level **Code** menu item takes you to an outline of your project structure. Drill down to see files in a directory, and choose a file to see its code.\n\nIf your project is too large for easy exploration via drilling, the search feature on this page will help. While the global search in the main menu returns results from throughout the {instance} instance, the localized search on the code page is restricted to files and directories in the current project.\n\n### How can I see the project activity / history?\nThe project-level **Activity** menu item takes you to the full list of code scans performed on your project since it was created in {instance}. By going there you can follow the evolution of the Quality Gate, see the changes of Quality Profiles and know when a given version of your code has been scanned.\n\n### How can I easily spot the risks in a project?\nVisualizations allow you to compare project components and quickly spot the ones that represent the greatest risks. The **Activity** page offers several pre-defined visualizations, and you can also create Custom visualizations with the metrics of your choice.\n\n### How can I promote the health of my project to peers ?\nIf your project is publicly visible, then you can further promote its status in external tools and websites using native Project Badges. The **Get project badges** button on the homepage of a public project lets you choose/fine-tune your badge and gives you the URL for it.\n"},{path:"user-guide/quality-gates",content:"---\ntitle: Quality Gates\nurl: /user-guide/quality-gates/\n---\n\n## Overview\n\nA quality gate is the best way to enforce a quality policy in your organization.\nIt's there to answer ONE question: can I deliver my project to production today or not?\n\nIn order to answer this question, you define a set of Boolean conditions based on measure thresholds against which projects are measured. For example:\n\n* No new blocker issues\n* Code coverage on new code greater than 80%\n* Etc.\n\nIdeally, all projects will be verified against the same quality gate, but that's not always practical. For instance, you may find that:\n\n* Technological implementation differs from one application to another (you might not require the same code coverage on new code for Web or Java applications).\n* You want to ensure stronger requirements on some of your applications (internal frameworks for example).\n* Etc.\n\nWhich is why you can define as many quality gates as you wish. Quality Gates are defined and managed in the **[Quality Gates](/#sonarqube#/quality_gates)** page found in the top menu.\n\n## Use the Best Quality Gate Configuration\n\nThe quality gate \"Sonar way\" is provided by SonarSource, activated by default and considered as built-in and so read-only. It represents our view of the best way to implement the [Fixing the Water Leak](/user-guide/fixing-the-water-leak/) concept. \x3c!-- sonarqube --\x3eAt each SonarQube release, we adjust automatically this default quality gate according to SonarQube's capabilities.\x3c!-- /sonarqube --\x3e\n\nThree metrics allow you to enforce a given Rating of Reliability, Security and Maintainability, not just overall but also on new code. These metrics are recommended and come as part of the default quality gate. We strongly advise you to adjust your own quality gates to use them to make feedback more clear to your developers looking at their quality gate on their project page.\n\nDon't forget also that quality gate conditions must use differential values. There is no point for example to check an absolute value such as : Number of Lines of Code is greater than 1000.\n\n### Recommended Quality Gate\n\nThe `Sonar way` Built-in quality gate is recommended for most projects. If focuses on keeping new code clean, rather than spending a lot of effort remediating old code. Out of the box, it's already set as the default profile.\n\n## Quality Gate Status\n\nThe current status is displayed prominently at the top of the Project Page:\n\n![Quality Gate Status](/images/quality-gate-status.jpeg)\n\n## Getting Notified When a Quality Gate Fails\n\nThanks to the notification mechanism, users can be notified when a quality gate fails. To do so, subscribe to the **New quality gate status** notification either for all projects or a set of projects you're interested in.\n\n## Security\n\nQuality Gates can be accessed by any user (even anonymous users). All users can view every aspect of a quality gate.\n\nTo make changes (create, edit or delete) users must be granted the **Administer Quality Profiles and Gates** permission.\n\nA **project administrator** can choose which quality gates his/her project is associated with. See Project Settings for more.\n\n## Defining Quality Gates\n\nTo manage quality gates, go to **[Quality Gates](/#sonarqube#/quality_gates)** (top menu bar).\n\nEach Quality Gate condition is a combination of:\n\n* measure\n* comparison operator\n* error value\n\nFor instance, a condition might be:\n\n* measure: Blocker issue\n* comparison operator: >\n* error value: 0\n\nWhich can be stated as: No blocker issues.\n"},{path:"user-guide/rules",content:'---\ntitle: Rules\nurl: /user-guide/rules/\n---\n## Table of Contents\n\n## Overview\nIn {instance}, analyzers contribute rules which are executed on source code to generate issues. There are four types of rules:\n* Code Smell (Maintainability domain)\n* Bug (Reliability domain)\n* Vulnerability (Security domain)\n* Security Hotspot (Security domain)\n\nFor Code Smells and Bugs, zero false-positives are expected. At least this is the target so that developers don\'t have to wonder if a fix is required.\n\nFor Vulnerabilities, the target is to have more than 80% of the issues to be true-positives.\n\nSecurity Hotspot rules are purposefully designed to draw attention to code is security-sensitive. It is expected that more than 80% of the issues will be quickly resolved as "Won\'t Fix" after review by a Security Auditor.\n\nThe Rules page is the entry point where you can discover all the existing rules or create new ones based on provided templates.\n\n## Rules\n\nBy default, when entering the top menu item "Rules", you will see all the available rules brought by the analyzers \x3c!-- sonarqube --\x3einstalled on your {instance} instance\x3c!-- /sonarqube --\x3e\x3c!-- sonarcloud --\x3eavailable on SonarCloud\x3c!-- /sonarcloud --\x3e. You have the ability to narrow the selection based on search criteria in the left pane:\n\n* **Language**: the language to which a rule applies.\n* **Type**: Bug, Vulnerability, Code Smell or Security Hotspot rules.\n* **Tag**: it is possible to add tags to rules in order to classify them and to help discover them more easily.\n* **Repository**: the engine/analyzer that contributes rules to {instance}.\n* **Default Severity**: the original severity of the rule - as defined by the analyzer that contributes this rule.\n* **Status**: rules can have 3 different statuses:\n  * **Beta**: The rule has been recently implemented and we haven\'t gotten enough feedback from users yet, so there may be false positives or false negatives.\n  * **Deprecated**: The rule should no longer be used because a similar, but more powerful and accurate rule exists.\n  * **Ready**: The rule is ready to be used in production.\n* **Available Since**: date when a rule was first added on {instance}. This is useful to list all the new rules since the last upgrade of a plugin for instance.\n* **Template**: display rule templates that allow to create custom rules (see later on this page).\n* **Quality Profile**: inclusion in or exclusion from a specific profile\n\nIf a quality profile is selected, it is also possible to check for its active severity and whether it is inherited or not. See the Quality Profile documentation for more.\n\n## Rule Details\n\nTo see the details of a rule, either click on it, or use the right arrow key. Along with basic rule data, you\'ll also be able to see which, if any, profiles it\'s active in and how many open issues have been raised with it.\n\nThe 2 following actions are available only if you have the right permissions ("Administer Quality Profiles and Gates"):\n\n* **Add/Remove Tags**:\n  * It is possible to add existing tags on a rule, or to create new ones (just enter a new name while typing in the text field).\n  * Note that some rules have built-in tags that you cannot remove - they are provided by the plugins which contribute the rules.\n* **Extend Description**:\n  * Extending rule descriptions is useful to let users know how your organization is using a particular rule for instance or to give more insight on a rule.\n  * Note that the extension will be available to non-admin users as a normal part of the rule details.\n\n\x3c!-- sonarqube --\x3e\n## Rule Templates and Custom Rules\n\nRule Templates are provided by plugins to allow users to define their own rules in {instance}. For instance, the template "Architectural Constraint" can be used to create any kind of rule that checks forbidden access from a set of file to another set of files.\n\nRule templates are like cookie cutters from which you can stamp out new, "custom rules". To find templates, use the template facet:\n\n![Rule templates.](/images/rule-templates.png)\n\nTo create a custom rule from a template, you will have to fill the following information:\n* Name\n* Key (auto-suggested)\n* Description (Markdown format is supported)\n* Default Severity\n* Status\n* The parameters specified by the template\n\nIt\'s easy to navigate from a template to the custom rules defined from it: just click on the link in the "Custom Rules" section and you will end up on the details of the given rule.\n\n![Rule template details.](/images/rule-template-details.png)\n\n### Custom Rules\nCustom Rules are considered like any other rule, except that they can be fully edited or even deleted:\n\n![Custom rules.](/images/rules-custom.png)\n\nNote that when deleting a custom rule, it is not physically removed from the {instance} instance but rather its status is set to "REMOVED". This allows current or old issues related to this rule to be displayed properly in {instance} until they are fully removed.\n\n## Extending Coding Rules\n\nCustom coding rules can be added. See [Adding Coding Rules](https://docs.sonarqube.org/display/DEV/Adding+Coding+Rules) for detailed information and tutorials.\n\x3c!-- /sonarqube --\x3e\n\n## Rule Types and Severities\n\n### How are rules categorized?\n\nThe {instance} Quality Model divides rules into four categories: Bugs, Vulnerabilities, Security Hotspots and Code Smells. Rules are assigned to categories based on the answers to these questions:\n\n**Is the rule about code that is demonstrably wrong, or more likely wrong than not?**  \nIf the answer is "yes", then it\'s a Bug rule.  \nIf not...\n\n**Is the rule about code that could be exploited by a hacker?**  \nIf so, then it\'s a Vulnerability rule.  \nIf not...\n\n**Is the rule about code that is security-sensitive?**  \nIf so, then it\'s a Security Hotspot rule.  \nIf not...\n\n**Is the rule neither a Bug nor a Vulnerability?**  \nIf so, then it\'s a Code Smell rule.\n\n## How are severities assigned?\nTo assign severity to a rule, we ask a further series of questions. The first one is basically:\n\n**What\'s the worst thing that could happen?**\n\nIn answering this question, we try to factor in Murphy\'s Law without predicting Armageddon.\n\nThen we assess whether the impact and likelihood of the Worst Thing (see _How are severity and likelihood decided?_, below) are high or low, and plug the answers into a truth table:\n\n|          | Impact                 | Likelihood             |\n| -------- | ---------------------- | ---------------------- |\n| Blocker  | ![](/images/check.svg) | ![](/images/check.svg) |\n| Critical | ![](/images/check.svg) | ![](/images/cross.svg) |\n| Major    | ![](/images/cross.svg) | ![](/images/check.svg) |\n| Minor    | ![](/images/cross.svg) | ![](/images/cross.svg) |\n\n## How are severity and likelihood decided?\nTo assess the severity of a rule, we start from the Worst Thing (see _How are severities assigned?_, above) and ask category-specific questions.\n\n### Bugs\nImpact: **Could the Worst Thing cause the application to crash or to corrupt stored data?**\n\nLikelihood: **What\'s the probability that the Worst Thing will happen?**\n\n### Vulnerabilities\nImpact: **Could the exploitation of the Worst Thing result in significant damage to your assets or your users?**\n\nLikelihood: **What is the probability that a hacker will be able to exploit the Worst Thing?**\n\n### Security Hotspots\nSecurity Hotspots are not assigned severities as it is unknown whether there is truly an issue until review by a Security Auditor. When an auditor converts a Security Hotspot into a Vulnerability, severity is assigned based on the identified Vulnerability (see above).\n'},{path:"user-guide/security-reports",content:"---\ntitle: Security Reports\nurl: /user-guide/security-reports/\n---\n\n## What do the Security Reports show?\nThe Security Reports are designed to quickly give you the big picture on your application's security, with breakdowns of just where you stand in regard to each of the [OWASP Top 10](https://www.owasp.org/index.php/Top_10-2017_Top_10), and [SANS Top 25](https://www.sans.org/top25-software-errors) categories, and [CWE](http://cwe.mitre.org/)-specific details.\nThe Security Reports are fed by the analyzers, which rely on the rules activated in your quality profiles to raise security issues. If there are no rules corresponding to a given OWASP category activated in your Quality Profile, you will get no issues linked to that specific category and the rating displayed will be A. That won't mean you are safe for that category, but that you need to activate more rules (assuming some exist).\n\n## What's the difference between a Hotspot and a Vulnerability?\nVulnerabilities are points in the code which are open to attack.\nSecurity Hotspots are security-sensitive pieces of code that should be carefully reviewed by someone with a security auditor hat. This person can be:\n* a member of the development team who is more sensitive to security problems \n* someone outside the development team contracted for the purpose of reviewing these Hotspots.\n\nThe main goal of Security Hotspots is to help focus the efforts of the security auditors who manually review application source code. The second goal is to educate developers and to increase their security-awareness. \nHaving a Hotspot in your application does not mean there is a problem. What it does mean is that a human, preferably a security auditor/expert should look over the code to see if the sensitive piece of code is being used in the safest manner.\n\n## Why are some Hotspot and Vulnerability rules very similar?\nThey are overlapping on purpose. The Hotspot rule is supposed to include all matches of the Vulnerability rules, and cases where the taint analysis engine is not able to detect vulnerabilities. For example, switching from one language to another (XML, JNI, etc...) or using some third party libraries will prevent the taint analysis from finding vulnerabilities. A Vulnerability rule highlights security threats only when it has a high level of confidence, which means that it will always miss some of them. Whereas a Hotspot rule guides secure code reviews by showing code where those issues might lurk, even if it could not detect any vulnerability.\n\n## Why don't I see any Hotspots?\nThey are three reasons you might not see any Hotspots:\n* it is possible you really have none of them because the code has been written without using any security-sensitive API. \n* it is possible that Hotspot rules are available, but not yet activated in your Quality Profile, and so naturally no issues are raised\n* it is more likely that the analyzer for the langauge you're using does not yet offer Hotspot rules, and so it doesn't raise any Hotspots regardless of the quality of how many are actually there, but this last option will disappear over time.\n\n## Why don't I see any Vulnerabilities?\nYou might not see any Vulnerabilities for more or less the same reasons as for Hotspots, but it may be more surprising for Vulnerabilities because you may see some Vulnerabilities reported in the Project homepage, while there are none in the Security Reports. This is because the language analyzer may not yet provide the \"Security Standards\" metadata required for issues to be visible on the Security Reports. This metadata is basically the link between a Rule (and its issues) and the \"OWASP Top 10\" or \"SANS Top 25\" categories. Without this link, there is no way to associate an already existing Vulnerability to the Security Standard categories and so to display security issues correctly in the reports. Every analyzer version released by SonarSource after July 2018 should feed the \"Security Standards\" and be compatible with the Hotspot issue type. \n\n## I'm a developer. Should I care about Hotspots?\nProbably not. Hotspots, as such, aren't really actionable. They simply mark *potential* problems, so there's really nothing to do immediately on the code. That's why you don't receive notifications when Hotspot issues are raised, and why Hotspots aren't shown in the Issues page by default.\n\n## What if my Hotspot really marks a Vulnerability?\nIf you look at the code where a Hotspot is raised and realize that there really is a problem, click on the current status (probably `Open`) to register that you've *Detect*ed a Vulnerability at that point in the code. Once you do, it will be converted to a Vulnerability, and the developer who last touched the line will receive \"new issue\" notifications (if she's signed up to get them).\n\n## What happens after my Hotspot becomes a Vulnerability?\nOnce you've *Detect*ed that there really is a problem at a Hotspot location, it will be assigned to the appropriate developer, who will make a fix, and must then `Request Review` *via the UI*. That request moves the issue from Vulnerability back to Hotspot. From there, it's up to the security auditor to either `Accept` or `Reject` the fix. Accepting the fix will mark it `Won't Fix`, and rejecting it will turn it back into a Vulnerability, putting it back in the developer's queue.\n\n## What does it mean for a Hotspot to be marked \"Won't Fix\"?\nThe `Won't Fix` designation is used to indicate that a Hotspot has been reviewed and there is no way, as of now, to exploit this piece of code to create an attack.\n\n\n"},{path:"user-guide/security-rules",content:"---\ntitle: Security-related Rules\nurl: /user-guide/security-rules/\n---\nThe {instance} Quality Model has three different types of rules: Reliability (bug), Vulnerability (security), and Maintainability (code smell) rules. But divided another way, there are only two types: security rules, and all the rest. The distinction between these two groups is not so much in what they catch but in where they come from and in the standards imposed on them.\n\n## What to expect from security-related rules\nTo be clear, the standard for most rules implemented in {instance} language plugins is very strict: no false positives. For normal rules, you should be able to be confident that whatever is reported to you as an issue really is an issue.\n\nBut for security-related rules, the story is a little different. For instance, a lot of security guidelines talk about how \"sensitive\" data should be handled (e.g. not logged, not stored un-encrypted, &etc.). But since it's not really possible in a rule to tell which data is sensitive and which isn't, the choice becomes: maintain the no-false-positives standard and don't implement security-related rules, or implement security-related rules with a different standard.\n\nThat's why security-related rules cast a wider net than you may be used to seeing. The idea is that the rule will flag anything suspicious, and leave it to the human security auditor to cull the false positives and sent the real issues for remediation.\n\nSecurity Hotspots are a special type of issue that identify sensitive areas of code that should be reviewed by a Security Auditor to determine if they are truly Vulnerabilities.  See Security Audits and Reports for detail on Security Hotspots and the audit process.\n\n## Where security-related rules come from\nThe vast majority of security-related rules originate from established standards: [CWE](http://cwe.mitre.org/), [SANS Top 25](http://www.sans.org/top25-software-errors/), and [OWASP Top 10](https://www.owasp.org/index.php/Top_10-2017_Top_10). To find rules that relate to any of these standards, you can search rules either by tag or by text. The standards that a rule relates to will be listed in the **See** section at the bottom of the rule description. \n\n### CWE\nCWE stands for Common Weakness Enumeration. According to the [CWE FAQ](http://cwe.mitre.org/about/faq.html#A.1):\n\n> Common Weakness Enumeration (CWE™) is a formal list or dictionary of common software weaknesses that can occur in software's architecture, design, code or implementation that can lead to exploitable security vulnerabilities. CWE was created to serve as a common language for describing software security weaknesses; serve as a standard measuring stick for software security tools targeting these weaknesses; and to provide a common baseline standard for weakness identification, mitigation, and prevention efforts.\n\nThe CWE is a hierarchy of weakness descriptions. The lowest level in the hierarchy is a \"Weakness Base\", which describes a granular weakness. Above Weakness Bases, are Weakness Classes and Categories. In general, rules are linked to Weakness Bases or Classes. \n\nTools which meet certain requirements can be certified as [CWE Compatible](http://cwe.mitre.org/compatible/). Those requirements are:\n\n* You must be able to search for CWE-related rules using a CWE identifier. To do so in the {instance} platform, simply drop the CWE identifier (e.g. CWE-595) in the search text input on the rules page and run the search.\n* Rules must be accurately linked to their related CWE items. To see the CWE mapping for a {instance} rule, consult the rule's See section at the bottom of the rule description.\n* You must be able to identify the relevant CWE from an Issue. To do so in the {instance} platform, consult the related rule.\n* The product documentation must include a description of CWE and CWE Compatibility.\n* The version of CWE supported must be listed. The {instance} langauge plugins support version 2.8.\n* In addition to searching rules by CWE id's, you can also search by the \"cwe\" rule tag.\n\nTo see which CWE items are covered for a language, consult the links below.\n\n* [C](https://rules.sonarsource.com/c/tag/cwe)/[C++](https://rules.sonarsource.com/cpp/tag/cwe)\n* [Java](https://rules.sonarsource.com/java/tag/cwe) \n* [Objective-C](https://rules.sonarsource.com/objective-c/tag/cwe)\n \n\n### SANS Top 25\n\nThe [SANS Top 25](http://www.sans.org/top25-software-errors/) list is a collection of the 25-most dangerous errors listed in the CWE, as compiled by the [SANS organization](http://www.sans.org/). The current SANS list is divided into three categories: Insecure Interaction Between Components, Risky Resource Management, and Porous Defenses.\n\nThe tags used for SANS correspond to its categories: sans-top25-insecure, sans-top25-risky, sans-top25-porous.\n\nTo find rules relating to SANS Top 25, you can perform a text search for the category, or the relevant CWE item, or perform a rule tag search.\n\n### OWASP Top 10\nOWASP stands for Open Web Application Security Project. According to its site, it is:\n\n> A [501(c)(3)](http://www.irs.gov/Charities-&-Non-Profits/Charitable-Organizations/Exemption-Requirements-Section-501(c)(3)-Organizations) worldwide not-for-profit charitable organization focused on improving the security of software. Our mission is to make software security [visible](https://www.owasp.org/index.php/Category:OWASP_Video), so that [individuals and organizations](https://www.owasp.org/index.php/Industry:Citations) worldwide can make informed decisions about true software security risks.\n\nThe [OWASP Top 10](https://www.owasp.org/index.php/Top_10-2017_Top_10) is a list of broad categories of weaknesses, each of which can map to many individual rules.\n\nThe tags used for OWASP correspond to the weakness categories: owasp-a1, owasp-a2, owasp-a3, owasp-a4, owasp-a5, owasp-a6, owasp-a7, owasp-a8, owasp-a9, owasp-a10.\n\nTo find rules relating to OWASP Top 10, you can perform a text search for the category, or perform a rule tag search.\n"},{path:"user-guide/sonarlint-notifications",content:"---\ntitle: SonarLint Smart Notifications\nurl: /user-guide/sonarlint-notifications/\n---\n\x3c!-- sonarqube --\x3e\n_SonarLint Smart Notifications is available as part of the [Developer Edition](https://redirect.sonarsource.com/editions/developer.html) and [above](https://www.sonarsource.com/plans-and-pricing/)._\n\x3c!-- /sonarqube --\x3e\n\nSmart notifications allow developers using Connected Mode in SonarLint to receive in-IDE notifications from {instance} when:\n\n* the Quality Gate status (failed / success) of a project /solution _open in the IDE_ changes\n* a {instance} analysis raises new issues _introduced by this developer in a project /solution open in the IDE_\n\n## Activate/deactivate Notifications\nThe activation or deactivation of notifications must be done individually, by each developer directly in SonarLint (on the IDE side).\n\n\x3c!-- sonarqube --\x3e\nReceiving notifications is configurable on the SonarLint side on a {instance} server-by-server basis.\n\x3c!-- /sonarqube --\x3e\n"},{path:"user-guide/user-account",content:"---\ntitle: User Account\nurl: /user-guide/user-account/\n---\n\nAs a {instance} user you have your own space where you can see the things that are relevant to you:\n\n## Home Page\n\nIt gives you a summary of:\n\n* your Groups\n* your SCM accounts\n\n## Security\n\nIf \x3c!-- sonarqube --\x3eyour instance is\x3c!-- /sonarqube --\x3e \x3c!-- sonarcloud --\x3eyou are\x3c!-- /sonarcloud --\x3e not using a 3rd party authentication mechanism such as \x3c!-- sonarqube --\x3eLDAP or\x3c!-- /sonarqube --\x3e an OAuth provider (GitHub, Google Account, ...), you can change your password from here. Additionally, you can also manage your own authentication tokens.\n\nYou can create as many Tokens as you want. Once a Token is created, you can use it to perform analysis on a project where you have the [Execute Analysis](/instance-administration/security/) permission.\n\n"},{path:"user-guide/user-token",content:"---\ntitle: User Token\nurl: /user-guide/user-token/\n---\n\nEach user has the ability to generate tokens that can be used to run analyses or invoke web services without access to the user's actual credentials.\n\n## How to Generate a Token\n\nTo generate a token, to go **User > My Account > Security**. Your existing tokens are listed here, each with a Revoke button.\n\nThe form at the bottom of the page allows you to generate new tokens. Once you click the **Generate** button, you will see the token value. Copy it immediately; once you dismiss the notification you will not be able to retrieve it.\n\n## How to Use a Token\n\nUser tokens have to be used as a replacement of your usual login:\n\n* when running analyses on your code: replace your login by the token in the `sonar.login` property. \n* when invoking web services: just pass the token instead of your login while doing the basic authentication.\n\nIn both cases, you don't need to provide a password (so when running analyses on your code, the property `sonar.password` is optional).\n"},{path:"user-guide/visualizations",content:"---\ntitle: Visualizations\nurl: /user-guide/visualizations/\n---\nVisualizations are available to help you gain deeper insights into your projects' current statuses and histories.\n\n## How do I compare current state for multiple projects or project components?\nThe Projects space allows you to filter the projects in your instance by multiple, measure-based criteria. Once you've chosen your set, you don't have to stare at the raw numbers to identify the risks its projects face. Instead, several visualizations (**Projects > Perspective**) are available to help you understand each project's relative position in terms of each of the major axes:\n\n* Risk - Reliability and Security ratings, test coverage, technical debt, and lines of code\n* Reliability - Reliability rating, Reliability remediation effort, lines of code, and Bug count\n* Security - Security rating, Security remediation effort, lines of code, and Vulnerability count\n* Maintainability - Maintainability rating, Technical debt, lines of code, and Code Smell count\n* Coverage - Coverage, complexity, and uncovered lines\n* Duplications - Duplicated Lines %, lines of code, and duplicated blocks\n* At the project level these same visualizations are available in the Measures tab to help you compare project components. The Project Overview corresponds to the Risk visualization in the Projects space, For the other five graphs, choose the Overview option under the relevant domain.\n\nAdditionally, treemaps are also available for percentage and rating metrics at the project level. Navigate to them in the Measures tab using the perspective selector in the right pane.\n\n## How do I visualize metric history?\nAt the project level, the Activity tab offers several canned line graphs of selected metrics across time, with convenient mouseovers to show graph details and the ability to easily narrow the graph to a slice of the project's history. Beyond the canned graphs, you also have the ability to map the metrics of your choice against each other in a Custom graph.\n\n![](/images/visualizations.png)\n"}]},1569:function(e,n,t){var o=t(1570);"string"==typeof o&&(o=[[e.i,o,""]]);var a={hmr:!0,transform:void 0,insertInto:void 0};t(358)(o,a);o.locals&&(e.exports=o.locals)},1570:function(e,n,t){(e.exports=t(357)(!1)).push([e.i,"/*\n * SonarQube\n * Copyright (C) 2009-2019 SonarSource SA\n * mailto:info AT sonarsource DOT com\n *\n * This program is free software; you can redistribute it and/or\n * modify it under the terms of the GNU Lesser General Public\n * License as published by the Free Software Foundation; either\n * version 3 of the License, or (at your option) any later version.\n *\n * This program is distributed in the hope that it will be useful,\n * but WITHOUT ANY WARRANTY; without even the implied warranty of\n * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n * Lesser General Public License for more details.\n *\n * You should have received a copy of the GNU Lesser General Public License\n * along with this program; if not, write to the Free Software Foundation,\n * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.\n */\n.documentation-page-header {\n  margin: 10px 20px;\n}\n\n.documentation-footer div,\n.documentation-footer .page-footer-menu {\n  max-width: 740px;\n}\n\n.documentation-content {\n  padding: 32px 64px;\n}\n\n.documentation-content.markdown {\n  position: relative;\n  font-size: 16px;\n  line-height: 1.7;\n}\n\n.documentation-content.markdown .documentation-title {\n  font-size: 24px;\n  padding-top: 8px;\n  margin-bottom: 2em;\n}\n\n.documentation-content.markdown h2 {\n  font-size: 18px;\n  font-weight: 800;\n  margin-top: 3em;\n}\n\n.documentation-content.markdown h3 {\n  font-size: 16px;\n  margin-bottom: 0.8em;\n}\n\n.documentation-content.markdown pre {\n  border: 1px solid #e6e6e6;\n  border-radius: 3px;\n  background-color: rgba(0, 0, 0, 0.06);\n}\n\n.documentation-content.markdown .alert,\n.documentation-content.markdown p,\n.documentation-content.markdown pre,\n.documentation-content.markdown table {\n  margin: 0.8em 0 2em;\n}\n\n.documentation-content.markdown ul {\n  margin: 0 0 2em;\n}\n\n.documentation-content.markdown ul > ul {\n  margin: 0;\n}\n\n.documentation-content.markdown p + ul,\n.documentation-content.markdown p + ol,\n.documentation-content.markdown p + pre {\n  margin: -1em 0 2em;\n}\n\n.documentation-content.markdown li > p {\n  margin: 0;\n}\n\n.documentation-content.markdown li > p + ul,\n.documentation-content.markdown li > p + ol {\n  margin: 0;\n}\n\n.documentation-content.markdown img[src$='.svg'] {\n  vertical-align: text-bottom;\n}\n\n.documentation-content.markdown .alert {\n  display: block;\n  padding: 8px 16px;\n}\n\n.documentation-content.markdown .collapse-container {\n  border: 1px solid #e6e6e6;\n  border-radius: 2px;\n  background-color: #f3f3f3;\n  padding: 8px;\n  margin: 0.8em 0 2em;\n}\n\n.documentation-content.markdown .collapse-container > a:first-child {\n  display: block;\n}\n\n.documentation-content.markdown .collapse-container > a:first-child:focus {\n  color: #236a97;\n}\n\n.documentation-content.markdown .collapse-container *:last-child {\n  margin-bottom: 0;\n}\n\n.markdown.has-toc {\n  display: flex;\n}\n\n.markdown.has-toc .markdown-content {\n  flex-shrink: 1;\n  overflow: hidden;\n  text-overflow: ellipsis;\n  overflow-x: auto;\n}\n\n.markdown-toc {\n  flex: 0 0 240px;\n  margin-right: -40px;\n}\n\n.markdown-toc-content {\n  margin-left: 32px;\n  padding: 0 8px;\n  font-size: 13px;\n  background: white;\n  position: -webkit-sticky;\n  position: sticky;\n  top: 68px;\n}\n\n.markdown-toc-content h4 {\n  margin: 0 8px 8px 8px;\n  font-size: 14px;\n}\n\n.markdown-toc-content a {\n  display: block;\n  color: #070706;\n  padding: 4px 8px;\n  border: 1px solid white;\n  line-height: 1.2;\n  transition: none;\n}\n\n.markdown-toc a:hover {\n  border-color: #4b9fd5;\n}\n\n.markdown-toc a.active {\n  font-weight: bold;\n}\n",""])},1643:function(e,n,t){"use strict";t.r(n);var o=t(354),a=t(371),s=t.n(a),i=t(360),r=t(1408),l=t(1409),c=t(355);function u({indent:e,node:n,splat:t}){if(!n)return null;const a=n.url==="/"+t;return o.createElement(i.Link,{className:c("list-group-item",{active:a}),key:n.url,style:{paddingLeft:e?31:10},to:"/documentation"+n.url},o.createElement("h3",{className:"list-group-item-heading"},n.navTitle||n.title))}var d=t(587),h=t.n(d),p=t(370),m=t.n(p);function g(e){return"object"==typeof e&&!e.url}function y(e){return"object"==typeof e&&e.url}function f(e,n){return e.find(e=>e.url===n)}const b=6;function v(e){let n=0;for(let t=0;t<e.length;t++)if(/\s/.test(e[t])&&n++,n===b)return t<e.length-1?`${e.substring(0,t)}...`:e;return e}function w(e){const n=[];let t=0;const o=e.findIndex(e=>e.marked);if(o>0){const a=function(e){let n=0;for(let t=e.length-1;t>=0;t--)if(/\s/.test(e[t])&&n++,n===b)return t>0?`...${e.substring(t+1)}`:e;return e}(e[o-1].text);n.push({text:a,marked:!1}),t+=a.length}n.push(e[o]),t+=e[o].text.length;for(let a=o+1;a<e.length;a++){if(t+e[a].text.length>100){const t=v(e[a].text);return n.push({text:t,marked:!1}),n}n.push(e[a]),t+=e[a].text.length}return n}function S(e,n){const t=m()([...n.map(e=>({pos:e.from,start:!0})),...n.map(e=>({pos:e.to,start:!1}))],e=>e.pos,e=>Number(!e.start)),o=[];let a=0,s=0;for(const n of t)n.start?(0===s&&a!==n.pos&&(o.push({text:e.substring(a,n.pos),marked:!1}),a=n.pos),s++):0===--s&&a!==n.pos&&(o.push({text:e.substring(a,n.pos),marked:!0}),a=n.pos);return a<e.length-1&&o.push({text:e.substr(a),marked:!1}),o}var k=t(510);class x extends o.PureComponent{constructor(){super(...arguments),this.handleClick=(e=>{e.stopPropagation(),e.preventDefault(),this.props.onToggle(this.props.title)})}render(){const e=this.props,n=e.open,t=e.block,a=e.pages,s=e.title,i=e.splat;return o.createElement(o.Fragment,null,o.createElement("a",{className:"list-group-item",href:"#",onClick:this.handleClick},o.createElement("h3",{className:"list-group-item-heading"},o.createElement(k.a,{className:"little-spacer-right",open:this.props.open}),s)),n&&t.children.map(e=>o.createElement(u,{indent:!0,key:e,node:f(a,e),splat:i})))}}var C=t(488);function T({title:e,url:n}){return o.createElement("a",{href:n,key:e,target:"_blank"},o.createElement("h3",{className:"list-group-item-heading"},o.createElement(C.a,{className:"spacer-right"}),e))}class j extends o.PureComponent{constructor(e){super(e),this.toggleBlock=(e=>{this.setState(n=>({openBlockTitle:n.openBlockTitle===e?"":e}))}),this.state={openBlockTitle:this.getOpenBlockFromLocation(this.props.splat)}}componentWillReceiveProps(e){this.props.splat!==e.splat&&this.setState({openBlockTitle:this.getOpenBlockFromLocation(e.splat)})}getOpenBlockFromLocation(e){const n=this.props.navigation.find(n=>g(n)&&n.children.some(n=>"/"+e===n));return n?n.title:""}render(){return this.props.navigation.map(e=>g(e)?o.createElement(x,{block:e,key:e.title,onToggle:this.toggleBlock,open:this.state.openBlockTitle===e.title,pages:this.props.pages,splat:this.props.splat,title:e.title}):y(e)?o.createElement(T,{key:e.title,title:e.title,url:e.url}):o.createElement(u,{indent:!1,key:e,node:f(this.props.pages,e),splat:this.props.splat}))}}var A=t(1410),P=t.n(A);function E({active:e,result:n}){return o.createElement(i.Link,{className:c("list-group-item",{active:e}),to:"/documentation"+n.page.url},o.createElement(I,{result:n}),o.createElement(_,{result:n}))}function I({result:e}){let n;const t=e.highlights.title;if(t&&t.length>0){const a=S(e.page.title,t.map(e=>({from:e[0],to:e[0]+e[1]})));n=o.createElement(R,{tokens:a})}else n=e.page.title;return o.createElement("h3",{className:"list-group-item-heading",style:{fontWeight:"normal"}},n)}function _({result:e}){const n=e.highlights.text,t=e.page.text;let a=[];if(e.exactMatch){const n=e.page.text.toLowerCase(),o=[];let s=0,i=n.indexOf(e.query,s),r=0;for(;i>-1&&r<10;)r++,o.push({from:i,to:i+e.query.length}),s=i+1,i=n.indexOf(e.query,s);o.length&&(a=S(t,o))}return 0===a.length&&n&&n.length>0&&(a=S(t,n.map(e=>({from:e[0],to:e[0]+e[1]})))),a.length?o.createElement("div",{className:"note"},o.createElement(R,{tokens:w(a)})):null}function R({tokens:e}){return o.createElement(o.Fragment,null,e.map((e,n)=>o.createElement(o.Fragment,{key:n},e.marked?o.createElement("mark",{key:n},e.text):e.text)))}class O extends o.PureComponent{constructor(e){super(e),this.index=P()(function(){this.use(q),this.ref("relativeName"),this.field("title",{boost:10}),this.field("text"),this.metadataWhitelist=["position","tokenContext"],e.pages.filter(n=>(function(e){return h()(e.filter(e=>!y(e)).map(e=>g(e)?e.children:[e]))})(e.navigation).includes(n.url)).forEach(e=>this.add(e))})}render(){const e=this.props.query.toLowerCase(),n=this.index.search(e.split(/\s+/).map(e=>`${e}~1 ${e}*`).join(" ")).map(n=>{const t=this.props.pages.find(e=>e.relativeName===n.ref),o={};let a="",s=!1;return Object.keys(n.matchData.metadata).forEach(t=>{e.includes(t.toLowerCase())&&a.length<t.length&&(a=t),Object.keys(n.matchData.metadata[t]).forEach(a=>{const i=n.matchData.metadata[t][a],r=i.position,l=i.tokenContext;o[a]=[...o[a]||[],...r],!s&&l&&l.forEach(n=>{!s&&n.includes(e)&&(s=!0)})})}),{exactMatch:s,highlights:o,longestTerm:a,page:t,query:e}}).filter(e=>e.page),t=m()(m()(n,e=>-e.longestTerm.length),e=>e.exactMatch&&-1);return o.createElement(o.Fragment,null,t.map(e=>o.createElement(E,{active:e.page.relativeName===this.props.splat,key:e.page.relativeName,result:e})))}}function q(e){const n=(e,n,t)=>{const o=t[n-1]||"",a=t[n+1]||"";return e.metadata.tokenContext=[o.toString(),e.toString(),a.toString()].filter(e=>e.length).join(" ").toLowerCase(),e};P.a.Pipeline.registerFunction(n,"tokenContext"),e.pipeline.before(P.a.stemmer,n),e.metadataWhitelist.push("tokenContext")}var M=t(405);class N extends o.PureComponent{constructor(){super(...arguments),this.state={query:""},this.handleSearch=(e=>{this.setState({query:e.trim()})})}render(){return o.createElement(o.Fragment,null,o.createElement(M.a,{className:"big-spacer-top spacer-bottom",minLength:2,onChange:this.handleSearch,placeholder:"Search for pages or keywords",value:this.state.query}),o.createElement("div",{className:"documentation-results panel"},o.createElement("div",{className:"list-group"},this.state.query?o.createElement(O,{navigation:this.props.navigation,pages:this.props.pages,query:this.state.query,splat:this.props.splat}):o.createElement(j,{navigation:this.props.navigation,pages:this.props.pages,splat:this.props.splat}))))}}var Q=t(861),D=t.n(Q),L=t(601),B=t.n(L),G=t(1518),H=t(993);function z(){return G.map(e=>{const n=Object(H.separateFrontMatter)(e.content),t=function(e){const n=D()().parse(e),t=[];return B()(n,e=>{"text"!==e.type&&"inlineCode"!==e.type||t.push(e.value)}),t.join(" ").replace(/\s+/g," ")}(Object(H.filterContent)(n.content));return{relativeName:e.path,url:n.frontmatter.url||`/${e.path}`,title:n.frontmatter.title,navTitle:n.frontmatter.nav||void 0,order:Number(n.frontmatter.order||-1),scope:n.frontmatter.scope?n.frontmatter.scope.toLowerCase():void 0,text:t,content:e.content}})}var U=t(445),F=t(493),W=t(471),J=t(0),V=t(13),Y=t(394);t(1569);t.d(n,"default",function(){return K});class K extends o.PureComponent{constructor(){super(...arguments),this.mounted=!1,this.pages=z()}componentDidMount(){Object(Y.a)()}componentWillUnmount(){Object(Y.c)()}render(){const e=Object(V.isSonarCloud)()?l:r,n=this.props.params.splat,t=void 0===n?"":n,a=this.pages.find(e=>e.url==="/"+t),c=Object(J.l)("documentation.page_title");if(!a)return o.createElement(o.Fragment,null,o.createElement(s.a,{title:c},o.createElement("meta",{content:"noindex nofollow",name:"robots"})),o.createElement(U.default,{withContainer:!1}));const u="index"===t;return o.createElement("div",{className:"layout-page"},o.createElement(s.a,{title:u||!a.title?c:`${a.title} | ${c}`},!Object(V.isSonarCloud)()&&o.createElement("meta",{content:"noindex nofollow",name:"robots"})),o.createElement(F.a,{className:"layout-page-side-outer"},({top:n})=>o.createElement("div",{className:"layout-page-side",style:{top:n}},o.createElement("div",{className:"layout-page-side-inner"},o.createElement("div",{className:"layout-page-filters"},o.createElement("div",{className:"documentation-page-header"},o.createElement(i.Link,{to:"/documentation/"},o.createElement("h1",null,Object(J.l)("documentation.page")))),o.createElement(N,{navigation:e,pages:this.pages,splat:t}))))),o.createElement("div",{className:"layout-page-main"},o.createElement("div",{className:"layout-page-main-inner"},o.createElement("div",{className:"boxed-group"},o.createElement(W.default,{className:"documentation-content cut-margins boxed-group-inner",content:a.content,displayH1:!0,stickyToc:!0})))))}}},394:function(e,n,t){"use strict";t.d(n,"a",function(){return s}),t.d(n,"b",function(){return i}),t.d(n,"c",function(){return r}),t.d(n,"d",function(){return l});const o="sidebar-page",a="white-page";function s(){c(o,!0)}function i(){c(a,!0)}function r(){c(o,!1)}function l(){c(a,!1)}function c(e,n){document.body.classList.toggle(e,n),document.documentElement&&document.documentElement.classList.toggle(e,n)}},428:function(e,n,t){"use strict";t.r(n),t.d(n,"default",function(){return r});var o=t(354),a=t(499),s=t(361),i=t(463);function r({children:e}){return o.createElement("div",{className:"global-container"},o.createElement("div",{className:"page-wrapper",id:"container"},o.createElement(i.a,{className:"navbar-global",height:s.globalNavHeightRaw}),e),o.createElement(a.a,null))}},445:function(e,n,t){"use strict";t.r(n),t.d(n,"default",function(){return l});var o=t(354),a=t(371),s=t(360),i=t(428),r=t(0);function l({withContainer:e=!0}){const n=e?i.default:o.Fragment;return o.createElement(n,null,o.createElement(a.Helmet,{defaultTitle:Object(r.l)("404_not_found"),defer:!1}),o.createElement("div",{className:"page-wrapper-simple",id:"bd"},o.createElement("div",{className:"page-simple",id:"nonav"},o.createElement("h2",{className:"big-spacer-bottom"},Object(r.l)("page_not_found")),o.createElement("p",{className:"spacer-bottom"},Object(r.l)("address_mistyped_or_page_moved")),o.createElement("p",null,o.createElement(s.Link,{to:"/"},Object(r.l)("go_back_to_homepage"))))))}},493:function(e,n,t){"use strict";t.d(n,"a",function(){return i});var o=t(418),a=t.n(o),s=t(354);class i extends s.PureComponent{constructor(e){super(e),this.getPosition=(()=>{const e=this.container&&this.container.getBoundingClientRect();return e?{top:window.pageYOffset+e.top,left:window.pageXOffset+e.left}:{top:0,left:0}}),this.debouncedOnResize=a()(()=>this.forceUpdate(),250)}componentDidMount(){this.forceUpdate(),window.addEventListener("resize",this.debouncedOnResize)}componentWillUnmount(){window.removeEventListener("resize",this.debouncedOnResize)}render(){return s.createElement("div",{className:this.props.className,ref:e=>this.container=e},this.props.children(this.getPosition()))}}}}]);
//# sourceMappingURL=docs.m.0ca09ba4.chunk.js.map